/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.NamedKeyStrokeArrayConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceAccess;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PropertyExporter;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.search.HTMLImageFinder;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.ArrayUtils;

public class ReportState
extends Decorator
implements TranslatablePiece {
    public static final String ID = "report;";
    protected NamedKeyStroke[] keys;
    protected FormattedString format = new FormattedString();
    protected String reportFormat;
    protected String[] cycleReportFormat;
    protected NamedKeyStroke[] cycleDownKeys;
    protected int cycleIndex = -1;
    protected String description;
    public static final String OLD_UNIT_NAME = "oldPieceName";
    public static final String NEW_UNIT_NAME = "newPieceName";
    public static final String MAP_NAME = "mapName";
    public static final String OLD_MAP_NAME = "oldMapName";
    public static final String LOCATION_NAME = "location";
    public static final String OLD_LOCATION_NAME = "oldLocation";
    public static final String COMMAND_NAME = "menuCommand";

    public ReportState() {
        this(ID, null);
    }

    public ReportState(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return new KeyCommand[0];
    }

    @Override
    public String myGetState() {
        return Integer.toString(this.cycleIndex);
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(NamedKeyStrokeArrayConfigurer.encode(this.keys)).append(this.reportFormat).append(NamedKeyStrokeArrayConfigurer.encode(this.cycleDownKeys)).append(StringArrayConfigurer.arrayToString(this.cycleReportFormat)).append(this.description);
        return ID + se.getValue();
    }

    @Override
    public Command keyEvent(KeyStroke stroke) {
        Command c = this.piece.keyEvent(stroke);
        return c == null ? this.myKeyEvent(stroke) : c.append(this.myKeyEvent(stroke));
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        java.util.Map<String, Object> oldPiece;
        GamePiece outer = ReportState.getOutermost(this);
        this.format.setProperty(MAP_NAME, this.getMap() == null ? null : this.getMap().getConfigureName());
        this.format.setProperty(LOCATION_NAME, this.getMap() == null ? null : this.getMap().locationName(this.getPosition()));
        this.format.setProperty(OLD_MAP_NAME, (String)this.getProperty("OldMap"));
        this.format.setProperty(OLD_LOCATION_NAME, (String)this.getProperty("OldLocationName"));
        Command c = null;
        Object o = this.getProperty("snapshot");
        if (o instanceof PropertyExporter) {
            oldPiece = ((PropertyExporter)o).getProperties();
            ProblemDialog.showOutdatedUsage(Resources.getString("Editor.ReportState.custom_trait_warning"));
        } else {
            oldPiece = (java.util.Map<String, Object>)o;
        }
        boolean wasVisible = oldPiece != null && !Boolean.TRUE.equals(oldPiece.get("InvisibleToOthers"));
        boolean isVisible = !Boolean.TRUE.equals(outer.getProperty("InvisibleToOthers"));
        PieceAccess.GlobalAccess.hideAll();
        String oldUnitName = oldPiece == null ? null : (String)oldPiece.get("localizedName");
        this.format.setProperty(OLD_UNIT_NAME, oldUnitName);
        String newUnitName = outer.getLocalizedName();
        this.format.setProperty(NEW_UNIT_NAME, newUnitName);
        PieceAccess.GlobalAccess.revertAll();
        if (isVisible || wasVisible) {
            NamedKeyStroke[] allKeys = (NamedKeyStroke[])ArrayUtils.addAll((Object[])this.keys, (Object[])this.cycleDownKeys);
            for (int i = 0; i < allKeys.length; ++i) {
                KeyCommand[] k;
                if (stroke == null || !stroke.equals(allKeys[i].getKeyStroke())) continue;
                String commandName = "";
                for (KeyCommand keyCommand : k = ((Decorator)outer).getKeyCommands()) {
                    KeyStroke commandKey = keyCommand.getKeyStroke();
                    if (!stroke.equals(commandKey)) continue;
                    commandName = keyCommand.getName();
                }
                ChangeTracker tracker = new ChangeTracker(this);
                this.format.setProperty(COMMAND_NAME, commandName);
                String theFormat = this.reportFormat;
                if (this.cycleIndex >= 0 && this.cycleReportFormat.length > 0) {
                    if (i < this.keys.length) {
                        theFormat = this.cycleReportFormat[this.cycleIndex];
                        this.cycleIndex = (this.cycleIndex + 1) % this.cycleReportFormat.length;
                    } else {
                        this.cycleIndex = (this.cycleIndex + this.cycleReportFormat.length - 1) % this.cycleReportFormat.length;
                        theFormat = this.cycleReportFormat[(this.cycleIndex + this.cycleReportFormat.length - 1) % this.cycleReportFormat.length];
                    }
                }
                this.format.setFormat(this.getTranslation(theFormat));
                OldAndNewPieceProperties properties = new OldAndNewPieceProperties(oldPiece, outer);
                String reportText = this.format.getLocalizedText(properties);
                if (this.getMap() != null) {
                    this.format.setFormat(this.getMap().getChangeFormat());
                } else if (!Map.isChangeReportingEnabled()) {
                    this.format.setFormat("");
                } else {
                    this.format.setFormat("$message$");
                }
                this.format.setProperty("message", reportText);
                reportText = this.format.getLocalizedText(properties);
                if (reportText.length() > 0) {
                    Chatter.DisplayText display = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "* " + reportText);
                    display.execute();
                    c = display;
                }
                c = tracker.getChangeCommand().append(c);
                break;
            }
        }
        return c;
    }

    protected String getPieceName() {
        PieceAccess.GlobalAccess.hideAll();
        String name = ReportState.getOutermost(this).getName();
        PieceAccess.GlobalAccess.revertAll();
        return name;
    }

    @Override
    public void mySetState(String newState) {
        if (newState.length() > 0) {
            try {
                this.cycleIndex = Integer.parseInt(newState);
            }
            catch (NumberFormatException e) {
                this.cycleIndex = -1;
                ReportState.reportDataError(this, Resources.getString("Error.non_number_error"), "Trying to init Message Index to " + newState);
            }
        } else {
            this.cycleIndex = -1;
        }
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.ReportState.trait_description", this.description);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ReportChanges.html");
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        String encodedKeys = st.nextToken("");
        if (encodedKeys.indexOf(44) > 0) {
            this.keys = NamedKeyStrokeArrayConfigurer.decode(encodedKeys);
        } else {
            this.keys = new NamedKeyStroke[encodedKeys.length()];
            for (int i = 0; i < this.keys.length; ++i) {
                this.keys[i] = NamedKeyStroke.getNamedKeyStroke(encodedKeys.charAt(i), 128);
            }
        }
        this.reportFormat = st.nextToken("$location$: $newPieceName$ *");
        String encodedCycleDownKeys = st.nextToken("");
        if (encodedCycleDownKeys.indexOf(44) > 0) {
            this.cycleDownKeys = NamedKeyStrokeArrayConfigurer.decode(encodedCycleDownKeys);
        } else {
            this.cycleDownKeys = new NamedKeyStroke[encodedCycleDownKeys.length()];
            for (int i = 0; i < this.cycleDownKeys.length; ++i) {
                this.cycleDownKeys[i] = NamedKeyStroke.getNamedKeyStroke(encodedCycleDownKeys.charAt(i), 128);
            }
        }
        this.cycleReportFormat = StringArrayConfigurer.stringToArray(st.nextToken(""));
        this.description = st.nextToken("");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        int c = this.cycleReportFormat == null ? 0 : this.cycleReportFormat.length;
        String[] formats = new String[c + 1];
        String[] descriptions = new String[c + 1];
        formats[0] = this.reportFormat;
        descriptions[0] = this.getCommandDescription(this.description, Resources.getString("Editor.ReportState.report_format"));
        int j = 1;
        for (int i = 0; i < c; ++i) {
            formats[j] = this.cycleReportFormat[i];
            descriptions[j] = this.getCommandDescription(this.description, Resources.getString("Editor.ReportState.report_format_2"));
            ++j;
        }
        return this.getI18nData(formats, descriptions);
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof ReportState)) {
            return false;
        }
        ReportState c = (ReportState)o;
        if (!Arrays.equals(this.keys, c.keys)) {
            return false;
        }
        if (!Objects.equals(this.reportFormat, c.reportFormat)) {
            return false;
        }
        if (!Arrays.equals(this.cycleDownKeys, c.cycleDownKeys)) {
            return false;
        }
        if (!Arrays.equals(this.cycleReportFormat, c.cycleReportFormat)) {
            return false;
        }
        return Objects.equals(this.description, c.description);
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(this.keys);
    }

    @Override
    public List<String> getFormattedStringList() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.cycleIndex >= 0 && this.cycleReportFormat.length > 0) {
            Collections.addAll(l, this.cycleReportFormat);
        } else {
            l.add(this.reportFormat);
        }
        return l;
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        if (this.cycleIndex >= 0 && this.cycleReportFormat.length > 0) {
            for (String r : this.cycleReportFormat) {
                HTMLImageFinder h = new HTMLImageFinder(r);
                h.addImageNames(s);
            }
        } else {
            HTMLImageFinder h = new HTMLImageFinder(this.reportFormat);
            h.addImageNames(s);
        }
    }

    private static class OldAndNewPieceProperties
    implements PropertySource {
        private final java.util.Map<String, Object> oldPiece;
        private final GamePiece newPiece;

        public OldAndNewPieceProperties(java.util.Map<String, Object> oldPiece, GamePiece newPiece) {
            this.oldPiece = oldPiece;
            this.newPiece = newPiece;
        }

        @Override
        public Object getProperty(Object key) {
            Object value = null;
            if (key != null) {
                String name = key.toString();
                if (name.startsWith("old") && name.length() >= 4) {
                    name = name.substring(3);
                    value = this.oldPiece.get(name);
                } else {
                    value = this.newPiece.getProperty(key);
                }
            }
            return value;
        }

        @Override
        public Object getLocalizedProperty(Object key) {
            return this.getProperty(key);
        }
    }

    public static class Ed
    implements PieceEditor {
        private final NamedKeyStrokeArrayConfigurer keys;
        private final StringConfigurer format;
        private final JLabel formatLabel;
        private final BooleanConfigurer cycle;
        private final JLabel cycleLabel;
        private final StringArrayConfigurer cycleFormat;
        private final JLabel cycleDownLabel;
        private final NamedKeyStrokeArrayConfigurer cycleDownKeys;
        protected StringConfigurer descInput;
        private final TraitConfigPanel box = new TraitConfigPanel();

        public Ed(ReportState piece) {
            this.descInput = new StringConfigurer(piece.description);
            this.descInput.setHintKey("Editor.description_hint");
            this.box.add("Editor.description_label", (Configurer)this.descInput);
            this.keys = new NamedKeyStrokeArrayConfigurer(piece.keys);
            this.box.add("Editor.ReportState.report_on_these_keystrokes", (Configurer)this.keys);
            this.cycle = new BooleanConfigurer(piece.cycleReportFormat.length > 0);
            this.cycle.addPropertyChangeListener(e -> this.adjustVisibilty());
            this.box.add("Editor.ReportState.cycle_through_different_messages", (Configurer)this.cycle);
            this.formatLabel = new JLabel(Resources.getString("Editor.ReportState.report_format_3"));
            this.format = new PlayerIdFormattedStringConfigurer(new String[]{ReportState.COMMAND_NAME, ReportState.OLD_UNIT_NAME, ReportState.NEW_UNIT_NAME, ReportState.MAP_NAME, ReportState.OLD_MAP_NAME, ReportState.LOCATION_NAME, ReportState.OLD_LOCATION_NAME}, piece.reportFormat);
            this.box.add(this.formatLabel, (Configurer)this.format);
            this.cycleLabel = new JLabel(Resources.getString("Editor.ReportState.message_formats"));
            this.cycleFormat = new StringArrayConfigurer(piece.cycleReportFormat);
            this.box.add(this.cycleLabel, (Configurer)this.cycleFormat);
            this.cycleDownLabel = new JLabel(Resources.getString("Editor.ReportState.report_previous"));
            this.cycleDownKeys = new NamedKeyStrokeArrayConfigurer(piece.cycleDownKeys);
            this.box.add(this.cycleDownLabel, (Configurer)this.cycleDownKeys);
            this.adjustVisibilty();
        }

        private void adjustVisibilty() {
            this.format.getControls().setVisible(!this.cycle.getValueBoolean());
            this.formatLabel.setVisible(!this.cycle.getValueBoolean());
            this.cycleFormat.getControls().setVisible(this.cycle.getValueBoolean());
            this.cycleLabel.setVisible(this.cycle.getValueBoolean());
            this.cycleDownKeys.getControls().setVisible(this.cycle.getValueBoolean());
            this.cycleDownLabel.setVisible(this.cycle.getValueBoolean());
            Decorator.repack(this.box);
        }

        @Override
        public Component getControls() {
            return this.box;
        }

        @Override
        public String getState() {
            return this.cycle.getValueBoolean() ? "0" : "-1";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.keys.getValueString()).append(this.format.getValueString()).append(this.cycleDownKeys.getValueString()).append(this.cycleFormat.getValueString()).append(this.descInput.getValueString());
            return ReportState.ID + se.getValue();
        }
    }
}

