/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.Info;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.GpIdChecker;
import VASSAL.build.GpIdSupport;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.BasicCommandEncoder;
import VASSAL.build.module.BasicLogger;
import VASSAL.build.module.ChartWindow;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.ChessClockControl;
import VASSAL.build.module.Console;
import VASSAL.build.module.DiceButton;
import VASSAL.build.module.DoActionButton;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.GameRefresher;
import VASSAL.build.module.GameState;
import VASSAL.build.module.GlobalKeyCommand;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Inventory;
import VASSAL.build.module.KeyNamer;
import VASSAL.build.module.Map;
import VASSAL.build.module.ModuleExtension;
import VASSAL.build.module.MultiActionButton;
import VASSAL.build.module.NotesWindow;
import VASSAL.build.module.PieceWindow;
import VASSAL.build.module.PlayerHand;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.Plugin;
import VASSAL.build.module.PluginsLoader;
import VASSAL.build.module.PredefinedSetup;
import VASSAL.build.module.PrivateMap;
import VASSAL.build.module.PrototypesContainer;
import VASSAL.build.module.RandomTextButton;
import VASSAL.build.module.ServerConnection;
import VASSAL.build.module.SpecialDiceButton;
import VASSAL.build.module.StartupGlobalKeyCommand;
import VASSAL.build.module.ToolbarMenu;
import VASSAL.build.module.WizardSupport;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.GamePieceImageDefinitions;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.build.module.properties.ChangePropertyCommandEncoder;
import VASSAL.build.module.properties.GlobalProperties;
import VASSAL.build.module.properties.GlobalTranslatableMessages;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.build.module.properties.TranslatableString;
import VASSAL.build.module.properties.TranslatableStringContainer;
import VASSAL.build.module.turn.TurnTracker;
import VASSAL.build.widget.PieceSlot;
import VASSAL.chat.AddressBookServerConfigurer;
import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.DynamicClient;
import VASSAL.chat.HybridClient;
import VASSAL.chat.node.OfficialNodeClientFactory;
import VASSAL.chat.node.PrivateNodeClientFactory;
import VASSAL.chat.peer2peer.P2PClientFactory;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.Logger;
import VASSAL.command.NullCommand;
import VASSAL.configure.CompoundValidityChecker;
import VASSAL.configure.MandatoryComponent;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TextConfigurer;
import VASSAL.configure.password.ToggleablePasswordConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.I18nResourcePathFinder;
import VASSAL.i18n.Language;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.launch.PlayerWindow;
import VASSAL.preferences.PositionOption;
import VASSAL.preferences.Prefs;
import VASSAL.script.expression.Expression;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.CRCUtils;
import VASSAL.tools.DataArchive;
import VASSAL.tools.KeyStrokeListener;
import VASSAL.tools.KeyStrokeSource;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.QuickColors;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.ReflectionUtils;
import VASSAL.tools.ResourcePathFinder;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.ToolBarComponent;
import VASSAL.tools.WarningDialog;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.image.ImageTileSource;
import VASSAL.tools.image.tilecache.ImageTileDiskCache;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.swing.SwingUtils;
import VASSAL.tools.version.VersionUtils;
import java.awt.FileDialog;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GameModule
extends AbstractConfigurable
implements CommandEncoder,
ToolBarComponent,
PropertySource,
MutablePropertiesContainer,
TranslatableStringContainer,
GpIdSupport {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(GameModule.class);
    private static final String DEFAULT_NAME = "Unnamed module";
    public static final String MODULE_NAME = "name";
    public static final String MODULE_VERSION = "version";
    public static final String DESCRIPTION = "description";
    public static final String VASSAL_VERSION_CREATED = "VassalVersion";
    public static final String VASSAL_VERSION_RUNNING = "runningVassalVersion";
    public static final String NEXT_PIECESLOT_ID = "nextPieceSlotId";
    public static final String BUILDFILE = "buildFile.xml";
    public static final String BUILDFILE_OLD = "buildFile";
    public static final String REAL_NAME = "RealName";
    public static final String SECRET_NAME = "SecretName";
    public static final String PERSONAL_INFO = "Profile";
    public static final String MODULE_NAME_PROPERTY = "ModuleName";
    public static final String MODULE_VERSION_PROPERTY = "ModuleVersion";
    public static final String MODULE_DESCRIPTION_PROPERTY = "ModuleDescription";
    public static final String MODULE_OTHER1_PROPERTY = "ModuleOther1";
    public static final String MODULE_OTHER2_PROPERTY = "ModuleOther2";
    public static final String MODULE_VASSAL_VERSION_CREATED_PROPERTY = "VassalVersionCreated";
    public static final String MODULE_VASSAL_VERSION_RUNNING_PROPERTY = "VassalVersionRunning";
    public static final String MODULE_CURRENT_LOCALE = "CurrentLanguage";
    public static final String MODULE_CURRENT_LOCALE_NAME = "CurrentLanguageName";
    private static final char COMMAND_SEPARATOR = '\u001b';
    private static String userId = null;
    private static GameModule theModule;
    private static String DEFAULT_MODULE_VERSION;
    private String moduleVersion = DEFAULT_MODULE_VERSION;
    private String vassalVersionCreated = "0.0";
    private String moduleOther1 = "";
    private String moduleOther2 = "";
    private String gameName = "Unnamed module";
    private String localizedGameName = null;
    private String description = "";
    private String lastSavedConfiguration;
    private FileChooser fileChooser;
    private FileDialog fileDialog;
    private final MutablePropertiesContainer propsContainer = new MutablePropertiesContainer.Impl();
    private final TranslatableStringContainer transContainer = new TranslatableStringContainer.Impl();
    private final PropertyChangeListener repaintOnPropertyChange = evt -> {
        for (Map map : Map.getMapList()) {
            map.repaint();
        }
    };
    private final PlayerWindow frame = new PlayerWindow();
    @Deprecated(since="2020-08-06", forRemoval=true)
    private final JPanel controlPanel = this.frame.getControlPanel();
    private GameState theState;
    private final DataArchive archive;
    private final ResourcePathFinder resourceFinder;
    private Prefs preferences;
    private Logger logger;
    private Chatter chat;
    private final Console console = new Console();
    private PieceWindow pieceWindow = null;
    private final Random RNG = new SecureRandom();
    private ServerConnection server;
    private ChatServerControls serverControls;
    private ImageTileSource tcache;
    private WizardSupport wizardSupport;
    private PropertyChangeSupport idChangeSupport;
    private final List<KeyStrokeSource> keyStrokeSources = new ArrayList<KeyStrokeSource>();
    private final List<KeyStrokeListener> keyStrokeListeners = new ArrayList<KeyStrokeListener>();
    private int ourKeyStrokeSourceCount = -1;
    private int ourKeyStrokeListenerCount = -1;
    private final List<KeyStrokeSource> keyStrokeSourcesToAdd = new ArrayList<KeyStrokeSource>();
    private final List<KeyStrokeListener> keyStrokeListenersToAdd = new ArrayList<KeyStrokeListener>();
    private final List<PlayerRoster.SideChangeListener> sideChangeListenersToAdd = new ArrayList<PlayerRoster.SideChangeListener>();
    private CommandEncoder[] commandEncoders = new CommandEncoder[0];
    private final List<String> deferredChat = new ArrayList<String>();
    private boolean loggingPaused = false;
    private final Object loggingLock = new Object();
    private Command pausedCommands;
    private String gameFile = "";
    private GameFileMode gameFileMode = GameFileMode.NEW_GAME;
    private boolean iFeelDirty = false;
    private GpIdSupport gpidSupport = null;
    private int nextGpId = 0;
    private Long crc = null;
    private static boolean errorLogToChat;
    private boolean loadOverSemaphore = false;
    private boolean refreshingSemaphore = false;

    public void setLoadOverSemaphore(boolean state) {
        this.loadOverSemaphore = state;
    }

    public boolean isLoadOverSemaphore() {
        return this.loadOverSemaphore;
    }

    public void setRefreshingSemaphore(boolean state) {
        this.refreshingSemaphore = state;
    }

    public boolean isRefreshingSemaphore() {
        return this.refreshingSemaphore;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public JFrame getFrame() {
        ProblemDialog.showDeprecated("2020-08-06");
        return this.frame;
    }

    public String toString() {
        return "BasicModule{name='" + this.name + "', moduleVersion='" + this.moduleVersion + "'}";
    }

    public PlayerWindow getPlayerWindow() {
        return this.frame;
    }

    public void initFrameTitle() {
        this.frame.setTitle(this.getTitleString());
    }

    public WizardSupport getWizardSupport() {
        if (this.wizardSupport == null) {
            this.wizardSupport = new WizardSupport();
        }
        return this.wizardSupport;
    }

    public ChatServerControls getServerControls() {
        return this.serverControls;
    }

    public Console getConsole() {
        return this.console;
    }

    public static boolean isErrorLogToChat() {
        return errorLogToChat;
    }

    public static void setErrorLogToChat(boolean errorLogToChat) {
        GameModule.errorLogToChat = errorLogToChat;
    }

    @Override
    public String getI18nPrefix() {
        return "";
    }

    public void setDirty(boolean touchThis) {
        this.iFeelDirty = touchThis;
    }

    public GameModule(DataArchive archive) {
        this.archive = archive;
        boolean isEditing = archive instanceof ArchiveWriter;
        this.resourceFinder = new I18nResourcePathFinder(archive, isEditing ? "en" : Resources.getLocale().getLanguage());
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GameModule.this.quit();
            }
        });
        this.addKeyStrokeSource(new KeyStrokeSource(this.frame.getRootPane(), 2));
        this.validator = new CompoundValidityChecker(new MandatoryComponent(this, Documentation.class), new MandatoryComponent(this, GlobalOptions.class));
        this.addCommandEncoder(new ChangePropertyCommandEncoder(this.propsContainer));
    }

    void build() throws IOException {
        DataArchive darch = this.getDataArchive();
        File f = new File(darch.getName());
        if (!f.exists() || f.length() == 0L) {
            this.build(null);
        } else {
            AbstractMetaData data = MetaDataFactory.buildMetaData(f);
            if (!(data instanceof ModuleMetaData)) {
                throw new IOException(Resources.getString("BasicModule.not_a_module"), null);
            }
            String properBuildFileName = VersionUtils.compareVersions(VersionUtils.truncateToMinorVersion(data.getVassalVersion()), "3.5") < 0 ? BUILDFILE_OLD : BUILDFILE;
            try (InputStream inner = darch.getInputStream(properBuildFileName);
                 BufferedInputStream in = new BufferedInputStream(inner);){
                Document doc = Builder.createDocument(in);
                this.build(doc.getDocumentElement());
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                throw new IOException(Resources.getString("BasicModule.no_buildfile"), e);
            }
            catch (IOException e) {
                throw new IOException(Resources.getString("BasicModule.io_error_reading_archive"), e);
            }
        }
        PieceWindow pw = this.getPieceWindow();
        if (pw != null) {
            pw.dockMe();
        }
        MenuManager.getInstance().addAction("Prefs.edit_preferences", this.getPrefs().getEditor().getEditAction());
        GameRefresher gameRefresher = new GameRefresher(this);
        gameRefresher.addTo(this);
        MenuManager.getInstance().addAction("GameRefresher.refresh_counters", gameRefresher.getRefreshAction());
    }

    @Override
    public void build(Element e) {
        if (e != null) {
            this.gameName = e.getAttribute(MODULE_NAME);
            if (e.getAttribute(VASSAL_VERSION_CREATED).length() > 0) {
                this.vassalVersionCreated = e.getAttribute(VASSAL_VERSION_CREATED);
            }
        }
        this.initIdentityPreferences();
        Prefs.initSharedGlobalPrefs();
        this.initGameState();
        this.initLogger();
        this.initServer();
        new PluginsLoader().addTo(this);
        if (e != null) {
            super.build(e);
            this.ensureComponent(GamePieceImageDefinitions.class);
            this.ensureComponent(GlobalProperties.class);
            if (this.isTranslatableSupport()) {
                this.ensureComponent(GlobalTranslatableMessages.class);
            }
            this.ensureComponent(Language.class);
            this.ensureComponent(BasicCommandEncoder.class);
            this.ensureComponent(Documentation.class);
            this.ensureComponent(PlayerRoster.class);
            this.ensureComponent(GlobalOptions.class);
            this.ensureComponent(PrototypesContainer.class);
            this.ensureComponent(Chatter.class);
            this.ensureComponent(KeyNamer.class);
        } else {
            this.buildDefaultComponents();
        }
        this.initFrame();
    }

    private void initIdentityPreferences() {
        this.idChangeSupport = new PropertyChangeSupport(this);
        StringConfigurer fullName = new StringConfigurer(REAL_NAME, Resources.getString("Prefs.name_label"), Resources.getString("Prefs.newbie"));
        fullName.addPropertyChangeListener(evt -> this.idChangeSupport.firePropertyChange(evt));
        TextConfigurer profile = new TextConfigurer(PERSONAL_INFO, Resources.getString("Prefs.personal_info"), "");
        profile.addPropertyChangeListener(evt -> this.idChangeSupport.firePropertyChange(evt));
        ToggleablePasswordConfigurer user = new ToggleablePasswordConfigurer(SECRET_NAME, Resources.getString("Prefs.password_label"), Resources.getString("Prefs.password_prompt", System.getProperty("user.name")));
        user.addPropertyChangeListener(evt -> GameModule.setUserId((String)evt.getNewValue()));
        this.getPrefs().addOption(Resources.getString("Prefs.personal_tab"), fullName);
        this.getPrefs().addOption(Resources.getString("Prefs.personal_tab"), user);
        this.getPrefs().addOption(Resources.getString("Prefs.personal_tab"), profile);
        GameModule.setUserId(user.getValueString());
    }

    private void initServer() {
        OfficialNodeClientFactory oncf = new OfficialNodeClientFactory();
        ChatServerFactory.register("official", oncf);
        ChatServerFactory.register("private", new PrivateNodeClientFactory());
        ChatServerFactory.register("peer2peer", new P2PClientFactory());
        ChatServerFactory.register("node", oncf);
        ChatServerFactory.register("jabber", oncf);
        this.server = new DynamicClient();
        AddressBookServerConfigurer config = new AddressBookServerConfigurer("ServerSelected", "", (HybridClient)this.server);
        Prefs.getGlobalPrefs().addOption(Resources.getString("Chat.server"), config);
        this.serverControls = new ChatServerControls();
        this.serverControls.addTo(this);
    }

    private void initLogger() {
        this.logger = new BasicLogger();
        ((BasicLogger)this.logger).build(null);
        ((BasicLogger)this.logger).addTo(this);
    }

    private void initGameState() {
        this.theState = new GameState();
        this.theState.addTo(this);
        this.addCommandEncoder(this.theState);
    }

    private void buildDefaultComponents() {
        this.addComponent(BasicCommandEncoder.class);
        this.addComponent(Documentation.class);
        this.addComponent(PlayerRoster.class);
        this.addComponent(GlobalOptions.class);
        this.addComponent(Map.class);
        this.addComponent(GamePieceImageDefinitions.class);
        this.addComponent(GlobalProperties.class);
        if (this.isTranslatableSupport()) {
            this.addComponent(GlobalTranslatableMessages.class);
        }
        this.addComponent(PrototypesContainer.class);
        this.addComponent(PieceWindow.class);
        this.addComponent(Chatter.class);
        this.addComponent(KeyNamer.class);
        this.addComponent(Language.class);
    }

    private void initFrame() {
        Rectangle screen = SwingUtils.getScreenBounds(this.frame);
        if (GlobalOptions.getInstance().isUseSingleWindow()) {
            this.frame.setLocation(screen.getLocation());
            Prefs p = Prefs.getGlobalPrefs();
            if (Boolean.FALSE.equals(p.getOption("mainWindowRemember").getValue())) {
                p.getOption("mainWindowWidth").setValue(-1);
                p.getOption("mainWindowHeight").setValue(-1);
            }
            int ph = (Integer)p.getOption("mainWindowHeight").getValue();
            int pw = (Integer)p.getOption("mainWindowWidth").getValue();
            int h = ph > 0 ? ph : screen.height;
            int w = pw > 0 ? pw : screen.width;
            this.frame.setSize(w, h / 3);
        } else {
            String key = "BoundsOfGameModule";
            Rectangle r = new Rectangle(0, 0, screen.width, screen.height / 4);
            this.getPrefs().addOption(new PositionOption("BoundsOfGameModule", this.frame, r));
        }
        String mess = Resources.getString("BasicModule.version_message", this.getLocalizedGameName(), this.moduleVersion);
        this.warn(mess);
        log.info(mess);
        this.initFrameTitle();
    }

    private void ensureComponent(Class<? extends Buildable> componentClass) {
        if (this.getComponentsOf(componentClass).isEmpty()) {
            this.addComponent(componentClass);
        }
    }

    private void addComponent(Class<? extends Buildable> componentClass) {
        Buildable child = null;
        try {
            child = componentClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            ReflectionUtils.handleNewInstanceFailure(t, componentClass);
        }
        if (child != null) {
            child.build(null);
            child.addTo(this);
            this.add(child);
        }
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (MODULE_NAME.equals(name)) {
            if (Localization.getInstance().isTranslationInProgress()) {
                this.localizedGameName = (String)value;
            } else {
                this.gameName = (String)value;
            }
            this.setConfigureName((String)value);
        } else if (MODULE_VERSION.equals(name)) {
            this.moduleVersion = (String)value;
        } else if (VASSAL_VERSION_CREATED.equals(name)) {
            this.vassalVersionCreated = (String)value;
            String runningVersion = Info.getVersion();
            if (VersionUtils.compareVersions(this.vassalVersionCreated, runningVersion) > 0) {
                WarningDialog.show("GameModule.version_warning", this.vassalVersionCreated, runningVersion);
            }
        } else if (NEXT_PIECESLOT_ID.equals(name)) {
            try {
                this.nextGpId = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalBuildException(e);
            }
        } else if (DESCRIPTION.equals(name)) {
            this.description = (String)value;
        } else if (MODULE_OTHER1_PROPERTY.equals(name)) {
            this.moduleOther1 = (String)value;
        } else if (MODULE_OTHER2_PROPERTY.equals(name)) {
            this.moduleOther2 = (String)value;
        }
    }

    @Override
    public String getAttributeValueString(String name) {
        if (MODULE_NAME.equals(name)) {
            return this.gameName;
        }
        if (MODULE_VERSION.equals(name)) {
            return this.moduleVersion;
        }
        if (VASSAL_VERSION_CREATED.equals(name)) {
            return this.vassalVersionCreated;
        }
        if (VASSAL_VERSION_RUNNING.equals(name)) {
            return Info.getVersion();
        }
        if (NEXT_PIECESLOT_ID.equals(name)) {
            return String.valueOf(this.nextGpId);
        }
        if (DESCRIPTION.equals(name)) {
            return this.description;
        }
        if (MODULE_OTHER1_PROPERTY.equals(name)) {
            return this.moduleOther1;
        }
        if (MODULE_OTHER2_PROPERTY.equals(name)) {
            return this.moduleOther2;
        }
        return null;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public static int compareVersions(String v1, String v2) {
        ProblemDialog.showDeprecated("2020-08-06");
        return VersionUtils.compareVersions(v1, v2);
    }

    @Override
    public void addTo(Buildable b) {
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.GameModule.component_type");
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.html");
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{MODULE_NAME, MODULE_VERSION, DESCRIPTION, MODULE_OTHER1_PROPERTY, MODULE_OTHER2_PROPERTY, VASSAL_VERSION_CREATED, NEXT_PIECESLOT_ID};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.GameModule.name_label"), Resources.getString("Editor.GameModule.version_label"), Resources.getString("Editor.description_label"), Resources.getString("Editor.GameModule.module_other_1_label"), Resources.getString("Editor.GameModule.module_other_2_label")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, String.class, String.class, String.class};
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{Map.class, PieceWindow.class, PrototypesContainer.class, ToolbarMenu.class, MultiActionButton.class, DoActionButton.class, DiceButton.class, GlobalKeyCommand.class, StartupGlobalKeyCommand.class, Inventory.class, RandomTextButton.class, SpecialDiceButton.class, PredefinedSetup.class, ChartWindow.class, PrivateMap.class, PlayerHand.class, NotesWindow.class, TurnTracker.class, ChessClockControl.class};
    }

    public void addKeyStrokeSource(KeyStrokeSource src) {
        this.keyStrokeSourcesToAdd.add(src);
    }

    private void addKeyStrokeSourceNow(KeyStrokeSource src) {
        if (!this.keyStrokeSources.contains(src)) {
            this.keyStrokeSources.add(src);
            for (KeyStrokeListener l : this.keyStrokeListeners) {
                l.addKeyStrokeSource(src);
            }
        }
    }

    public void addKeyStrokeListener(KeyStrokeListener l) {
        this.keyStrokeListenersToAdd.add(l);
    }

    private void addKeyStrokeListenerNow(KeyStrokeListener l) {
        if (!this.keyStrokeListeners.contains(l)) {
            this.keyStrokeListeners.add(l);
            for (KeyStrokeSource s : this.keyStrokeSources) {
                l.addKeyStrokeSource(s);
            }
        }
    }

    protected void markModuleListeners() {
        this.ourKeyStrokeSourceCount = this.keyStrokeSources.size();
        this.ourKeyStrokeListenerCount = this.keyStrokeListeners.size();
        this.getPlayerRoster().markModuleListeners();
    }

    public void incorporateSourcesAndListeners() {
        for (KeyStrokeSource keyStrokeSource : this.keyStrokeSourcesToAdd) {
            this.addKeyStrokeSourceNow(keyStrokeSource);
        }
        for (KeyStrokeListener keyStrokeListener : this.keyStrokeListenersToAdd) {
            this.addKeyStrokeListenerNow(keyStrokeListener);
        }
        for (PlayerRoster.SideChangeListener sideChangeListener : this.sideChangeListenersToAdd) {
            this.addSideChangeListenerToPlayerRosterNow(sideChangeListener);
        }
        this.keyStrokeSourcesToAdd.clear();
        this.keyStrokeListenersToAdd.clear();
        this.sideChangeListenersToAdd.clear();
    }

    public void resetSourcesAndListeners() {
        int curSourcesSize = this.keyStrokeSources.size();
        int curListenersSize = this.keyStrokeListeners.size();
        List<KeyStrokeSource> sourcesToRemove = this.keyStrokeSources.subList(this.ourKeyStrokeSourceCount, curSourcesSize);
        for (KeyStrokeListener l : this.keyStrokeListeners) {
            for (KeyStrokeSource s : sourcesToRemove) {
                l.removeKeyStrokeSource(s);
            }
        }
        List<KeyStrokeListener> listenersToRemove = this.keyStrokeListeners.subList(this.ourKeyStrokeListenerCount, curListenersSize);
        for (KeyStrokeListener l : listenersToRemove) {
            for (KeyStrokeSource s : this.keyStrokeSources) {
                l.removeKeyStrokeSource(s);
            }
        }
        this.getPlayerRoster().resetListeners();
        sourcesToRemove.clear();
        listenersToRemove.clear();
        this.keyStrokeSourcesToAdd.clear();
        this.keyStrokeListenersToAdd.clear();
        this.sideChangeListenersToAdd.clear();
        Expression.resetCachedExpressions();
    }

    public void refreshKeyStrokeListeners() {
        this.keyStrokeListeners.forEach(l -> l.setKeyStroke(l.getKeyStroke()));
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public void fireKeyStroke(KeyStroke stroke) {
        ProblemDialog.showDeprecated("2020-08-06");
        if (stroke != null) {
            for (KeyStrokeListener l : this.keyStrokeListeners) {
                l.keyPressed(stroke);
            }
        }
    }

    public void fireKeyStroke(NamedKeyStroke stroke) {
        if (stroke == null || stroke.isNull()) {
            return;
        }
        KeyStroke innerStroke = stroke.getKeyStroke();
        if (innerStroke == null) {
            return;
        }
        this.keyStrokeListeners.forEach(l -> l.keyPressed(innerStroke));
    }

    public String getGameName() {
        return this.gameName;
    }

    public String getLocalizedGameName() {
        return this.localizedGameName == null ? this.gameName : this.localizedGameName;
    }

    public String getGameVersion() {
        return this.moduleVersion;
    }

    public void addIdChangeListener(PropertyChangeListener l) {
        this.idChangeSupport.addPropertyChangeListener(l);
    }

    public void removeIdChangeListener(PropertyChangeListener l) {
        this.idChangeSupport.removePropertyChangeListener(l);
    }

    public Prefs getPrefs() {
        if (this.preferences == null) {
            this.setPrefs(new Prefs(Prefs.getGlobalPrefs().getEditor(), this.gameName));
        }
        return this.preferences;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public Prefs getGlobalPrefs() {
        ProblemDialog.showDeprecated("2020-08-06");
        return Prefs.getGlobalPrefs();
    }

    public boolean isTranslatableSupport() {
        Prefs p = Prefs.getGlobalPrefs();
        return Boolean.TRUE.equals(p.getOption("translatableSupport").getValue());
    }

    public void addCommandEncoder(CommandEncoder ce) {
        this.commandEncoders = (CommandEncoder[])ArrayUtils.add((Object[])this.commandEncoders, (Object)ce);
    }

    public void removeCommandEncoder(CommandEncoder ce) {
        this.commandEncoders = (CommandEncoder[])ArrayUtils.removeElement((Object[])this.commandEncoders, (Object)ce);
    }

    public GamePiece createPiece(String type) {
        for (CommandEncoder commandEncoder : this.commandEncoders) {
            GamePiece p;
            if (!(commandEncoder instanceof BasicCommandEncoder) || (p = ((BasicCommandEncoder)commandEncoder).createPiece(type)) == null) continue;
            return p;
        }
        return null;
    }

    public GamePiece createPiece(String type, GamePiece inner) {
        for (CommandEncoder commandEncoder : this.commandEncoders) {
            Decorator p;
            if (!(commandEncoder instanceof BasicCommandEncoder) || (p = ((BasicCommandEncoder)commandEncoder).createDecorator(type, inner)) == null) continue;
            return p;
        }
        return null;
    }

    public void warn(String s) {
        String s2 = s;
        if (s2.isEmpty() || QuickColors.getQuickColor(s) == -1) {
            s2 = s2.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        }
        if (this.chat == null) {
            this.deferredChat.add(s2);
        } else {
            this.chat.show(" - " + s2);
        }
    }

    public Random getRNG() {
        return this.RNG;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setChatter(Chatter c) {
        this.chat = c;
        if (!this.deferredChat.isEmpty()) {
            for (String msg : this.deferredChat) {
                this.warn(msg);
            }
            this.deferredChat.clear();
        }
    }

    public JComponent getControlPanel() {
        return this.controlPanel;
    }

    public Chatter getChatter() {
        return this.chat;
    }

    public PieceWindow getPieceWindow() {
        return this.pieceWindow;
    }

    public void setPieceWindow(PieceWindow pieceWindow) {
        this.pieceWindow = pieceWindow;
    }

    public void setPrefs(Prefs p) {
        this.preferences = p;
        this.preferences.getEditor().initDialog(this.getPlayerWindow());
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public void setGlobalPrefs(Prefs p) {
        ProblemDialog.showDeprecated("2020-08-06");
    }

    @Override
    public Command decode(String command) {
        Command c;
        if (command == null) {
            return null;
        }
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(command, '\u001b');
        String first = st.nextToken();
        if (command.equals(first)) {
            c = this.decodeSubCommand(first);
        } else {
            c = this.decode(first);
            while (st.hasMoreTokens()) {
                Command next = this.decode(st.nextToken());
                c = c == null ? next : c.append(next);
            }
        }
        return c;
    }

    private Command decodeSubCommand(String subCommand) {
        Command c = null;
        for (int i = 0; i < this.commandEncoders.length && c == null; ++i) {
            c = this.commandEncoders[i].decode(subCommand);
        }
        return c;
    }

    @Override
    public String encode(Command c) {
        if (c == null) {
            return null;
        }
        String s = this.encodeSubCommand(c);
        Command[] sub = c.getSubCommands();
        if (sub.length > 0) {
            SequenceEncoder se = new SequenceEncoder(s, '\u001b');
            for (Command command : sub) {
                String s2 = this.encode(command);
                if (s2 == null) continue;
                se.append(s2);
            }
            s = se.getValue();
        }
        return s;
    }

    private String encodeSubCommand(Command c) {
        String s = null;
        for (int i = 0; i < this.commandEncoders.length && s == null; ++i) {
            s = this.commandEncoders[i].encode(c);
        }
        return s;
    }

    public FileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = FileChooser.createFileChooser(this.getPlayerWindow(), this.getGameState().getSavedGameDirectoryPreference());
        } else {
            this.fileChooser.resetChoosableFileFilters();
            this.fileChooser.rescanCurrentDirectory();
        }
        return this.fileChooser;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public FileDialog getFileDialog() {
        ProblemDialog.showDeprecated("2020-08-06");
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog(this.getPlayerWindow());
            File f = this.getGameState().getSavedGameDirectoryPreference().getFileValue();
            if (f != null) {
                this.fileDialog.setDirectory(f.getPath());
            }
            this.fileDialog.setModal(true);
        } else {
            this.fileDialog.setDirectory(this.fileDialog.getDirectory());
        }
        return this.fileDialog;
    }

    @Override
    public JToolBar getToolBar() {
        return this.frame.getToolBar();
    }

    public String getWindowTitleString(String key, String name) {
        String version = this.getGameVersion();
        Object nameString = !DEFAULT_MODULE_VERSION.equals(version) ? name + " " + version : name;
        if (StringUtils.isEmpty((CharSequence)this.gameFile) || GameFileMode.NEW_GAME.equals((Object)this.gameFileMode)) {
            return Resources.getString(key + "_title", nameString, "", Info.getVersion());
        }
        return Resources.getString(key + "_title_" + this.gameFileMode, nameString, this.gameFile, Info.getVersion());
    }

    public String getTitleString() {
        return this.getWindowTitleString("GameModule.frame", this.getLocalizedGameName());
    }

    public void updateTitleBar() {
        this.frame.setTitle(this.getTitleString());
        for (Map m : this.getComponentsOf(Map.class)) {
            m.updateTitleBar();
        }
    }

    @Deprecated(since="2020-09-16", forRemoval=true)
    public void appendToTitle(String s) {
    }

    public void setGameFile(String gameFile, GameFileMode mode) {
        this.gameFile = gameFile;
        this.setGameFileMode(mode);
        this.updateTitleBar();
    }

    public String getGameFile() {
        return this.gameFile;
    }

    public void setGameFileMode(GameFileMode mode) {
        this.gameFileMode = Objects.requireNonNull(mode);
        this.updateTitleBar();
    }

    public GameFileMode getGameFileMode() {
        return this.gameFileMode;
    }

    public boolean isReplayingOrLogging() {
        return this.gameFileMode == GameFileMode.LOGGING_GAME || this.gameFileMode == GameFileMode.REPLAYING_GAME;
    }

    public void quit() {
        if (this.shutDown()) {
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutDown() {
        this.getGameState().setup(false);
        boolean cancelled = this.getGameState().isGameStarted();
        if (!cancelled) {
            if (this.getDataArchive() instanceof ArchiveWriter && (!this.buildString().equals(this.lastSavedConfiguration) || this.iFeelDirty)) {
                switch (JOptionPane.showConfirmDialog(this.frame, Resources.getString("GameModule.save_module"), "", 1)) {
                    case 0: {
                        this.save();
                        break;
                    }
                    case -1: 
                    case 2: {
                        cancelled = true;
                    }
                }
            }
            for (ModuleExtension ext : this.getComponentsOf(ModuleExtension.class)) {
                cancelled = !ext.confirmExit();
            }
        }
        if (!cancelled) {
            Prefs p = null;
            try {
                p = this.getPrefs();
                p.save();
            }
            catch (IOException e) {
                WriteErrorDialog.error(e, p.getFile());
            }
            finally {
                if (p != null) {
                    try {
                        p.close();
                    }
                    catch (IOException e) {
                        log.error("Error while closing module preferences", (Throwable)e);
                    }
                }
            }
            try {
                this.archive.close();
            }
            catch (IOException e) {
                ReadErrorDialog.error(e, this.archive.getName());
            }
            log.info("Exiting");
        }
        return !cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAndLog(Command c) {
        if (c != null && !c.isNull()) {
            Object object = this.loggingLock;
            synchronized (object) {
                if (this.loggingPaused) {
                    if (this.pausedCommands == null) {
                        this.pausedCommands = c;
                    } else {
                        this.pausedCommands.append(c);
                    }
                } else {
                    this.getServer().sendToOthers(c);
                    this.getLogger().log(c);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pauseLogging() {
        Object object = this.loggingLock;
        synchronized (object) {
            if (this.loggingPaused) {
                return false;
            }
            this.loggingPaused = true;
            this.pausedCommands = null;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command resumeLogging() {
        Command c;
        Object object = this.loggingLock;
        synchronized (object) {
            c = this.pausedCommands == null ? new NullCommand() : this.pausedCommands;
            this.pausedCommands = null;
            this.loggingPaused = false;
        }
        return c;
    }

    public void clearPausedCommands() {
        this.pausedCommands = null;
    }

    public static String getUserId() {
        return userId;
    }

    public static void setUserId(String newId) {
        userId = newId;
    }

    public ServerConnection getServer() {
        return this.server;
    }

    public static void init(GameModule module) throws IOException {
        if (theModule != null) {
            throw new UnsupportedOperationException(Resources.getString("GameModule.open_error", theModule.getDataArchive().getName()));
        }
        theModule = module;
        theModule.setGpIdSupport(theModule);
        try {
            theModule.build();
        }
        catch (IOException e) {
            theModule = null;
            throw e;
        }
        if (theModule.getDataArchive() instanceof ArchiveWriter) {
            theModule.checkGpIds();
        }
        for (Plugin plugin : theModule.getComponentsOf(Plugin.class)) {
            plugin.init();
        }
        theModule.incorporateSourcesAndListeners();
        theModule.markModuleListeners();
    }

    public void updateLastSave() {
        this.lastSavedConfiguration = this.buildString();
    }

    @Override
    public String generateGpId() {
        return String.valueOf(this.nextGpId++);
    }

    @Override
    public int getNextGpId() {
        return this.nextGpId;
    }

    @Override
    public void setNextGpId(int id) {
        this.nextGpId = id;
    }

    public void setGpIdSupport(GpIdSupport s) {
        this.gpidSupport = s;
    }

    public GpIdSupport getGpIdSupport() {
        return this.gpidSupport;
    }

    private void checkGpIds() {
        GpIdChecker checker = new GpIdChecker(this);
        for (PieceSlot pieceSlot : this.getAllDescendantComponentsOf(PieceSlot.class)) {
            checker.add(pieceSlot);
        }
        for (PrototypesContainer pc : this.getComponentsOf(PrototypesContainer.class)) {
            pc.getDefinitions().forEach(checker::add);
        }
        checker.fixErrors();
    }

    public DataArchive getDataArchive() {
        return this.archive;
    }

    public ResourcePathFinder getResourcePathFinder() {
        return this.resourceFinder;
    }

    public ArchiveWriter getArchiveWriter() {
        return this.archive.getWriter();
    }

    public ImageTileSource getImageTileSource() {
        if (this.tcache == null) {
            String hstr = DigestUtils.sha1Hex((String)(this.getGameName() + "_" + this.getGameVersion()));
            File tc = new File(Info.getConfDir(), "tiles/" + hstr);
            this.tcache = new ImageTileDiskCache(tc.getAbsolutePath());
        }
        return this.tcache;
    }

    public boolean isLocalizationEnabled() {
        return this.getArchiveWriter() == null;
    }

    public boolean isEditorOpen() {
        return !this.isLocalizationEnabled();
    }

    public static GameModule getGameModule() {
        return theModule;
    }

    public GameState getGameState() {
        return this.theState;
    }

    public void saveAs() {
        this.save(true);
    }

    public void save() {
        this.save(false);
    }

    private void save(boolean saveAs) {
        this.vassalVersionCreated = Info.getVersion();
        this.iFeelDirty = false;
        ArchiveWriter writer = this.getArchiveWriter();
        try {
            new ModuleMetaData(this).save(writer);
        }
        catch (IOException e) {
            WriteErrorDialog.error(e, writer.getName());
        }
        try {
            String save = this.buildString();
            writer.addFile(BUILDFILE, save.getBytes(StandardCharsets.UTF_8));
            writer.removeFile(BUILDFILE_OLD);
            if (saveAs) {
                writer.saveAs(true);
            } else {
                writer.save(true);
            }
            this.lastSavedConfiguration = save;
            this.warn(Resources.getString("Editor.GameModule.saved", writer.getArchive().getFile().getName()));
        }
        catch (IOException e) {
            WriteErrorDialog.showError(this.getPlayerWindow(), e, writer.getArchive().getFile(), "Error.file_write_error");
        }
    }

    private String buildString() {
        Document doc = Builder.createNewDocument();
        doc.appendChild(this.getBuildElement(doc));
        return Builder.toString(doc);
    }

    @Override
    public Object getProperty(Object key) {
        if ("PlayerSide".equals(key) || "playerSide".equals(key)) {
            String mySide = PlayerRoster.getMySide();
            return mySide == null ? "" : mySide;
        }
        if ("PlayerName".equals(key) || "playerName".equals(key)) {
            return this.getPrefs().getValue(REAL_NAME);
        }
        if ("PlayerId".equals(key) || "playerId".equals(key)) {
            return GlobalOptions.getInstance().getPlayerId();
        }
        if (MODULE_NAME_PROPERTY.equals(key)) {
            return this.gameName;
        }
        if (MODULE_VERSION_PROPERTY.equals(key)) {
            return this.moduleVersion;
        }
        if (MODULE_DESCRIPTION_PROPERTY.equals(key)) {
            return this.description;
        }
        if (MODULE_VASSAL_VERSION_CREATED_PROPERTY.equals(key)) {
            return this.vassalVersionCreated;
        }
        if (MODULE_VASSAL_VERSION_RUNNING_PROPERTY.equals(key)) {
            return Info.getVersion();
        }
        if (MODULE_OTHER1_PROPERTY.equals(key)) {
            return this.moduleOther1;
        }
        if (MODULE_OTHER2_PROPERTY.equals(key)) {
            return this.moduleOther2;
        }
        if (MODULE_CURRENT_LOCALE.equals(key)) {
            return Resources.getLocale().getLanguage();
        }
        if (MODULE_CURRENT_LOCALE_NAME.equals(key)) {
            return Resources.getLocale().getDisplayName();
        }
        MutableProperty p = this.propsContainer.getMutableProperty(String.valueOf(key));
        if (p != null) {
            return p.getPropertyValue();
        }
        TranslatableString s = this.transContainer.getTranslatableString(String.valueOf(key));
        return s == null ? null : s.getPropertyValue();
    }

    @Override
    public MutableProperty getMutableProperty(String name) {
        return this.propsContainer.getMutableProperty(name);
    }

    @Override
    public TranslatableString getTranslatableString(String name) {
        return this.transContainer.getTranslatableString(name);
    }

    @Override
    public void addMutableProperty(String key, MutableProperty p) {
        this.propsContainer.addMutableProperty(key, p);
        p.addMutablePropertyChangeListener(this.repaintOnPropertyChange);
    }

    @Override
    public void addTranslatableString(String key, TranslatableString p) {
        this.transContainer.addTranslatableString(key, p);
    }

    @Override
    public MutableProperty removeMutableProperty(String key) {
        MutableProperty p = this.propsContainer.removeMutableProperty(key);
        if (p != null) {
            p.removeMutablePropertyChangeListener(this.repaintOnPropertyChange);
        }
        return p;
    }

    @Override
    public TranslatableString removeTranslatableString(String key) {
        return this.transContainer.removeTranslatableString(key);
    }

    @Override
    public String getMutablePropertiesContainerId() {
        return "Module";
    }

    @Override
    public String getTranslatableStringContainerId() {
        return "Module";
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if ("PlayerSide".equals(key) || "playerSide".equals(key)) {
            String mySide = PlayerRoster.getMyLocalizedSide();
            return mySide == null ? "" : mySide;
        }
        return this.getProperty(key);
    }

    public long getCrc() {
        if (this.crc == null) {
            this.crc = this.buildCrc();
        }
        return this.crc;
    }

    private Long buildCrc() {
        ArrayList<File> files = new ArrayList<File>();
        if (this.getDataArchive().getArchive() != null) {
            files.add(new File(this.getDataArchive().getName()));
        }
        for (ModuleExtension ext : this.getComponentsOf(ModuleExtension.class)) {
            if (ext.getDataArchive().getArchive() == null) continue;
            files.add(new File(ext.getDataArchive().getName()));
        }
        try {
            return CRCUtils.getCRC(files);
        }
        catch (IOException e) {
            log.error("Error generating CRC", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public ComponentI18nData getI18nData() {
        ComponentI18nData myI18nData = super.getI18nData();
        myI18nData.setAttributeTranslatable(MODULE_VERSION, false);
        return myI18nData;
    }

    public PlayerRoster getPlayerRoster() {
        return this.getComponentsOf(PlayerRoster.class).stream().findFirst().orElse(null);
    }

    public void addSideChangeListenerToPlayerRoster(PlayerRoster.SideChangeListener l) {
        this.sideChangeListenersToAdd.add(l);
    }

    private void addSideChangeListenerToPlayerRosterNow(PlayerRoster.SideChangeListener l) {
        PlayerRoster r = this.getPlayerRoster();
        if (r != null) {
            r.addSideChangeListenerToInstance(l);
        }
    }

    public void removeSideChangeListenerFromPlayerRoster(PlayerRoster.SideChangeListener l) {
        PlayerRoster r = this.getPlayerRoster();
        if (r != null) {
            r.removeSideChangeListenerFromInstance(l);
        }
    }

    @Override
    public List<String> getExpressionList() {
        return List.of(this.gameName, this.moduleVersion, this.description);
    }

    static {
        DEFAULT_MODULE_VERSION = "0.0";
        errorLogToChat = false;
    }

    public static enum GameFileMode {
        SAVED_GAME("saved"),
        LOADED_GAME("loaded"),
        REPLAYED_GAME("replayed"),
        REPLAYING_GAME("replaying"),
        LOGGING_GAME("logging"),
        LOGGED_GAME("logged"),
        NEW_GAME("new");

        private final String prettyName;

        private GameFileMode(String prettyName) {
            this.prettyName = prettyName;
        }

        public String toString() {
            return this.prettyName;
        }
    }
}

