/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.BadDataReport;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.GameModule;
import VASSAL.command.AddPiece;
import VASSAL.command.ChangePiece;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.MovePiece;
import VASSAL.command.NullCommand;
import VASSAL.command.PlayAudioClipCommand;
import VASSAL.command.RemovePiece;
import VASSAL.counters.ActionButton;
import VASSAL.counters.AreaOfEffect;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.CalculatedProperty;
import VASSAL.counters.Clone;
import VASSAL.counters.CounterGlobalKeyCommand;
import VASSAL.counters.Deck;
import VASSAL.counters.Decorator;
import VASSAL.counters.Delete;
import VASSAL.counters.Deselect;
import VASSAL.counters.DynamicProperty;
import VASSAL.counters.Embellishment;
import VASSAL.counters.Embellishment0;
import VASSAL.counters.Footprint;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.GlobalHotKey;
import VASSAL.counters.Hideable;
import VASSAL.counters.Immobilized;
import VASSAL.counters.Labeler;
import VASSAL.counters.Marker;
import VASSAL.counters.MenuSeparator;
import VASSAL.counters.MovementMarkable;
import VASSAL.counters.NonRectangular;
import VASSAL.counters.Obscurable;
import VASSAL.counters.Pivot;
import VASSAL.counters.PlaceMarker;
import VASSAL.counters.PlaySound;
import VASSAL.counters.PropertySheet;
import VASSAL.counters.Replace;
import VASSAL.counters.ReportState;
import VASSAL.counters.RestrictCommands;
import VASSAL.counters.Restricted;
import VASSAL.counters.ReturnToDeck;
import VASSAL.counters.SendToLocation;
import VASSAL.counters.SetGlobalProperty;
import VASSAL.counters.Stack;
import VASSAL.counters.SubMenu;
import VASSAL.counters.TableInfo;
import VASSAL.counters.TranslatableMessage;
import VASSAL.counters.Translate;
import VASSAL.counters.TriggerAction;
import VASSAL.counters.UsePrototype;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.SequenceEncoder;
import java.awt.Point;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BasicCommandEncoder
implements CommandEncoder,
Buildable {
    private final Map<String, BasicPieceFactory> basicFactories = Map.ofEntries(Map.entry("stack", type -> new Stack()), Map.entry("piece;", BasicPiece::new), Map.entry("deck;", type -> new Deck(GameModule.getGameModule(), type)));
    private final BasicPieceFactory defaultBasicPieceFactory = type -> null;
    private final Map<String, DecoratorFactory> decoratorFactories = Map.ofEntries(Map.entry("immob;", Immobilized::new), Map.entry("emb2;", (type, inner) -> {
        Embellishment e = new Embellishment(type, inner);
        if (e.getVersion() == 0) {
            return new Embellishment0(type, inner);
        }
        return e;
    }), Map.entry("emb;", Embellishment::new), Map.entry("hide;", Hideable::new), Map.entry("obs;", Obscurable::new), Map.entry("label;", Labeler::new), Map.entry("table;", TableInfo::new), Map.entry("propertysheet;", PropertySheet::new), Map.entry("rotate;", FreeRotator::new), Map.entry("pivot;", Pivot::new), Map.entry("nonRect;", NonRectangular::new), Map.entry("mark;", Marker::new), Map.entry("locmsg;", TranslatableMessage::new), Map.entry("restrict;", Restricted::new), Map.entry("placemark;", PlaceMarker::new), Map.entry("replace;", Replace::new), Map.entry("report;", ReportState::new), Map.entry("markmoved;", MovementMarkable::new), Map.entry("footprint;", Footprint::new), Map.entry("return;", ReturnToDeck::new), Map.entry("sendto;", SendToLocation::new), Map.entry("prototype;", UsePrototype::new), Map.entry("clone;", Clone::new), Map.entry("delete;", Delete::new), Map.entry("submenu;", SubMenu::new), Map.entry("menuSeparator;", MenuSeparator::new), Map.entry("translate;", Translate::new), Map.entry("AreaOfEffect;", AreaOfEffect::new), Map.entry("globalkey;", CounterGlobalKeyCommand::new), Map.entry("macro;", TriggerAction::new), Map.entry("PROP;", DynamicProperty::new), Map.entry("calcProp;", CalculatedProperty::new), Map.entry("setprop;", SetGlobalProperty::new), Map.entry("hideCmd;", RestrictCommands::new), Map.entry("playSound;", PlaySound::new), Map.entry("button;", ActionButton::new), Map.entry("globalhotkey;", GlobalHotKey::new), Map.entry("deselect;", Deselect::new));
    private final DecoratorFactory defaultDecoratorFactory = (type, inner) -> {
        ErrorDialog.dataWarning(new BadDataReport("Unknown type " + type + " not found in BasicCommandEncoder's list of traits and basic pieces.", ""));
        return new Marker("mark;", inner);
    };
    private static final char PARAM_SEPARATOR = '/';
    public static final String ADD = "+/";
    public static final String REMOVE = "-/";
    public static final String CHANGE = "D/";
    public static final String MOVE = "M/";

    private String typePrefix(String type) {
        String prefix = type.substring(0, type.indexOf(59) + 1);
        return prefix.isEmpty() ? type : prefix;
    }

    public Decorator createDecorator(String type, GamePiece inner) {
        return this.decoratorFactories.getOrDefault(this.typePrefix(type), this.defaultDecoratorFactory).createDecorator(type, inner);
    }

    protected GamePiece createBasic(String type) {
        return this.basicFactories.getOrDefault(this.typePrefix(type), this.defaultBasicPieceFactory).createBasicPiece(type);
    }

    public GamePiece createPiece(String type) {
        String innerType;
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, '\t');
        type = st.nextToken();
        String string = innerType = st.hasMoreTokens() ? st.nextToken() : null;
        if (innerType != null) {
            Decorator d;
            GamePiece inner = this.createPiece(innerType);
            if (inner == null) {
                ErrorDialog.dataWarning(new BadDataReport("Could not create piece with type " + innerType, type));
                inner = new BasicPiece();
            }
            return (d = this.createDecorator(type, inner)) != null ? d : inner;
        }
        return this.createBasic(type);
    }

    @Override
    public void build(Element e) {
        Builder.build(e, this);
    }

    @Override
    public void addTo(Buildable parent) {
        ((GameModule)parent).addCommandEncoder(this);
    }

    @Override
    public void add(Buildable b) {
    }

    @Override
    public Element getBuildElement(Document doc) {
        return doc.createElement(this.getClass().getName());
    }

    @Override
    public Command decode(String command) {
        if (command.length() == 0) {
            return new NullCommand();
        }
        if (command.startsWith(ADD)) {
            command = command.substring(ADD.length());
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(command, '/');
            String id = this.unwrapNull(st.nextToken());
            String type = st.nextToken();
            String state = st.nextToken();
            GamePiece p = this.createPiece(type);
            if (p == null) {
                return null;
            }
            p.setId(id);
            return new AddPiece(p, state);
        }
        if (command.startsWith(REMOVE)) {
            String id = command.substring(REMOVE.length());
            GamePiece target = GameModule.getGameModule().getGameState().getPieceForId(id);
            if (target == null) {
                return new RemovePiece(id);
            }
            return new RemovePiece(target);
        }
        if (command.startsWith(CHANGE)) {
            command = command.substring(CHANGE.length());
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(command, '/');
            String id = st.nextToken();
            String newState = st.nextToken();
            String oldState = st.hasMoreTokens() ? st.nextToken() : null;
            return new ChangePiece(id, oldState, newState);
        }
        if (command.startsWith(MOVE)) {
            command = command.substring(MOVE.length());
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(command, '/');
            String id = this.unwrapNull(st.nextToken());
            String newMapId = this.unwrapNull(st.nextToken());
            int newX = Integer.parseInt(st.nextToken());
            int newY = Integer.parseInt(st.nextToken());
            String newUnderId = this.unwrapNull(st.nextToken());
            String oldMapId = this.unwrapNull(st.nextToken());
            int oldX = Integer.parseInt(st.nextToken());
            int oldY = Integer.parseInt(st.nextToken());
            String oldUnderId = this.unwrapNull(st.nextToken());
            String playerid = st.nextToken(GameModule.getUserId());
            return new MovePiece(id, newMapId, new Point(newX, newY), newUnderId, oldMapId, new Point(oldX, oldY), oldUnderId, playerid);
        }
        return PlayAudioClipCommand.decode(command);
    }

    private String wrapNull(String s) {
        return s == null ? "null" : s;
    }

    private String unwrapNull(String s) {
        return "null".equals(s) ? null : s;
    }

    @Override
    public String encode(Command c) {
        SequenceEncoder se = new SequenceEncoder('/');
        if (c instanceof AddPiece) {
            AddPiece a = (AddPiece)c;
            return ADD + se.append(this.wrapNull(a.getTarget().getId())).append(a.getTarget().getType()).append(a.getState()).getValue();
        }
        if (c instanceof RemovePiece) {
            return REMOVE + ((RemovePiece)c).getId();
        }
        if (c instanceof ChangePiece) {
            ChangePiece cp = (ChangePiece)c;
            se.append(cp.getId()).append(cp.getNewState());
            if (cp.getOldState() != null) {
                se.append(cp.getOldState());
            }
            return CHANGE + se.getValue();
        }
        if (c instanceof MovePiece) {
            MovePiece mp = (MovePiece)c;
            se.append(mp.getId()).append(this.wrapNull(mp.getNewMapId())).append(mp.getNewPosition().x).append(mp.getNewPosition().y).append(this.wrapNull(mp.getNewUnderneathId())).append(this.wrapNull(mp.getOldMapId())).append(mp.getOldPosition().x).append(mp.getOldPosition().y).append(this.wrapNull(mp.getOldUnderneathId())).append(mp.getPlayerId());
            return MOVE + se.getValue();
        }
        if (c instanceof NullCommand) {
            return "";
        }
        if (c instanceof PlayAudioClipCommand) {
            return ((PlayAudioClipCommand)c).encode();
        }
        return null;
    }

    @FunctionalInterface
    public static interface BasicPieceFactory {
        public GamePiece createBasicPiece(String var1);
    }

    @FunctionalInterface
    public static interface DecoratorFactory {
        public Decorator createDecorator(String var1, GamePiece var2);
    }
}

