/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.chessclockcontrol.ChessClock;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.NullCommand;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.TranslatableStringEnum;
import VASSAL.i18n.Resources;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.NamedKeyStrokeListener;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.UniqueIdManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.w3c.dom.Element;

public class ChessClockControl
extends AbstractConfigurable
implements CommandEncoder,
GameComponent,
UniqueIdManager.Identifyable {
    protected static final UniqueIdManager ID_MGR = new UniqueIdManager("ChessClockControl");
    protected List<ChessClock> chessclocks = new ArrayList<ChessClock>();
    protected String showTenthSeconds = "Auto";
    protected String showSeconds = "Auto";
    protected String showHours = "Auto";
    protected String showDays = "Auto";
    protected boolean allowReset = false;
    protected LaunchButton chessClockButton;
    protected boolean chessClocksVisible;
    protected boolean onlineGame;
    protected NamedKeyStrokeListener nextListener;
    protected NamedKeyStrokeListener showListener;
    protected NamedKeyStrokeListener pauseListener;
    protected boolean instanceIsActive;
    protected String id;
    public static final char DELIMITER = '\t';
    public static final String NAME = "name";
    public static final String ICON = "icon";
    public static final String BUTTON_TEXT = "buttonText";
    public static final String BUTTON_TOOLTIP = "buttonTooltip";
    public static final String PAUSE_HOTKEY = "pauseHotkey";
    public static final String NEXT_HOTKEY = "nextHotkey";
    public static final String SHOW_HOTKEY = "showHotkey";
    public static final String SHOW_TENTHSECONDS = "showTenths";
    public static final String SHOW_SECONDS = "showSeconds";
    public static final String SHOW_HOURS = "showHours";
    public static final String SHOW_DAYS = "showDays";
    public static final String ALLOW_RESET = "allowReset";
    public static final String STYLE_ALWAYS = "Always";
    public static final String STYLE_AUTO = "Auto";
    public static final String STYLE_NEVER = "Never";
    public static final String CHESSMENU_PAUSE = Resources.getString("ChessClock.pause");
    public static final String CHESSMENU_SHOW = Resources.getString("ChessClock.show");
    public static final String CHESSMENU_HIDE = Resources.getString("ChessClock.hide");
    public static final String CHESSMENU_NEXT = Resources.getString("ChessClock.next");
    public static final String COMMAND_PREFIX = "CLOCKCONTROL\t";

    public ChessClockControl() {
        this.setConfigureName(Resources.getString("Editor.ChessClock.chess_clock_control"));
        this.chessClocksVisible = false;
        this.onlineGame = false;
        ActionListener al = e -> this.pressControlButton();
        this.chessClockButton = new LaunchButton("Chess Clocks", BUTTON_TOOLTIP, BUTTON_TEXT, SHOW_HOTKEY, ICON, al);
        this.chessClockButton.setToolTipText(Resources.getString("Editor.tooltip_text_label"));
        this.chessClockButton.setAttribute(ICON, "chess_clock.png");
        this.chessClockButton.addMouseListener(new ChessMouseListener());
        this.nextListener = new NamedKeyStrokeListener(e -> {
            Command c = this.startNextClock();
            if (c != null && !c.isNull()) {
                c.execute();
                GameModule.getGameModule().sendAndLog(c);
            }
        });
        GameModule.getGameModule().addKeyStrokeListener(this.nextListener);
        this.showListener = new NamedKeyStrokeListener(e -> this.pressControlButton());
        GameModule.getGameModule().addKeyStrokeListener(this.showListener);
        this.pauseListener = new NamedKeyStrokeListener(e -> {
            Command command = this.stopAllClocks();
            command.execute();
            GameModule.getGameModule().sendAndLog(command);
        });
        GameModule.getGameModule().addKeyStrokeListener(this.pauseListener);
    }

    public boolean isInstanceIsActive() {
        return this.instanceIsActive;
    }

    public List<ChessClock> getChessClocks() {
        return this.chessclocks;
    }

    @Override
    public void build(Element e) {
        super.build(e);
        if (e != null) {
            return;
        }
        PlayerRoster r = GameModule.getGameModule().getPlayerRoster();
        int added = 0;
        if (r != null) {
            for (String s : r.sides) {
                if (PlayerRoster.isSoloSide(s)) continue;
                this.addChild(new ChessClock(s));
                ++added;
            }
        }
        if (added == 0) {
            this.addChild(new ChessClock());
        }
    }

    private void addChild(Buildable b) {
        this.add(b);
        b.addTo(this);
    }

    @Override
    public void addTo(Buildable parent) {
        GameModule gameModule = GameModule.getGameModule();
        gameModule.getToolBar().add(this.getComponent());
        gameModule.addCommandEncoder(this);
        gameModule.getGameState().addGameComponent(this);
        ID_MGR.add(this);
        for (ChessClock c : this.chessclocks) {
            c.addToToolbar();
        }
        this.instanceIsActive = true;
    }

    @Override
    public void removeFrom(Buildable parent) {
        this.instanceIsActive = false;
        GameModule gameModule = GameModule.getGameModule();
        gameModule.getToolBar().remove(this.getComponent());
        gameModule.removeCommandEncoder(this);
        gameModule.getGameState().removeGameComponent(this);
        ID_MGR.remove(this);
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean isAllowReset() {
        return this.allowReset;
    }

    public boolean getChessClocksVisible() {
        return this.chessClocksVisible;
    }

    private JButton getComponent() {
        return this.chessClockButton;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.ChessClock.chess_clock_control");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{ChessClock.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, ICON, BUTTON_TEXT, BUTTON_TOOLTIP, SHOW_HOTKEY, NEXT_HOTKEY, PAUSE_HOTKEY, SHOW_TENTHSECONDS, SHOW_SECONDS, SHOW_HOURS, SHOW_DAYS, ALLOW_RESET};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.ChessClock.show_clocks_hotkey"), Resources.getString("Editor.ChessClock.start_next_clock_hotkey"), Resources.getString("Editor.ChessClock.pause_all_clocks_hotkey"), Resources.getString("Editor.ChessClock.show_tenths_of_seconds"), Resources.getString("Editor.ChessClock.show_seconds"), Resources.getString("Editor.ChessClock.show_hours"), Resources.getString("Editor.ChessClock.show_days"), Resources.getString("Editor.ChessClock.allow_reset")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, IconConfig.class, String.class, String.class, NamedKeyStroke.class, NamedKeyStroke.class, NamedKeyStroke.class, TimeStyleConfig.class, TimeStyleConfig.class, TimeStyleConfig.class, TimeStyleConfig.class, Boolean.class};
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)value);
        } else if (BUTTON_TOOLTIP.equals(key)) {
            this.chessClockButton.setToolTipText((String)value);
        } else if (NEXT_HOTKEY.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.nextListener.setKeyStroke((NamedKeyStroke)value);
        } else if (PAUSE_HOTKEY.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.pauseListener.setKeyStroke((NamedKeyStroke)value);
        } else if (SHOW_HOTKEY.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.showListener.setKeyStroke((NamedKeyStroke)value);
        } else if (SHOW_TENTHSECONDS.equals(key)) {
            this.showTenthSeconds = (String)value;
            this.updateAllClocks();
        } else if (SHOW_SECONDS.equals(key)) {
            this.showSeconds = (String)value;
            this.updateAllClocks();
        } else if (SHOW_HOURS.equals(key)) {
            this.showHours = (String)value;
            this.updateAllClocks();
        } else if (SHOW_DAYS.equals(key)) {
            this.showDays = (String)value;
            this.updateAllClocks();
        } else if (ALLOW_RESET.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.allowReset = (Boolean)value;
        } else {
            this.chessClockButton.setAttribute(key, value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (BUTTON_TOOLTIP.equals(key)) {
            return this.chessClockButton.getToolTipText();
        }
        if (NEXT_HOTKEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.nextListener.getNamedKeyStroke());
        }
        if (PAUSE_HOTKEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.pauseListener.getNamedKeyStroke());
        }
        if (SHOW_HOTKEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.showListener.getNamedKeyStroke());
        }
        if (SHOW_TENTHSECONDS.equals(key)) {
            return this.showTenthSeconds;
        }
        if (SHOW_SECONDS.equals(key)) {
            return this.showSeconds;
        }
        if (SHOW_HOURS.equals(key)) {
            return this.showHours;
        }
        if (SHOW_DAYS.equals(key)) {
            return this.showDays;
        }
        return this.chessClockButton.getAttributeValueString(key);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ChessClock.html");
    }

    public static ChessClockControl getInstance() {
        return GameModule.getGameModule().getAllDescendantComponentsOf(ChessClockControl.class).stream().findFirst().orElse(null);
    }

    public String getShowTenths() {
        return this.showTenthSeconds;
    }

    public String getShowSeconds() {
        return this.showSeconds;
    }

    public String getShowHours() {
        return this.showHours;
    }

    public String getShowDays() {
        return this.showDays;
    }

    public int getClocksTicking() {
        int running = 0;
        if (this.instanceIsActive && ChessClockControl.getInstance() != null) {
            for (ChessClock c : ChessClockControl.getInstance().chessclocks) {
                if (!c.isTicking()) continue;
                ++running;
            }
        }
        return running;
    }

    public Command stopAllClocks() {
        Command command = new NullCommand();
        if (this.instanceIsActive && ChessClockControl.getInstance() != null) {
            for (ChessClock c : ChessClockControl.getInstance().chessclocks) {
                if (!c.isTicking()) continue;
                command = command.append(c.updateState(false));
            }
        }
        return command;
    }

    public Command startNextClock() {
        Command command = new NullCommand();
        if (this.chessclocks.isEmpty()) {
            return command;
        }
        ChessClock first = null;
        boolean found = false;
        for (ChessClock clock : this.chessclocks) {
            if (first == null) {
                first = clock;
                if (this.chessclocks.size() == 1) {
                    command = command.append(clock.updateState(!clock.isTicking()));
                    return command;
                }
            }
            if (found) {
                command = command.append(clock.updateState(true));
                return command;
            }
            if (!clock.isTicking()) continue;
            command = command.append(clock.updateState(false));
            found = true;
        }
        if (first != null) {
            command = command.append(first.updateState(true));
        }
        return command;
    }

    public void hideClocks() {
        this.chessClocksVisible = false;
        if (this.instanceIsActive && ChessClockControl.getInstance() != null) {
            for (ChessClock c : ChessClockControl.getInstance().chessclocks) {
                c.hideClock();
            }
        }
    }

    public void showClocks() {
        this.chessClocksVisible = true;
        if (this.instanceIsActive && ChessClockControl.getInstance() != null) {
            for (ChessClock c : ChessClockControl.getInstance().chessclocks) {
                c.showClock();
            }
        }
    }

    public void updateAllClocks() {
        if (this.instanceIsActive && ChessClockControl.getInstance() != null) {
            for (ChessClock c : ChessClockControl.getInstance().chessclocks) {
                c.setTimerButton();
            }
        }
    }

    public void pressControlButton() {
        if (!this.chessClocksVisible) {
            this.showClocks();
        } else if (this.getClocksTicking() > 0) {
            Command command = this.stopAllClocks();
            command.execute();
            GameModule.getGameModule().sendAndLog(command);
        } else {
            this.hideClocks();
        }
    }

    public void setOnline(boolean online) {
        this.onlineGame = online;
    }

    public boolean isOnline() {
        return this.onlineGame;
    }

    @Override
    public void setup(boolean gameStarting) {
        if (gameStarting) {
            this.setOnline(GameModule.getGameModule().getServer().isConnected());
        } else {
            this.stopAllClocks();
        }
    }

    public void addChessClock(ChessClock clock) {
        this.chessclocks.add(clock);
    }

    public void removeChessClock(ChessClock clock) {
        this.chessclocks.remove(clock);
    }

    @Override
    public Command decode(String command) {
        if (!command.startsWith(COMMAND_PREFIX)) {
            return null;
        }
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(command, '\t');
        decoder.nextToken();
        boolean showing = decoder.nextBoolean(false);
        boolean online = decoder.nextBoolean(false);
        return new UpdateClockControlCommand(showing, online);
    }

    @Override
    public String encode(Command c) {
        if (!(c instanceof UpdateClockControlCommand)) {
            return null;
        }
        UpdateClockControlCommand comm = (UpdateClockControlCommand)c;
        SequenceEncoder encoder = new SequenceEncoder('\t');
        encoder.append(comm.showing);
        encoder.append(comm.online);
        return COMMAND_PREFIX + encoder.getValue();
    }

    @Override
    public Command getRestoreCommand() {
        return new UpdateClockControlCommand(this.chessClocksVisible, this.onlineGame);
    }

    private class ChessMouseListener
    implements MouseListener,
    ActionListener {
        protected JPopupMenu popup;

        private ChessMouseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.contains(CHESSMENU_NEXT)) {
                Command c = ChessClockControl.this.startNextClock();
                if (c != null && !c.isNull()) {
                    c.execute();
                    GameModule.getGameModule().sendAndLog(c);
                }
            } else if (command.contains(CHESSMENU_PAUSE)) {
                Command c = ChessClockControl.this.stopAllClocks();
                c.execute();
                GameModule.getGameModule().sendAndLog(c);
            } else if (command.contains(CHESSMENU_SHOW)) {
                ChessClockControl.this.pressControlButton();
            } else if (command.contains(CHESSMENU_HIDE)) {
                ChessClockControl.this.pressControlButton();
            }
        }

        void buildPopup() {
            this.popup = new JPopupMenu();
            this.popup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent evt) {
                    ChessClockControl.this.getComponent().repaint();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                    ChessClockControl.this.getComponent().repaint();
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                }
            });
            String s = ChessClockControl.this.getClocksTicking() > 0 ? CHESSMENU_PAUSE + "  " + NamedHotKeyConfigurer.getString(ChessClockControl.this.pauseListener.getNamedKeyStroke()) : (ChessClockControl.this.getChessClocksVisible() ? CHESSMENU_HIDE + "  " + NamedHotKeyConfigurer.getString(ChessClockControl.this.showListener.getNamedKeyStroke()) : CHESSMENU_SHOW + "  " + NamedHotKeyConfigurer.getString(ChessClockControl.this.showListener.getNamedKeyStroke()));
            JMenuItem item = new JMenuItem(s);
            item.addActionListener(this);
            this.popup.add(item);
            item = new JMenuItem(CHESSMENU_NEXT + "  " + NamedHotKeyConfigurer.getString(ChessClockControl.this.nextListener.getNamedKeyStroke()));
            item.addActionListener(this);
            this.popup.add(item);
        }

        void doPopup(Point p) {
            this.buildPopup();
            this.popup.show(ChessClockControl.this.getComponent(), p.x, p.y);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopup(e.getPoint());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopup(e.getPoint());
            }
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, ((ChessClockControl)c).chessClockButton.getAttributeValueString(ChessClockControl.ICON));
        }
    }

    public static class TimeStyleConfig
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{ChessClockControl.STYLE_ALWAYS, ChessClockControl.STYLE_AUTO, ChessClockControl.STYLE_NEVER};
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            return new String[]{"Editor.ChessClock.always", "Editor.ChessClock.auto", "Editor.ChessClock.never"};
        }
    }

    private class UpdateClockControlCommand
    extends Command {
        private final boolean showing;
        private final boolean online;

        public UpdateClockControlCommand(boolean showing, boolean online) {
            this.showing = showing;
            this.online = online;
        }

        @Override
        protected void executeCommand() {
            if (this.showing != ChessClockControl.this.chessClocksVisible) {
                if (this.showing) {
                    ChessClockControl.this.showClocks();
                } else {
                    ChessClockControl.this.hideClocks();
                }
            }
            if (GameModule.getGameModule().getServer().isConnected()) {
                ChessClockControl.this.onlineGame = true;
            } else if (!ChessClockControl.this.onlineGame) {
                ChessClockControl.this.onlineGame = this.online;
            }
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }

        @Override
        public boolean isLoggable() {
            return false;
        }
    }
}

