/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractToolbarItem;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.BasicLogger;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GameSetupStep;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.Logger;
import VASSAL.configure.ComponentConfigPanel;
import VASSAL.configure.Configurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JOptionPane;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class PlayerRoster
extends AbstractToolbarItem
implements CommandEncoder,
GameComponent,
GameSetupStep {
    public static final String BUTTON_ICON = "buttonIcon";
    public static final String BUTTON_TEXT = "buttonText";
    public static final String TOOL_TIP = "buttonToolTip";
    public static final String BUTTON_KEYSTROKE = "buttonKeyStroke";
    public static final String SIDES = "sides";
    public static final String COMMAND_PREFIX = "PLAYER\t";
    public static final String OBSERVER = "<observer>";
    public static final String SOLITAIRE = "Solitaire";
    public static final String REFEREE = "Referee";
    public static final String SOLO = "Solo";
    public static final String MODERATOR = "Moderator";
    protected List<PlayerInfo> players = new ArrayList<PlayerInfo>();
    protected List<String> sides = new ArrayList<String>();
    protected String[] untranslatedSides;
    protected LaunchButton retireButton;
    protected List<SideChangeListener> sideChangeListeners = new ArrayList<SideChangeListener>();
    protected int ourSideChangeListenerCount = -1;
    protected String translatedObserver;
    private boolean pickedSide = false;
    protected StringEnumConfigurer sideConfig;

    public PlayerRoster() {
        ActionListener al = e -> this.launch();
        this.setButtonTextKey(BUTTON_TEXT);
        this.setTooltipKey(TOOL_TIP);
        this.setIconKey(BUTTON_ICON);
        this.setHotKeyKey(BUTTON_KEYSTROKE);
        this.retireButton = this.makeLaunchButton(Resources.getString("PlayerRoster.allow_another"), Resources.getString("PlayerRoster.retire"), "", al);
        this.getLaunchButton().setVisible(false);
        this.translatedObserver = Resources.getString("PlayerRoster.observer");
    }

    @Override
    public void removeFrom(Buildable parent) {
        super.removeFrom(parent);
        GameModule gm = GameModule.getGameModule();
        gm.getGameState().removeGameComponent(this);
        gm.removeCommandEncoder(this);
    }

    @Override
    public void remove(Buildable child) {
    }

    @Override
    public void build(Element e) {
        if (e != null) {
            NamedNodeMap attributes = e.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr att = (Attr)attributes.item(i);
                if (BUTTON_ICON.equals(att.getName()) && "Retire".equals(att.getValue())) {
                    try {
                        GameModule.getGameModule().getDataArchive().getInputStream("images/" + att.getValue());
                    }
                    catch (IOException ex) {
                        continue;
                    }
                }
                this.retireButton.setAttribute(att.getName(), att.getValue());
                Localization.getInstance().saveTranslatableAttribute(this, att.getName(), att.getValue());
            }
            NodeList n = e.getElementsByTagName("*");
            this.sides.clear();
            for (int i = 0; i < n.getLength(); ++i) {
                Element el = (Element)n.item(i);
                this.sides.add(Builder.getText(el));
            }
            Localization.getInstance().saveTranslatableAttribute(this, SIDES, this.getSidesAsString());
        }
    }

    @Override
    public String getConfigureName() {
        return null;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.PlayerRoster.component_type");
    }

    @Override
    public void add(Buildable child) {
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    @Override
    public Element getBuildElement(Document doc) {
        Element el = doc.createElement(this.getClass().getName());
        String att = super.getAttributeValueString(BUTTON_TEXT);
        if (att != null) {
            el.setAttribute(BUTTON_TEXT, att);
        }
        if ((att = super.getAttributeValueString(BUTTON_ICON)) != null) {
            el.setAttribute(BUTTON_ICON, att);
        }
        if ((att = super.getAttributeValueString(TOOL_TIP)) != null) {
            el.setAttribute(TOOL_TIP, att);
        }
        if ((att = super.getAttributeValueString(BUTTON_KEYSTROKE)) != null) {
            el.setAttribute(BUTTON_KEYSTROKE, att);
        }
        for (String s : this.sides) {
            Element sub = doc.createElement("entry");
            sub.appendChild(doc.createTextNode(s));
            el.appendChild(sub);
        }
        return el;
    }

    @Override
    public Configurer getConfigurer() {
        return new Con();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    @Deprecated
    public static void addSideChangeListener(SideChangeListener l) {
        GameModule.getGameModule().addSideChangeListenerToPlayerRoster(l);
    }

    public void markModuleListeners() {
        this.ourSideChangeListenerCount = this.sideChangeListeners.size();
    }

    public void resetListeners() {
        int curSize = this.sideChangeListeners.size();
        if (this.ourSideChangeListenerCount == -1) {
            this.ourSideChangeListenerCount = curSize;
        } else {
            this.sideChangeListeners.subList(this.ourSideChangeListenerCount, curSize).clear();
        }
    }

    public void addSideChangeListenerToInstance(SideChangeListener l) {
        this.sideChangeListeners.add(l);
    }

    @Deprecated
    public static void removeSideChangeListener(SideChangeListener l) {
        PlayerRoster r = GameModule.getGameModule().getPlayerRoster();
        if (r != null) {
            r.sideChangeListeners.remove(l);
        }
    }

    public void removeSideChangeListenerFromInstance(SideChangeListener l) {
        this.sideChangeListeners.remove(l);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.html", "Definition_of_Player_Sides");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addTo(Buildable b) {
        GameModule gm = GameModule.getGameModule();
        gm.getGameState().addGameComponent(this);
        gm.getGameState().addGameSetupStep(this);
        gm.addCommandEncoder(this);
        super.addTo(b);
    }

    protected void launch() {
        String mySide = PlayerRoster.getMySide();
        if (mySide == null && this.allSidesAllocated()) {
            return;
        }
        String newSide = this.promptForSide();
        if (newSide == null || newSide.equals(mySide)) {
            return;
        }
        GameModule gm = GameModule.getGameModule();
        PlayerInfo me = new PlayerInfo(GameModule.getUserId(), GlobalOptions.getInstance().getPlayerId(), newSide);
        Command c = new Chatter.DisplayText(gm.getChatter(), Resources.getString(GlobalOptions.getInstance().chatterHTMLSupport() ? "PlayerRoster.changed_sides_2" : "PlayerRoster.changed_sides", me.playerName, mySide, newSide));
        c.execute();
        this.remove(GameModule.getUserId());
        Add a = new Add(this, me.playerId, me.playerName, me.side);
        a.execute();
        c = c.append(a);
        gm.getServer().sendToOthers(c);
        newSide = PlayerRoster.getMySide();
        this.fireSideChange(mySide, newSide);
    }

    protected void fireSideChange(String oldSide, String newSide) {
        for (SideChangeListener l : this.sideChangeListeners) {
            l.sideChanged(oldSide, newSide);
        }
    }

    public static boolean isActive() {
        return GameModule.getGameModule().getPlayerRoster() != null;
    }

    @Deprecated
    protected static PlayerRoster getInstance() {
        return GameModule.getGameModule().getPlayerRoster();
    }

    public static String getMySide() {
        return PlayerRoster.getMySide(false);
    }

    public static String getMyLocalizedSide() {
        return PlayerRoster.getMySide(true);
    }

    protected static String getMySide(boolean localized) {
        PlayerRoster r = GameModule.getGameModule().getPlayerRoster();
        if (r != null) {
            for (PlayerInfo pi : r.getPlayers()) {
                if (!pi.playerId.equals(GameModule.getUserId())) continue;
                return localized ? pi.getLocalizedSide() : pi.getSide();
            }
        }
        return null;
    }

    public PlayerInfo[] getPlayers() {
        return this.players.toArray(new PlayerInfo[0]);
    }

    public List<String> getSides() {
        return new ArrayList<String>(this.sides);
    }

    public void add(String playerId, String playerName, String side) {
        Logger log;
        PlayerInfo e = new PlayerInfo(playerId, playerName, side);
        if (this.players.contains(e)) {
            this.players.set(this.players.indexOf(e), e);
        } else {
            this.players.add(e);
        }
        if (this.isMultiPlayer() && (log = GameModule.getGameModule().getLogger()) instanceof BasicLogger) {
            ((BasicLogger)log).setMultiPlayer(true);
        }
    }

    public void remove(String playerId) {
        PlayerInfo e = new PlayerInfo(playerId, null, null);
        this.players.remove(e);
    }

    @Override
    public Command decode(String command) {
        if (!command.startsWith(COMMAND_PREFIX)) {
            return null;
        }
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(command, '\t');
        st.nextToken();
        return new Add(this, st.nextToken(), st.nextToken(), st.nextToken());
    }

    @Override
    public String encode(Command c) {
        if (!(c instanceof Add)) {
            return null;
        }
        Add a = (Add)c;
        SequenceEncoder se = new SequenceEncoder('\t');
        se.append(a.id).append(a.name).append(a.side);
        return COMMAND_PREFIX + se.getValue();
    }

    @Override
    public Command getRestoreCommand() {
        Add c = null;
        for (PlayerInfo entry : this.players) {
            Add sub = new Add(this, entry.playerId, entry.playerName, entry.side);
            c = c == null ? sub : c.append(sub);
        }
        return c;
    }

    @Override
    public void setup(boolean gameStarting) {
        if (gameStarting) {
            Logger log;
            PlayerInfo me = new PlayerInfo(GameModule.getUserId(), GlobalOptions.getInstance().getPlayerId(), null);
            if (this.players.contains(me)) {
                PlayerInfo saved = this.players.get(this.players.indexOf(me));
                saved.playerName = me.playerName;
            }
            if (this.isMultiPlayer() && (log = GameModule.getGameModule().getLogger()) instanceof BasicLogger) {
                ((BasicLogger)log).setMultiPlayer(true);
            }
        } else {
            this.players.clear();
        }
        this.getLaunchButton().setVisible(gameStarting && PlayerRoster.getMySide() != null);
        this.pickedSide = false;
    }

    @Override
    public void finish() {
        String newSide = this.untranslateSide(this.sideConfig.getValueString());
        if (newSide != null) {
            Add a = new Add(this, GameModule.getUserId(), GlobalOptions.getInstance().getPlayerId(), newSide);
            a.execute();
            GameModule.getGameModule().getServer().sendToOthers(a);
        }
        this.getLaunchButton().setVisible(PlayerRoster.getMySide() != null);
        this.pickedSide = true;
    }

    @Override
    public Component getControls() {
        ArrayList<String> availableSides = new ArrayList<String>(this.sides);
        ArrayList<String> alreadyTaken = new ArrayList<String>();
        for (PlayerInfo p : this.players) {
            alreadyTaken.add(p.side);
        }
        availableSides.removeAll(alreadyTaken);
        availableSides.add(0, this.translatedObserver);
        this.sideConfig = new StringEnumConfigurer(null, Resources.getString("PlayerRoster.join_game_as"), availableSides.toArray(new String[0]));
        this.sideConfig.setValue(this.translatedObserver);
        return this.sideConfig.getControls();
    }

    @Override
    public String getStepTitle() {
        return Resources.getString("PlayerRoster.choose_side");
    }

    @Override
    public boolean isFinished() {
        if (this.pickedSide) {
            return true;
        }
        if (this.allSidesAllocated()) {
            return true;
        }
        PlayerInfo newPlayerInfo = new PlayerInfo(GameModule.getUserId(), GlobalOptions.getInstance().getPlayerId(), null);
        int i = this.players.indexOf(newPlayerInfo);
        if (i != -1) {
            return !OBSERVER.equals(this.players.get(i).getSide());
        }
        return false;
    }

    protected boolean allSidesAllocated() {
        int allocatedSideCount = 0;
        for (PlayerInfo p : this.players) {
            if (OBSERVER.equals(p.getSide())) continue;
            ++allocatedSideCount;
        }
        return this.sides.size() == allocatedSideCount;
    }

    public static boolean isSoloSide(String side) {
        return Resources.getString("PlayerRoster.solitaire").equals(side) || Resources.getString("PlayerRoster.solo").equals(side) || Resources.getString("PlayerRoster.moderator").equals(side) || Resources.getString("PlayerRoster.referee").equals(side);
    }

    public boolean isMultiPlayer() {
        if (GameModule.getGameModule().getServer().isConnected()) {
            return true;
        }
        return this.players.size() > 1;
    }

    protected String promptForSide() {
        ArrayList<String> availableSides = new ArrayList<String>(this.sides);
        ArrayList<String> alreadyTaken = new ArrayList<String>();
        for (PlayerInfo p : this.players) {
            alreadyTaken.add(p.side);
        }
        availableSides.removeAll(alreadyTaken);
        boolean found = false;
        String mySide = PlayerRoster.getMySide();
        int myidx = mySide != null ? this.sides.indexOf(mySide) : -1;
        int i = myidx >= 0 ? (myidx + 1) % this.sides.size() : 0;
        for (int tries = 0; i != myidx && tries < this.sides.size(); ++tries) {
            String s = this.sides.get(i);
            if (!alreadyTaken.contains(s) && !PlayerRoster.isSoloSide(s)) {
                found = true;
                break;
            }
            i = (i + 1) % this.sides.size();
        }
        String nextChoice = found ? this.sides.get(i) : this.translatedObserver;
        availableSides.add(0, this.translatedObserver);
        GameModule g = GameModule.getGameModule();
        String newSide = (String)JOptionPane.showInputDialog(g.getPlayerWindow(), Resources.getString("PlayerRoster.switch_sides", PlayerRoster.getMyLocalizedSide()), Resources.getString("PlayerRoster.choose_side"), 3, null, availableSides.toArray(new String[0]), nextChoice);
        newSide = this.translatedObserver.equals(newSide) ? OBSERVER : this.untranslateSide(newSide);
        return newSide;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{BUTTON_TEXT, TOOL_TIP, SIDES, BUTTON_KEYSTROKE};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, String.class, NamedKeyStroke.class};
    }

    @Override
    public String getAttributeValueString(String key) {
        if (SIDES.equals(key)) {
            return this.getSidesAsString();
        }
        return super.getAttributeValueString(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (SIDES.equals(key)) {
            this.untranslatedSides = this.sides.toArray(new String[0]);
            String[] s = StringArrayConfigurer.stringToArray((String)value);
            this.sides = new ArrayList<String>(s.length);
            Collections.addAll(this.sides, s);
        } else {
            super.setAttribute(key, value);
        }
    }

    protected String getSidesAsString() {
        String[] s = this.sides.toArray(new String[0]);
        return StringArrayConfigurer.arrayToString(s);
    }

    public String untranslateSide(String side) {
        if (this.translatedObserver.equals(side)) {
            return OBSERVER;
        }
        if (this.untranslatedSides != null) {
            for (int i = 0; i < this.sides.size(); ++i) {
                if (!this.sides.get(i).equals(side)) continue;
                return this.untranslatedSides[i];
            }
        }
        return side;
    }

    public String translateSide(String side) {
        if (OBSERVER.equals(side)) {
            return this.translatedObserver;
        }
        if (this.untranslatedSides != null) {
            for (int i = 0; i < this.untranslatedSides.length; ++i) {
                if (!this.untranslatedSides[i].equals(side)) continue;
                return this.sides.get(i);
            }
        }
        return side;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.PlayerRoster.sides_label"), Resources.getString("Editor.hotkey_label")};
    }

    @Override
    public List<String> getPropertyList() {
        return this.sides;
    }

    private class Con
    extends Configurer {
        private final StringArrayConfigurer sidesConfig;
        private final IconConfigurer iconConfig;
        private final StringConfigurer textConfig;
        private final StringConfigurer tooltipConfig;
        private final NamedHotKeyConfigurer keyConfig;
        private final ComponentConfigPanel controls;

        private Con() {
            super(null, null);
            this.controls = new ComponentConfigPanel();
            this.sidesConfig = new StringArrayConfigurer(PlayerRoster.this.sides.toArray(new String[0]));
            this.sidesConfig.addPropertyChangeListener(evt -> {
                PlayerRoster.this.sides.clear();
                PlayerRoster.this.sides.addAll(Arrays.asList(this.sidesConfig.getStringArray()));
                this.repack();
            });
            this.controls.add("Editor.PlayerRoster.sides_available", (Configurer)this.sidesConfig);
            this.textConfig = new StringConfigurer(PlayerRoster.BUTTON_TEXT, "", PlayerRoster.this.retireButton.getAttributeValueString(PlayerRoster.BUTTON_TEXT));
            this.textConfig.addPropertyChangeListener(evt -> PlayerRoster.this.retireButton.setAttribute(PlayerRoster.BUTTON_TEXT, this.textConfig.getValueString()));
            this.controls.add("Editor.PlayerRoster.retire_button_text", (Configurer)this.textConfig);
            this.tooltipConfig = new StringConfigurer(PlayerRoster.TOOL_TIP, "", PlayerRoster.this.retireButton.getAttributeValueString(PlayerRoster.TOOL_TIP));
            this.tooltipConfig.addPropertyChangeListener(evt -> PlayerRoster.this.retireButton.setAttribute(PlayerRoster.TOOL_TIP, this.tooltipConfig.getValueString()));
            this.controls.add("Editor.PlayerRoster.retire_button_tooltip", (Configurer)this.tooltipConfig);
            this.iconConfig = new IconConfigurer(PlayerRoster.BUTTON_ICON, "", null);
            this.iconConfig.setValue(PlayerRoster.this.retireButton.getIcon());
            this.iconConfig.addPropertyChangeListener(evt -> PlayerRoster.this.retireButton.setAttribute(PlayerRoster.BUTTON_ICON, this.iconConfig.getValueString()));
            this.controls.add("Editor.PlayerRoster.retire_button_icon", (Configurer)this.iconConfig, "grow");
            this.keyConfig = (NamedHotKeyConfigurer)PlayerRoster.this.retireButton.getHotkeyConfigurer();
            this.keyConfig.setName("");
            this.keyConfig.addPropertyChangeListener(evt -> PlayerRoster.this.retireButton.setAttribute(PlayerRoster.BUTTON_KEYSTROKE, this.keyConfig.getValueString()));
            this.controls.add("Editor.PlayerRoster.retire_button_keystroke", (Configurer)this.keyConfig);
        }

        @Override
        public String getValueString() {
            return null;
        }

        @Override
        public void setValue(String s) {
        }

        @Override
        public Component getControls() {
            return this.controls;
        }
    }

    @FunctionalInterface
    public static interface SideChangeListener {
        public void sideChanged(String var1, String var2);
    }

    public static class PlayerInfo {
        public String playerId;
        public String playerName;
        private final String side;

        public PlayerInfo(String id, String name, String side) {
            this.playerId = Objects.requireNonNull(id);
            this.playerName = name;
            this.side = side;
        }

        public boolean equals(Object o) {
            if (o instanceof PlayerInfo && this.playerId != null) {
                return this.playerId.equals(((PlayerInfo)o).playerId);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.playerId);
        }

        public String getSide() {
            return this.side;
        }

        public String getLocalizedSide() {
            return GameModule.getGameModule().getPlayerRoster().translateSide(this.side);
        }
    }

    public static class Add
    extends Command {
        private final PlayerRoster roster;
        private final String id;
        private final String name;
        private final String side;

        public Add(PlayerRoster r, String playerId, String playerName, String side) {
            this.roster = r;
            this.id = playerId;
            this.name = playerName;
            this.side = side;
        }

        @Override
        protected void executeCommand() {
            this.roster.add(this.id, this.name, this.side);
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }
}

