/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.chessclockcontrol;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.BadDataReport;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.ChessClockControl;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.NullCommand;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.TranslatableStringEnum;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.lang3.StringUtils;

public class ChessClock
extends AbstractConfigurable
implements CommandEncoder,
GameComponent,
ActionListener {
    private static final int MILLISECONDS_PER_MINUTE = 60000;
    private static final int MILLISECONDS_PER_HOUR = 3600000;
    private static final int MILLISECONDS_PER_DAY = 86400000;
    public static final char DELIMITER = '\t';
    public static final String COMMAND_PREFIX = "CLOCK\t";
    public static final String ICON = "icon";
    public static final String SIDE = "side";
    public static final String TOOLTIP = "tooltip";
    public static final String BUTTON_TEXT = "buttonText";
    public static final String TICKING_BACKGROUND_COLOR = "tickingBackgroundColor";
    public static final String TICKING_FONT_COLOR = "tickingFontColor";
    public static final String TOCKING_FONT_COLOR = "tockingFontColor";
    public static final String GENERIC = "Player";
    public static final String CHESSMENU_START = Resources.getString("ChessClock.start");
    public static final String CHESSMENU_STOP = Resources.getString("ChessClock.stop");
    public static final String CHESSMENU_RESET = Resources.getString("ChessClock.reset");
    private static Color defaultColor;
    private static Color defaultFontColor;
    protected Color tickingBackgroundColor = new Color(255, 255, 0);
    protected Color tickingFontColor = new Color(51, 51, 51);
    protected Color tockingFontColor = new Color(0, 0, 0);
    protected static Timer timer;
    protected long startTime = -1L;
    protected LaunchButton timerButton;
    protected String image;
    protected String side;
    protected String buttonText;
    protected long elapsedTime;
    protected long verifiedTime;
    protected boolean clockTicking;
    protected boolean tocking;
    protected boolean instanceIsActive;

    public ChessClock(String side) {
        this();
        this.side = side;
        this.buttonText = side;
        this.setConfigureName(side);
        this.setTimerButton();
    }

    public ChessClock() {
        defaultColor = UIManager.getColor("Panel.background");
        defaultFontColor = UIManager.getColor("Button.foreground");
        this.buttonText = this.side = GENERIC;
        PlayerRoster r = GameModule.getGameModule().getPlayerRoster();
        ChessClockControl ctrl = ChessClockControl.getInstance();
        if (r != null && ctrl != null) {
            for (String s : r.getSides()) {
                boolean okay = true;
                for (ChessClock c : ctrl.getChessClocks()) {
                    if (!c.getSide().equals(s)) continue;
                    okay = false;
                    break;
                }
                if (!okay) continue;
                this.side = s;
                this.buttonText = s;
                break;
            }
        }
        this.setConfigureName(this.side);
        this.image = "";
        this.elapsedTime = 0L;
        this.verifiedTime = 0L;
        this.clockTicking = false;
        if (timer == null) {
            timer = new Timer(100, this);
        }
        timer.addActionListener(this);
        ActionListener al = e -> {
            Command command = new NullCommand();
            ChessClockControl ccc = ChessClockControl.getInstance();
            command = ccc != null && ccc.getClocksTicking() > 0 ? command.append(ChessClockControl.getInstance().startNextClock()) : command.append(this.updateState(true));
            command.execute();
            GameModule.getGameModule().sendAndLog(command);
            if (timer == null) {
                this.setup(true);
            }
            this.startTimer();
        };
        this.timerButton = new LaunchButton(this.buttonText + " 0:00:00", TOOLTIP, null, null, ICON, al);
        this.timerButton.setFont(new Font("SansSerif", 1, 12));
        this.timerButton.setHorizontalAlignment(2);
        this.timerButton.addMouseListener(new ClockMouseListener());
        this.initTimerButton();
    }

    public String getSide() {
        return this.side;
    }

    public boolean isTicking() {
        return this.clockTicking;
    }

    public long getElapsed() {
        return this.elapsedTime;
    }

    public long getVerified() {
        return this.verifiedTime;
    }

    protected static boolean isReferee(String name) {
        return PlayerRoster.isSoloSide(name);
    }

    protected void startTimer() {
        if (!timer.isRunning()) {
            timer.start();
        }
    }

    protected void updateTimerColor() {
        if (!this.instanceIsActive) {
            return;
        }
        if (this.clockTicking) {
            this.timerButton.setBackground(this.tickingBackgroundColor);
            this.timerButton.setOpaque(true);
            this.timerButton.setBorderPainted(false);
            this.timerButton.setForeground(this.tocking ? this.tockingFontColor : this.tickingFontColor);
        } else {
            this.timerButton.setBackground(defaultColor);
            this.timerButton.setOpaque(false);
            this.timerButton.setBorderPainted(true);
            this.timerButton.setForeground(defaultFontColor);
        }
    }

    private void initTimerButton() {
        this.timerButton.setVisible(false);
        this.updateTimerColor();
    }

    public void hideClock() {
        this.timerButton.setVisible(false);
    }

    public void showClock() {
        this.timerButton.setVisible(true);
        this.setTimerButton();
    }

    public void updateDisplay() {
        if (this.startTime == -1L) {
            this.startTime = System.currentTimeMillis();
            return;
        }
        long currentTime = System.currentTimeMillis();
        long elapsed = currentTime - this.startTime;
        this.startTime = currentTime;
        if (this.clockTicking) {
            this.elapsedTime += elapsed;
            if (this.setTimerButton()) {
                this.updateTimerColor();
            }
        }
    }

    private String getFormattedButtonText() {
        return StringUtils.isEmpty((CharSequence)this.buttonText) ? "" : this.buttonText + " ";
    }

    public boolean setTimerButton() {
        int iconHeight;
        int iconWidth;
        String baseline;
        String showingTenths;
        String showingSeconds;
        String showingHours;
        String showingDays;
        long time = this.elapsedTime;
        int days = (int)(time / 86400000L);
        int hours = (int)((time %= 86400000L) / 3600000L);
        int minutes = (int)((time %= 3600000L) / 60000L);
        int seconds = (int)(time %= 60000L) / 1000;
        int tenths = (int)(time %= 1000L) / 100;
        ChessClockControl c = ChessClockControl.getInstance();
        if (c != null && this.instanceIsActive) {
            showingDays = c.getShowDays();
            showingHours = c.getShowHours();
            showingSeconds = c.getShowSeconds();
            showingTenths = c.getShowTenths();
        } else {
            showingDays = "Auto";
            showingHours = "Auto";
            showingSeconds = "Auto";
            showingTenths = "Auto";
        }
        boolean doDays = "Always".equals(showingDays) || days > 0 && !"Never".equals(showingDays);
        boolean doHours = doDays || "Always".equals(showingHours) || (hours > 0 || "Never".equals(showingTenths)) && !"Never".equals(showingHours);
        boolean doTenths = "Always".equals(showingTenths) || !doHours && !"Never".equals(showingTenths);
        boolean doSeconds = doTenths || "Always".equals(showingSeconds) || !doDays && !"Never".equals(showingSeconds);
        boolean oldTocking = this.tocking;
        boolean bl = this.tocking = tenths >= 5;
        if (doDays) {
            if (doTenths) {
                this.timerButton.setText(String.format("%s%d:%02d:%02d:%02d.%d", this.getFormattedButtonText(), days, hours, minutes, seconds, tenths));
                baseline = "0:00:00:00.0";
            } else if (doSeconds) {
                this.timerButton.setText(String.format("%s%d:%02d:%02d:%02d", this.getFormattedButtonText(), days, hours, minutes, seconds));
                baseline = "0:00:00:00";
            } else {
                this.timerButton.setText(String.format("%s%dd:%02d:%02d", this.getFormattedButtonText(), days, hours, minutes));
                baseline = "0d:00:00";
            }
        } else {
            hours += days * 24;
            if (doHours) {
                if (doTenths) {
                    this.timerButton.setText(String.format("%s%d:%02d:%02d.%d", this.getFormattedButtonText(), hours, minutes, seconds, tenths));
                    baseline = hours >= 10 ? String.format("%d0:00:00.0", hours / 10) : "0:00:00.0";
                } else if (doSeconds) {
                    this.timerButton.setText(String.format("%s%d:%02d:%02d", this.getFormattedButtonText(), hours, minutes, seconds));
                    baseline = hours >= 10 ? String.format("%d0:00:00", hours / 10) : "0:00:00";
                } else {
                    this.timerButton.setText(String.format("%s%d:%02d", this.getFormattedButtonText(), hours, minutes));
                    baseline = hours >= 10 ? String.format("%d0:00", hours / 10) : "0:00";
                }
            } else {
                minutes += hours * 60;
                if (doTenths) {
                    this.timerButton.setText(String.format("%s%d:%02d.%d", this.getFormattedButtonText(), minutes, seconds, tenths));
                    baseline = minutes >= 10 ? String.format("%d0:00.0", minutes / 10) : "0:00.0";
                } else {
                    this.timerButton.setText(String.format("%s%d:%02d", this.getFormattedButtonText(), minutes, seconds));
                    baseline = minutes >= 10 ? String.format("%d0:00", minutes / 10) : "0:00";
                }
            }
        }
        Insets ins = this.timerButton.getInsets();
        Icon icon = this.timerButton.getIcon();
        if (icon != null) {
            iconWidth = icon.getIconWidth() + ins.left;
            iconHeight = icon.getIconHeight() + ins.top + ins.bottom;
        } else {
            iconWidth = 0;
            iconHeight = 0;
        }
        FontMetrics metrics = this.timerButton.getFontMetrics(this.timerButton.getFont());
        int width = ins.left + iconWidth + metrics.stringWidth(this.getFormattedButtonText() + baseline + ins.right);
        int textHeight = ins.top + metrics.getHeight() + ins.bottom;
        this.timerButton.setPreferredSize(new Dimension(width, Math.max(textHeight, iconHeight)));
        return this.tocking != oldTocking;
    }

    public String getName() {
        return this.side;
    }

    @Override
    public void addTo(Buildable parent) {
        if (parent instanceof ChessClockControl) {
            this.initTimerButton();
            GameModule gameModule = GameModule.getGameModule();
            gameModule.addCommandEncoder(this);
            gameModule.getGameState().addGameComponent(this);
            ChessClockControl ccc = (ChessClockControl)parent;
            ccc.addChessClock(this);
            if (ccc.isInstanceIsActive()) {
                gameModule.getToolBar().add(this.timerButton);
            }
            this.instanceIsActive = true;
        } else {
            ErrorDialog.dataWarning(new BadDataReport("Chess Clock can only be added to Chess Clock Control", ""));
        }
    }

    public void addToToolbar() {
        GameModule gameModule = GameModule.getGameModule();
        gameModule.getToolBar().add(this.timerButton);
    }

    @Override
    public void removeFrom(Buildable parent) {
        this.instanceIsActive = false;
        if (parent instanceof ChessClockControl) {
            this.timerButton.setVisible(false);
            GameModule gameModule = GameModule.getGameModule();
            gameModule.getToolBar().remove(this.timerButton);
            gameModule.removeCommandEncoder(this);
            gameModule.getGameState().removeGameComponent(this);
            if (timer != null) {
                timer.removeActionListener(this);
            }
            ((ChessClockControl)parent).removeChessClock(this);
        }
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{SIDE, BUTTON_TEXT, ICON, TICKING_BACKGROUND_COLOR, TICKING_FONT_COLOR, TOCKING_FONT_COLOR, TOOLTIP};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.ChessClock.player_side_for_timer"), Resources.getString("Editor.ChessClock.timer_button_text"), Resources.getString("Editor.ChessClock.timer_icon"), Resources.getString("Editor.ChessClock.ticking_background_color"), Resources.getString("Editor.ChessClock.ticking_foreground_color"), Resources.getString("Editor.ChessClock.tocking_foreground_color"), Resources.getString("Editor.ChessClock.chess_clock_tooltip")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{PlayerSidesConfig.class, String.class, IconConfig.class, ColorConfig.class, ColorConfig2.class, ColorConfig3.class, String.class};
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (SIDE.equals(key)) {
            this.side = (String)value;
            this.setConfigureName(this.side);
        } else if (BUTTON_TEXT.equals(key)) {
            this.buttonText = (String)value;
            this.setTimerButton();
        } else if (TICKING_BACKGROUND_COLOR.equals(key)) {
            if (value instanceof String) {
                value = ColorConfigurer.stringToColor((String)value);
            }
            this.tickingBackgroundColor = (Color)value;
            this.updateTimerColor();
        } else if (TICKING_FONT_COLOR.equals(key)) {
            if (value instanceof String) {
                value = ColorConfigurer.stringToColor((String)value);
            }
            this.tickingFontColor = (Color)value;
            this.updateTimerColor();
        } else if (TOCKING_FONT_COLOR.equals(key)) {
            if (value instanceof String) {
                value = ColorConfigurer.stringToColor((String)value);
            }
            this.tockingFontColor = (Color)value;
            this.updateTimerColor();
        } else {
            this.timerButton.setAttribute(key, value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (SIDE.equals(key)) {
            return this.side;
        }
        if (BUTTON_TEXT.equals(key)) {
            return this.buttonText;
        }
        if (TICKING_BACKGROUND_COLOR.equals(key)) {
            return ColorConfigurer.colorToString(this.tickingBackgroundColor);
        }
        if (TICKING_FONT_COLOR.equals(key)) {
            return ColorConfigurer.colorToString(this.tickingFontColor);
        }
        if (TOCKING_FONT_COLOR.equals(key)) {
            return ColorConfigurer.colorToString(this.tockingFontColor);
        }
        return this.timerButton.getAttributeValueString(key);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ChessClock.html");
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.ChessClock.chess_clock");
    }

    @Override
    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    private JButton getComponent() {
        return this.timerButton;
    }

    @Override
    public Command decode(String command) {
        if (!command.startsWith(COMMAND_PREFIX)) {
            return null;
        }
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(command, '\t');
        decoder.nextToken();
        String who = decoder.nextToken();
        String name = decoder.nextToken();
        if (!this.getName().equals(name)) {
            return null;
        }
        long elapsed = decoder.nextLong(0L);
        long verified = decoder.nextLong(0L);
        boolean ticking = decoder.nextBoolean(false);
        boolean restore = decoder.nextBoolean(false);
        return new UpdateTimerCommand(who, name, elapsed, verified, ticking, restore);
    }

    @Override
    public String encode(Command c) {
        if (!(c instanceof UpdateTimerCommand)) {
            return null;
        }
        UpdateTimerCommand comm = (UpdateTimerCommand)c;
        SequenceEncoder encoder = new SequenceEncoder('\t');
        encoder.append(comm.who);
        encoder.append(comm.name);
        encoder.append(comm.elapsed);
        encoder.append(comm.verified);
        encoder.append(comm.ticking);
        encoder.append(comm.restore);
        return COMMAND_PREFIX + encoder.getValue();
    }

    @Override
    public void setup(boolean gameStarting) {
        this.clockTicking = false;
        if (!gameStarting) {
            this.elapsedTime = 0L;
            this.verifiedTime = 0L;
        }
        this.setTimerButton();
        this.updateTimerColor();
    }

    @Override
    public Command getRestoreCommand() {
        long verified = ChessClock.isReferee(PlayerRoster.getMySide()) ? this.elapsedTime : this.verifiedTime;
        return new UpdateTimerCommand(PlayerRoster.getMySide(), this.getName(), this.elapsedTime, verified, false, true);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == timer) {
            this.updateDisplay();
        }
    }

    public Command updateState(boolean ticking) {
        String mySide = PlayerRoster.getMySide();
        if (mySide != null) {
            return new UpdateTimerCommand(mySide, this.getName(), this.elapsedTime, this.verifiedTime, ticking, false);
        }
        if (!GameModule.getGameModule().getGameState().isGameStarted()) {
            return new UpdateTimerCommand("", this.getName(), this.elapsedTime, this.verifiedTime, ticking, false);
        }
        return new NullCommand();
    }

    public Command resetState() {
        String mySide = PlayerRoster.getMySide();
        if (mySide != null) {
            return new UpdateTimerCommand(mySide, this.getName());
        }
        if (!GameModule.getGameModule().getGameState().isGameStarted()) {
            return new UpdateTimerCommand("", this.getName());
        }
        return new NullCommand();
    }

    private class ClockMouseListener
    implements MouseListener,
    ActionListener {
        protected JPopupMenu popup;

        private ClockMouseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            Command c = new NullCommand();
            ChessClockControl ccc = ChessClockControl.getInstance();
            if (command.contains(CHESSMENU_START) || command.contains(CHESSMENU_STOP)) {
                c = ccc != null && ccc.getClocksTicking() > 0 ? c.append(ChessClockControl.getInstance().startNextClock()) : c.append(ChessClock.this.updateState(true));
            } else if (command.contains(CHESSMENU_RESET)) {
                c = ChessClock.this.resetState();
                PlayerRoster.PlayerInfo me = new PlayerRoster.PlayerInfo(GameModule.getUserId(), GlobalOptions.getInstance().getPlayerId(), PlayerRoster.getMySide());
                c = c.append(new Chatter.DisplayText(GameModule.getGameModule().getChatter(), Resources.getString(GlobalOptions.getInstance().chatterHTMLSupport() ? "ChessClock.reset_clock_2" : "ChessClock.reset_clock", me.playerName, ChessClock.this.side)));
            }
            c.execute();
            GameModule.getGameModule().sendAndLog(c);
            if (timer == null) {
                ChessClock.this.setup(true);
            }
            ChessClock.this.startTimer();
        }

        void buildPopup() {
            this.popup = new JPopupMenu();
            this.popup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent evt) {
                    ChessClock.this.getComponent().repaint();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                    ChessClock.this.getComponent().repaint();
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                }
            });
            String s = ChessClock.this.clockTicking ? CHESSMENU_STOP : CHESSMENU_START;
            JMenuItem item = new JMenuItem(s);
            item.addActionListener(this);
            this.popup.add(item);
            ChessClockControl ccc = ChessClockControl.getInstance();
            if (ccc == null || ccc.isAllowReset()) {
                item = new JMenuItem(CHESSMENU_RESET);
                item.addActionListener(this);
                this.popup.add(item);
            }
        }

        void doPopup(Point p) {
            this.buildPopup();
            this.popup.show(ChessClock.this.getComponent(), p.x, p.y);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopup(e.getPoint());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopup(e.getPoint());
            }
        }
    }

    public static class PlayerSidesConfig
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            PlayerRoster r = GameModule.getGameModule().getPlayerRoster();
            ArrayList<String> sides = new ArrayList<String>(r.getSides());
            if (r.getSides().size() == 0) {
                sides.add(ChessClock.GENERIC);
            }
            return sides.toArray(new String[0]);
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            ArrayList<String> sides = new ArrayList<String>();
            PlayerRoster r = GameModule.getGameModule().getPlayerRoster();
            for (String s : r.getSides()) {
                sides.add(r.translateSide(s));
            }
            if (r.getSides().size() == 0) {
                sides.add(ChessClock.GENERIC);
            }
            return sides.toArray(new String[0]);
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, "");
        }
    }

    public static class ColorConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new ColorConfigurer(key, name, ColorConfigurer.stringToColor(c.getAttributeValueString(ChessClock.TICKING_BACKGROUND_COLOR)));
        }
    }

    public static class ColorConfig2
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new ColorConfigurer(key, name, ColorConfigurer.stringToColor(c.getAttributeValueString(ChessClock.TICKING_FONT_COLOR)));
        }
    }

    public static class ColorConfig3
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new ColorConfigurer(key, name, ColorConfigurer.stringToColor(c.getAttributeValueString(ChessClock.TOCKING_FONT_COLOR)));
        }
    }

    private class UpdateTimerCommand
    extends Command {
        private final String who;
        private final String name;
        private final long elapsed;
        private final long verified;
        private final boolean ticking;
        private final boolean restore;

        public UpdateTimerCommand(String who, String name, long elapsed, long verified, boolean ticking, boolean restore) {
            this.who = who;
            this.name = name;
            this.elapsed = elapsed;
            this.verified = verified;
            this.ticking = ticking;
            this.restore = restore;
        }

        public UpdateTimerCommand(String who, String name) {
            this(who, name, -1L, -1L, false, false);
        }

        @Override
        protected void executeCommand() {
            ChessClockControl ccc;
            boolean noChecks;
            ChessClockControl ccc2;
            if (!this.name.equals(ChessClock.this.side)) {
                return;
            }
            String me = PlayerRoster.getMySide();
            if (this.restore) {
                ChessClock.this.startTime = -1L;
            }
            ChessClock.this.startTimer();
            if (GameModule.getGameModule().getServer().isConnected() && (ccc2 = ChessClockControl.getInstance()) != null) {
                ccc2.setOnline(true);
            }
            boolean bl = noChecks = GameModule.getGameModule().getGameState().isGameStarted() || ChessClock.isReferee(this.who) || ChessClockControl.getInstance() != null && !ChessClockControl.getInstance().isOnline();
            if (ChessClock.this.elapsedTime == -1L && ChessClock.this.verifiedTime == -1L) {
                ChessClock.this.elapsedTime = 0L;
                ChessClock.this.verifiedTime = 0L;
                ChessClock.this.clockTicking = false;
            } else if (this.who.equals(me) || noChecks) {
                if (noChecks) {
                    ChessClock.this.elapsedTime = this.elapsed;
                    ChessClock.this.verifiedTime = this.elapsed;
                } else {
                    ChessClock.this.elapsedTime = this.verified;
                    ChessClock.this.verifiedTime = this.verified;
                }
                ChessClock.this.clockTicking = this.ticking;
            } else if (this.name.equals(me)) {
                if (this.verified > ChessClock.this.elapsedTime) {
                    ChessClock.this.verifiedTime = this.verified;
                    ChessClock.this.elapsedTime = this.verified;
                } else if (this.verified > 0L) {
                    ChessClock.this.verifiedTime = this.verified;
                }
            } else if (this.who.equals(this.name)) {
                ChessClock.this.elapsedTime = this.elapsed;
                ChessClock.this.verifiedTime = this.elapsed;
                ChessClock.this.clockTicking = this.ticking;
                if (me != null) {
                    GameModule.getGameModule().sendAndLog(new UpdateTimerCommand(me, ChessClock.this.getName(), ChessClock.this.elapsedTime, ChessClock.this.verifiedTime, this.ticking, false));
                }
            }
            ChessClock.this.setTimerButton();
            ChessClock.this.updateTimerColor();
            if ((ChessClock.this.clockTicking || this.restore && ChessClock.this.elapsedTime > 0L) && (ccc = ChessClockControl.getInstance()) != null) {
                ccc.showClocks();
            }
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }

        @Override
        public boolean isLoggable() {
            return false;
        }
    }
}

