/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.documentation;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.documentation.DialogHelpWindow;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.i18n.Resources;
import VASSAL.search.HTMLImageFinder;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.URLUtils;
import VASSAL.tools.menu.MenuItemProxy;
import VASSAL.tools.menu.MenuManager;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class HelpFile
extends AbstractConfigurable {
    public static final String TITLE = "title";
    public static final String FILE = "fileName";
    public static final String TYPE = "fileType";
    private static final String IMAGE = "image";
    public static final String ARCHIVE_ENTRY = "archive";
    public static final String RESOURCE = "resource";
    public static final String LOCAL_FILE = "file";
    protected HelpWindow frame;
    protected DialogHelpWindow dialog;
    protected URL contents;
    protected String title;
    protected String fileName;
    protected Action launch;
    protected String fileType = "archive";
    protected MenuItemProxy launchItem;

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.HelpFile.component_type");
    }

    public HelpFile() {
        this("help", (URL)null);
    }

    public HelpFile(String title, File contents, String ref) throws MalformedURLException {
        this(title, new URL(URLUtils.toURL(contents), ref));
    }

    public HelpFile(String title, File contents) throws MalformedURLException {
        this(title, URLUtils.toURL(contents));
    }

    public HelpFile(String title, URL contents) {
        this.title = title;
        this.contents = contents;
        this.setConfigureName(title);
        this.launch = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpFile.this.showWindow();
            }
        };
        this.launch.putValue("Name", this.getConfigureName());
    }

    public void showWindow() {
        HelpWindow w = this.getHelpWindow();
        w.setVisible(true);
        w.toFront();
    }

    protected HelpWindow getHelpWindow() {
        if (this.frame == null) {
            this.frame = new HelpWindow(this.title, this.getContents());
        }
        return this.frame;
    }

    public void showWindow(Dialog owner) {
        DialogHelpWindow w = this.getDialogHelpWindow(owner);
        w.setVisible(true);
        w.toFront();
    }

    protected DialogHelpWindow getDialogHelpWindow(Dialog d) {
        if (this.dialog == null) {
            this.dialog = new DialogHelpWindow(this.title, this.getContents(), d);
        }
        return this.dialog;
    }

    public URL getContents() {
        if (this.contents != null || this.fileName == null) {
            return this.contents;
        }
        if (ARCHIVE_ENTRY.equals(this.fileType)) {
            try {
                String localizedFileName = GameModule.getGameModule().getResourcePathFinder().findHelpFileName(this.fileName);
                this.contents = GameModule.getGameModule().getDataArchive().getURL(localizedFileName);
            }
            catch (IOException e) {
                ReadErrorDialog.error(e, this.fileName);
            }
        } else if (RESOURCE.equals(this.fileType)) {
            this.contents = this.getClass().getResource(this.fileName);
        } else if (LOCAL_FILE.equals(this.fileType)) {
            File f = new File(this.fileName);
            if (this.fileName.startsWith("docs/")) {
                f = new File(Documentation.getDocumentationBaseDir(), this.fileName.substring("docs/".length()));
            }
            try {
                this.contents = URLUtils.toURL(f);
            }
            catch (MalformedURLException e) {
                ErrorDialog.bug(e);
            }
        }
        return this.contents;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public static URL toURL(File f) throws MalformedURLException {
        ProblemDialog.showDeprecated("2020-08-06");
        return URLUtils.toURL(f);
    }

    @Override
    public HelpFile getHelpFile() {
        File dir = Documentation.getDocumentationBaseDir();
        dir = new File(dir, "ReferenceManual");
        try {
            return new HelpFile(null, new File(dir, "HelpMenu.html"), "#HelpFile");
        }
        catch (MalformedURLException e) {
            ErrorDialog.bug(e);
            return null;
        }
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{TITLE, FILE, IMAGE, TYPE};
    }

    @Override
    public String getAttributeValueString(String key) {
        if (TITLE.equals(key)) {
            return this.title;
        }
        if (FILE.equals(key)) {
            return this.fileName;
        }
        if (TYPE.equals(key)) {
            return this.fileType;
        }
        return null;
    }

    @Override
    public void setAttribute(String key, Object val) {
        if (TITLE.equals(key)) {
            this.title = (String)val;
            this.setConfigureName(this.title);
            this.launch.putValue("Name", this.title);
        } else if (FILE.equals(key)) {
            if (val instanceof File) {
                val = ((File)val).getName();
                this.fileType = ARCHIVE_ENTRY;
            }
            this.fileName = (String)val;
            if ("Intro.txt".equals(this.fileName)) {
                this.fileType = RESOURCE;
            }
        } else if (TYPE.equals(key)) {
            this.fileType = (String)val;
        }
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.menu_command"), Resources.getString("Editor.HelpFile.text_file")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, File.class};
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addTo(Buildable b) {
        this.launchItem = new MenuItemProxy(this.launch);
        MenuManager.getInstance().addToSection("Documentation.Module", this.launchItem);
        this.launch.setEnabled(true);
    }

    @Override
    public void removeFrom(Buildable b) {
        MenuManager.getInstance().removeFromSection("Documentation.Module", this.launchItem);
        this.launch.setEnabled(false);
    }

    public static HelpFile getReferenceManualPage(String page) {
        return HelpFile.getReferenceManualPage(page, null);
    }

    public static HelpFile getReferenceManualPage(String page, String anchor) {
        if (anchor != null) {
            if (!((String)anchor).startsWith("#")) {
                anchor = "#" + (String)anchor;
            }
            anchor = ((String)anchor).replace(" ", "");
        }
        File dir = Documentation.getDocumentationBaseDir();
        dir = new File(dir, "ReferenceManual");
        try {
            return anchor == null ? new HelpFile(null, new File(dir, page)) : new HelpFile(null, new File(dir, page), (String)anchor);
        }
        catch (MalformedURLException ex) {
            ErrorDialog.bug(ex);
            return null;
        }
    }

    @Override
    public List<String> getFormattedStringList() {
        return List.of(this.title);
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        HTMLImageFinder h = new HTMLImageFinder(this.getAttributeValueString(FILE));
        h.addImageNames(s);
    }
}

