/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractToolbarItem;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.tools.LaunchButton;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;

public class PieceRecenterer
extends AbstractToolbarItem
implements DeckVisitor {
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String BUTTON_TEXT = "text";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String ICON = "icon";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String HOTKEY = "hotkey";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String TOOLTIP = "tooltip";
    protected LaunchButton launch;
    protected Map map;
    protected DeckVisitorDispatcher dispatcher;

    public PieceRecenterer() {
        ActionListener al = e -> GameModule.getGameModule().sendAndLog(this.recenter(this.map));
        this.setNameKey("");
        this.launch = this.makeLaunchButton("Editor.PieceRecenterer.recenter", "Editor.PieceRecenterer.recenter", "/images/recenter.gif", al);
        this.dispatcher = new DeckVisitorDispatcher(this);
    }

    public Command recenter(Map map) {
        NullCommand c = new NullCommand();
        GamePiece[] pieces = map.getPieces();
        Rectangle r = new Rectangle(0, 0, -1, -1);
        for (GamePiece p : pieces) {
            if (!Boolean.TRUE.equals(this.dispatcher.accept(p))) continue;
            Point pt = p.getPosition();
            Rectangle pRect = p.getShape().getBounds();
            pRect.translate(pt.x, pt.y);
            r.add(pRect);
        }
        if (r.height >= 0 && r.width >= 0) {
            int dx = map.mapSize().width / 2 - (r.x + r.width / 2);
            int dy = map.mapSize().height / 2 - (r.y + r.height / 2);
            for (GamePiece p : pieces) {
                if (!Boolean.TRUE.equals(this.dispatcher.accept(p))) continue;
                ChangeTracker tracker = new ChangeTracker(p);
                Point pt = p.getPosition();
                pt.translate(dx, dy);
                p.setPosition(pt);
                c.append(tracker.getChangeCommand());
            }
        }
        map.repaint();
        return c;
    }

    @Override
    public Object visitDeck(Deck d) {
        return Boolean.TRUE;
    }

    @Override
    public Object visitDefault(GamePiece p) {
        return Boolean.TRUE;
    }

    @Override
    public Object visitStack(Stack s) {
        return s.getPieceCount() > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.PieceRecenterer.component_type");
    }

    @Override
    public void addTo(Buildable parent) {
        this.map = (Map)parent;
        this.map.getToolBar().add(this.getLaunchButton());
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.html", "PieceRecenterer");
    }

    @Override
    public void removeFrom(Buildable parent) {
        this.map.getToolBar().remove(this.getLaunchButton());
    }

    @Deprecated(since="2020-10-01", forRemoval=true)
    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, "/images/recenter.gif");
        }
    }
}

