/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.board.GeometricGrid;
import VASSAL.build.module.map.boardPicker.board.GridEditor;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridContainer;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridNumbering;
import VASSAL.build.module.map.boardPicker.board.mapgrid.SquareGridNumbering;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;

public class SquareGrid
extends AbstractConfigurable
implements GeometricGrid,
GridEditor.EditableGrid {
    protected double dx = 48.0;
    protected double dy = 48.0;
    protected int snapScale = 0;
    protected Point origin = new Point(24, 24);
    protected boolean visible = false;
    protected boolean edgesLegal = false;
    protected boolean cornersLegal = false;
    protected boolean dotsVisible = false;
    protected Color color = Color.black;
    protected GridContainer container;
    protected Map<Integer, Area> shapeCache = new HashMap<Integer, Area>();
    protected SquareGridEditor gridEditor;
    protected String rangeOption = "Metric";
    protected boolean snapTo = true;
    private GridNumbering gridNumbering;
    public static final String DX = "dx";
    public static final String DY = "dy";
    public static final String X0 = "x0";
    public static final String Y0 = "y0";
    public static final String VISIBLE = "visible";
    public static final String CORNERS = "cornersLegal";
    public static final String EDGES = "edgesLegal";
    public static final String COLOR = "color";
    public static final String DOTS_VISIBLE = "dotsVisible";
    public static final String RANGE = "range";
    public static final String RANGE_MANHATTAN = "Manhattan";
    public static final String RANGE_METRIC = "Metric";
    public static final String SNAP_TO = "snapTo";

    @Override
    public GridNumbering getGridNumbering() {
        return this.gridNumbering;
    }

    public void setGridNumbering(GridNumbering gridNumbering) {
        this.gridNumbering = gridNumbering;
    }

    @Override
    public double getDx() {
        return this.dx;
    }

    @Override
    public void setDx(double d) {
        this.dx = d;
    }

    @Override
    public double getDy() {
        return this.dy;
    }

    @Override
    public void setDy(double d) {
        this.dy = d;
    }

    @Override
    public Point getOrigin() {
        return new Point(this.origin);
    }

    @Override
    public void setOrigin(Point p) {
        this.origin.x = p.x;
        this.origin.y = p.y;
    }

    @Override
    public boolean isSideways() {
        return false;
    }

    @Override
    public void setSideways(boolean b) {
    }

    @Override
    public GridContainer getContainer() {
        return this.container;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{X0, Y0, DX, DY, RANGE, SNAP_TO, EDGES, CORNERS, VISIBLE, DOTS_VISIBLE, COLOR};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.x_offset"), Resources.getString("Editor.y_offset"), Resources.getString("Editor.RectangleGrid.width"), Resources.getString("Editor.RectangleGrid.height"), Resources.getString("Editor.RectangleGrid.range_method"), Resources.getString("Editor.Grid.snap"), Resources.getString("Editor.Grid.edges"), Resources.getString("Editor.RectangleGrid.corners"), Resources.getString("Editor.Grid.show_grid"), Resources.getString("Editor.Grid.center_dots"), Resources.getString("Editor.color_label")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{Integer.class, Integer.class, Double.class, Double.class, RangeOptions.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Color.class};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (COLOR.equals(name)) {
            return () -> this.visible;
        }
        if (EDGES.equals(name) || CORNERS.equals(name)) {
            return () -> this.snapTo;
        }
        return super.getAttributeVisibility(name);
    }

    @Override
    public void addTo(Buildable b) {
        this.container = (GridContainer)((Object)b);
        this.container.setGrid(this);
    }

    @Override
    public void removeFrom(Buildable b) {
        ((GridContainer)((Object)b)).removeGrid(this);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.RectangleGrid.component_type");
    }

    @Override
    public String getGridName() {
        return SquareGrid.getConfigureTypeName();
    }

    @Override
    public String getConfigureName() {
        return null;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("RectangularGrid.html");
    }

    @Override
    public String getAttributeValueString(String key) {
        if (X0.equals(key)) {
            return String.valueOf(this.origin.x);
        }
        if (Y0.equals(key)) {
            return String.valueOf(this.origin.y);
        }
        if (DY.equals(key)) {
            return String.valueOf(this.dy);
        }
        if (DX.equals(key)) {
            return String.valueOf(this.dx);
        }
        if (RANGE.equals(key)) {
            return this.rangeOption;
        }
        if (SNAP_TO.equals(key)) {
            return String.valueOf(this.snapTo);
        }
        if (CORNERS.equals(key)) {
            return String.valueOf(this.cornersLegal);
        }
        if (EDGES.equals(key)) {
            return String.valueOf(this.edgesLegal);
        }
        if (VISIBLE.equals(key)) {
            return String.valueOf(this.visible);
        }
        if (DOTS_VISIBLE.equals(key)) {
            return String.valueOf(this.dotsVisible);
        }
        if (COLOR.equals(key)) {
            return ColorConfigurer.colorToString(this.color);
        }
        return null;
    }

    @Override
    public void setAttribute(String key, Object val) {
        if (X0.equals(key)) {
            if (val instanceof String) {
                val = Integer.valueOf((String)val);
            }
            this.origin.x = (Integer)val;
        } else if (Y0.equals(key)) {
            if (val instanceof String) {
                val = Integer.valueOf((String)val);
            }
            this.origin.y = (Integer)val;
        } else if (DY.equals(key)) {
            if (val instanceof String) {
                val = Double.valueOf((String)val);
            }
            this.dy = (Double)val;
        } else if (DX.equals(key)) {
            if (val instanceof String) {
                val = Double.valueOf((String)val);
            }
            this.dx = (Double)val;
        } else if (RANGE.equals(key)) {
            this.rangeOption = (String)val;
        } else if (SNAP_TO.equals(key)) {
            if (val instanceof String) {
                val = Boolean.valueOf((String)val);
            }
            this.snapTo = (Boolean)val;
        } else if (CORNERS.equals(key)) {
            if (val instanceof String) {
                val = Boolean.valueOf((String)val);
            }
            this.cornersLegal = (Boolean)val;
        } else if (EDGES.equals(key)) {
            if (val instanceof String) {
                val = Boolean.valueOf((String)val);
            }
            this.edgesLegal = (Boolean)val;
        } else if (VISIBLE.equals(key)) {
            if (val instanceof String) {
                val = Boolean.valueOf((String)val);
            }
            this.visible = (Boolean)val;
        } else if (DOTS_VISIBLE.equals(key)) {
            if (val instanceof String) {
                val = Boolean.valueOf((String)val);
            }
            this.dotsVisible = (Boolean)val;
        } else if (COLOR.equals(key)) {
            if (val instanceof String) {
                val = ColorConfigurer.stringToColor((String)val);
            }
            this.color = (Color)val;
        }
        this.shapeCache.clear();
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{SquareGridNumbering.class};
    }

    @Override
    public Point getLocation(String location) throws MapGrid.BadCoords {
        if (this.gridNumbering == null) {
            throw new MapGrid.BadCoords();
        }
        return this.gridNumbering.getLocation(location);
    }

    @Override
    public int range(Point p1, Point p2) {
        if (this.rangeOption.equals(RANGE_METRIC)) {
            return Math.max(Math.abs((int)Math.floor((double)(p2.x - p1.x) / this.dx + 0.5)), Math.abs((int)Math.floor((double)(p2.y - p1.y) / this.dy + 0.5)));
        }
        return Math.abs((int)Math.floor((double)(p2.x - p1.x) / this.dx + 0.5)) + Math.abs((int)Math.floor((double)(p2.y - p1.y) / this.dy + 0.5));
    }

    @Override
    public Area getGridShape(Point center, int range) {
        Area shape = this.shapeCache.get(range);
        if (shape == null) {
            shape = this.getSingleSquareShape(0, 0);
            double dx = this.getDx();
            double dy = this.getDy();
            for (int x = -range; x < range + 1; ++x) {
                int x1 = (int)((double)x * dx);
                int yRange = range;
                for (int y = -yRange; y < yRange + 1; ++y) {
                    int y1 = (int)((double)y * dy);
                    shape.add(this.getSingleSquareShape(x1, y1));
                }
            }
            this.shapeCache.put(range, shape);
        }
        shape = new Area(AffineTransform.getTranslateInstance(center.x, center.y).createTransformedShape(shape));
        return shape;
    }

    public Area getSingleSquareShape(int centerX, int centerY) {
        double dx = this.getDx();
        double dy = this.getDy();
        Rectangle rect = new Rectangle((int)((double)centerX - dx / 2.0), (int)((double)centerY - dy / 2.0), (int)dx, (int)dy);
        return new Area(rect);
    }

    @Override
    public Point snapTo(Point p) {
        if (!this.snapTo) {
            return p;
        }
        int offsetX = p.x - this.origin.x;
        int nx = (int)Math.round((double)offsetX / (0.5 * this.dx));
        int offsetY = p.y - this.origin.y;
        int ny = (int)Math.round((double)offsetY / (0.5 * this.dy));
        Point snap = null;
        if (!this.cornersLegal || !this.edgesLegal) {
            if (this.cornersLegal) {
                nx = ny % 2 == 0 ? 2 * (int)Math.round((double)offsetX / this.dx) : 1 + 2 * (int)Math.round((double)offsetX / this.dx - 0.5);
            } else if (this.edgesLegal) {
                if (ny % 2 == 0) {
                    if (nx % 2 == 0) {
                        nx = 2 * (int)Math.round((double)offsetX / this.dx);
                    }
                } else {
                    nx = 2 * (int)Math.round((double)offsetX / this.dx);
                }
            } else {
                nx = 2 * (int)Math.round((double)offsetX / this.dx);
                ny = 2 * (int)Math.round((double)offsetY / this.dy);
                if (this.snapScale > 0) {
                    int deltaX = offsetX - (int)Math.round((double)nx * this.dx / 2.0);
                    deltaX = (int)Math.round((double)deltaX / (0.5 * this.dx / (double)this.snapScale));
                    deltaX = Math.max(deltaX, 1 - this.snapScale);
                    deltaX = Math.min(deltaX, this.snapScale - 1);
                    deltaX = (int)Math.round((double)deltaX * 0.5 * this.dx / (double)this.snapScale);
                    int deltaY = offsetY - (int)Math.round((double)ny * this.dy / 2.0);
                    deltaY = (int)Math.round((double)deltaY / (0.5 * this.dy / (double)this.snapScale));
                    deltaY = Math.max(deltaY, 1 - this.snapScale);
                    deltaY = Math.min(deltaY, this.snapScale - 1);
                    deltaY = (int)Math.round((double)deltaY * 0.5 * this.dy / (double)this.snapScale);
                    snap = new Point((int)Math.round((double)nx * this.dx / 2.0 + (double)deltaX), (int)Math.round((double)ny * this.dy / 2.0 + (double)deltaY));
                    snap.translate(this.origin.x, this.origin.y);
                }
            }
        }
        if (snap == null) {
            snap = new Point(this.origin.x + (int)Math.round((double)nx * this.dx / 2.0), this.origin.y + (int)Math.round((double)ny * this.dy / 2.0));
        }
        return snap;
    }

    @Override
    public boolean isLocationRestricted(Point p) {
        return this.snapTo;
    }

    @Override
    public String locationName(Point p) {
        return this.gridNumbering == null ? null : this.gridNumbering.locationName(p);
    }

    @Override
    public String localizedLocationName(Point p) {
        return this.gridNumbering == null ? null : this.gridNumbering.localizedLocationName(p);
    }

    @Override
    public boolean isVisible() {
        return this.visible || this.gridNumbering != null && this.gridNumbering.isVisible();
    }

    @Override
    public void setVisible(boolean b) {
        this.visible = true;
    }

    protected void reverse(Point p, Rectangle bounds) {
        p.x = bounds.x + bounds.width - (p.x - bounds.x);
        p.y = bounds.y + bounds.height - (p.y - bounds.y);
    }

    @Override
    public void draw(Graphics g, Rectangle bounds, Rectangle visibleRect, double scale, boolean reversed) {
        if (this.visible) {
            this.forceDraw(g, bounds, visibleRect, scale, reversed);
        }
        if (this.gridNumbering != null) {
            this.gridNumbering.draw(g, bounds, visibleRect, scale, reversed);
        }
    }

    public void forceDraw(Graphics g, Rectangle bounds, Rectangle visibleRect, double scale, boolean reversed) {
        double x;
        if (!bounds.intersects(visibleRect) || this.color == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Rectangle region = bounds.intersection(visibleRect);
        Shape oldClip = g2d.getClip();
        if (oldClip != null) {
            Area clipArea = new Area(oldClip);
            clipArea.intersect(new Area(region));
            g2d.setClip(clipArea);
        }
        double deltaX = scale * this.dx;
        double deltaY = scale * this.dy;
        double xmin = reversed ? (double)bounds.x + scale * (double)this.origin.x + (double)bounds.width - deltaX * (double)Math.round(((double)bounds.x + scale * (double)this.origin.x + (double)bounds.width - (double)region.x) / deltaX) + deltaX / 2.0 : (double)bounds.x + scale * (double)this.origin.x + deltaX * (double)Math.round(((double)(region.x - bounds.x) - scale * (double)this.origin.x) / deltaX) + deltaX / 2.0;
        double xmax = region.x + region.width;
        double ymin = reversed ? (double)bounds.y + scale * (double)this.origin.y + (double)bounds.height - deltaY * (double)Math.round(((double)bounds.y + scale * (double)this.origin.y + (double)bounds.height - (double)region.y) / deltaY) + deltaY / 2.0 : (double)bounds.y + scale * (double)this.origin.y + deltaY * (double)Math.round(((double)(region.y - bounds.y) - scale * (double)this.origin.y) / deltaY) + deltaY / 2.0;
        double ymax = region.y + region.height;
        Point p1 = new Point();
        Point p2 = new Point();
        g2d.setColor(this.color);
        for (x = xmin; x < xmax; x += deltaX) {
            p1.move((int)Math.round(x), region.y);
            p2.move((int)Math.round(x), region.y + region.height);
            g2d.drawLine(p1.x, p1.y, p2.x, p2.y);
        }
        for (double y = ymin; y < ymax; y += deltaY) {
            g2d.drawLine(region.x, (int)Math.round(y), region.x + region.width, (int)Math.round(y));
        }
        if (this.dotsVisible) {
            xmin = reversed ? (double)bounds.x + scale * (double)this.origin.x + (double)bounds.width - deltaX * (double)Math.round(((double)bounds.x + scale * (double)this.origin.x + (double)bounds.width - (double)region.x) / deltaX) : (double)bounds.x + scale * (double)this.origin.x + deltaX * (double)Math.round(((double)(region.x - bounds.x) - scale * (double)this.origin.x) / deltaX);
            ymin = reversed ? (double)bounds.y + scale * (double)this.origin.y + (double)bounds.height - deltaY * (double)Math.round(((double)bounds.y + scale * (double)this.origin.y + (double)bounds.height - (double)region.y) / deltaY) : (double)bounds.y + scale * (double)this.origin.y + deltaY * (double)Math.round(((double)(region.y - bounds.y) - scale * (double)this.origin.y) / deltaY);
            for (x = xmin; x < xmax; x += deltaX) {
                for (double y = ymin; y < ymax; y += deltaY) {
                    p1.move((int)Math.round(x - 0.5), (int)Math.round(y - 0.5));
                    g2d.fillRect(p1.x, p1.y, 2, 2);
                }
            }
        }
        g2d.setClip(oldClip);
    }

    @Override
    public Configurer getConfigurer() {
        boolean buttonExists = this.config != null;
        Configurer c = super.getConfigurer();
        if (!buttonExists) {
            JButton b = new JButton(Resources.getString("Editor.Grid.edit_grid"));
            b.addActionListener(e -> this.editGrid());
            ((Container)c.getControls()).add(b);
        }
        return c;
    }

    public void editGrid() {
        this.gridEditor = new SquareGridEditor(this);
        this.gridEditor.setVisible(true);
        AutoConfigurer cfg = (AutoConfigurer)this.getConfigurer();
        cfg.getConfigurer(DX).setValue(String.valueOf(this.dx));
        cfg.getConfigurer(DY).setValue(String.valueOf(this.dy));
        cfg.getConfigurer(X0).setValue(String.valueOf(this.origin.x));
        cfg.getConfigurer(Y0).setValue(String.valueOf(this.origin.y));
    }

    public int getSnapScale() {
        return this.snapScale;
    }

    public void setSnapScale(int snapScale) {
        this.snapScale = snapScale;
    }

    public static class RangeOptions
    extends StringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{SquareGrid.RANGE_METRIC, SquareGrid.RANGE_MANHATTAN};
        }
    }

    public static class SquareGridEditor
    extends GridEditor {
        private static final long serialVersionUID = 1L;

        public SquareGridEditor(GridEditor.EditableGrid grid) {
            super(grid);
        }

        @Override
        public void calculate() {
            if (this.isPerpendicular(this.hp1, this.hp2) && this.isPerpendicular(this.hp1, this.hp3) && !this.isPerpendicular(this.hp2, this.hp3) || this.isPerpendicular(this.hp2, this.hp1) && this.isPerpendicular(this.hp2, this.hp3) && !this.isPerpendicular(this.hp1, this.hp3) || this.isPerpendicular(this.hp3, this.hp1) && this.isPerpendicular(this.hp3, this.hp2) && !this.isPerpendicular(this.hp1, this.hp2)) {
                int height = Math.max(Math.abs(this.hp1.y - this.hp2.y), Math.abs(this.hp1.y - this.hp3.y));
                int width = Math.max(Math.abs(this.hp1.x - this.hp2.x), Math.abs(this.hp1.x - this.hp3.x));
                int top = Math.min(this.hp1.y, Math.min(this.hp2.y, this.hp3.y));
                int left = Math.min(this.hp1.x, Math.min(this.hp2.x, this.hp3.x));
                this.grid.setDx(width);
                this.grid.setDy(height);
                this.setNewOrigin(new Point(left + width / 2, top + height / 2));
            } else {
                this.reportShapeError();
            }
        }
    }
}

