/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board.mapgrid;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.board.mapgrid.ZonedGridHighlighter;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.TranslatableStringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.SourceOp;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JSlider;

public class ZoneHighlight
extends AbstractConfigurable {
    public static final String NAME = "name";
    public static final String COLOR = "color";
    public static final String COVERAGE = "coverage";
    public static final String WIDTH = "width";
    public static final String STYLE = "style";
    public static final String IMAGE = "image";
    public static final String OPACITY = "opacity";
    public static final String COVERAGE_FULL = "Entire Zone";
    public static final String COVERAGE_BORDER = "Zone Border";
    public static final String STYLE_PLAIN = "Plain";
    public static final String STYLE_STRIPES = "Striped";
    public static final String STYLE_CROSS = "Crosshatched";
    public static final String STYLE_IMAGE = "Tiled Image";
    protected Color color = null;
    protected String coverage = "Entire Zone";
    protected int width = 1;
    protected String style = "Plain";
    protected String imageName = null;
    protected SourceOp srcOp;
    protected int opacity = 100;
    protected TexturePaint paint;

    public ZoneHighlight() {
        this.setConfigureName("");
    }

    public void draw(Graphics2D g2d, Shape s, double scale) {
        if (this.color != null && this.opacity > 0 || STYLE_IMAGE.equals(this.style)) {
            Stroke oldStroke = g2d.getStroke();
            Color oldColor = g2d.getColor();
            Composite oldComposite = g2d.getComposite();
            Paint oldPaint = g2d.getPaint();
            if (!STYLE_PLAIN.equals(this.style)) {
                g2d.setPaint(this.getPaint());
            } else {
                g2d.setColor(this.color);
            }
            g2d.setComposite(AlphaComposite.getInstance(3, (float)this.opacity / 100.0f));
            if (COVERAGE_FULL.equals(this.coverage)) {
                g2d.fill(s);
            } else {
                BasicStroke stroke = new BasicStroke((float)((double)this.width * scale), 1, 1);
                g2d.setStroke(stroke);
                g2d.draw(s);
            }
            g2d.setColor(oldColor);
            g2d.setStroke(oldStroke);
            g2d.setComposite(oldComposite);
            g2d.setPaint(oldPaint);
        }
    }

    protected Paint getPaint() {
        if (this.paint == null) {
            if (this.style.equals(STYLE_IMAGE)) {
                BufferedImage im = this.srcOp.getImage();
                if (im != null) {
                    this.paint = new TexturePaint(ImageUtils.toBufferedImage(im), new Rectangle(this.srcOp.getSize()));
                }
            } else {
                BufferedImage img = ImageUtils.createCompatibleTranslucentImage(6, 6);
                Graphics2D g = img.createGraphics();
                g.setColor(this.color);
                if (this.style.equals(STYLE_STRIPES)) {
                    g.drawLine(0, 5, 5, 0);
                } else if (this.style.equals(STYLE_CROSS)) {
                    g.drawLine(0, 5, 5, 0);
                    g.drawLine(1, 0, 5, 4);
                }
                g.dispose();
                this.paint = new TexturePaint(img, new Rectangle(0, 0, 6, 6));
            }
        }
        return this.paint;
    }

    public String getName() {
        return this.getConfigureName();
    }

    public Color getColor() {
        return this.color;
    }

    public void setOpacity(int o) {
        this.opacity = o;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, COLOR, COVERAGE, WIDTH, STYLE, IMAGE, OPACITY};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.color_label"), Resources.getString("Editor.ZoneHighlight.coverage"), Resources.getString("Editor.ZoneHighlight.width"), Resources.getString("Editor.ZoneHighlight.style"), Resources.getString("Editor.ZoneHighlight.image"), Resources.getString("Editor.ZoneHighlight.opacity")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Color.class, Coverage.class, Integer.class, Style.class, Icon.class, OpacityConfig.class};
    }

    @Override
    public void addTo(Buildable b) {
        ((ZonedGridHighlighter)b).addHighlight(this);
    }

    @Override
    public void removeFrom(Buildable b) {
        ((ZonedGridHighlighter)b).removeHighlight(this);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.ZoneHighlight.component_type");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ZonedGrid.html", "ZoneHighlighter");
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (COLOR.equals(key)) {
            return ColorConfigurer.colorToString(this.color);
        }
        if (COVERAGE.equals(key)) {
            return this.coverage;
        }
        if (WIDTH.equals(key)) {
            return String.valueOf(this.width);
        }
        if (STYLE.equals(key)) {
            return this.style;
        }
        if (OPACITY.equals(key)) {
            return String.valueOf(this.opacity);
        }
        if (IMAGE.equals(key)) {
            return this.imageName;
        }
        return null;
    }

    @Override
    public void setAttribute(String key, Object val) {
        if (val == null) {
            return;
        }
        if (NAME.equals(key)) {
            this.setConfigureName((String)val);
        } else if (COLOR.equals(key)) {
            if (val instanceof String) {
                val = ColorConfigurer.stringToColor((String)val);
            }
            if (val != null) {
                this.color = (Color)val;
            }
        } else if (COVERAGE.equals(key)) {
            this.coverage = (String)val;
        } else if (WIDTH.equals(key)) {
            if (val instanceof String) {
                val = Integer.valueOf((String)val);
            }
            this.width = (Integer)val;
        } else if (STYLE.equals(key)) {
            this.style = (String)val;
            this.paint = null;
        } else if (OPACITY.equals(key)) {
            if (val instanceof String) {
                val = Integer.valueOf((String)val);
            }
            this.opacity = (Integer)val;
        } else if (IMAGE.equals(key)) {
            this.imageName = (String)val;
            this.srcOp = this.imageName.isBlank() ? null : Op.load(this.imageName);
        }
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (IMAGE.equals(name)) {
            return () -> STYLE_IMAGE.equals(this.style);
        }
        if (WIDTH.equals(name)) {
            return () -> COVERAGE_BORDER.equals(this.coverage);
        }
        return super.getAttributeVisibility(name);
    }

    public static class Coverage
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{ZoneHighlight.COVERAGE_FULL, ZoneHighlight.COVERAGE_BORDER};
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            return new String[]{"Editor.ZoneHighlight.coverage_full", "Editor.ZoneHighlight.coverage_border"};
        }
    }

    public static class Style
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{ZoneHighlight.STYLE_PLAIN, ZoneHighlight.STYLE_STRIPES, ZoneHighlight.STYLE_CROSS, ZoneHighlight.STYLE_IMAGE};
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            return new String[]{"Editor.ZoneHighlight.style_plain", "Editor.ZoneHighlight.style_stripes", "Editor.ZoneHighlight.style_cross", "Editor.ZoneHighlight.style_image"};
        }
    }

    public static class OpacityConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            ZoneHighlight zh;
            ZoneHighlight zoneHighlight = zh = (ZoneHighlight)c;
            Objects.requireNonNull(zoneHighlight);
            return zoneHighlight.new PercentageConfigurer(key, name, zh.opacity);
        }
    }

    public class PercentageConfigurer
    extends Configurer {
        public PercentageConfigurer(String key, String name, Object val) {
            super(key, name, val);
            ZoneHighlight.this.opacity = (Integer)val;
        }

        @Override
        public String getValueString() {
            return String.valueOf(ZoneHighlight.this.opacity);
        }

        @Override
        public void setValue(String s) {
            ZoneHighlight.this.opacity = Integer.parseInt(s);
        }

        @Override
        public Component getControls() {
            JSlider slider = new JSlider(0, 0, 100, ZoneHighlight.this.opacity);
            HashMap<Integer, JLabel> labelTable = new HashMap<Integer, JLabel>();
            labelTable.put(0, new JLabel(Resources.getString("Editor.ZoneHighlight.transparent")));
            labelTable.put(100, new JLabel(Resources.getString("Editor.ZoneHighlight.opaque")));
            slider.setMajorTickSpacing(10);
            slider.setPaintTicks(true);
            slider.setLabelTable(new Hashtable(labelTable));
            slider.setPaintLabels(true);
            slider.setBorder(BorderFactory.createTitledBorder(this.name));
            slider.addChangeListener(e -> {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    ZoneHighlight.this.opacity = source.getValue();
                }
            });
            return slider;
        }
    }
}

