/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.module.properties.PropertyPrompt;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.tools.ProblemDialog;
import javax.swing.JOptionPane;

public class EnumeratedPropertyPrompt
extends PropertyPrompt {
    protected String[] validValues;
    protected Expression[] valueExpressions;
    protected PropertyPrompt.DialogParent dialogParent;
    protected PropertyPrompt.Constraints propertySource;

    @Deprecated(since="2020-08-06", forRemoval=true)
    public EnumeratedPropertyPrompt(PropertyPrompt.DialogParent dialogParent, String prompt, String[] validValues) {
        this(dialogParent, prompt, validValues, null);
        ProblemDialog.showDeprecated("2020-08-06");
    }

    public EnumeratedPropertyPrompt(PropertyPrompt.DialogParent dialogParent, String prompt, String[] validValues, PropertyPrompt.Constraints propertySource) {
        super(null, prompt);
        this.validValues = validValues;
        this.valueExpressions = new Expression[validValues.length];
        for (int i = 0; i < validValues.length; ++i) {
            this.valueExpressions[i] = Expression.createExpression(validValues[i]);
        }
        this.dialogParent = dialogParent;
        this.propertySource = propertySource;
    }

    public Expression[] getValueExpressions() {
        return this.valueExpressions;
    }

    @Override
    public String getNewValue(String oldValue) {
        Object[] finalValues = new String[this.valueExpressions.length];
        for (int i = 0; i < finalValues.length; ++i) {
            String value;
            try {
                value = this.propertySource == null ? this.valueExpressions[i].evaluate() : this.valueExpressions[i].evaluate(this.propertySource.getPropertySource());
            }
            catch (ExpressionException e) {
                value = this.valueExpressions[i].getExpression();
            }
            finalValues[i] = value;
        }
        String newValue = (String)JOptionPane.showInputDialog(this.dialogParent.getComponent(), this.promptText, null, 3, null, finalValues, oldValue);
        return newValue == null ? oldValue : newValue;
    }

    public String[] getValidValues() {
        return this.validValues;
    }
}

