/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.module.properties.ChangePropertyCommand;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.command.Command;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public interface MutableProperty {
    public String getPropertyValue();

    public Command setPropertyValue(String var1);

    public void addMutablePropertyChangeListener(PropertyChangeListener var1);

    public void removeMutablePropertyChangeListener(PropertyChangeListener var1);

    public MutablePropertiesContainer getParent();

    public static class Impl
    implements MutableProperty {
        private final PropertyChangeSupport propSupport;
        private String value = "";
        private String propertyName;
        private MutablePropertiesContainer parent;
        private static final List<Impl> allProperties = new ArrayList<Impl>();

        public static List<Impl> getAllProperties() {
            return allProperties;
        }

        public Impl(String propertyName, Object source) {
            this.propertyName = propertyName;
            this.propSupport = new PropertyChangeSupport(this);
        }

        @Override
        public void addMutablePropertyChangeListener(PropertyChangeListener l) {
            this.propSupport.addPropertyChangeListener(l);
        }

        public void addTo(MutablePropertiesContainer c) {
            this.parent = c;
            this.parent.addMutableProperty(this.propertyName, this);
            allProperties.add(this);
        }

        public void setPropertyName(String name) {
            if (this.parent != null) {
                this.parent.removeMutableProperty(this.propertyName);
                this.parent.addMutableProperty(name, this);
            }
            this.propertyName = name;
        }

        public void removeFromContainer() {
            if (this.parent != null) {
                this.parent.removeMutableProperty(this.propertyName);
                allProperties.remove(this);
            }
        }

        @Override
        public String getPropertyValue() {
            return this.value;
        }

        public String getName() {
            return this.propertyName;
        }

        @Override
        public MutablePropertiesContainer getParent() {
            return this.parent;
        }

        @Override
        public void removeMutablePropertyChangeListener(PropertyChangeListener l) {
            this.propSupport.removePropertyChangeListener(l);
        }

        protected Command getChangeCommand(String oldValue, String newValue) {
            return new ChangePropertyCommand(this, this.propertyName, oldValue, newValue);
        }

        @Override
        public Command setPropertyValue(String newValue) {
            if (newValue == null) {
                newValue = "";
            }
            String oldValue = this.value;
            Command c = this.getChangeCommand(this.value, newValue);
            this.value = newValue;
            this.propSupport.firePropertyChange(this.propertyName, oldValue, newValue);
            return c;
        }
    }

    public static class Util {
        public static MutableProperty findMutableProperty(String propertyName, List<MutablePropertiesContainer> propertyContainers) {
            MutablePropertiesContainer c;
            MutableProperty p = null;
            Iterator<MutablePropertiesContainer> iterator = propertyContainers.iterator();
            while (iterator.hasNext() && (p = (c = iterator.next()) == null ? null : c.getMutableProperty(propertyName)) == null) {
            }
            return p;
        }
    }
}

