/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.widget;

import VASSAL.build.BadDataReport;
import VASSAL.build.Buildable;
import VASSAL.build.Widget;
import VASSAL.build.widget.PieceSlot;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class PanelWidget
extends Widget {
    private JPanel panel;
    private final List<Widget> widgets = new ArrayList<Widget>();
    private int nColumns = 3;
    private boolean vertical = false;
    private boolean fixed = false;
    protected double scale = 1.0;
    public static final String SCALE = "scale";
    public static final String FIXED = "fixed";
    public static final String COLS = "nColumns";
    public static final String VERTICAL = "vert";

    @Override
    public boolean hasScale() {
        return true;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.PanelWidget.component_type");
    }

    @Override
    public Component getComponent() {
        if (this.panel == null) {
            this.rebuild();
            this.panel = new JPanel();
            this.panel.setLayout(this.getLayout(this.panel));
            for (Widget w : this.widgets) {
                Component c = w.getComponent();
                if (c instanceof JComponent) {
                    ((JComponent)c).setAlignmentX(0.0f);
                    ((JComponent)c).setAlignmentY(0.0f);
                }
                if (w instanceof PieceSlot) {
                    this.panel.setBackground(Color.WHITE);
                }
                this.panel.add(c);
            }
        }
        return this.panel;
    }

    private LayoutManager getLayout(Container c) {
        if (this.fixed) {
            return new GridLayout(0, this.nColumns);
        }
        return new BoxLayout(c, this.vertical ? 1 : 0);
    }

    @Override
    public void add(Buildable b) {
        if (b instanceof Widget) {
            Widget w = (Widget)b;
            this.widgets.add(w);
            if (this.panel != null) {
                Component c = w.getComponent();
                if (c instanceof JComponent) {
                    ((JComponent)c).setAlignmentX(0.0f);
                    ((JComponent)c).setAlignmentY(0.0f);
                }
                this.panel.add(c);
                this.panel.revalidate();
            }
        }
        super.add(b);
    }

    @Override
    public void remove(Buildable b) {
        if (b instanceof Widget) {
            Widget w = (Widget)b;
            if (this.panel != null) {
                this.panel.remove(w.getComponent());
            }
            this.widgets.remove(w);
        }
        super.remove(b);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"entryName", FIXED, COLS, VERTICAL, SCALE};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.PanelWidget.fixed_cell_size"), Resources.getString("Editor.PanelWidget.number_of_columns"), Resources.getString("Editor.PanelWidget.vertical_layout"), Resources.getString("Editor.PanelWidget.scale")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Boolean.class, Integer.class, Boolean.class, Double.class};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (COLS.equals(name)) {
            return () -> this.fixed;
        }
        if (VERTICAL.equals(name)) {
            return () -> !this.fixed;
        }
        return super.getAttributeVisibility(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if ("entryName".equals(name)) {
            this.setConfigureName((String)value);
        } else if (FIXED.equals(name)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.fixed = (Boolean)value;
        } else if (COLS.equals(name)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.nColumns = (Integer)value;
            if (this.nColumns < 1) {
                ErrorDialog.dataWarning(new BadDataReport("Panel has &lt; 1 column:", this.getConfigureName()));
                this.nColumns = 1;
            }
        } else if (VERTICAL.equals(name)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.vertical = (Boolean)value;
        } else if (SCALE.equals(name)) {
            if (value instanceof String) {
                value = Double.valueOf((String)value);
            }
            this.scale = (Double)value;
            if (this.scale < 0.01) {
                this.scale = 0.01;
            } else if (this.scale >= 4.0) {
                this.scale = 4.0;
            }
        }
        if (this.panel != null) {
            this.panel.setLayout(this.getLayout(this.panel));
            this.panel.revalidate();
        }
    }

    @Override
    public String getAttributeValueString(String name) {
        if ("entryName".equals(name)) {
            return this.getConfigureName();
        }
        if (FIXED.equals(name)) {
            return String.valueOf(this.fixed);
        }
        if (COLS.equals(name)) {
            return String.valueOf(this.nColumns);
        }
        if (VERTICAL.equals(name)) {
            return String.valueOf(this.vertical);
        }
        if (SCALE.equals(name)) {
            return String.valueOf(this.scale);
        }
        return null;
    }
}

