/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.command;

import VASSAL.command.NullCommand;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.ThrowableUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public abstract class Command {
    private List<Command> seq = new LinkedList<Command>();
    private Command undo;

    public Command[] getSubCommands() {
        return this.seq.toArray(new Command[0]);
    }

    public void execute() {
        try {
            this.executeCommand();
        }
        catch (Throwable t) {
            this.handleFailure(t);
            List<Command> oldSeq = this.seq;
            this.stripSubCommands();
            this.seq = oldSeq;
        }
        for (Command cmd : this.seq) {
            try {
                cmd.execute();
            }
            catch (Throwable t) {
                this.handleFailure(t);
            }
        }
    }

    private void handleFailure(Throwable t) {
        ThrowableUtils.throwRecent(OutOfMemoryError.class, t);
        if (t instanceof Error) {
            throw (Error)t;
        }
        ErrorDialog.bug(t);
    }

    protected abstract void executeCommand();

    protected abstract Command myUndoCommand();

    public void stripSubCommands() {
        this.seq = new LinkedList<Command>();
    }

    public boolean isNull() {
        return false;
    }

    public boolean isLoggable() {
        return !this.isNull();
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    protected boolean hasNullSubcommands() {
        ProblemDialog.showDeprecated("2020-08-06");
        return this.isAtomic();
    }

    protected boolean isAtomic() {
        for (Command c : this.seq) {
            if (c.isNull()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        String details = this.getDetails();
        if (details != null) {
            sb.append('[').append(details).append(']');
        }
        for (Command c : this.seq) {
            sb.append('+').append(c);
        }
        return sb.toString();
    }

    public String getDetails() {
        return null;
    }

    public Command append(Command c) {
        Command retval = this;
        if (c != null && !c.isNull()) {
            if (this.isNull()) {
                retval = c;
            }
            this.seq.add(c);
        }
        return retval;
    }

    public Command getUndoCommand() {
        if (this.undo == null) {
            this.undo = new NullCommand();
            ListIterator<Command> i = this.seq.listIterator(this.seq.size());
            while (i.hasPrevious()) {
                this.undo = this.undo.append(i.previous().getUndoCommand());
            }
            this.undo = this.undo.append(this.myUndoCommand());
        }
        return this.undo;
    }

    public boolean isNullOrcontainsOnly(Class<?> target) {
        if (this instanceof NullCommand || target.isInstance(this)) {
            for (Command c : this.seq) {
                if (c == null || c.isNullOrcontainsOnly(target)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

