/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerPanel;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class BooleanConfigurer
extends Configurer {
    protected JPanel p;
    private JCheckBox box;

    public BooleanConfigurer(String key, String name, Boolean val) {
        super(key, name, val);
    }

    public BooleanConfigurer(String key, String name, boolean val) {
        super(key, name, val ? Boolean.TRUE : Boolean.FALSE);
    }

    public BooleanConfigurer(String key, String name) {
        this(key, name, Boolean.FALSE);
    }

    public BooleanConfigurer(Boolean val) {
        this((String)null, "", val);
    }

    public BooleanConfigurer(boolean val) {
        this((String)null, "", val);
    }

    @Override
    public String getValueString() {
        return this.booleanValue().toString();
    }

    public boolean getValueBoolean() {
        return this.booleanValue();
    }

    @Override
    public void setValue(Object o) {
        super.setValue(o);
        if (this.box != null && !Boolean.valueOf(this.box.isSelected()).equals(o)) {
            this.box.setSelected(this.booleanValue());
        }
    }

    @Override
    public void setValue(String s) {
        this.setValue(Boolean.valueOf(s));
    }

    @Override
    public void setName(String s) {
        super.setName(s);
        if (this.box != null) {
            this.box.setText(s);
        }
    }

    @Override
    public Component getControls() {
        if (this.p == null) {
            this.p = new ConfigurerPanel(this.getName(), "[]0[0]", "[][][]");
            this.box = new JCheckBox();
            this.box.setSelected(this.booleanValue());
            this.box.addItemListener(e -> this.setValue(this.box.isSelected()));
            this.p.add(this.box);
        }
        return this.p;
    }

    public Boolean booleanValue() {
        return (Boolean)this.value;
    }

    @Override
    public void setLabelVisibile(boolean visible) {
        if (this.p instanceof ConfigurerPanel) {
            ((ConfigurerPanel)this.p).setLabelVisibility(visible);
        }
    }
}

