/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerPanel;
import VASSAL.i18n.Resources;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class TranslatingStringEnumConfigurer
extends Configurer {
    private String[] validValues;
    private String[] i18nKeys;
    private JComboBox<String> box;
    private JPanel panel;
    private boolean isDisplayNames;

    public TranslatingStringEnumConfigurer(String key, String name, String[] validValues, String[] i18nKeys) {
        super(key, name, validValues != null && validValues.length > 0 ? validValues[0] : "");
        this.validValues = validValues;
        this.i18nKeys = i18nKeys;
        this.isDisplayNames = false;
    }

    public TranslatingStringEnumConfigurer(String[] validValues, String[] i18nKeys) {
        this(null, null, validValues, i18nKeys);
    }

    public TranslatingStringEnumConfigurer(String[] validValues, String[] i18nKeys, boolean isDisplayNames) {
        this(null, null, validValues, i18nKeys, isDisplayNames);
    }

    public TranslatingStringEnumConfigurer(String key, String name, String[] validValues, String[] i18nKeys, boolean isDisplayNames) {
        super(key, name, validValues);
        this.validValues = validValues;
        this.i18nKeys = i18nKeys;
        this.isDisplayNames = isDisplayNames;
    }

    public TranslatingStringEnumConfigurer(String key, String name, List<String> validValues, List<String> i18nKeys) {
        this(key, name, validValues.toArray(new String[0]), i18nKeys.toArray(new String[0]));
    }

    public TranslatingStringEnumConfigurer(List<String> validValues, List<String> i18nKeys) {
        this(null, null, validValues.toArray(new String[0]), i18nKeys.toArray(new String[0]));
    }

    public TranslatingStringEnumConfigurer(String key, String name, List<String> validValues, List<String> i18nKeys, boolean isDisplayNames) {
        this(key, name, validValues.toArray(new String[0]), i18nKeys.toArray(new String[0]), isDisplayNames);
    }

    public TranslatingStringEnumConfigurer(String key, String name, String[] validValues, String[] i18nKeys, String initialValue) {
        this(key, name, validValues, i18nKeys);
        this.setValue(initialValue);
    }

    public TranslatingStringEnumConfigurer(String key, String name, String[] validValues, String[] i18nKeys, char initialValue) {
        this(key, name, validValues, i18nKeys, String.valueOf(initialValue));
    }

    public TranslatingStringEnumConfigurer(String[] validValues, String[] i18nKeys, String initialValue) {
        this(null, null, validValues, i18nKeys, initialValue);
    }

    public TranslatingStringEnumConfigurer(String[] validValues, String[] i18nKeys, char initialValue) {
        this(null, null, validValues, i18nKeys, String.valueOf(initialValue));
    }

    public TranslatingStringEnumConfigurer(String key, String name, String[] validValues, String[] i18nKeys, String initialValue, boolean isDisplayNames) {
        this(key, name, validValues, i18nKeys, isDisplayNames);
        this.setValue(initialValue);
    }

    public TranslatingStringEnumConfigurer(String key, String name, List<String> validValues, List<String> i18nKeys, String initialValue) {
        this(key, name, validValues, i18nKeys);
        this.setValue(initialValue);
    }

    public TranslatingStringEnumConfigurer(List<String> validValues, List<String> i18nKeys, String initialValue) {
        this(null, null, validValues, i18nKeys, initialValue);
    }

    public TranslatingStringEnumConfigurer(String key, String name, List<String> validValues, List<String> i18nKeys, String initialValue, boolean isDisplayNames) {
        this(key, name, validValues, i18nKeys, isDisplayNames);
        this.setValue(initialValue);
    }

    public boolean isDisplayNames() {
        return this.isDisplayNames;
    }

    public void setDisplayNames(boolean isDisplayNames) {
        this.isDisplayNames = isDisplayNames;
    }

    @Override
    public Component getControls() {
        if (this.panel == null) {
            String[] displayValues = new String[this.i18nKeys.length];
            for (int i = 0; i < this.i18nKeys.length; ++i) {
                displayValues[i] = this.isDisplayNames() ? this.i18nKeys[i] : Resources.getString(this.i18nKeys[i]);
            }
            this.panel = new ConfigurerPanel(this.getName(), "[]", "[][]");
            this.box = new JComboBox<String>(displayValues);
            this.box.setMaximumSize(new Dimension(this.box.getMaximumSize().width, this.box.getPreferredSize().height));
            if (this.isValidValue(this.getValue())) {
                this.box.setSelectedIndex(this.getValueIndex(this.getValue()));
            } else if (displayValues.length > 0) {
                this.box.setSelectedIndex(0);
            }
            this.box.addActionListener(e -> {
                int selected = this.box.getSelectedIndex();
                if (selected >= 0) {
                    this.noUpdate = true;
                    this.setValue(this.validValues[selected]);
                    this.noUpdate = false;
                }
            });
            this.panel.add(this.box);
        }
        return this.panel;
    }

    public int getSelectedIndex() {
        return this.box.getSelectedIndex();
    }

    public void setEnabled(boolean enabled) {
        this.box.setEnabled(enabled);
    }

    public void setEditable(boolean editable) {
        this.box.setEditable(editable);
    }

    public boolean isValidValue(Object o) {
        for (String validValue : this.validValues) {
            if (!validValue.equals(o)) continue;
            return true;
        }
        return false;
    }

    public int getValueIndex(Object o) {
        for (int i = 0; i < this.validValues.length; ++i) {
            if (!this.validValues[i].equals(o)) continue;
            return i;
        }
        return 0;
    }

    public String[] getValidValues() {
        return this.validValues;
    }

    public void setValidValues(String[] values, String[] keys) {
        this.validValues = values;
        this.i18nKeys = keys;
        String[] displayValues = new String[this.i18nKeys.length];
        for (int i = 0; i < this.i18nKeys.length; ++i) {
            displayValues[i] = this.isDisplayNames() ? this.i18nKeys[i] : Resources.getString(this.i18nKeys[i]);
        }
        this.box.setModel(new DefaultComboBoxModel<String>(displayValues));
    }

    @Override
    public void setValue(Object o) {
        if (this.validValues == null || this.isValidValue(o)) {
            super.setValue(o);
            if (!this.noUpdate && this.box != null && this.validValues != null) {
                for (int i = 0; i < this.validValues.length; ++i) {
                    if (!this.validValues[i].equals(o)) continue;
                    this.box.setSelectedIndex(i);
                    break;
                }
            }
        }
    }

    @Override
    public String getValueString() {
        return this.getValue() == null ? "" : this.getValue().toString();
    }

    @Override
    public void setValue(String s) {
        this.setValue((Object)s);
    }

    @Override
    public void setLabelVisibile(boolean visible) {
        if (this.panel instanceof ConfigurerPanel) {
            ((ConfigurerPanel)this.panel).setLabelVisibility(visible);
        }
    }
}

