/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.Drawable;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PieceImage;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.counters.TraitLayout;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.imageop.GamePieceOp;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.RotateScaleOp;
import VASSAL.tools.swing.SwingUtils;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;

public class FreeRotator
extends Decorator
implements EditablePiece,
MouseListener,
MouseMotionListener,
Drawable,
TranslatablePiece {
    public static final String ID = "rotate;";
    public static final String FACING = "_Facing";
    public static final String DEGREES = "_Degrees";
    public static final double PI_180 = Math.PI / 180;
    protected KeyCommand setAngleCommand;
    protected KeyCommand rotateCWCommand;
    protected KeyCommand rotateCCWCommand;
    protected KeyCommand[] commands;
    protected NamedKeyStroke setAngleKey;
    protected String setAngleText = Resources.getString("Editor.FreeRotator.default_rotate_command");
    protected NamedKeyStroke rotateCWKey;
    protected String rotateCWText = Resources.getString("Editor.FreeRotator.default_rotate_cw_command");
    protected NamedKeyStroke rotateCCWKey;
    protected String rotateCCWText = Resources.getString("Editor.FreeRotator.default_rotate_ccw_command");
    protected String name = Resources.getString("Editor.FreeRotator.default_trait_name");
    protected String description = "";
    protected KeyCommand rotateRNDCommand;
    protected String rotateRNDText = "";
    protected NamedKeyStroke rotateRNDKey;
    protected boolean useUnrotatedShape;
    protected double[] validAngles = new double[]{0.0};
    protected int angleIndex = 0;
    @Deprecated(since="2020-08-06", forRemoval=true)
    protected java.util.Map<Double, Image> images = new HashMap<Double, Image>();
    protected java.util.Map<Double, Rectangle> bounds = new HashMap<Double, Rectangle>();
    @Deprecated(since="2020-08-06", forRemoval=true)
    protected PieceImage unrotated;
    protected GamePieceOp gpOp;
    protected java.util.Map<Double, RotateScaleOp> rotOp = new HashMap<Double, RotateScaleOp>();
    protected double tempAngle;
    protected double startAngle;
    protected Point pivot;
    protected boolean drawGhost;
    protected Map startMap;
    protected Point startPosition;

    public FreeRotator() {
        this("rotate;6;];[;" + Resources.getString("Editor.FreeRotator.default_rotate_cw_command") + ";" + Resources.getString("Editor.FreeRotator.default_rotate_ccw_command") + ";;;;", null);
    }

    public FreeRotator(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public void setInner(GamePiece p) {
        this.gpOp = null;
        super.setInner(p);
    }

    private double centerX() {
        return (double)(this.piece.boundingBox().width % 2) / 2.0;
    }

    private double centerY() {
        return (double)(this.piece.boundingBox().height % 2) / 2.0;
    }

    @Override
    public Rectangle boundingBox() {
        Rectangle r;
        Rectangle b = this.piece.boundingBox();
        double angle = this.getAngle();
        if (angle == 0.0) {
            return b;
        }
        if (this.getGpOp() != null && this.getGpOp().isChanged() || (r = this.bounds.get(angle)) == null) {
            r = AffineTransform.getRotateInstance(this.getAngleInRadians(), this.centerX(), this.centerY()).createTransformedShape(b).getBounds();
            this.bounds.put(angle, r);
        }
        return new Rectangle(r);
    }

    protected GamePieceOp getGpOp() {
        if (this.gpOp == null && this.getInner() != null) {
            this.gpOp = Op.piece(this.getInner());
        }
        return this.gpOp;
    }

    public double getAngle() {
        return this.useUnrotatedShape ? 0.0 : this.validAngles[this.angleIndex];
    }

    public double getCumulativeAngle() {
        double angle = this.getAngle();
        FreeRotator nextRotation = (FreeRotator)Decorator.getDecorator(this.getInner(), FreeRotator.class);
        if (nextRotation != null) {
            angle += nextRotation.getCumulativeAngle();
        }
        return angle;
    }

    public double getCumulativeAngleInRadians() {
        return -Math.PI / 180 * this.getCumulativeAngle();
    }

    public void setAngle(double angle) {
        if (this.validAngles.length == 1) {
            this.validAngles[this.angleIndex] = angle;
        } else {
            angle = (angle % 360.0 - 360.0) % 360.0;
            double ex = -angle / 360.0 * (double)this.validAngles.length;
            this.angleIndex = (int)Math.round(ex) % this.validAngles.length;
        }
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public Rectangle getRotatedBounds() {
        ProblemDialog.showDeprecated("2020-08-06");
        return this.boundingBox();
    }

    @Override
    public Shape getShape() {
        Shape s = this.piece.getShape();
        if (this.getAngle() == 0.0) {
            return s;
        }
        return AffineTransform.getRotateInstance(this.getAngleInRadians(), this.centerX(), this.centerY()).createTransformedShape(s);
    }

    public double getAngleInRadians() {
        return -Math.PI / 180 * this.getAngle();
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.validAngles = new double[Integer.parseInt(st.nextToken())];
        for (int i = 0; i < this.validAngles.length; ++i) {
            this.validAngles[i] = (double)(-i) * (360.0 / (double)this.validAngles.length);
        }
        if (this.validAngles.length == 1) {
            this.setAngleKey = st.nextNamedKeyStroke(null);
            if (st.hasMoreTokens()) {
                this.setAngleText = st.nextToken();
            }
        } else {
            this.rotateCWKey = st.nextNamedKeyStroke(null);
            this.rotateCCWKey = st.nextNamedKeyStroke(null);
            this.rotateCWText = st.nextToken("");
            this.rotateCCWText = st.nextToken("");
        }
        this.rotateRNDKey = st.nextNamedKeyStroke(null);
        this.rotateRNDText = st.nextToken("");
        this.name = st.nextToken("");
        this.description = st.nextToken("");
        this.commands = null;
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        if (this.getAngle() == 0.0) {
            this.piece.draw(g, x, y, obs, zoom);
        } else {
            RotateScaleOp op;
            double angle = this.getAngle();
            if (this.getGpOp() != null && this.getGpOp().isChanged()) {
                this.gpOp = Op.piece(this.piece);
                this.bounds.clear();
                this.rotOp.clear();
                op = Op.rotateScale(this.gpOp, angle, zoom);
                this.rotOp.put(angle, op);
            } else {
                op = this.rotOp.get(angle);
                if (op == null || op.getScale() != zoom) {
                    op = Op.rotateScale(this.gpOp, angle, zoom);
                    this.rotOp.put(angle, op);
                }
            }
            Rectangle r = this.boundingBox();
            BufferedImage img = op.getImage();
            if (img != null) {
                g.drawImage(img, x + (int)(zoom * (double)r.x), y + (int)(zoom * (double)r.y), obs);
            }
        }
    }

    @Override
    public void draw(Graphics g, Map map) {
        if (!this.drawGhost) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
        Point p = map.mapToDrawing(this.getGhostPosition(), os_scale);
        g2d.transform(AffineTransform.getRotateInstance(-Math.PI / 180 * this.tempAngle, (double)p.x + this.centerX(), (double)p.y + this.centerY()));
        g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.piece.draw(g2d, p.x, p.y, map.getView(), map.getZoom() * os_scale);
        g2d.dispose();
    }

    @Override
    public boolean drawAboveCounters() {
        return true;
    }

    private Point getGhostPosition() {
        AffineTransform t = AffineTransform.getRotateInstance(-Math.PI / 180 * (this.tempAngle - this.getAngle()), (double)this.pivot.x + this.centerX(), (double)this.pivot.y + this.centerY());
        Point2D.Float newPos2D = new Point2D.Float(this.getPosition().x, this.getPosition().y);
        t.transform(newPos2D, newPos2D);
        return new Point((int)Math.round(((Point2D)newPos2D).getX()), (int)Math.round(((Point2D)newPos2D).getY()));
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.validAngles.length);
        if (this.validAngles.length == 1) {
            se.append(this.setAngleKey);
            se.append(this.setAngleText);
        } else {
            se.append(this.rotateCWKey).append(this.rotateCCWKey).append(this.rotateCWText).append(this.rotateCCWText);
        }
        se.append(this.rotateRNDKey).append(this.rotateRNDText);
        se.append(this.name);
        se.append(this.description);
        return ID + se.getValue();
    }

    @Override
    public String myGetState() {
        if (this.validAngles.length == 1) {
            return String.valueOf(this.validAngles[0]);
        }
        return String.valueOf(this.angleIndex);
    }

    @Override
    public void mySetState(String state) {
        if (this.validAngles.length == 1) {
            try {
                this.validAngles[0] = Double.parseDouble(state);
            }
            catch (NumberFormatException e) {
                FreeRotator.reportDataError(this, Resources.getString("Error.non_number_error"), "Angle=" + state, e);
            }
        } else {
            try {
                this.angleIndex = Integer.parseInt(state);
            }
            catch (NumberFormatException e) {
                FreeRotator.reportDataError(this, Resources.getString("Error.non_number_error"), "Fixed Angle Index=" + state, e);
            }
        }
    }

    @Override
    public KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            ArrayList<KeyCommand> l = new ArrayList<KeyCommand>();
            GamePiece outer = Decorator.getOutermost(this);
            this.setAngleCommand = new KeyCommand(this.setAngleText, this.setAngleKey, outer, (TranslatablePiece)this);
            this.rotateCWCommand = new KeyCommand(this.rotateCWText, this.rotateCWKey, outer, (TranslatablePiece)this);
            this.rotateCCWCommand = new KeyCommand(this.rotateCCWText, this.rotateCCWKey, outer, (TranslatablePiece)this);
            this.rotateRNDCommand = new KeyCommand(this.rotateRNDText, this.rotateRNDKey, outer, (TranslatablePiece)this);
            if (this.validAngles.length == 1) {
                if (this.setAngleText.length() > 0) {
                    l.add(this.setAngleCommand);
                } else {
                    this.setAngleCommand.setEnabled(false);
                }
                this.rotateCWCommand.setEnabled(false);
                this.rotateCCWCommand.setEnabled(false);
            } else {
                if (this.rotateCWText.length() > 0 && this.rotateCCWText.length() > 0) {
                    l.add(this.rotateCWCommand);
                    l.add(this.rotateCCWCommand);
                } else if (this.rotateCWText.length() > 0) {
                    l.add(this.rotateCWCommand);
                    this.rotateCCWCommand.setEnabled(this.rotateCCWKey != null);
                } else if (this.rotateCCWText.length() > 0) {
                    l.add(this.rotateCCWCommand);
                    this.rotateCWCommand.setEnabled(this.rotateCWKey != null);
                }
                this.setAngleCommand.setEnabled(false);
            }
            if (this.rotateRNDText.length() > 0) {
                l.add(this.rotateRNDCommand);
            }
            this.commands = l.toArray(new KeyCommand[0]);
        }
        this.setAngleCommand.setEnabled(this.getMap() != null && this.validAngles.length == 1 && this.setAngleText.length() > 0);
        return this.commands;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        Command c = null;
        if (this.setAngleCommand.matches(stroke)) {
            this.beginInteractiveRotate();
        } else if (this.rotateCWCommand.matches(stroke)) {
            ChangeTracker tracker = new ChangeTracker(this);
            this.angleIndex = (this.angleIndex + 1) % this.validAngles.length;
            c = tracker.getChangeCommand();
        } else if (this.rotateCCWCommand.matches(stroke)) {
            ChangeTracker tracker = new ChangeTracker(this);
            this.angleIndex = (this.angleIndex - 1 + this.validAngles.length) % this.validAngles.length;
            c = tracker.getChangeCommand();
        } else if (this.rotateRNDCommand.matches(stroke)) {
            ChangeTracker tracker = new ChangeTracker(this);
            Random rand = GameModule.getGameModule().getRNG();
            if (this.validAngles.length == 1) {
                this.setAngle(rand.nextDouble() * 360.0);
            } else {
                this.angleIndex = rand.nextInt(this.validAngles.length);
            }
            c = tracker.getChangeCommand();
        }
        return c;
    }

    public void beginInteractiveRotate() {
        this.startPosition = this.getPosition();
        this.startMap = this.getMap();
        this.startMap.pushMouseListener(this);
        this.startMap.addDrawComponent(this);
        JComponent view = this.startMap.getView();
        view.addMouseMotionListener(this);
        view.setCursor(Cursor.getPredefinedCursor(1));
        this.startMap.disableKeyListeners();
        this.pivot = this.getPosition();
    }

    public void endInteractiveRotate() {
        if (this.startMap != null) {
            this.startMap.getView().setCursor(null);
            this.startMap.removeDrawComponent(this);
            this.startMap.popMouseListener();
            this.startMap.getView().removeMouseMotionListener(this);
            this.startMap.enableKeyListeners();
            this.drawGhost = false;
            this.startMap = null;
        }
    }

    public boolean hasPieceMoved() {
        Map m = this.getMap();
        Point p = this.getPosition();
        return m == null || m != this.startMap || p == null || !p.equals(this.startPosition);
    }

    public void setPivot(int x, int y) {
        this.pivot = new Point(x, y);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtils.isMainMouseButtonDown(e)) {
            if (this.hasPieceMoved()) {
                this.endInteractiveRotate();
                return;
            }
            this.drawGhost = true;
            this.startAngle = this.getRelativeAngle(e.getPoint(), this.getPosition());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtils.isMainMouseButtonDown(e)) {
            if (this.hasPieceMoved()) {
                this.endInteractiveRotate();
                return;
            }
            Map m = this.getMap();
            try {
                Point ghostPosition = this.getGhostPosition();
                Command c = null;
                ChangeTracker tracker = new ChangeTracker(this);
                if (!this.getPosition().equals(ghostPosition)) {
                    GamePiece outer = Decorator.getOutermost(this);
                    outer.setProperty("Moved", Boolean.TRUE);
                    c = m.placeOrMerge(outer, m.snapTo(ghostPosition));
                }
                this.setAngle(this.tempAngle);
                c = tracker.getChangeCommand().append(c);
                GameModule.getGameModule().sendAndLog(c);
            }
            finally {
                this.endInteractiveRotate();
            }
        }
    }

    @Override
    public void setProperty(Object key, Object val) {
        if ("useUnrotatedShape".equals(key)) {
            this.useUnrotatedShape = Boolean.TRUE.equals(val);
        }
        super.setProperty(key, val);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if ((this.name + FACING).equals(key)) {
            return String.valueOf(this.angleIndex + 1);
        }
        if ((this.name + DEGREES).equals(key)) {
            return String.valueOf((int)Math.abs(this.validAngles[this.angleIndex]));
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public Object getProperty(Object key) {
        if ((this.name + FACING).equals(key)) {
            return String.valueOf(this.angleIndex + 1);
        }
        if ((this.name + DEGREES).equals(key)) {
            return String.valueOf((int)Math.abs(this.validAngles[this.angleIndex]));
        }
        return super.getProperty(key);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (SwingUtils.isMainMouseButtonDown(e) && !this.hasPieceMoved()) {
            if (this.drawGhost) {
                Point mousePos = this.getMap().componentToMap(e.getPoint());
                double myAngle = this.getRelativeAngle(mousePos, this.pivot);
                this.tempAngle = this.getAngle() - (myAngle - this.startAngle) / (Math.PI / 180);
            }
            this.getMap().repaint();
        }
    }

    private double getRelativeAngle(Point p, Point origin) {
        double myAngle;
        if (p.y == origin.y) {
            myAngle = p.x < origin.x ? -1.5707963267948966 : 1.5707963267948966;
        } else {
            myAngle = Math.atan((double)(p.x - origin.x) / (double)(origin.y - p.y));
            if (origin.y < p.y) {
                myAngle += Math.PI;
            }
        }
        return myAngle;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.hasPieceMoved()) {
            this.endInteractiveRotate();
        }
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public Image getRotatedImage(double angle, Component obs) {
        ProblemDialog.showDeprecated("2020-08-06");
        if (this.gpOp == null) {
            return null;
        }
        if (this.gpOp.isChanged()) {
            this.gpOp = Op.piece(this.piece);
        }
        return Op.rotateScale(this.gpOp, angle, 1.0).getImage();
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.FreeRotator.trait_description", this.name, this.description);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Rotate.html");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(new String[]{this.setAngleText, this.rotateCWText, this.rotateCCWText, this.rotateRNDText}, new String[]{this.getCommandDescription(this.name, Resources.getString("Editor.FreeRotator.set_angle_command_description")), this.getCommandDescription(this.name, Resources.getString("Editor.FreeRotator.rotate_cw_command_description")), this.getCommandDescription(this.name, Resources.getString("Editor.FreeRotator.rotate_ccw_command_description")), this.getCommandDescription(this.name, Resources.getString("Editor.FreeRotator.rotate_random_command_description"))});
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.name + FACING);
        l.add(this.name + DEGREES);
        return l;
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof FreeRotator)) {
            return false;
        }
        FreeRotator c = (FreeRotator)o;
        if (!Objects.equals(this.validAngles.length, c.validAngles.length)) {
            return false;
        }
        if (this.validAngles.length == 1) {
            if (!Objects.equals(this.setAngleKey, c.setAngleKey)) {
                return false;
            }
            if (!Objects.equals(this.setAngleText, c.setAngleText)) {
                return false;
            }
        } else {
            if (!Objects.equals(this.rotateCWKey, c.rotateCWKey)) {
                return false;
            }
            if (!Objects.equals(this.rotateCCWKey, c.rotateCCWKey)) {
                return false;
            }
            if (!Objects.equals(this.rotateCWText, c.rotateCWText)) {
                return false;
            }
            if (!Objects.equals(this.rotateCCWText, c.rotateCCWText)) {
                return false;
            }
        }
        if (!Objects.equals(this.rotateRNDKey, c.rotateRNDKey)) {
            return false;
        }
        if (!Objects.equals(this.name, c.name)) {
            return false;
        }
        if (this.validAngles.length == 1) {
            return Objects.equals(this.validAngles[0], c.validAngles[0]);
        }
        return Objects.equals(this.angleIndex, c.angleIndex);
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(this.setAngleKey, this.rotateCWKey, this.rotateCCWKey, this.rotateRNDKey);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.setAngleText, this.rotateCWText, this.rotateCCWText, this.rotateRNDText);
    }

    private static class Ed
    implements PieceEditor,
    PropertyChangeListener {
        private final BooleanConfigurer anyConfig;
        private final NamedHotKeyConfigurer anyKeyConfig;
        private final JLabel facingsLabel;
        private final IntConfigurer facingsConfig;
        private final NamedHotKeyConfigurer cwKeyConfig;
        private final JLabel cwLabel;
        private final NamedHotKeyConfigurer ccwKeyConfig;
        private final JLabel ccwLabel;
        private final NamedHotKeyConfigurer rndKeyConfig;
        private final StringConfigurer nameConfig;
        private final StringConfigurer descConfig;
        private final JLabel anyLabel;
        private final StringConfigurer anyCommand;
        private final StringConfigurer cwCommand;
        private final StringConfigurer ccwCommand;
        private final StringConfigurer rndCommand;
        private final TraitConfigPanel panel = new TraitConfigPanel(new TraitLayout(false, "ins 0,gapy 4,hidemode 3,wrap 3", "[right]rel[fill,grow 1]rel[fill,grow 2]"));

        public Ed(FreeRotator p) {
            this.descConfig = new StringConfigurer(p.description);
            this.descConfig.setHintKey("Editor.description_hint");
            this.panel.add("Editor.description_label", (Configurer)this.descConfig, "span 2,wrap");
            this.nameConfig = new StringConfigurer(p.name);
            this.nameConfig.setHintKey("Editor.trait_name_hint");
            this.panel.add("Editor.FreeRotator.name", (Configurer)this.nameConfig, "span 2,wrap");
            this.anyConfig = new BooleanConfigurer(p.validAngles.length == 1);
            this.panel.add("Editor.FreeRotator.allow_arbitrary_rotations", (Configurer)this.anyConfig, "wrap");
            this.facingsLabel = new JLabel(Resources.getString("Editor.FreeRotator.number_of_allowed_facings"));
            this.facingsConfig = new IntConfigurer(p.validAngles.length == 1 ? 6 : p.validAngles.length);
            this.panel.add(this.facingsLabel, (Configurer)this.facingsConfig, "wrap");
            JLabel menuLabel = new JLabel(Resources.getString("Editor.menu_command"));
            Font boldFont = new Font(menuLabel.getFont().getFamily(), 1, menuLabel.getFont().getSize());
            menuLabel.setFont(boldFont);
            this.panel.add(new JLabel(""));
            this.panel.add((Component)menuLabel, "grow 0,align center");
            JLabel keyLabel = new JLabel(Resources.getString("Editor.keyboard_command"));
            keyLabel.setFont(boldFont);
            this.panel.add((Component)keyLabel, "grow 0,align center,wrap");
            this.cwLabel = new JLabel(Resources.getString("Editor.FreeRotator.rotate_clockwise"));
            this.panel.add(this.cwLabel);
            this.cwCommand = new StringConfigurer(p.rotateCWText);
            this.cwCommand.setHintKey("Editor.menu_command_hint");
            this.panel.add(this.cwCommand.getControls());
            this.cwKeyConfig = new NamedHotKeyConfigurer(p.rotateCWKey);
            this.panel.add(this.cwKeyConfig.getControls(), "wrap");
            this.ccwLabel = new JLabel(Resources.getString("Editor.FreeRotator.rotate_counter_clockwise"));
            this.panel.add(this.ccwLabel);
            this.ccwCommand = new StringConfigurer(p.rotateCCWText);
            this.ccwCommand.setHintKey("Editor.menu_command_hint");
            this.panel.add(this.ccwCommand.getControls());
            this.ccwKeyConfig = new NamedHotKeyConfigurer(p.rotateCCWKey);
            this.panel.add(this.ccwKeyConfig.getControls(), "wrap");
            this.anyLabel = new JLabel(Resources.getString("Editor.FreeRotator.rotate"));
            this.panel.add(this.anyLabel);
            this.anyCommand = new StringConfigurer(p.setAngleText);
            this.anyCommand.setHintKey("Editor.menu_command_hint");
            this.panel.add(this.anyCommand.getControls());
            this.anyKeyConfig = new NamedHotKeyConfigurer(p.setAngleKey);
            this.panel.add(this.anyKeyConfig.getControls(), "wrap");
            JLabel rndLabel = new JLabel(Resources.getString("Editor.FreeRotator.rotate_randomly"));
            this.panel.add(rndLabel);
            this.rndCommand = new StringConfigurer(p.rotateRNDText);
            this.rndCommand.setHintKey("Editor.menu_command_hint");
            this.panel.add(this.rndCommand.getControls());
            this.rndKeyConfig = new NamedHotKeyConfigurer(p.rotateRNDKey);
            this.panel.add(this.rndKeyConfig.getControls(), "wrap");
            this.anyConfig.addPropertyChangeListener(this);
            this.propertyChange(null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean any = Boolean.TRUE.equals(this.anyConfig.getValue());
            this.anyCommand.getControls().setVisible(any);
            this.anyKeyConfig.getControls().setVisible(any);
            this.anyLabel.setVisible(any);
            this.facingsLabel.setVisible(!any);
            this.facingsConfig.getControls().setVisible(!any);
            this.cwCommand.getControls().setVisible(!any);
            this.cwKeyConfig.getControls().setVisible(!any);
            this.cwLabel.setVisible(!any);
            this.ccwCommand.getControls().setVisible(!any);
            this.ccwKeyConfig.getControls().setVisible(!any);
            this.ccwLabel.setVisible(!any);
            this.panel.revalidate();
        }

        @Override
        public Component getControls() {
            return this.panel;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            if (Boolean.TRUE.equals(this.anyConfig.getValue())) {
                se.append("1").append(this.anyKeyConfig.getValueString()).append(this.anyCommand.getValueString() == null ? "" : this.anyCommand.getValueString().trim());
            } else {
                se.append(this.facingsConfig.getValueString()).append(this.cwKeyConfig.getValueString()).append(this.ccwKeyConfig.getValueString()).append(this.cwCommand.getValueString() == null ? "" : this.cwCommand.getValueString().trim()).append(this.ccwCommand.getValueString() == null ? "" : this.ccwCommand.getValueString().trim());
            }
            se.append(this.rndKeyConfig.getValueString()).append(this.rndCommand.getValueString() == null ? "" : this.rndCommand.getValueString().trim());
            se.append(this.nameConfig.getValueString());
            se.append(this.descConfig.getValueString());
            return FreeRotator.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "0";
        }
    }
}

