/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.DrawPile;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GamePiece;
import VASSAL.counters.GlobalCommandTarget;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.PropertyExporter;
import VASSAL.counters.Stack;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.KeyStroke;

public class GlobalCommand {
    protected KeyStroke keyStroke;
    protected boolean reportSingle;
    protected int selectFromDeck = -1;
    protected FormattedString reportFormat = new FormattedString();
    protected RecursionLimiter.Loopable owner;
    protected PropertySource source;
    protected GlobalCommandTarget target;
    private String fastProperty = "";
    private String fastValue = "";
    private boolean fastIsNumber = false;
    private double fastNumber = 0.0;
    private Pattern fastPattern;
    private static final Pattern fastCheckNumber = Pattern.compile("(\\+-)?\\d+(\\.\\d+)?");

    public GlobalCommand(RecursionLimiter.Loopable l) {
        this(l, null);
    }

    public GlobalCommand(RecursionLimiter.Loopable l, PropertySource p) {
        this.owner = l;
        this.source = p;
    }

    public void setPropertySource(PropertySource ps) {
        this.source = ps;
    }

    public void setKeyStroke(KeyStroke keyStroke) {
        this.keyStroke = keyStroke;
    }

    public void setKeyStroke(NamedKeyStroke keyStroke) {
        this.keyStroke = keyStroke.getKeyStroke();
    }

    public void setReportFormat(String format) {
        this.reportFormat.setFormat(format);
    }

    public KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public String getReportFormat() {
        return this.reportFormat.getFormat();
    }

    public boolean isReportSingle() {
        return this.reportSingle;
    }

    public void setReportSingle(boolean reportSingle) {
        this.reportSingle = reportSingle;
    }

    public void setTarget(GlobalCommandTarget target) {
        this.target = target;
    }

    public GlobalCommandTarget getTarget() {
        return this.target;
    }

    private boolean passesPropertyFastMatch(GamePiece gamePiece) {
        if (!this.target.fastMatchProperty || this.fastProperty.isEmpty()) {
            return true;
        }
        Object prop = gamePiece.getProperty(this.fastProperty);
        String value = prop == null ? null : prop.toString();
        switch (this.target.targetCompare) {
            case EQUALS: {
                return this.fastValue.equals(value);
            }
            case NOT_EQUALS: {
                return !this.fastValue.equals(value);
            }
        }
        if (prop == null || value == null) {
            return false;
        }
        switch (this.target.targetCompare) {
            case MATCH: {
                return this.fastPattern.matcher(value).matches();
            }
            case NOT_MATCH: {
                return !this.fastPattern.matcher(value).matches();
            }
        }
        if (!this.fastIsNumber || !this.isNumeric(value)) {
            switch (this.target.targetCompare) {
                case GREATER_EQUALS: {
                    return value.compareTo(this.fastValue) >= 0;
                }
                case GREATER: {
                    return value.compareTo(this.fastValue) > 0;
                }
                case LESS_EQUALS: {
                    return value.compareTo(this.fastValue) <= 0;
                }
                case LESS: {
                    return value.compareTo(this.fastValue) < 0;
                }
            }
        }
        double num = Double.parseDouble(value);
        switch (this.target.targetCompare) {
            case GREATER_EQUALS: {
                return num >= this.fastNumber;
            }
            case GREATER: {
                return num > this.fastNumber;
            }
            case LESS_EQUALS: {
                return num <= this.fastNumber;
            }
            case LESS: {
                return num < this.fastNumber;
            }
        }
        return false;
    }

    private boolean isNumeric(String s) {
        return fastCheckNumber.matcher(s).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command apply(Map[] maps, PieceFilter filter, GlobalCommandTarget fastMatch) {
        Command command = new NullCommand();
        this.setTarget(fastMatch != null ? fastMatch : new GlobalCommandTarget());
        try {
            if (this.reportSingle) {
                Map.setChangeReportingEnabled(false);
            }
            RecursionLimiter.startExecution(this.owner);
            String reportText = this.reportFormat.getLocalizedText(this.source);
            if (reportText.length() > 0) {
                command = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "*" + reportText);
                command.execute();
            }
            if (this.keyStroke == null || this.keyStroke.getKeyCode() == 0 && this.keyStroke.getModifiers() == 0) {
                NullCommand nullCommand = command;
                return nullCommand;
            }
            String fastMap = "";
            String fastBoard = "";
            String fastZone = "";
            String fastLocation = "";
            String fastDeck = "";
            String fastX = "";
            String fastY = "";
            GamePiece curPiece = this.target.getCurPiece();
            if (this.target.fastMatchLocation) {
                switch (this.target.targetType) {
                    case CURZONE: {
                        fastZone = curPiece != null ? (String)curPiece.getProperty("CurrentZone") : "";
                        break;
                    }
                    case CURLOC: {
                        fastLocation = curPiece != null ? (String)curPiece.getProperty("LocationName") : "";
                        break;
                    }
                    case ZONE: {
                        fastZone = this.target.targetZone.tryEvaluate(this.source);
                        break;
                    }
                    case DECK: {
                        fastDeck = this.target.targetDeck.tryEvaluate(this.source);
                        break;
                    }
                    case LOCATION: {
                        fastLocation = this.target.targetLocation.tryEvaluate(this.source);
                        break;
                    }
                    case XY: {
                        fastBoard = this.target.targetLocation.tryEvaluate(this.source);
                        fastX = this.target.targetX.tryEvaluate(this.source);
                        fastY = this.target.targetY.tryEvaluate(this.source);
                    }
                }
                if (!this.target.targetType.isCurrent()) {
                    fastMap = this.target.targetMap.tryEvaluate(this.source);
                }
            }
            if (this.target.fastMatchProperty) {
                this.fastProperty = this.target.targetProperty.tryEvaluate(this.source);
                this.fastValue = this.target.targetValue.tryEvaluate(this.source);
                if (this.target.targetCompare == GlobalCommandTarget.CompareMode.EQUALS || this.target.targetCompare == GlobalCommandTarget.CompareMode.NOT_EQUALS) {
                    this.fastIsNumber = false;
                    this.fastNumber = 0.0;
                } else if (this.target.targetCompare == GlobalCommandTarget.CompareMode.MATCH || this.target.targetCompare == GlobalCommandTarget.CompareMode.NOT_MATCH) {
                    this.fastPattern = Pattern.compile(this.fastValue);
                    this.fastIsNumber = false;
                    this.fastNumber = 0.0;
                } else {
                    this.fastIsNumber = this.isNumeric(this.fastValue);
                    this.fastNumber = this.fastIsNumber ? Double.parseDouble(this.fastValue) : 0.0;
                }
            }
            Visitor visitor = new Visitor(command, filter, this.keyStroke);
            DeckVisitorDispatcher dispatcher = new DeckVisitorDispatcher(visitor);
            if (this.target.fastMatchLocation && this.target.targetType == GlobalCommandTarget.Target.CURSTACK) {
                if (curPiece != null) {
                    int useFromDeck;
                    Stack stack = curPiece.getParent();
                    int n = useFromDeck = stack instanceof Deck ? this.getSelectFromDeck() : -1;
                    if (stack instanceof Deck) {
                        command = command.append(((Deck)stack).maybeShuffle());
                        visitor.setSelectedCount(0);
                    }
                    List<GamePiece> pieces = stack.asList();
                    if (stack instanceof Deck) {
                        pieces = new ArrayList<GamePiece>(pieces);
                        Collections.reverse(pieces);
                    }
                    if (useFromDeck != 0) {
                        for (GamePiece gamePiece : pieces) {
                            if (!this.passesPropertyFastMatch(gamePiece)) continue;
                            dispatcher.accept(gamePiece);
                            if (useFromDeck <= 0 || visitor.getSelectedCount() < useFromDeck) continue;
                            break;
                        }
                    }
                }
            } else if (this.target.fastMatchLocation && this.target.targetType == GlobalCommandTarget.Target.DECK) {
                DrawPile d = DrawPile.findDrawPile(fastDeck);
                int useFromDeck = this.getSelectFromDeck();
                if (d != null && useFromDeck != 0) {
                    command = command.append(d.getDeck().maybeShuffle());
                    ArrayList<GamePiece> pieces = new ArrayList<GamePiece>(d.getDeck().asList());
                    Collections.reverse(pieces);
                    visitor.setSelectedCount(0);
                    for (GamePiece gamePiece : pieces) {
                        if (!this.passesPropertyFastMatch(gamePiece)) continue;
                        dispatcher.accept(gamePiece);
                        if (useFromDeck <= 0 || visitor.getSelectedCount() < useFromDeck) continue;
                        break;
                    }
                }
            } else {
                for (Map map : maps) {
                    List<GamePiece> pieceList;
                    int useFromDeck;
                    if (this.target.fastMatchLocation && (this.target.targetType == GlobalCommandTarget.Target.CURMAP ? curPiece != null && !map.equals(curPiece.getMap()) : !this.target.targetType.isCurrent() && !fastMap.isEmpty() && !fastMap.equals(map.getConfigureName()))) continue;
                    GamePiece[] everythingOnMap = map.getPieces();
                    if (!this.target.fastMatchLocation) {
                        if (!this.target.fastMatchProperty) {
                            for (GamePiece pieceOrStack : everythingOnMap) {
                                dispatcher.accept(pieceOrStack);
                            }
                            continue;
                        }
                        block22: for (GamePiece pieceOrStack : everythingOnMap) {
                            if (pieceOrStack instanceof Deck) {
                                useFromDeck = this.getSelectFromDeck();
                                if (useFromDeck == 0) continue;
                                command = command.append(((Deck)pieceOrStack).maybeShuffle());
                                visitor.setSelectedCount(0);
                                pieceList = new ArrayList<GamePiece>(((Stack)pieceOrStack).asList());
                                Collections.reverse(pieceList);
                                for (GamePiece gamePiece : pieceList) {
                                    if (!this.passesPropertyFastMatch(gamePiece)) continue;
                                    dispatcher.accept(gamePiece);
                                    if (useFromDeck <= 0 || visitor.getSelectedCount() < useFromDeck) continue;
                                    continue block22;
                                }
                                continue;
                            }
                            pieceList = pieceOrStack instanceof Stack ? ((Stack)pieceOrStack).asList() : Collections.singletonList(pieceOrStack);
                            for (GamePiece gamePiece : pieceList) {
                                if (!this.passesPropertyFastMatch(gamePiece)) continue;
                                dispatcher.accept(gamePiece);
                            }
                        }
                        continue;
                    }
                    block25: for (GamePiece pieceOrStack : everythingOnMap) {
                        if (pieceOrStack instanceof Stack) {
                            if (pieceOrStack instanceof Deck) {
                                command = command.append(((Deck)pieceOrStack).maybeShuffle());
                                useFromDeck = this.getSelectFromDeck();
                                visitor.setSelectedCount(0);
                            } else {
                                useFromDeck = -1;
                            }
                            pieceList = ((Stack)pieceOrStack).asList();
                            if (pieceOrStack instanceof Deck) {
                                pieceList = new ArrayList<GamePiece>(pieceList);
                                Collections.reverse(pieceList);
                            }
                        } else {
                            pieceList = Collections.singletonList(pieceOrStack);
                            useFromDeck = -1;
                        }
                        if (useFromDeck == 0) continue;
                        block26: for (GamePiece gamePiece : pieceList) {
                            Point pt;
                            if (!this.passesPropertyFastMatch(gamePiece)) continue;
                            switch (this.target.targetType) {
                                case CURZONE: 
                                case ZONE: {
                                    if (fastZone.equals(gamePiece.getProperty("CurrentZone"))) break;
                                    continue block26;
                                }
                                case CURLOC: 
                                case LOCATION: {
                                    if (fastLocation.equals(gamePiece.getProperty("LocationName"))) break;
                                    continue block26;
                                }
                            }
                            if (this.target.targetType == GlobalCommandTarget.Target.XY && (!fastBoard.isEmpty() && !fastBoard.equals(gamePiece.getProperty("CurrentBoard")) || !fastX.equals(Integer.toString((int)(pt = new Point(gamePiece.getPosition())).getX())) || !fastY.equals(Integer.toString((int)pt.getY())))) continue;
                            dispatcher.accept(gamePiece);
                            if (useFromDeck <= 0 || visitor.getSelectedCount() < useFromDeck) continue;
                            continue block25;
                        }
                    }
                }
            }
            visitor.getTracker().repaint();
            command = visitor.getCommand();
        }
        catch (RecursionLimitException e) {
            RecursionLimiter.infiniteLoop(e);
        }
        finally {
            RecursionLimiter.endExecution();
            if (this.reportSingle) {
                Map.setChangeReportingEnabled(true);
            }
        }
        return command;
    }

    public Command apply(Map map, PieceFilter filter) {
        return this.apply(new Map[]{map}, filter);
    }

    public Command apply(Map[] maps, PieceFilter filter) {
        return this.apply(maps, filter, null);
    }

    public Command apply(Map map, PieceFilter filter, GlobalCommandTarget fastMatch) {
        return this.apply(new Map[]{map}, filter, fastMatch);
    }

    public int getSelectFromDeck() {
        return this.selectFromDeck;
    }

    public void setSelectFromDeck(int selectFromDeck) {
        this.selectFromDeck = selectFromDeck;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keyStroke == null ? 0 : this.keyStroke.hashCode());
        result = 31 * result + (this.reportFormat == null ? 0 : this.reportFormat.hashCode());
        result = 31 * result + (this.reportSingle ? 1231 : 1237);
        result = 31 * result + this.selectFromDeck;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalCommand other = (GlobalCommand)obj;
        if (this.keyStroke == null ? other.keyStroke != null : !this.keyStroke.equals(other.keyStroke)) {
            return false;
        }
        if (this.reportFormat == null ? other.reportFormat != null : !this.reportFormat.equals(other.reportFormat)) {
            return false;
        }
        if (this.reportSingle != other.reportSingle) {
            return false;
        }
        if (this.selectFromDeck != other.selectFromDeck) {
            return false;
        }
        if (this.target.fastMatchLocation != other.target.fastMatchLocation) {
            return false;
        }
        if (this.target.targetType != other.target.targetType) {
            return false;
        }
        if (!this.target.targetType.isCurrent() && !this.target.targetMap.equals(other.target.targetMap)) {
            return false;
        }
        if (this.target.targetType == GlobalCommandTarget.Target.ZONE && !this.target.targetZone.equals(other.target.targetZone)) {
            return false;
        }
        if (this.target.targetType == GlobalCommandTarget.Target.LOCATION && !this.target.targetLocation.equals(other.target.targetLocation)) {
            return false;
        }
        if (!(this.target.targetType != GlobalCommandTarget.Target.XY || this.target.targetBoard.equals(other.target.targetBoard) && this.target.targetX.equals(other.target.targetX) && this.target.targetY.equals(other.target.targetY))) {
            return false;
        }
        if (this.target.fastMatchProperty != other.target.fastMatchProperty) {
            return false;
        }
        if (this.target.fastMatchProperty) {
            if (!this.target.targetProperty.equals(other.target.targetProperty)) {
                return false;
            }
            if (!this.target.targetValue.equals(other.target.targetValue)) {
                return false;
            }
        }
        return this.selectFromDeck == other.selectFromDeck;
    }

    protected class Visitor
    implements DeckVisitor {
        private final Command command;
        private final BoundsTracker tracker;
        private final PieceFilter filter;
        private final KeyStroke stroke;
        private int selectedCount;

        public Visitor(Command command, PieceFilter filter, KeyStroke stroke) {
            this.command = command;
            this.tracker = new BoundsTracker();
            this.filter = filter;
            this.stroke = stroke;
        }

        public void setSelectedCount(int selectedCount) {
            this.selectedCount = selectedCount;
        }

        public int getSelectedCount() {
            return this.selectedCount;
        }

        @Override
        public Object visitDeck(Deck d) {
            if (GlobalCommand.this.getSelectFromDeck() != 0) {
                d.setDragCount(d.getPieceCount());
                this.selectedCount = 0;
                PieceIterator it = d.drawCards();
                while (it.hasMoreElements() && (GlobalCommand.this.getSelectFromDeck() < 0 || GlobalCommand.this.getSelectFromDeck() > this.selectedCount)) {
                    this.apply(it.nextPiece(), true);
                }
            }
            return null;
        }

        @Override
        public Object visitStack(Stack s) {
            s.asList().forEach(this::apply);
            return null;
        }

        @Override
        public Object visitDefault(GamePiece p) {
            this.apply(p);
            return null;
        }

        private void apply(GamePiece p) {
            this.apply(p, false);
        }

        private void apply(GamePiece p, boolean visitingDeck) {
            if (this.filter == null || this.filter.accept(p)) {
                if (visitingDeck) {
                    p.setProperty("obs;", p.getProperty("ObscuredPreDraw"));
                }
                this.tracker.addPiece(p);
                p.setProperty("snapshot", ((PropertyExporter)((Object)p)).getProperties());
                this.command.append(p.keyEvent(this.stroke));
                this.tracker.addPiece(p);
                ++this.selectedCount;
            } else if (visitingDeck) {
                p.setProperty("obs;", p.getProperty("ObscuredPreDraw"));
            }
        }

        public Command getCommand() {
            return this.command;
        }

        public BoundsTracker getTracker() {
            return this.tracker;
        }
    }
}

