/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.Region;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ChooseComponentDialog;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.PropertyExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Stack;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class SendToLocation
extends Decorator
implements TranslatablePiece {
    public static final String ID = "sendto;";
    private static final String _0 = "0";
    public static final String BACK_MAP = "backMap";
    public static final String BACK_POINT = "backPoint";
    protected static final String DEST_GRIDLOCATION = "G";
    protected static final String DEST_LOCATION = "L";
    protected static final String DEST_ZONE = "Z";
    protected static final String DEST_REGION = "R";
    protected static final String DEST_COUNTER = "A";
    protected static final String[] DEST_OPTIONS = new String[]{"G", "L", "Z", "R", "A"};
    protected static final String[] DEST_KEYS = new String[]{Resources.getString("Editor.SendToLocation.grid_location_on_selected_map"), Resources.getString("Editor.SendToLocation.location_on_selected_map"), Resources.getString("Editor.SendToLocation.zone_on_selected_map"), Resources.getString("Editor.SendToLocation.region_on_selected_map"), Resources.getString("Editor.SendToLocation.another_counter_selected_by_properties")};
    protected KeyCommand[] command;
    protected String commandName;
    protected String backCommandName;
    protected NamedKeyStroke key;
    protected NamedKeyStroke backKey;
    protected FormattedString mapId = new FormattedString("");
    protected FormattedString boardName = new FormattedString("");
    protected FormattedString x = new FormattedString("");
    protected FormattedString xIndex = new FormattedString("");
    protected FormattedString xOffset = new FormattedString("");
    protected FormattedString y = new FormattedString("");
    protected FormattedString yIndex = new FormattedString("");
    protected FormattedString yOffset = new FormattedString("");
    protected FormattedString gridLocation = new FormattedString("");
    protected KeyCommand sendCommand;
    protected KeyCommand backCommand;
    protected String description;
    protected String destination;
    protected FormattedString zone = new FormattedString("");
    protected FormattedString region = new FormattedString("");
    protected PropertyExpression propertyFilter = new PropertyExpression("");
    private Map map;

    public SendToLocation() {
        this(ID, null);
    }

    public SendToLocation(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.commandName = st.nextToken("");
        this.key = st.nextNamedKeyStroke(null);
        this.mapId.setFormat(st.nextToken(""));
        this.boardName.setFormat(st.nextToken(""));
        this.x.setFormat(st.nextToken(_0));
        this.y.setFormat(st.nextToken(_0));
        this.backCommandName = st.nextToken("");
        this.backKey = st.nextNamedKeyStroke(null);
        this.xIndex.setFormat(st.nextToken(_0));
        this.yIndex.setFormat(st.nextToken(_0));
        this.xOffset.setFormat(st.nextToken(_0));
        this.yOffset.setFormat(st.nextToken(_0));
        this.description = st.nextToken("");
        this.destination = st.nextToken(DEST_LOCATION.substring(0, 1));
        if (this.destination.length() == 0) {
            this.destination = DEST_LOCATION.substring(0, 1);
        }
        this.zone.setFormat(st.nextToken(""));
        this.region.setFormat(st.nextToken(""));
        this.propertyFilter.setExpression(st.nextToken(""));
        this.gridLocation.setFormat(st.nextToken(""));
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.commandName).append(this.key).append(this.mapId.getFormat()).append(this.boardName.getFormat()).append(this.x.getFormat()).append(this.y.getFormat()).append(this.backCommandName).append(this.backKey).append(this.xIndex.getFormat()).append(this.yIndex.getFormat()).append(this.xOffset.getFormat()).append(this.yOffset.getFormat()).append(this.description).append(this.destination).append(this.zone.getFormat()).append(this.region.getFormat()).append(this.propertyFilter.getExpression()).append(this.gridLocation.getFormat());
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.command == null) {
            this.sendCommand = new KeyCommand(this.commandName, this.key, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.backCommand = new KeyCommand(this.backCommandName, this.backKey, Decorator.getOutermost(this), (TranslatablePiece)this);
            ArrayList<KeyCommand> l = new ArrayList<KeyCommand>();
            if (this.commandName.length() > 0 && this.key != null && !this.key.isNull()) {
                l.add(this.sendCommand);
            }
            if (this.backCommandName.length() > 0 && this.backKey != null && !this.backKey.isNull()) {
                l.add(this.backCommand);
            }
            this.command = l.toArray(new KeyCommand[0]);
        }
        for (KeyCommand c : this.command) {
            if (c.getName().equals(this.backCommandName)) {
                c.setEnabled(this.getMap() != null && this.getProperty(BACK_MAP) != null && this.getProperty(BACK_POINT) != null);
                continue;
            }
            Point p = this.getSendLocation();
            c.setEnabled(this.getMap() != null && p != null && (this.map != this.getMap() || !p.equals(this.getPosition())));
        }
        return this.command;
    }

    private void LogBadGridLocation(Point p) {
        String s = "* " + Decorator.getOutermost(this).getName();
        s = this.getMap() == null ? s + "getMap is null" : (p == null ? s + "p is null" : s + "getMap: " + this.getMap().getMapName() + "; p: (" + p.x + "," + p.y + "; Position: (" + this.getPosition().x + "," + this.getPosition().y + "); map: " + this.map.getMapName() + ";");
        new Chatter.DisplayText(GameModule.getGameModule().getChatter(), s).execute();
    }

    @Override
    public String myGetState() {
        SequenceEncoder se = new SequenceEncoder(';');
        Map backMap = (Map)this.getProperty(BACK_MAP);
        if (backMap != null) {
            se.append(backMap.getIdentifier());
        } else {
            se.append("");
        }
        Point backPoint = (Point)this.getProperty(BACK_POINT);
        if (backPoint != null) {
            se.append(backPoint.x).append(backPoint.y);
        } else {
            se.append("").append("");
        }
        return se.getValue();
    }

    private Point getSendLocation() {
        GamePiece outer = Decorator.getOutermost(this);
        this.map = null;
        Point dest = null;
        if (this.destination.equals(DEST_COUNTER.substring(0, 1))) {
            GamePiece target = null;
            for (GamePiece piece : GameModule.getGameModule().getGameState().getAllPieces()) {
                if (piece instanceof Stack) {
                    Stack s = (Stack)piece;
                    for (GamePiece gamePiece : s.asList()) {
                        if (this.propertyFilter.accept(outer, gamePiece) && (target = gamePiece) != null) break;
                    }
                } else if (this.propertyFilter.accept(outer, piece)) {
                    target = piece;
                }
                if (target == null) continue;
                break;
            }
            if (target != null) {
                this.map = target.getMap();
                if (this.map != null) {
                    dest = target.getPosition();
                }
            }
        } else {
            this.map = Map.getMapById(this.mapId.getText(outer));
            if (this.map == null) {
                this.map = this.getMap();
            }
            if (this.map != null) {
                switch (this.destination.charAt(0)) {
                    case 'G': {
                        Board b = this.map.getBoardByName(this.boardName.getText(outer));
                        if (b == null) break;
                        try {
                            MapGrid g = b.getGrid();
                            if (g != null) {
                                dest = g.getLocation(this.gridLocation.getText(outer));
                                if (dest == null) break;
                                dest.translate(b.bounds().x, b.bounds().y);
                                break;
                            }
                            SendToLocation.reportDataError(this, Resources.getString("Error.no_grid_assigned"), this.map.getMapName());
                        }
                        catch (MapGrid.BadCoords e) {
                            this.LogBadGridLocation(dest);
                            SendToLocation.reportDataError(this, Resources.getString("Error.not_found", Resources.getString("Editor.SendToLocation.grid_location")), this.map.getMapName());
                        }
                        break;
                    }
                    case 'L': {
                        int xValue = this.x.getTextAsInt((PropertySource)outer, Resources.getString("Editor.x_position"), this);
                        int yValue = this.y.getTextAsInt((PropertySource)outer, Resources.getString("Editor.y_position"), this);
                        dest = new Point(xValue, yValue);
                        Board b = this.map.getBoardByName(this.boardName.getText(outer));
                        if (b == null) break;
                        dest.translate(b.bounds().x, b.bounds().y);
                        break;
                    }
                    case 'Z': {
                        String zoneName = this.zone.getText(outer);
                        Zone z = this.map.findZone(zoneName);
                        if (z == null) {
                            SendToLocation.reportDataError(this, Resources.getString("Error.not_found", "Zone"), this.zone.debugInfo(zoneName, "Zone"));
                            break;
                        }
                        Rectangle r = z.getBounds();
                        Rectangle r2 = z.getBoard().bounds();
                        dest = new Point(r2.x + r.x + r.width / 2, r2.y + r.y + r.height / 2);
                        break;
                    }
                    case 'R': {
                        String regionName = this.region.getText(outer);
                        Region r = this.map.findRegion(regionName);
                        if (r == null) {
                            SendToLocation.reportDataError(this, Resources.getString("Error.not_found", "Region"), this.region.debugInfo(regionName, "Region"));
                            break;
                        }
                        Rectangle r2 = r.getBoard().bounds();
                        dest = new Point(r.getOrigin().x + r2.x, r.getOrigin().y + r2.y);
                    }
                }
            }
        }
        if (dest != null && this.destination.charAt(0) != 'G') {
            dest = this.offsetDestination(dest.x, dest.y, outer);
        }
        return dest;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        Command c = null;
        this.myGetKeyCommands();
        if (this.sendCommand.matches(stroke)) {
            GamePiece outer = Decorator.getOutermost(this);
            Stack parent = outer.getParent();
            Point dest = this.getSendLocation();
            if (this.map != null && dest != null) {
                if (this.map == this.getMap() && dest.equals(this.getPosition())) {
                    return null;
                }
                ChangeTracker tracker = new ChangeTracker(this);
                this.setProperty(BACK_MAP, this.getMap());
                this.setProperty(BACK_POINT, this.getPosition());
                if (Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue("stlMovementTrails"))) {
                    outer.setProperty("Moved", Boolean.TRUE);
                }
                c = tracker.getChangeCommand();
                c = c.append(SendToLocation.putOldProperties(this));
                if (!Boolean.TRUE.equals(outer.getProperty("IgnoreGrid"))) {
                    dest = this.map.snapTo(dest);
                }
                c = c.append(this.map.placeOrMerge(outer, dest));
                if (this.map.getMoveKey() != null) {
                    c = c.append(outer.keyEvent(this.map.getMoveKey()));
                }
                if (parent != null) {
                    c = c.append(parent.pieceRemoved(outer));
                }
            }
        } else if (this.backCommand.matches(stroke)) {
            GamePiece outer = Decorator.getOutermost(this);
            Map backMap = (Map)this.getProperty(BACK_MAP);
            Point backPoint = (Point)this.getProperty(BACK_POINT);
            ChangeTracker tracker = new ChangeTracker(this);
            this.setProperty(BACK_MAP, null);
            this.setProperty(BACK_POINT, null);
            if (Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue("stlMovementTrails"))) {
                outer.setProperty("Moved", Boolean.TRUE);
            }
            c = tracker.getChangeCommand();
            if (backMap != null && backPoint != null) {
                c = c.append(SendToLocation.putOldProperties(this));
                c = c.append(backMap.placeOrMerge(outer, backPoint));
                if (backMap.getMoveKey() != null) {
                    c = c.append(outer.keyEvent(backMap.getMoveKey()));
                }
            }
        }
        return c;
    }

    protected Point offsetDestination(int x, int y, GamePiece outer) {
        int xPos = x + this.parse("xIndex", this.xIndex, outer) * this.parse("xOffset", this.xOffset, outer);
        int yPos = y + this.parse("yIndex", this.yIndex, outer) * this.parse("yOffset", this.yOffset, outer);
        return new Point(xPos, yPos);
    }

    private int parse(String desc, FormattedString s, GamePiece outer) {
        int i = 0;
        String val = s.getText((PropertySource)outer, _0);
        try {
            i = Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            SendToLocation.reportDataError(this, Resources.getString("Error.non_number_error"), s.debugInfo(val, desc), e);
        }
        return i;
    }

    @Override
    public void mySetState(String newState) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(newState, ';');
        String mapId = st.nextToken("");
        if (mapId.length() > 0) {
            this.setProperty(BACK_MAP, Map.getMapById(mapId));
        }
        String x = st.nextToken("");
        String y = st.nextToken("");
        if (x.length() > 0 && y.length() > 0) {
            try {
                this.setProperty(BACK_POINT, new Point(Integer.parseInt(x), Integer.parseInt(y)));
            }
            catch (NumberFormatException e) {
                SendToLocation.reportDataError(this, Resources.getString("Error.non_number_error"), "Back Point=(" + x + "," + y + ")", e);
            }
        }
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public String getDescription() {
        Object d = Resources.getString("Editor.SendToLocation.trait_description");
        if (this.description.length() > 0) {
            d = (String)d + " - " + this.description;
        }
        return d;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("SendToLocation.html");
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(new String[]{this.commandName, this.backCommandName}, new String[]{this.getCommandDescription(this.description, Resources.getString("Editor.SendToLocation.send_command_description")), this.getCommandDescription(this.description, Resources.getString("Editor.SendToLocation.back_command_description"))});
    }

    @Override
    public boolean testEquals(Object o) {
        String id2;
        if (!(o instanceof SendToLocation)) {
            return false;
        }
        SendToLocation c = (SendToLocation)o;
        if (!Objects.equals(this.commandName, c.commandName)) {
            return false;
        }
        if (!Objects.equals(this.key, c.key)) {
            return false;
        }
        if (!Objects.equals(this.mapId, c.mapId)) {
            return false;
        }
        if (!Objects.equals(this.boardName, c.boardName)) {
            return false;
        }
        if (!Objects.equals(this.x, c.x)) {
            return false;
        }
        if (!Objects.equals(this.y, c.y)) {
            return false;
        }
        if (!Objects.equals(this.backCommandName, c.backCommandName)) {
            return false;
        }
        if (!Objects.equals(this.backKey, c.backKey)) {
            return false;
        }
        if (!Objects.equals(this.xIndex, c.xIndex)) {
            return false;
        }
        if (!Objects.equals(this.yIndex, c.yIndex)) {
            return false;
        }
        if (!Objects.equals(this.xOffset, c.xOffset)) {
            return false;
        }
        if (!Objects.equals(this.yOffset, c.yOffset)) {
            return false;
        }
        if (!Objects.equals(this.description, c.description)) {
            return false;
        }
        if (!Objects.equals(this.destination, c.destination)) {
            return false;
        }
        if (!Objects.equals(this.zone, c.zone)) {
            return false;
        }
        if (!Objects.equals(this.region, c.region)) {
            return false;
        }
        if (!Objects.equals(this.propertyFilter, c.propertyFilter)) {
            return false;
        }
        if (!Objects.equals(this.gridLocation, c.gridLocation)) {
            return false;
        }
        Map backMap = (Map)this.getProperty(BACK_MAP);
        String id1 = backMap == null ? "" : backMap.getIdentifier();
        Map backMapc = (Map)c.getProperty(BACK_MAP);
        String string = id2 = backMapc == null ? "" : backMapc.getIdentifier();
        if (!Objects.equals(id1, id2)) {
            return false;
        }
        Point bp1 = (Point)this.getProperty(BACK_POINT);
        Point bp2 = (Point)c.getProperty(BACK_POINT);
        return Objects.equals(bp1, bp2);
    }

    @Override
    public List<String> getExpressionList() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.destination.equals(DEST_COUNTER.substring(0, 1))) {
            l.add(this.propertyFilter.getExpression());
        } else {
            l.add(this.mapId.getFormat());
            switch (this.destination.charAt(0)) {
                case 'G': {
                    l.add(this.boardName.getFormat());
                    l.add(this.gridLocation.getFormat());
                    break;
                }
                case 'L': {
                    l.add(this.boardName.getFormat());
                    l.add(this.x.getFormat());
                    l.add(this.y.getFormat());
                    break;
                }
                case 'Z': {
                    l.add(this.zone.getFormat());
                    break;
                }
                case 'R': {
                    l.add(this.region.getFormat());
                }
            }
        }
        return l;
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Collections.singletonList(this.key);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.commandName);
    }

    public static class Ed
    implements PieceEditor {
        protected StringConfigurer nameInput;
        protected StringConfigurer backNameInput;
        protected NamedHotKeyConfigurer keyInput;
        protected NamedHotKeyConfigurer backKeyInput;
        protected FormattedStringConfigurer mapIdInput;
        protected FormattedStringConfigurer boardNameInput;
        protected JLabel xInputLabel;
        protected FormattedStringConfigurer xInput;
        protected JLabel yInputLabel;
        protected FormattedStringConfigurer yInput;
        @Deprecated(since="2020-12-11", forRemoval=true)
        protected JLabel advancedLabel;
        @Deprecated(since="2020-12-11", forRemoval=true)
        protected BooleanConfigurer advancedInput;
        protected JLabel xAdvancedLabel;
        protected JLabel yAdvancedLabel;
        protected FormattedStringConfigurer xIndexInput;
        protected FormattedStringConfigurer xOffsetInput;
        protected FormattedStringConfigurer yIndexInput;
        protected FormattedStringConfigurer yOffsetInput;
        protected StringConfigurer descInput;
        protected StringEnumConfigurer destInput;
        protected TranslatingStringEnumConfigurer newDestInput;
        protected JLabel propertyLabel;
        protected PropertyExpressionConfigurer propertyInput;
        protected JLabel zoneLabel;
        protected FormattedStringConfigurer zoneInput;
        protected JLabel regionLabel;
        protected FormattedStringConfigurer regionInput;
        protected TraitConfigPanel controls = new TraitConfigPanel();
        protected JLabel mapLabel;
        protected JPanel mapControls;
        protected JLabel boardLabel;
        protected JPanel boardControls;
        protected JPanel advancedControls;
        protected JPanel yAdvancedControls;
        protected JLabel gridLabel;
        protected StringConfigurer gridLocationInput;

        public Ed(SendToLocation p) {
            this.descInput = new StringConfigurer(p.description);
            this.descInput.setHintKey("Editor.description_hint");
            this.controls.add("Editor.description_label", (Configurer)this.descInput);
            this.nameInput = new StringConfigurer(p.commandName);
            this.nameInput.setHintKey("Editor.menu_command_hint");
            this.controls.add("Editor.menu_command", (Configurer)this.nameInput);
            this.keyInput = new NamedHotKeyConfigurer(p.key);
            this.controls.add("Editor.keyboard_command", (Configurer)this.keyInput);
            this.backNameInput = new StringConfigurer(p.backCommandName);
            this.backNameInput.setHintKey("Editor.menu_command_hint");
            this.controls.add("Editor.SendToLocation.send_back_command_name", (Configurer)this.backNameInput);
            this.backKeyInput = new NamedHotKeyConfigurer(p.backKey);
            this.controls.add("Editor.SendToLocation.send_back_keyboard_command", (Configurer)this.backKeyInput);
            this.newDestInput = new TranslatingStringEnumConfigurer(DEST_OPTIONS, DEST_KEYS);
            this.newDestInput.setValue(SendToLocation.DEST_LOCATION);
            for (String destOption : DEST_OPTIONS) {
                if (!destOption.substring(0, 1).equals(p.destination)) continue;
                this.newDestInput.setValue(destOption);
            }
            this.newDestInput.addPropertyChangeListener(arg0 -> this.updateVisibility());
            this.controls.add("Editor.SendToLocation.destination", (Configurer)this.newDestInput);
            this.mapLabel = new JLabel(Resources.getString("Editor.SendToLocation.map"));
            this.mapControls = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow,fill]rel[]rel[]"));
            JPanel mapPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow]", "push[]push"));
            this.mapIdInput = new FormattedExpressionConfigurer(p.mapId.getFormat(), p);
            this.mapIdInput.setHintKey("Editor.SendToLocation.map_hint");
            mapPanel.add(this.mapIdInput.getControls(), "grow");
            this.mapControls.add((Component)mapPanel, "grow");
            JButton select = new JButton(Resources.getString("Editor.select"));
            select.addActionListener(e -> this.selectMap());
            this.mapControls.add(select);
            JButton clear = new JButton(Resources.getString("Editor.clear"));
            clear.addActionListener(e -> this.clearMap());
            this.mapControls.add(clear);
            this.controls.add(this.mapLabel, this.mapControls);
            this.boardLabel = new JLabel(Resources.getString("Editor.SendToLocation.board"));
            this.boardControls = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow,fill]rel[]rel[]"));
            this.boardNameInput = new FormattedExpressionConfigurer(p.boardName.getFormat(), p);
            this.boardNameInput.setHintKey("Editor.SendToLocation.board_hint");
            JPanel boardPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow]", "push[]push"));
            boardPanel.add(this.boardNameInput.getControls(), "grow");
            this.boardControls.add((Component)boardPanel, "grow");
            select = new JButton(Resources.getString("Editor.select"));
            select.addActionListener(e -> this.selectBoard());
            clear = new JButton(Resources.getString("Editor.clear"));
            clear.addActionListener(e -> this.clearBoard());
            this.boardControls.add(select);
            this.boardControls.add(clear);
            this.controls.add(this.boardLabel, this.boardControls);
            this.xInputLabel = new JLabel(Resources.getString("Editor.x_position"));
            this.xInput = new FormattedExpressionConfigurer(p.x.getFormat(), p);
            this.controls.add(this.xInputLabel, (Configurer)this.xInput);
            this.yInputLabel = new JLabel(Resources.getString("Editor.y_position"));
            this.yInput = new FormattedExpressionConfigurer(p.y.getFormat(), p);
            this.controls.add(this.yInputLabel, (Configurer)this.yInput);
            this.zoneLabel = new JLabel(Resources.getString("Editor.SendToLocation.zone_name"));
            this.zoneInput = new FormattedExpressionConfigurer(p.zone.getFormat(), p);
            this.zoneInput.setHintKey("Editor.SendToLocation.zone_hint");
            this.controls.add(this.zoneLabel, (Configurer)this.zoneInput);
            this.regionLabel = new JLabel(Resources.getString("Editor.SendToLocation.region_name"));
            this.regionInput = new FormattedExpressionConfigurer(p.region.getFormat(), p);
            this.regionInput.setHintKey("Editor.SendToLocation.region_hint");
            this.controls.add(this.regionLabel, (Configurer)this.regionInput);
            this.propertyLabel = new JLabel(Resources.getString("Editor.property_match_label"));
            this.propertyInput = new PropertyExpressionConfigurer(p.propertyFilter);
            this.controls.add(this.propertyLabel, (Configurer)this.propertyInput);
            this.gridLabel = new JLabel(Resources.getString("Editor.SendToLocation.grid_location"));
            this.gridLocationInput = new StringConfigurer(p.gridLocation.getFormat());
            this.gridLocationInput.setHintKey("Editor.SendToLocation.grid_location_hint");
            this.controls.add(this.gridLabel, (Configurer)this.gridLocationInput);
            this.xAdvancedLabel = new JLabel(Resources.getString("Editor.SendToLocation.additional_x_offset"));
            this.advancedControls = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow,fill]rel[]rel[grow,fill]"));
            this.xIndexInput = new FormattedExpressionConfigurer(p.xIndex.getFormat(), p);
            this.advancedControls.add(this.xIndexInput.getControls(), "grow");
            this.advancedControls.add(new JLabel(Resources.getString("Editor.SendToLocation.times")));
            this.xOffsetInput = new FormattedExpressionConfigurer(p.xOffset.getFormat(), p);
            this.advancedControls.add(this.xOffsetInput.getControls(), "grow");
            this.controls.add(this.xAdvancedLabel, this.advancedControls);
            this.yAdvancedLabel = new JLabel(Resources.getString("Editor.SendToLocation.additional_y_offset"));
            this.yAdvancedControls = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow,fill]rel[]rel[grow,fill]"));
            this.yIndexInput = new FormattedExpressionConfigurer(p.yIndex.getFormat(), p);
            this.yAdvancedControls.add(this.yIndexInput.getControls(), "grow");
            this.yAdvancedControls.add(new JLabel(Resources.getString("Editor.SendToLocation.times")));
            this.yOffsetInput = new FormattedExpressionConfigurer(p.yOffset.getFormat(), p);
            this.yAdvancedControls.add(this.yOffsetInput.getControls(), "grow");
            this.controls.add(this.yAdvancedLabel, this.yAdvancedControls);
            this.updateVisibility();
        }

        private void updateVisibility() {
            String destOption = this.newDestInput.getValueString();
            this.xInput.getControls().setVisible(destOption.equals(SendToLocation.DEST_LOCATION));
            this.xInputLabel.setVisible(destOption.equals(SendToLocation.DEST_LOCATION));
            this.yInput.getControls().setVisible(destOption.equals(SendToLocation.DEST_LOCATION));
            this.yInputLabel.setVisible(destOption.equals(SendToLocation.DEST_LOCATION));
            this.mapControls.setVisible(!destOption.equals(SendToLocation.DEST_COUNTER));
            this.mapLabel.setVisible(!destOption.equals(SendToLocation.DEST_COUNTER));
            this.boardControls.setVisible(destOption.equals(SendToLocation.DEST_LOCATION) || destOption.equals(SendToLocation.DEST_GRIDLOCATION));
            this.boardLabel.setVisible(destOption.equals(SendToLocation.DEST_LOCATION) || destOption.equals(SendToLocation.DEST_GRIDLOCATION));
            this.zoneInput.getControls().setVisible(destOption.equals(SendToLocation.DEST_ZONE));
            this.zoneLabel.setVisible(destOption.equals(SendToLocation.DEST_ZONE));
            this.regionInput.getControls().setVisible(destOption.equals(SendToLocation.DEST_REGION));
            this.regionLabel.setVisible(destOption.equals(SendToLocation.DEST_REGION));
            this.propertyInput.getControls().setVisible(destOption.equals(SendToLocation.DEST_COUNTER));
            this.propertyLabel.setVisible(destOption.equals(SendToLocation.DEST_COUNTER));
            this.gridLocationInput.getControls().setVisible(destOption.equals(SendToLocation.DEST_GRIDLOCATION));
            this.gridLabel.setVisible(destOption.equals(SendToLocation.DEST_GRIDLOCATION));
            Decorator.repack(this.controls);
        }

        private void clearBoard() {
            this.boardNameInput.setValue("");
        }

        private void clearMap() {
            this.mapIdInput.setValue("");
        }

        private void selectBoard() {
            ChooseComponentDialog d = new ChooseComponentDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.controls), Board.class);
            d.setVisible(true);
            if (d.getTarget() != null) {
                Board b = (Board)d.getTarget();
                this.boardNameInput.setValue(b.getName());
            }
        }

        private void selectMap() {
            ChooseComponentDialog d = new ChooseComponentDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.controls), Map.class);
            d.setVisible(true);
            if (d.getTarget() != null) {
                Map map = (Map)d.getTarget();
                this.mapIdInput.setValue(map.getMapName());
            }
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.nameInput.getValueString()).append(this.keyInput.getValueString()).append(this.mapIdInput.getValueString()).append(this.boardNameInput.getValueString()).append(this.xInput.getValueString()).append(this.yInput.getValueString()).append(this.backNameInput.getValueString()).append(this.backKeyInput.getValueString()).append(this.xIndexInput.getValueString()).append(this.yIndexInput.getValueString()).append(this.xOffsetInput.getValueString()).append(this.yOffsetInput.getValueString()).append(this.descInput.getValueString()).append(this.newDestInput.getValueString().charAt(0)).append(this.zoneInput.getValueString()).append(this.regionInput.getValueString()).append(this.propertyInput.getValueString()).append(this.gridLocationInput.getValueString());
            return SendToLocation.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

