/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.KeyCommandSubMenu;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.KeyStroke;

public class SubMenu
extends Decorator
implements TranslatablePiece {
    public static final String ID = "submenu;";
    private String subMenu;
    private KeyCommandSubMenu keyCommandSubMenu;
    private final KeyCommand[] keyCommands = new KeyCommand[1];
    private static final String DEFAULT_MENU_NAME = Resources.getString("Editor.SubMenu.default_menu_name");
    private String description = "";

    public SubMenu() {
        this(ID + Resources.getString("Editor.SubMenu.default_menu_name") + ";", null);
    }

    public SubMenu(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.SubMenu.trait_description", DEFAULT_MENU_NAME.equals(this.subMenu) ? "" : this.subMenu, this.description);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("SubMenu.html");
    }

    @Override
    public PieceEditor getEditor() {
        return new Editor(this);
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.subMenu = st.nextToken();
        this.keyCommandSubMenu = new KeyCommandSubMenu(this.subMenu, this, this);
        this.keyCommandSubMenu.setCommands(StringArrayConfigurer.stringToArray(st.nextToken()));
        this.description = st.nextToken("");
        this.keyCommands[0] = this.keyCommandSubMenu;
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return this.keyCommands;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.getMenuName()).append(StringArrayConfigurer.arrayToString(this.getSubcommands())).append(this.description);
        return ID + se.getValue();
    }

    public String[] getSubcommands() {
        ArrayList<String> l = new ArrayList<String>();
        Iterator<String> i = this.keyCommandSubMenu.getCommands();
        while (i.hasNext()) {
            l.add(i.next());
        }
        return l.toArray(new String[0]);
    }

    public String getMenuName() {
        return this.subMenu;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Rectangle boundingBox() {
        return this.getInner().boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.getInner().draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.getInner().getName();
    }

    @Override
    public Shape getShape() {
        return this.getInner().getShape();
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.getMenuName(), Resources.getString("Editor.SubMenu.sub_menu.name"));
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof SubMenu)) {
            return false;
        }
        SubMenu c = (SubMenu)o;
        if (!Objects.equals(this.subMenu, c.subMenu)) {
            return false;
        }
        return Objects.equals(StringArrayConfigurer.arrayToString(this.getSubcommands()), StringArrayConfigurer.arrayToString(c.getSubcommands()));
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.subMenu);
    }

    public static class Editor
    implements PieceEditor {
        private final StringConfigurer nameConfig;
        private final StringArrayConfigurer commandsConfig;
        private final TraitConfigPanel panel = new TraitConfigPanel();
        private final StringConfigurer descConfig;

        public Editor(SubMenu p) {
            this.descConfig = new StringConfigurer(p.description);
            this.descConfig.setHintKey("Editor.description_hint");
            this.panel.add("Editor.description_label", (Configurer)this.descConfig);
            this.nameConfig = new StringConfigurer(p.getMenuName());
            this.nameConfig.setHintKey("Editor.menu_command_hint");
            this.panel.add("Editor.SubMenu.menu_name", (Configurer)this.nameConfig);
            this.commandsConfig = new StringArrayConfigurer(p.getSubcommands());
            this.commandsConfig.setHintKey("Editor.menu_command_hint");
            this.panel.add("Editor.SubMenu.sub_commands", (Configurer)this.commandsConfig);
        }

        @Override
        public Component getControls() {
            return this.panel;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.nameConfig.getValueString()).append(this.commandsConfig.getValueString()).append(this.descConfig.getValueString());
            return SubMenu.ID + se.getValue();
        }
    }
}

