/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.PrototypeDefinition;
import VASSAL.build.module.PrototypesContainer;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.swing.KeyStroke;

public class UsePrototype
extends Decorator
implements EditablePiece,
RecursionLimiter.Loopable {
    public static final String ID = "prototype;";
    private String prototypeName;
    private String lastCachedPrototype;
    private GamePiece prototype;
    private PropertySource properties;
    private String type;

    public UsePrototype() {
        this(ID, null);
    }

    public UsePrototype(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.UsePrototype.trait_description", this.prototypeName);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("UsePrototype.html");
    }

    @Override
    public void mySetType(String type) {
        this.type = type;
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type.substring(ID.length()), ';');
        this.prototypeName = st.nextToken("");
        if (st.hasMoreTokens()) {
            final Properties p = new Properties();
            SequenceEncoder.Decoder st2 = new SequenceEncoder.Decoder(st.nextToken(), ',');
            while (st2.hasMoreTokens()) {
                SequenceEncoder.Decoder st3 = new SequenceEncoder.Decoder(st2.nextToken(), '=');
                if (!st3.hasMoreTokens()) continue;
                String key = st3.nextToken();
                if (!st3.hasMoreTokens()) continue;
                String value = st3.nextToken();
                p.setProperty(key, value);
            }
            this.properties = new PropertySource(){

                @Override
                public Object getProperty(Object key) {
                    return p.getProperty(String.valueOf(key));
                }

                @Override
                public Object getLocalizedProperty(Object key) {
                    return this.getProperty(key);
                }
            };
        }
        this.lastCachedPrototype = null;
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return KeyCommand.NONE;
    }

    @Override
    protected KeyCommand[] getKeyCommands() {
        return (KeyCommand[])this.getExpandedInner().getProperty("KeyCommands");
    }

    @Override
    public void setInner(GamePiece p) {
        super.setInner(p);
        this.lastCachedPrototype = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildPrototype() {
        PrototypeDefinition def = PrototypesContainer.getPrototype(this.prototypeName);
        if (def != null) {
            GamePiece expandedPrototype = def.getPiece(this.properties);
            String type = expandedPrototype.getType();
            if (!type.equals(this.lastCachedPrototype)) {
                this.lastCachedPrototype = type.intern();
                try {
                    RecursionLimiter.startExecution(this);
                    this.prototype = PieceCloner.getInstance().clonePiece(expandedPrototype);
                    Decorator outer = (Decorator)Decorator.getInnermost(this.prototype).getProperty("Outer");
                    if (outer != null) {
                        outer.setInner(this.piece);
                        this.prototype.setProperty("Outer", this);
                    }
                    this.prototype = null;
                }
                catch (RecursionLimitException e) {
                    RecursionLimiter.infiniteLoop(e);
                    this.prototype = null;
                }
                finally {
                    RecursionLimiter.endExecution();
                }
            }
        } else {
            this.prototype = null;
        }
    }

    public GamePiece getExpandedInner() {
        this.buildPrototype();
        return this.prototype != null ? this.prototype : this.piece;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        return this.type;
    }

    @Override
    public Command keyEvent(KeyStroke stroke) {
        return this.getExpandedInner().keyEvent(stroke);
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Rectangle boundingBox() {
        return this.getExpandedInner().boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.getExpandedInner().draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.getExpandedInner().getName();
    }

    @Override
    public Shape getShape() {
        return this.getExpandedInner().getShape();
    }

    public String getPrototypeName() {
        return this.prototypeName;
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof UsePrototype)) {
            return false;
        }
        UsePrototype c = (UsePrototype)o;
        return Objects.equals(this.prototypeName, c.prototypeName);
    }

    @Override
    public PieceEditor getEditor() {
        return new Editor(this);
    }

    @Override
    public String getComponentName() {
        return this.piece.getName();
    }

    @Override
    public String getComponentTypeName() {
        return this.getDescription();
    }

    @Override
    public List<String> getPropertyList() {
        return List.of(this.prototypeName);
    }

    public static class Editor
    implements PieceEditor {
        private final TraitConfigPanel controls = new TraitConfigPanel();
        private final StringConfigurer nameConfig;

        public Editor(UsePrototype up) {
            this.nameConfig = new StringConfigurer(up.type.substring(UsePrototype.ID.length()));
            this.controls.add("Editor.UsePrototype.prototype_name", (Configurer)this.nameConfig);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            return UsePrototype.ID + this.nameConfig.getValueString();
        }
    }
}

