/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import VASSAL.Info;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.ShowHelpAction;
import VASSAL.i18n.LocaleConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.i18n.Translatable;
import VASSAL.i18n.TranslateWindow;
import VASSAL.i18n.Translation;
import VASSAL.i18n.VassalTranslation;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.ExtensionFileFilter;
import VASSAL.tools.filechooser.FileChooser;
import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class TranslateVassalWindow
extends TranslateWindow {
    private static final long serialVersionUID = 1L;
    protected LocaleConfigurer localeConfig;
    protected FileChooser fileChooser;

    public TranslateVassalWindow(Frame owner, boolean modal, Translatable target, ConfigureTree tree) {
        super(owner, modal, target, tree);
    }

    public TranslateVassalWindow(Frame owner) {
        super(owner, false, new VassalTranslation(), null);
        this.currentTranslation = (Translation)this.target;
        this.keyTable.setEnabled(true);
        this.newTranslation();
    }

    protected FileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = FileChooser.createFileChooser(this, null);
        } else {
            this.fileChooser.resetChoosableFileFilters();
            this.fileChooser.rescanCurrentDirectory();
        }
        return this.fileChooser;
    }

    @Override
    protected Component buildMainPanel() {
        JSplitPane pane = (JSplitPane)super.buildMainPanel();
        return pane.getBottomComponent();
    }

    @Override
    protected Component getHeaderPanel() {
        JPanel headPanel = new JPanel();
        this.localeConfig = new LocaleConfigurer(null, "", new Locale(Locale.getDefault().getLanguage()));
        this.localeConfig.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Locale l = TranslateVassalWindow.this.localeConfig.getValueLocale();
                if (!Resources.getSupportedLocales().contains(l)) {
                    l = new Locale(l.getLanguage());
                }
                if (Resources.getSupportedLocales().contains(l)) {
                    String filename = "VASSAL_" + l + ".properties";
                    InputStream is = this.getClass().getResourceAsStream(filename);
                    if (is != null) {
                        try (BufferedInputStream in = new BufferedInputStream(is);){
                            ((VassalTranslation)TranslateVassalWindow.this.target).loadProperties(in);
                            ((TranslateWindow.MyTableModel)TranslateVassalWindow.this.keyTable.getModel()).fireTableDataChanged();
                        }
                        catch (IOException e) {
                            ReadErrorDialog.error(e, filename);
                        }
                    }
                } else {
                    ((VassalTranslation)TranslateVassalWindow.this.target).clearProperties();
                    ((TranslateWindow.MyTableModel)TranslateVassalWindow.this.keyTable.getModel()).fireTableDataChanged();
                }
            }
        });
        headPanel.add(this.localeConfig.getControls());
        return headPanel;
    }

    @Override
    protected Component getButtonPanel() {
        JPanel buttonBox = new JPanel();
        JButton helpButton = new JButton(Resources.getString("General.help"));
        helpButton.addActionListener(new ShowHelpAction(HelpFile.getReferenceManualPage("Translations.html", "application").getContents(), null));
        JButton loadButton = new JButton(Resources.getString("General.load"));
        loadButton.addActionListener(e -> this.loadTranslation());
        buttonBox.add(helpButton);
        buttonBox.add(loadButton);
        JButton okButton = new JButton(Resources.getString("General.save"));
        okButton.addActionListener(e -> {
            try {
                this.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        buttonBox.add(okButton);
        JButton cancelButton = new JButton(Resources.getString("General.cancel"));
        cancelButton.addActionListener(e -> this.cancel());
        buttonBox.add(cancelButton);
        return buttonBox;
    }

    protected void newTranslation() {
        ((VassalTranslation)this.target).clearProperties();
        ArrayList<String> keyList = new ArrayList<String>(Resources.getVassalKeys());
        Collections.sort(keyList);
        this.keys = keyList.toArray(new String[0]);
        this.copyButtons = new TranslateWindow.CopyButton[this.keys.length];
        ((TranslateWindow.MyTableModel)this.keyTable.getModel()).update();
    }

    protected void loadTranslation() {
        if (this.currentTranslation.isDirty()) {
            try {
                if (!this.querySave()) {
                    return;
                }
            }
            catch (IOException e) {
                ReadErrorDialog.error(e, this.currentTranslation.getBundleFileName());
                return;
            }
        }
        FileChooser fc = this.getFileChooser();
        fc.setFileFilter(new ExtensionFileFilter(Resources.getString("Editor.TranslateVassalWindow.property_files"), new String[]{".properties"}));
        fc.setCurrentDirectory(Info.getConfDir());
        if (fc.showOpenDialog(this) != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        if (!file.getName().endsWith(".properties")) {
            this.loadError(Resources.getString("Editor.TranslateVassalWindow.must_end_in"));
            return;
        }
        String language = file.getName().substring(7, 9);
        String country = "";
        if (file.getName().charAt(9) == '_') {
            country = file.getName().substring(10, 12);
        }
        Locale locale = new Locale(language, country);
        this.localeConfig.setValue(locale);
        try (InputStream fin = Files.newInputStream(file.toPath(), new OpenOption[0]);
             BufferedInputStream in = new BufferedInputStream(fin);){
            ((VassalTranslation)this.target).loadProperties(in);
        }
        catch (IOException e) {
            ReadErrorDialog.error(e, file);
        }
        ((TranslateWindow.MyTableModel)this.keyTable.getModel()).fireTableDataChanged();
    }

    protected void loadError(String mess) {
        JOptionPane.showMessageDialog(this, mess, Resources.getString("Editor.TranslateVassalWindow.invalid"), 0);
    }

    @Override
    protected boolean saveTranslation() {
        FileChooser fc = this.getFileChooser();
        Locale l = this.localeConfig.getValueLocale();
        String bundle = "VASSAL_" + l.getLanguage();
        if (l.getCountry() != null && l.getCountry().length() > 0) {
            bundle = bundle + "_" + l.getCountry();
        }
        bundle = bundle + ".properties";
        fc.setSelectedFile(new File(Info.getConfDir(), bundle));
        if (fc.showSaveDialog(this) != 0) {
            return false;
        }
        File outputFile = fc.getSelectedFile();
        try {
            ((VassalTranslation)this.target).saveProperties(outputFile, this.localeConfig.getValueLocale());
        }
        catch (IOException e) {
            WriteErrorDialog.error(e, outputFile);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            TranslateVassalWindow w = new TranslateVassalWindow(null);
            w.setVisible(true);
        });
    }
}

