/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.ExtensionsManager;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.ExtensionMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.build.module.metadata.SaveMetaData;
import VASSAL.chat.CgiServerStatus;
import VASSAL.chat.ui.ServerStatusView;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.ShowHelpAction;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.launch.AboutVASSALAction;
import VASSAL.launch.AbstractLaunchAction;
import VASSAL.launch.Editor;
import VASSAL.launch.LaunchRequest;
import VASSAL.launch.LaunchTourAction;
import VASSAL.launch.ModuleManager;
import VASSAL.launch.Player;
import VASSAL.preferences.PositionOption;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ApplicationIcons;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.ModuleExtensionFileFilter;
import VASSAL.tools.logging.LogPane;
import VASSAL.tools.menu.CheckBoxMenuItemProxy;
import VASSAL.tools.menu.MenuBarProxy;
import VASSAL.tools.menu.MenuItemProxy;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.menu.MenuProxy;
import VASSAL.tools.swing.Dialogs;
import VASSAL.tools.swing.SplitPane;
import VASSAL.tools.swing.SwingUtils;
import VASSAL.tools.version.UpdateCheckAction;
import VASSAL.tools.version.VersionUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleManagerWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ModuleManagerWindow.class);
    private static final String SHOW_STATUS_KEY = "showServerStatus";
    private static final String DIVIDER_LOCATION_KEY = "moduleManagerDividerLocation";
    private static final String DEVELOPER_INFO_KEY = "moduleManagerDeveloperInfo";
    private static final String COLUMN_WIDTHS_KEY = "moduleManagerColumnWidths";
    private static final int COLUMNS = 5;
    private static final int KEY_COLUMN = 0;
    private static final int VERSION_COLUMN = 1;
    private static final int SPARE_COLUMN = 2;
    private static final int VASSAL_COLUMN = 3;
    private static final int SAVED_COLUMN = 4;
    private static final String[] columnHeadings = new String[5];
    private static final TableColumn[] columns = new TableColumn[5];
    private final ImageIcon moduleIcon;
    private final ImageIcon activeExtensionIcon;
    private final ImageIcon inactiveExtensionIcon;
    private final ImageIcon openGameFolderIcon;
    private final ImageIcon closedGameFolderIcon;
    private final ImageIcon fileIcon;
    private StringArrayConfigurer recentModuleConfig;
    private StringArrayConfigurer moduleConfig;
    private File selectedModule;
    private final CardLayout modulePanelLayout;
    private final JPanel moduleView;
    private final SplitPane splitPane;
    private MyTreeNode rootNode;
    private MyTree tree;
    private MyTreeTableModel treeModel;
    protected MyTreeNode selectedNode;
    private long lastExpansionTime;
    private TreePath lastExpansionPath;
    private final IntConfigurer dividerLocationConfig;
    private static final long doubleClickInterval;
    private static final ModuleManagerWindow instance;

    public static ModuleManagerWindow getInstance() {
        return instance;
    }

    public ModuleManagerWindow() {
        URL url;
        this.setTitle("VASSAL " + Info.getVersion());
        this.setLayout(new BoxLayout(this.getContentPane(), 0));
        ApplicationIcons.setFor(this);
        final AbstractAction shutDownAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ModuleManagerWindow.this.saveColumnWidths();
                Prefs gp = Prefs.getGlobalPrefs();
                try {
                    gp.close();
                }
                catch (IOException ex) {
                    WriteErrorDialog.error(ex, gp.getFile());
                }
                try {
                    ModuleManager.getInstance().shutDown();
                }
                catch (IOException ex) {
                    ErrorDialog.bug(ex);
                }
                logger.info("Exiting");
                System.exit(0);
            }
        };
        shutDownAction.putValue("Name", Resources.getString("General.quit"));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                shutDownAction.actionPerformed(null);
            }
        });
        MenuManager mm = MenuManager.getInstance();
        MenuBarProxy mb = mm.getMenuBarProxyFor(this);
        MenuProxy fileMenu = new MenuProxy(Resources.getString("General.file"));
        fileMenu.setMnemonic(Resources.getString("General.file.shortcut").charAt(0));
        fileMenu.add(mm.addKey("Main.play_module"));
        fileMenu.add(mm.addKey("Main.edit_module"));
        fileMenu.add(mm.addKey("Main.new_module"));
        fileMenu.addSeparator();
        if (!SystemUtils.IS_OS_MAC) {
            fileMenu.add(mm.addKey("Prefs.edit_preferences"));
            fileMenu.addSeparator();
            fileMenu.add(mm.addKey("General.quit"));
        }
        MenuProxy toolsMenu = new MenuProxy(Resources.getString("General.tools"));
        Prefs.getGlobalPrefs().getEditor().initDialog(this);
        Prefs.initSharedGlobalPrefs();
        final BooleanConfigurer serverStatusConfig = new BooleanConfigurer(SHOW_STATUS_KEY, null, Boolean.FALSE);
        Prefs.getGlobalPrefs().addOption(null, serverStatusConfig);
        this.dividerLocationConfig = new IntConfigurer(DIVIDER_LOCATION_KEY, null, (Integer)-10);
        Prefs.getGlobalPrefs().addOption(null, this.dividerLocationConfig);
        BooleanConfigurer developerInfoConfig = new BooleanConfigurer(DEVELOPER_INFO_KEY, Resources.getString("Prefs.developer_info"), false);
        Prefs.getGlobalPrefs().addOption(Resources.getString("Prefs.general_tab"), developerInfoConfig);
        developerInfoConfig.addPropertyChangeListener(e1 -> this.updateColumnDisplay());
        toolsMenu.add(new CheckBoxMenuItemProxy(new AbstractAction(Resources.getString("Chat.server_status")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ModuleManagerWindow.this.splitPane.toggleRight();
                serverStatusConfig.setValue(serverStatusConfig.booleanValue() != false ? Boolean.FALSE : Boolean.TRUE);
                if (ModuleManagerWindow.this.splitPane.isRightVisible()) {
                    ModuleManagerWindow.this.splitPane.setDividerLocation(ModuleManagerWindow.this.getPreferredDividerLocation());
                }
            }
        }, serverStatusConfig.booleanValue()));
        toolsMenu.add(mm.addKey("Main.import_module"));
        toolsMenu.add(new MenuItemProxy(new AbstractAction(Resources.getString("ModuleManager.clear_tilecache")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                File tdir;
                int dialogResult = Dialogs.showConfirmDialog(ModuleManagerWindow.this, Resources.getString("ModuleManager.clear_tilecache_title"), Resources.getString("ModuleManager.clear_tilecache_heading"), Resources.getString("ModuleManager.clear_tilecache_message"), 2, 2);
                if (dialogResult == 0 && (tdir = new File(Info.getConfDir(), "tiles")).exists()) {
                    try {
                        FileUtils.forceDelete((File)tdir);
                        FileUtils.forceMkdir((File)tdir);
                    }
                    catch (IOException e) {
                        WriteErrorDialog.error(e, tdir);
                    }
                }
            }
        }));
        MenuProxy helpMenu = new MenuProxy(Resources.getString("General.help"));
        helpMenu.setMnemonic(Resources.getString("General.help.shortcut").charAt(0));
        helpMenu.add(mm.addKey("General.help"));
        helpMenu.add(mm.addKey("Main.tour"));
        helpMenu.add(mm.addKey("Help.user_guide"));
        helpMenu.addSeparator();
        helpMenu.add(mm.addKey("UpdateCheckAction.update_check"));
        helpMenu.add(mm.addKey("Help.error_log"));
        if (!SystemUtils.IS_OS_MAC) {
            helpMenu.addSeparator();
            helpMenu.add(mm.addKey("AboutScreen.about_vassal"));
        }
        mb.add(fileMenu);
        mb.add(toolsMenu);
        mb.add(helpMenu);
        mm.addAction("Main.play_module", new Player.PromptLaunchAction(this));
        mm.addAction("Main.edit_module", new Editor.PromptLaunchAction(this));
        mm.addAction("Main.new_module", new Editor.NewModuleLaunchAction(this));
        mm.addAction("Main.import_module", new Editor.PromptImportLaunchAction(this));
        mm.addAction("Prefs.edit_preferences", Prefs.getGlobalPrefs().getEditor().getEditAction());
        mm.addAction("General.quit", shutDownAction);
        try {
            url = new File(Documentation.getDocumentationBaseDir(), "README.html").toURI().toURL();
            mm.addAction("General.help", new ShowHelpAction(url, null));
        }
        catch (MalformedURLException e2) {
            ErrorDialog.bug(e2);
        }
        try {
            url = new File(Documentation.getDocumentationBaseDir(), "userguide/userguide.pdf").toURI().toURL();
            mm.addAction("Help.user_guide", new ShowHelpAction("Help.user_guide", url, null));
        }
        catch (MalformedURLException e3) {
            ErrorDialog.bug(e3);
        }
        mm.addAction("Main.tour", new LaunchTourAction(this));
        mm.addAction("AboutScreen.about_vassal", new AboutVASSALAction(this));
        mm.addAction("UpdateCheckAction.update_check", new UpdateCheckAction(this));
        mm.addAction("Help.error_log", new ShowErrorLogAction(this));
        this.setJMenuBar(mm.getMenuBarFor(this));
        this.moduleIcon = new ImageIcon(this.getClass().getResource("/images/mm-module.png"));
        this.activeExtensionIcon = new ImageIcon(this.getClass().getResource("/images/mm-extension-active.png"));
        this.inactiveExtensionIcon = new ImageIcon(this.getClass().getResource("/images/mm-extension-inactive.png"));
        this.openGameFolderIcon = new ImageIcon(this.getClass().getResource("/images/mm-gamefolder-open.png"));
        this.closedGameFolderIcon = new ImageIcon(this.getClass().getResource("/images/mm-gamefolder-closed.png"));
        this.fileIcon = new ImageIcon(this.getClass().getResource("/images/mm-file.png"));
        JPanel moduleControls = new JPanel(new BorderLayout());
        this.modulePanelLayout = new CardLayout();
        this.moduleView = new JPanel(this.modulePanelLayout);
        this.buildTree();
        JScrollPane scroll = new JScrollPane((Component)((Object)this.tree));
        this.moduleView.add((Component)scroll, "modules");
        JEditorPane l = new JEditorPane("text/html", Resources.getString("ModuleManager.quickstart"));
        l.setEditable(false);
        Color bg = UIManager.getColor("control");
        Font font = UIManager.getFont("Label.font");
        if (bg == null || font == null) {
            JLabel dummy = new JLabel();
            if (bg == null) {
                bg = dummy.getBackground();
            }
            if (font == null) {
                font = dummy.getFont();
            }
        }
        l.setBackground(bg);
        ((HTMLEditorKit)l.getEditorKit()).getStyleSheet().addRule("body { font: " + font.getFamily() + " " + font.getSize() + "pt }");
        l.addHyperlinkListener(BrowserSupport.getListener());
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        p.add((Component)l, c);
        this.moduleView.add((Component)p, "quickStart");
        this.modulePanelLayout.show(this.moduleView, this.getModuleCount() == 0 ? "quickStart" : "modules");
        moduleControls.add((Component)this.moduleView, "Center");
        moduleControls.setBorder(new TitledBorder(Resources.getString("ModuleManager.recent_modules")));
        this.add(moduleControls);
        ServerStatusView serverStatusControls = new ServerStatusView(new CgiServerStatus());
        serverStatusControls.setBorder(new TitledBorder(Resources.getString("Chat.server_status")));
        this.splitPane = new SplitPane(1, moduleControls, serverStatusControls);
        this.splitPane.setRightVisible(serverStatusConfig.booleanValue());
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setDividerLocation(this.getPreferredDividerLocation());
        this.splitPane.addPropertyChangeListener("dividerLocation", e -> this.setPreferredDividerLocation((Integer)e.getNewValue()));
        this.add(this.splitPane);
        Rectangle r = SwingUtils.getScreenBounds(this);
        serverStatusControls.setPreferredSize(new Dimension((int)((double)r.width / 3.5), 0));
        this.setSize(3 * r.width / 4, 3 * r.height / 4);
        PositionOption option = new PositionOption("BoundsOfModuleManager", this);
        Prefs.getGlobalPrefs().addOption(option);
    }

    public void setWaitCursor(boolean wait) {
        this.setCursor(Cursor.getPredefinedCursor(wait ? 3 : 0));
    }

    protected void setPreferredDividerLocation(int i) {
        this.dividerLocationConfig.setValue(i);
    }

    protected int getPreferredDividerLocation() {
        return this.dividerLocationConfig.getIntValue(500);
    }

    private void updateColumnDisplay() {
        boolean showDeveloperInfo = (Boolean)Prefs.getGlobalPrefs().getValue(DEVELOPER_INFO_KEY);
        TableColumnModel model = this.tree.getColumnModel();
        if (showDeveloperInfo) {
            if (model.getColumnCount() < 5) {
                model.addColumn(columns[3]);
                model.addColumn(columns[4]);
            }
        } else {
            model.removeColumn(columns[3]);
            model.removeColumn(columns[4]);
        }
    }

    private static Pair<String, String> splitVersion(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if ('0' > c || c > '9') continue;
            return Pair.of((Object)s.substring(0, i), (Object)s.substring(i));
        }
        return Pair.of((Object)s, (Object)"");
    }

    protected void buildTree() {
        ArrayList moduleList = new ArrayList();
        ArrayList missingModules = new ArrayList();
        this.recentModuleConfig = new StringArrayConfigurer("RecentModules", null);
        Prefs.getGlobalPrefs().addOption(null, this.recentModuleConfig);
        this.moduleConfig = new StringArrayConfigurer("Modules", null);
        Prefs.getGlobalPrefs().addOption(null, this.moduleConfig);
        Stream.concat(Arrays.stream(this.recentModuleConfig.getStringArray()), Arrays.stream(this.moduleConfig.getStringArray())).sorted().distinct().forEach(s -> {
            ModuleInfo module = new ModuleInfo((String)s);
            if (module.getFile().exists() && module.isValid()) {
                moduleList.add(module);
            } else {
                missingModules.add(s);
            }
        });
        for (String s2 : missingModules) {
            logger.info(Resources.getString("ModuleManager.removing_module", s2));
            ModuleInfo toRemove = moduleList.stream().filter(moduleInfo -> moduleInfo.getModuleName().equals(s2)).findFirst().orElse(null);
            moduleList.remove(toRemove);
            this.recentModuleConfig.removeValue(s2);
            this.moduleConfig.removeValue(s2);
        }
        moduleList.sort((a, b) -> {
            int i = a.toString().compareTo(b.toString());
            if (i == 0) {
                Pair<String, String> ap = ModuleManagerWindow.splitVersion(a.getVersion());
                Pair<String, String> bp = ModuleManagerWindow.splitVersion(b.getVersion());
                i = ((String)ap.getLeft()).compareTo((String)bp.getLeft());
                if (i == 0) {
                    i = -VersionUtils.compareVersions((String)ap.getRight(), (String)bp.getRight());
                }
            }
            return i;
        });
        this.rootNode = new MyTreeNode(new RootInfo());
        for (ModuleInfo moduleInfo2 : moduleList) {
            MyTreeNode moduleNode = new MyTreeNode(moduleInfo2);
            for (ExtensionInfo ext : moduleInfo2.getExtensions()) {
                MyTreeNode extensionNode = new MyTreeNode(ext);
                moduleNode.add((MutableTreeTableNode)extensionNode);
            }
            ArrayList<File> missingFolders = new ArrayList<File>();
            for (File f : moduleInfo2.getFolders()) {
                if (f.exists() && f.isDirectory()) {
                    GameFolderInfo folderInfo = new GameFolderInfo(f, moduleInfo2);
                    MyTreeNode folderNode = new MyTreeNode(folderInfo);
                    moduleNode.add((MutableTreeTableNode)folderNode);
                    ArrayList<File> l = new ArrayList<File>();
                    File[] files = f.listFiles();
                    if (files == null) continue;
                    for (File f1 : files) {
                        if (!f1.isFile()) continue;
                        l.add(f1);
                    }
                    Collections.sort(l);
                    for (File f2 : l) {
                        SaveFileInfo fileInfo = new SaveFileInfo(f2, folderInfo);
                        if (!fileInfo.isValid() || !fileInfo.belongsToModule()) continue;
                        MyTreeNode fileNode = new MyTreeNode(fileInfo);
                        folderNode.add((MutableTreeTableNode)fileNode);
                    }
                    continue;
                }
                missingFolders.add(f);
            }
            for (File mf : missingFolders) {
                logger.info(Resources.getString("ModuleManager.removing_folder", mf.getPath()));
                moduleInfo2.removeFolder(mf);
            }
            this.rootNode.add((MutableTreeTableNode)moduleNode);
        }
        this.updateModuleList();
        this.treeModel = new MyTreeTableModel(this.rootNode);
        this.tree = new MyTree(this.treeModel);
        this.tree.setRootVisible(false);
        this.tree.setEditable(false);
        this.tree.setTreeCellRenderer(new MyTreeCellRenderer());
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtils.isMainMouseButtonDown(e)) {
                    TreePath path = ModuleManagerWindow.this.tree.getPathForLocation(e.getPoint().x, e.getPoint().y);
                    if (path == null || ModuleManagerWindow.this.lastExpansionPath == path && e.getWhen() - ModuleManagerWindow.this.lastExpansionTime <= doubleClickInterval) {
                        return;
                    }
                    ModuleManagerWindow.this.tree.activateOrExpandNode(path);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybePopup(e);
            }

            private void maybePopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TreePath path = ModuleManagerWindow.this.tree.getPathForLocation(e.getPoint().x, e.getPoint().y);
                    if (path == null) {
                        return;
                    }
                    int row = ModuleManagerWindow.this.tree.getRowForPath(path);
                    if (row >= 0) {
                        ModuleManagerWindow.this.selectedNode = (MyTreeNode)((Object)path.getLastPathComponent());
                        ModuleManagerWindow.this.tree.clearSelection();
                        ModuleManagerWindow.this.tree.addRowSelectionInterval(row, row);
                        AbstractInfo target = (AbstractInfo)ModuleManagerWindow.this.selectedNode.getUserObject();
                        target.buildPopup(row).show((Component)((Object)ModuleManagerWindow.this.tree), e.getX(), e.getY());
                    }
                }
            }
        });
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent e) {
                ModuleManagerWindow.this.lastExpansionTime = System.currentTimeMillis();
                ModuleManagerWindow.this.lastExpansionPath = e.getPath();
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent e) {
                ModuleManagerWindow.this.lastExpansionTime = System.currentTimeMillis();
                ModuleManagerWindow.this.lastExpansionPath = e.getPath();
            }
        });
        this.tree.setToggleClickCount(3);
        this.tree.setSelectionMode(0);
        this.tree.addTreeSelectionListener(e -> {
            MyTreeNode node = (MyTreeNode)((Object)((Object)e.getPath().getLastPathComponent()));
            AbstractInfo target = node.getNodeInfo();
            if (target instanceof ModuleInfo) {
                this.setSelectedModule(target.getFile());
            } else if (node.getParent() != null) {
                this.setSelectedModule(node.getParentModuleFile());
            }
        });
        StringConfigurer widthsConfig = new StringConfigurer(COLUMN_WIDTHS_KEY, null, "");
        Prefs.getGlobalPrefs().addOption(null, widthsConfig);
        this.setColumnWidths();
        TableColumnModel model = this.tree.getColumnModel();
        CenteringCellRenderer centerRenderer = new CenteringCellRenderer();
        model.getColumn(1).setCellRenderer(centerRenderer);
        model.getColumn(4).setCellRenderer(centerRenderer);
        model.getColumn(3).setCellRenderer(centerRenderer);
        this.tree.getTableHeader().setAlignmentX(0.5f);
        for (int i = 0; i < 5; ++i) {
            ModuleManagerWindow.columns[i] = this.tree.getColumnModel().getColumn(i);
        }
        this.updateColumnDisplay();
    }

    private void setColumnWidths() {
        String widths = Prefs.getGlobalPrefs().getValue(COLUMN_WIDTHS_KEY).toString();
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(widths, ',');
        TableColumnModel model = this.tree.getColumnModel();
        model.getColumn(0).setPreferredWidth(sd.nextInt(250));
        model.getColumn(0).setMinWidth(200);
        model.getColumn(1).setPreferredWidth(sd.nextInt(100));
        model.getColumn(1).setMinWidth(100);
        model.getColumn(2).setPreferredWidth(sd.nextInt(500));
        model.getColumn(2).setMinWidth(200);
        model.getColumn(3).setPreferredWidth(sd.nextInt(100));
        model.getColumn(3).setMinWidth(100);
        model.getColumn(4).setPreferredWidth(sd.nextInt(100));
        model.getColumn(4).setMinWidth(100);
    }

    private void saveColumnWidths() {
        SequenceEncoder se = new SequenceEncoder(',');
        TableColumnModel model = this.tree.getColumnModel();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            se.append(model.getColumn(i).getWidth());
        }
        Prefs.getGlobalPrefs().setValue(COLUMN_WIDTHS_KEY, se.toString());
    }

    public void updateRequest(File f) {
        SwingUtilities.invokeLater(() -> this.update(f));
    }

    public void update(File f) {
        AbstractMetaData data = MetaDataFactory.buildMetaData(f);
        if (data instanceof ModuleMetaData) {
            MyTreeNode moduleNode = this.rootNode.findNode(f);
            if (moduleNode == null) {
                this.addModule(f);
            } else {
                moduleNode.refresh();
            }
        } else if (data instanceof ExtensionMetaData) {
            for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
                MyTreeNode moduleNode = this.rootNode.getChild(i);
                ModuleInfo moduleInfo = (ModuleInfo)moduleNode.getNodeInfo();
                for (ExtensionInfo ext : moduleInfo.getExtensions()) {
                    if (!ext.getFile().equals(f)) continue;
                    moduleNode.refresh();
                    return;
                }
            }
        } else if (data instanceof SaveMetaData) {
            for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
                MyTreeNode moduleNode = this.rootNode.getChild(i);
                MyTreeNode folderNode = moduleNode.findNode(f.getParentFile());
                if (folderNode == null || !(folderNode.getNodeInfo() instanceof GameFolderInfo)) continue;
                ((GameFolderInfo)folderNode.getNodeInfo()).update(f);
                return;
            }
        }
        this.tree.repaint();
    }

    private int getModuleCount() {
        return this.rootNode.getChildCount();
    }

    public File getSelectedModule() {
        return this.selectedModule;
    }

    private void setSelectedModule(File selectedModule) {
        this.selectedModule = selectedModule;
    }

    public void addModule(File f) {
        ModuleInfo moduleInfo;
        if (!this.rootNode.contains(f) && (moduleInfo = new ModuleInfo(f)).isValid()) {
            MyTreeNode moduleNode = new MyTreeNode(moduleInfo);
            this.treeModel.insertNodeInto((MutableTreeTableNode)moduleNode, (MutableTreeTableNode)this.rootNode, this.rootNode.findInsertIndex(moduleInfo));
            for (ExtensionInfo ext : moduleInfo.getExtensions()) {
                MyTreeNode extensionNode = new MyTreeNode(ext);
                this.treeModel.insertNodeInto((MutableTreeTableNode)extensionNode, (MutableTreeTableNode)moduleNode, moduleNode.findInsertIndex(ext));
            }
            this.updateModuleList();
        }
    }

    public void removeModule(File f) {
        MyTreeNode moduleNode = this.rootNode.findNode(f);
        this.treeModel.removeNodeFromParent((MutableTreeTableNode)moduleNode);
        this.updateModuleList();
    }

    public File getModuleByName(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
            ModuleInfo module = (ModuleInfo)this.rootNode.getChild(i).getNodeInfo();
            if (!name.equals(module.getModuleName())) continue;
            return module.getFile();
        }
        return null;
    }

    private void updateModuleList() {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
            ModuleInfo module = (ModuleInfo)this.rootNode.getChild(i).getNodeInfo();
            l.add(module.encode());
        }
        this.recentModuleConfig.setValue(l.toArray(new String[0]));
        this.moduleConfig.setValue(l.toArray(new String[0]));
        this.modulePanelLayout.show(this.moduleView, this.getModuleCount() == 0 ? "quickStart" : "modules");
    }

    static {
        Object dci = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        doubleClickInterval = dci instanceof Integer ? (long)((Integer)dci).intValue() : 200L;
        instance = new ModuleManagerWindow();
    }

    private static class ShowErrorLogAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final Frame frame;

        public ShowErrorLogAction(Frame frame) {
            super(Resources.getString("Help.error_log"));
            this.frame = frame;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File logfile = Info.getErrorLogPath();
            LogPane lp = new LogPane(logfile);
            JDialog d = new JDialog(this.frame, Resources.getString("Help.error_log"));
            d.setLayout((LayoutManager)new MigLayout("insets 0"));
            d.add((Component)new JScrollPane(lp), "grow, push, w 500, h 600");
            d.setLocationRelativeTo(this.frame);
            d.setDefaultCloseOperation(2);
            SwingUtils.repack(d);
            d.setVisible(true);
        }
    }

    private static class MyTree
    extends JXTreeTable {
        private static final long serialVersionUID = 1L;

        public MyTree(MyTreeTableModel treeModel) {
            super((TreeTableModel)treeModel);
            this.createKeyBindings((JTable)((Object)this));
        }

        public void activateOrExpandNode(TreePath path) {
            ModuleManagerWindow mmw = ModuleManagerWindow.getInstance();
            mmw.selectedNode = (MyTreeNode)((Object)path.getLastPathComponent());
            AbstractInfo target = (AbstractInfo)mmw.selectedNode.getUserObject();
            int row = mmw.tree.getRowForPath(path);
            if (row < 0) {
                return;
            }
            if (target instanceof ModuleInfo) {
                ModuleInfo modInfo = (ModuleInfo)target;
                if (modInfo.isModuleTooNew()) {
                    ErrorDialog.show("Error.module_too_new", modInfo.getFile().getPath(), modInfo.getVassalVersion(), Info.getVersion());
                    return;
                }
                ((ModuleInfo)target).play();
            } else if (target instanceof SaveFileInfo) {
                ((SaveFileInfo)target).play();
            } else if (this.isExpanded(row)) {
                this.collapseRow(row);
            } else {
                this.expandRow(row);
            }
        }

        private void createKeyBindings(JTable table) {
            table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "Enter");
            table.getActionMap().put("Enter", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    MyTree tree = ModuleManagerWindow.getInstance().tree;
                    int row = tree.getSelectedRow();
                    TreePath path = tree.getPathForRow(row);
                    if (path != null) {
                        tree.activateOrExpandNode(path);
                    }
                }
            });
        }

        public String getToolTipText(MouseEvent event) {
            if (this.getComponentAt(event.getPoint().x, event.getPoint().y) == null) {
                return null;
            }
            return super.getToolTipText(event);
        }
    }

    public class ModuleInfo
    extends AbstractInfo {
        private final ExtensionsManager extMgr;
        private final SortedSet<File> gameFolders;
        private ModuleMetaData metadata;
        private final Action newExtensionAction;
        private final AbstractAction addExtensionAction;
        private final AbstractAction addFolderAction;

        public ModuleInfo(File f) {
            super(f, ModuleManagerWindow.this.moduleIcon);
            this.gameFolders = new TreeSet<File>();
            this.newExtensionAction = new NewExtensionLaunchAction(ModuleManagerWindow.this);
            this.addExtensionAction = new AbstractAction(Resources.getString("ModuleManager.add_extension")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileChooser fc = FileChooser.createFileChooser(ModuleManagerWindow.this, (DirectoryConfigurer)Prefs.getGlobalPrefs().getOption("modulesDir"));
                    if (fc.showOpenDialog() == 0) {
                        File selectedFile = fc.getSelectedFile();
                        ExtensionInfo testExtInfo = new ExtensionInfo(selectedFile, true, null);
                        if (testExtInfo.isValid()) {
                            MyTreeNode moduleNode;
                            File f = ModuleInfo.this.getExtensionsManager().setActive(fc.getSelectedFile(), true);
                            ExtensionInfo extInfo = new ExtensionInfo(f, true, (ModuleInfo)(moduleNode = ModuleManagerWindow.this.rootNode.findNode(ModuleManagerWindow.this.selectedModule)).getNodeInfo());
                            if (extInfo.isValid()) {
                                MyTreeNode extNode = new MyTreeNode(extInfo);
                                ModuleManagerWindow.this.treeModel.insertNodeInto((MutableTreeTableNode)extNode, (MutableTreeTableNode)moduleNode, moduleNode.findInsertIndex(extInfo));
                            }
                        } else {
                            JOptionPane.showMessageDialog(ModuleManagerWindow.this, testExtInfo.getError(), null, 0);
                        }
                    }
                }
            };
            this.addFolderAction = new AbstractAction(Resources.getString("ModuleManager.add_save_game_folder")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileChooser fc = FileChooser.createFileChooser(ModuleManagerWindow.this, (DirectoryConfigurer)Prefs.getGlobalPrefs().getOption("modulesDir"), 1);
                    if (fc.showOpenDialog() == 0) {
                        ModuleInfo.this.addFolder(fc.getSelectedFile());
                    }
                }
            };
            this.extMgr = new ExtensionsManager(f);
            this.loadMetaData();
        }

        protected void loadMetaData() {
            AbstractMetaData data = MetaDataFactory.buildMetaData(this.file);
            if (data instanceof ModuleMetaData) {
                this.setValid(true);
                this.metadata = (ModuleMetaData)data;
            } else {
                this.setValid(false);
            }
        }

        protected boolean isModuleTooNew() {
            return this.metadata != null && Info.isModuleTooNew(this.metadata.getVassalVersion());
        }

        @Override
        public String getVassalVersion() {
            return this.metadata == null ? "" : this.metadata.getVassalVersion();
        }

        @Override
        public String getLastSaved() {
            return this.metadata == null ? "" : this.metadata.formatLastSaved();
        }

        public ModuleInfo(String s) {
            this.gameFolders = new TreeSet<File>();
            this.newExtensionAction = new NewExtensionLaunchAction(ModuleManagerWindow.this);
            this.addExtensionAction = new /* invalid duplicate definition of identical inner class */;
            this.addFolderAction = new /* invalid duplicate definition of identical inner class */;
            SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ';');
            this.setFile(new File(sd.nextToken()));
            this.setIcon(ModuleManagerWindow.this.moduleIcon);
            this.loadMetaData();
            this.extMgr = new ExtensionsManager(this.getFile());
            while (sd.hasMoreTokens()) {
                this.gameFolders.add(new File(sd.nextToken()));
            }
        }

        @Override
        public void refresh() {
            this.loadMetaData();
            MyTreeNode[] nodes = new MyTreeNode[this.getTreeNode().getChildCount()];
            for (int i = 0; i < this.getTreeNode().getChildCount(); ++i) {
                nodes[i] = this.getTreeNode().getChild(i);
            }
            for (MyTreeNode myTreeNode : nodes) {
                if (myTreeNode.getFile().exists()) continue;
                ModuleManagerWindow.this.treeModel.removeNodeFromParent((MutableTreeTableNode)myTreeNode);
            }
            for (ExtensionInfo ext : this.getExtensions()) {
                MyTreeNode extNode = this.getTreeNode().findNode(ext.getFile());
                if (extNode == null) {
                    if (!ext.isValid()) continue;
                    extNode = new MyTreeNode(ext);
                    ModuleManagerWindow.this.treeModel.insertNodeInto((MutableTreeTableNode)extNode, (MutableTreeTableNode)this.getTreeNode(), this.getTreeNode().findInsertIndex(ext));
                    continue;
                }
                extNode.refresh();
            }
        }

        public String encode() {
            SequenceEncoder se = new SequenceEncoder(this.file.getPath(), ';');
            for (File f : this.gameFolders) {
                se.append(f.getPath());
            }
            return se.getValue();
        }

        public ExtensionsManager getExtensionsManager() {
            return this.extMgr;
        }

        public void addFolder(File f) {
            try {
                f = f.getCanonicalFile();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(ModuleManagerWindow.this, Resources.getString("Error.file_read_error", f.getPath()), "Error", 0);
                return;
            }
            if (!f.exists() && !f.mkdirs()) {
                JOptionPane.showMessageDialog(ModuleManagerWindow.this, Resources.getString("Install.error_unable_to_create", f.getPath()), "Error", 0);
                return;
            }
            this.gameFolders.add(f);
            MyTreeNode moduleNode = ModuleManagerWindow.this.rootNode.findNode(ModuleManagerWindow.this.selectedModule);
            GameFolderInfo folderInfo = new GameFolderInfo(f, (ModuleInfo)moduleNode.getNodeInfo());
            MyTreeNode folderNode = new MyTreeNode(folderInfo);
            int idx = moduleNode.findInsertIndex(folderInfo);
            ModuleManagerWindow.this.treeModel.insertNodeInto((MutableTreeTableNode)folderNode, (MutableTreeTableNode)moduleNode, idx);
            for (File file : f.listFiles()) {
                SaveFileInfo fileInfo;
                if (!file.isFile() || !(fileInfo = new SaveFileInfo(file, folderInfo)).isValid() || !fileInfo.belongsToModule()) continue;
                MyTreeNode fileNode = new MyTreeNode(fileInfo);
                ModuleManagerWindow.this.treeModel.insertNodeInto((MutableTreeTableNode)fileNode, (MutableTreeTableNode)folderNode, folderNode.findInsertIndex(fileInfo));
            }
            ModuleManagerWindow.this.updateModuleList();
        }

        public void removeFolder(File f) {
            this.gameFolders.remove(f);
        }

        public SortedSet<File> getFolders() {
            return this.gameFolders;
        }

        public List<ExtensionInfo> getExtensions() {
            ArrayList<ExtensionInfo> l = new ArrayList<ExtensionInfo>();
            for (File f : this.extMgr.getActiveExtensions()) {
                l.add(new ExtensionInfo(f, true, this));
            }
            for (File f : this.extMgr.getInactiveExtensions()) {
                l.add(new ExtensionInfo(f, false, this));
            }
            Collections.sort(l);
            return l;
        }

        public void play() {
            new Player.LaunchAction(ModuleManagerWindow.this, this.file).actionPerformed(null);
        }

        @Override
        public JPopupMenu buildPopup(int row) {
            Player.LaunchAction playAction;
            boolean tooNew = Info.isModuleTooNew(this.metadata.getVassalVersion());
            JPopupMenu m = new JPopupMenu();
            playAction.setEnabled((playAction = new Player.LaunchAction(ModuleManagerWindow.this, this.file)).isEnabled() && !tooNew);
            m.add(playAction);
            Editor.ListLaunchAction editAction = new Editor.ListLaunchAction(ModuleManagerWindow.this, this.file);
            editAction.setEnabled(editAction.isEnabled() && !tooNew);
            m.add(editAction);
            m.add(new AbstractAction(Resources.getString("General.remove")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ModuleManagerWindow.this.removeModule(ModuleInfo.this.file);
                    ModuleInfo.this.cleanupTileCache();
                }
            });
            m.addSeparator();
            m.add(this.addFolderAction);
            this.addFolderAction.setEnabled(!tooNew);
            m.addSeparator();
            m.add(this.newExtensionAction);
            this.newExtensionAction.setEnabled(!tooNew);
            m.add(this.addExtensionAction);
            this.addExtensionAction.setEnabled(!tooNew);
            return m;
        }

        public void cleanupTileCache() {
            String hstr = DigestUtils.sha1Hex((String)(this.metadata.getName() + "_" + this.metadata.getVersion()));
            File tdir = new File(Info.getConfDir(), "tiles/" + hstr);
            if (tdir.exists()) {
                try {
                    FileUtils.forceDelete((File)tdir);
                }
                catch (IOException e) {
                    WriteErrorDialog.error(e, tdir);
                }
            }
        }

        public boolean isInUse() {
            return AbstractLaunchAction.isInUse(this.file) || AbstractLaunchAction.isEditing(this.file);
        }

        @Override
        public String getVersion() {
            return this.metadata.getVersion();
        }

        public String getLocalizedDescription() {
            return this.metadata.getLocalizedDescription();
        }

        public String getModuleName() {
            return this.metadata.getName();
        }

        @Override
        public String toString() {
            return this.metadata.getLocalizedName();
        }

        @Override
        public String getValueAt(int column) {
            return column == 2 ? this.getLocalizedDescription() : super.getValueAt(column);
        }

        @Override
        public String getSortKey() {
            return this.metadata == null ? "" : this.metadata.getLocalizedName();
        }

        @Override
        public Color getTreeCellFgColor() {
            return Info.isModuleTooNew(this.getVassalVersion()) ? Color.GRAY : Color.BLACK;
        }
    }

    private static class MyTreeNode
    extends DefaultMutableTreeTableNode {
        public MyTreeNode(AbstractInfo nodeInfo) {
            super((Object)nodeInfo);
            nodeInfo.setTreeNode(this);
        }

        public AbstractInfo getNodeInfo() {
            return (AbstractInfo)this.getUserObject();
        }

        public File getFile() {
            return this.getNodeInfo().getFile();
        }

        public void refresh() {
            this.getNodeInfo().refresh();
        }

        public void setValueAt(Object aValue, int column) {
        }

        public Object getValueAt(int column) {
            return this.getNodeInfo().getValueAt(column);
        }

        public MyTreeNode getChild(int index) {
            return (MyTreeNode)super.getChildAt(index);
        }

        public MyTreeNode findNode(File f) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                MyTreeNode moduleNode = this.getChild(i);
                try {
                    f = f.getCanonicalFile();
                }
                catch (IOException e) {
                    f = f.getAbsoluteFile();
                }
                if (!f.equals(moduleNode.getNodeInfo().getFile())) continue;
                return moduleNode;
            }
            return null;
        }

        public boolean contains(File f) {
            return this.findNode(f) != null;
        }

        public int findInsertIndex(AbstractInfo info) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                MyTreeNode childNode = this.getChild(i);
                if (childNode.getNodeInfo().compareTo(info) < 0) continue;
                return i;
            }
            return this.getChildCount();
        }

        public MyTreeNode getParentModuleNode() {
            AbstractInfo info = this.getNodeInfo();
            if (info instanceof RootInfo) {
                return null;
            }
            if (info instanceof ModuleInfo) {
                return this;
            }
            if (this.getParent() == null) {
                return null;
            }
            return ((MyTreeNode)this.getParent()).getParentModuleNode();
        }

        public File getParentModuleFile() {
            MyTreeNode parentNode = this.getParentModuleNode();
            return parentNode == null ? null : parentNode.getFile();
        }
    }

    private class RootInfo
    extends AbstractInfo {
        public RootInfo() {
            super(null);
        }

        @Override
        public String getSortKey() {
            return "";
        }
    }

    private abstract class AbstractInfo
    implements Comparable<AbstractInfo> {
        protected File file;
        protected Icon openIcon;
        protected Icon closedIcon;
        protected boolean valid = true;
        protected String error = "";
        protected MyTreeNode node;

        public AbstractInfo(File f, Icon open, Icon closed) {
            this.setFile(f);
            this.setIcon(open, closed);
        }

        public AbstractInfo(File f, Icon i) {
            this(f, i, i);
        }

        public AbstractInfo(File f) {
            this(f, null);
        }

        public AbstractInfo() {
        }

        public String toString() {
            return this.file == null ? "" : this.file.getName();
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File f) {
            if (f == null) {
                return;
            }
            try {
                this.file = f.getCanonicalFile();
            }
            catch (IOException e) {
                this.file = f.getAbsoluteFile();
            }
        }

        public String getToolTipText() {
            if (this.file == null) {
                return "";
            }
            return this.file.getPath();
        }

        @Override
        public int compareTo(AbstractInfo info) {
            return this.getSortKey().compareTo(info.getSortKey());
        }

        public JPopupMenu buildPopup(int row) {
            return null;
        }

        public Icon getIcon(boolean expanded) {
            return expanded ? this.openIcon : this.closedIcon;
        }

        public void setIcon(Icon i) {
            this.setIcon(i, i);
        }

        public void setIcon(Icon open, Icon closed) {
            this.openIcon = open;
            this.closedIcon = closed;
        }

        public String getValueAt(int column) {
            switch (column) {
                case 0: {
                    return this.toString();
                }
                case 1: {
                    return this.getVersion();
                }
                case 3: {
                    return this.getVassalVersion();
                }
                case 4: {
                    return this.getLastSaved();
                }
            }
            return null;
        }

        public void setValid(boolean b) {
            this.valid = b;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setError(String s) {
            this.error = s;
        }

        public String getError() {
            return this.error;
        }

        public String getVersion() {
            return "";
        }

        public String getVassalVersion() {
            return "";
        }

        public String getComments() {
            return "";
        }

        public String getLastSaved() {
            return "";
        }

        public MyTreeNode getTreeNode() {
            return this.node;
        }

        public void setTreeNode(MyTreeNode n) {
            this.node = n;
        }

        public abstract String getSortKey();

        public Color getTreeCellFgColor() {
            return Color.black;
        }

        public void refresh() {
            this.refreshChildren();
        }

        public void refreshChildren() {
            for (int i = 0; i < this.node.getChildCount(); ++i) {
                this.node.getChild(i).refresh();
            }
        }
    }

    private class ExtensionInfo
    extends AbstractInfo {
        private boolean active;
        private final ModuleInfo moduleInfo;
        private ExtensionMetaData metadata;

        public ExtensionInfo(File file, boolean active, ModuleInfo module) {
            super(file, active ? ModuleManagerWindow.this.activeExtensionIcon : ModuleManagerWindow.this.inactiveExtensionIcon);
            this.active = active;
            this.moduleInfo = module;
            this.loadMetaData();
        }

        protected void loadMetaData() {
            AbstractMetaData data = MetaDataFactory.buildMetaData(this.file);
            if (data instanceof ExtensionMetaData) {
                this.setValid(true);
                this.metadata = (ExtensionMetaData)data;
            } else {
                this.setError(Resources.getString("ModuleManager.invalid_extension"));
                this.setValid(false);
            }
        }

        @Override
        public void refresh() {
            this.loadMetaData();
            this.setActive(this.getExtensionsManager().isExtensionActive(this.getFile()));
            ModuleManagerWindow.this.tree.repaint();
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean b) {
            this.active = b;
            this.setIcon(this.active ? ModuleManagerWindow.this.activeExtensionIcon : ModuleManagerWindow.this.inactiveExtensionIcon);
        }

        @Override
        public String getVersion() {
            return this.metadata == null ? "" : this.metadata.getVersion();
        }

        @Override
        public String getVassalVersion() {
            return this.metadata == null ? "" : this.metadata.getVassalVersion();
        }

        @Override
        public String getLastSaved() {
            return this.metadata == null ? "" : this.metadata.formatLastSaved();
        }

        public String getDescription() {
            return this.metadata == null ? "" : this.metadata.getDescription();
        }

        public ExtensionsManager getExtensionsManager() {
            return this.moduleInfo == null ? null : this.moduleInfo.getExtensionsManager();
        }

        @Override
        public String toString() {
            Object s = this.getFile().getName();
            Object st = "";
            if (this.metadata == null) {
                st = Resources.getString("ModuleManager.invalid");
            }
            if (!this.active) {
                st = (String)st + (((String)st).length() > 0 ? "," : "");
                st = (String)st + Resources.getString("ModuleManager.inactive");
            }
            if (((String)st).length() > 0) {
                s = (String)s + " (" + (String)st + ")";
            }
            return s;
        }

        @Override
        public JPopupMenu buildPopup(int row) {
            JPopupMenu m = new JPopupMenu();
            boolean tooNew = Info.isModuleTooNew(this.metadata.getVassalVersion());
            ActivateExtensionAction activateAction = new ActivateExtensionAction(Resources.getString(this.isActive() ? "ModuleManager.deactivate" : "ModuleManager.activate"));
            activateAction.setEnabled(!tooNew);
            m.add(activateAction);
            EditExtensionLaunchAction editAction = new EditExtensionLaunchAction(ModuleManagerWindow.this, this.getFile(), ModuleManagerWindow.this.getSelectedModule());
            editAction.setEnabled(!tooNew);
            m.add(editAction);
            return m;
        }

        @Override
        public Color getTreeCellFgColor() {
            if (this.isActive()) {
                return this.metadata == null ? Color.red : Color.black;
            }
            return this.metadata == null ? Color.pink : Color.gray;
        }

        @Override
        public String getValueAt(int column) {
            return column == 2 ? this.getDescription() : super.getValueAt(column);
        }

        public boolean isInUse() {
            return AbstractLaunchAction.isInUse(this.file) || AbstractLaunchAction.isEditing(this.file);
        }

        @Override
        public String getSortKey() {
            return this.getFile().getName();
        }

        private class ActivateExtensionAction
        extends AbstractAction {
            private static final long serialVersionUID = 1L;

            public ActivateExtensionAction(String s) {
                super(s);
                this.setEnabled(!ExtensionInfo.this.isInUse() && !ExtensionInfo.this.moduleInfo.isInUse());
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtensionInfo.this.setFile(ExtensionInfo.this.getExtensionsManager().setActive(ExtensionInfo.this.getFile(), !ExtensionInfo.this.isActive()));
                ExtensionInfo.this.setActive(ExtensionInfo.this.getExtensionsManager().isExtensionActive(ExtensionInfo.this.getFile()));
                TreePath path = ModuleManagerWindow.this.tree.getPathForRow(ModuleManagerWindow.this.tree.getSelectedRow());
                MyTreeNode extNode = (MyTreeNode)((Object)path.getLastPathComponent());
                ModuleManagerWindow.this.treeModel.setValueAt("", (Object)extNode, 0);
            }
        }
    }

    private class GameFolderInfo
    extends AbstractInfo {
        protected String comment;
        protected ModuleInfo moduleInfo;
        protected long dtm;

        public GameFolderInfo(File f, ModuleInfo m) {
            super(f, ModuleManagerWindow.this.openGameFolderIcon, ModuleManagerWindow.this.closedGameFolderIcon);
            this.moduleInfo = m;
            this.dtm = f.lastModified();
        }

        @Override
        public JPopupMenu buildPopup(int row) {
            boolean tooNew = Info.isModuleTooNew(this.moduleInfo.getVassalVersion());
            JPopupMenu m = new JPopupMenu();
            AbstractAction refreshAction = new AbstractAction(Resources.getString("General.refresh")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    GameFolderInfo.this.refresh();
                }
            };
            refreshAction.setEnabled(!tooNew);
            m.add(refreshAction);
            m.addSeparator();
            AbstractAction removeAction = new AbstractAction(Resources.getString("General.remove")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyTreeNode moduleNode = ModuleManagerWindow.this.rootNode.findNode(GameFolderInfo.this.moduleInfo.getFile());
                    MyTreeNode folderNode = moduleNode.findNode(GameFolderInfo.this.getFile());
                    ModuleManagerWindow.this.treeModel.removeNodeFromParent((MutableTreeTableNode)folderNode);
                    GameFolderInfo.this.moduleInfo.removeFolder(GameFolderInfo.this.getFile());
                    ModuleManagerWindow.this.updateModuleList();
                }
            };
            removeAction.setEnabled(!tooNew);
            m.add(removeAction);
            return m;
        }

        public ModuleInfo getModuleInfo() {
            return this.moduleInfo;
        }

        @Override
        public void refresh() {
            for (int i = this.getTreeNode().getChildCount() - 1; i >= 0; --i) {
                MyTreeNode fileNode = this.getTreeNode().getChild(i);
                SaveFileInfo fileInfo = (SaveFileInfo)fileNode.getNodeInfo();
                if (fileInfo.getFile().exists()) continue;
                ModuleManagerWindow.this.treeModel.removeNodeFromParent((MutableTreeTableNode)fileNode);
            }
            File[] files = this.getFile().listFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                String moduleName;
                AbstractMetaData fdata = MetaDataFactory.buildMetaData(f);
                if (fdata == null || !(fdata instanceof SaveMetaData) || (moduleName = ((SaveMetaData)fdata).getModuleName()) != null && moduleName.length() != 0 && !moduleName.equals(this.getModuleInfo().getModuleName())) continue;
                this.update(f);
            }
        }

        public void update(File f) {
            for (int i = 0; i < this.getTreeNode().getChildCount(); ++i) {
                SaveFileInfo fileInfo = (SaveFileInfo)this.getTreeNode().getChild(i).getNodeInfo();
                if (!fileInfo.getFile().equals(f)) continue;
                fileInfo.refresh();
                return;
            }
            SaveFileInfo fileInfo = new SaveFileInfo(f, this);
            MyTreeNode fileNode = new MyTreeNode(fileInfo);
            ModuleManagerWindow.this.treeModel.insertNodeInto((MutableTreeTableNode)fileNode, (MutableTreeTableNode)this.getTreeNode(), this.getTreeNode().findInsertIndex(fileInfo));
        }

        @Override
        public String getSortKey() {
            return "~~~" + this.getFile().getName();
        }
    }

    private class SaveFileInfo
    extends AbstractInfo {
        protected GameFolderInfo folderInfo;
        protected SaveMetaData metadata;

        public SaveFileInfo(File f, GameFolderInfo folder) {
            super(f, ModuleManagerWindow.this.fileIcon);
            this.folderInfo = folder;
            this.loadMetaData();
        }

        protected void loadMetaData() {
            AbstractMetaData data = MetaDataFactory.buildMetaData(this.file);
            if (data instanceof SaveMetaData) {
                this.metadata = (SaveMetaData)data;
                this.setValid(true);
            } else {
                this.setValid(false);
            }
        }

        @Override
        public void refresh() {
            this.loadMetaData();
            ModuleManagerWindow.this.tree.repaint();
        }

        @Override
        public JPopupMenu buildPopup(int row) {
            boolean tooNew = Info.isModuleTooNew(this.metadata.getVassalVersion());
            JPopupMenu m = new JPopupMenu();
            Player.LaunchAction launchAction = new Player.LaunchAction(ModuleManagerWindow.this, this.getModuleFile(), this.file);
            launchAction.setEnabled(!tooNew);
            m.add(launchAction);
            return m;
        }

        protected File getModuleFile() {
            return this.folderInfo.getModuleInfo().getFile();
        }

        public void play() {
            new Player.LaunchAction(ModuleManagerWindow.this, this.getModuleFile(), this.file).actionPerformed(null);
        }

        @Override
        public String getValueAt(int column) {
            return column == 2 ? this.buildComments() : super.getValueAt(column);
        }

        private String buildComments() {
            Object comments = "";
            if (!this.belongsToModule() && this.metadata != null && this.metadata.getModuleName().length() > 0) {
                comments = "[" + this.metadata.getModuleName() + "] ";
            }
            comments = (String)comments + (this.metadata == null ? "" : this.metadata.getDescription());
            return comments;
        }

        private boolean belongsToModule() {
            return this.metadata != null && (this.metadata.getModuleName().length() == 0 || this.folderInfo.getModuleInfo().getModuleName().equals(this.metadata.getModuleName()));
        }

        @Override
        public Color getTreeCellFgColor() {
            return this.belongsToModule() ? Color.black : Color.gray;
        }

        @Override
        public String getVersion() {
            return this.metadata == null ? "" : this.metadata.getModuleVersion();
        }

        @Override
        public String getSortKey() {
            return this.getFile().getName();
        }
    }

    private static class MyTreeTableModel
    extends DefaultTreeTableModel {
        public MyTreeTableModel(MyTreeNode rootNode) {
            super((TreeTableNode)rootNode);
            ModuleManagerWindow.columnHeadings[0] = Resources.getString("ModuleManager.module");
            ModuleManagerWindow.columnHeadings[1] = Resources.getString("ModuleManager.version");
            ModuleManagerWindow.columnHeadings[3] = Resources.getString("ModuleManager.created_by");
            ModuleManagerWindow.columnHeadings[2] = Resources.getString("ModuleManager.description");
            ModuleManagerWindow.columnHeadings[4] = Resources.getString("ModuleManager.last_saved");
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int col) {
            return columnHeadings[col];
        }

        public Object getValueAt(Object node, int column) {
            return ((MyTreeNode)((Object)node)).getValueAt(column);
        }
    }

    private static class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        private MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            AbstractInfo info = ((MyTreeNode)((Object)value)).getNodeInfo();
            this.setText(info.toString());
            this.setToolTipText(info.getToolTipText());
            this.setIcon(info.getIcon(expanded));
            this.setForeground(info.getTreeCellFgColor());
            return this;
        }
    }

    private static class CenteringCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        public CenteringCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return this;
        }
    }

    private static class EditExtensionLaunchAction
    extends AbstractLaunchAction {
        private static final long serialVersionUID = 1L;

        public EditExtensionLaunchAction(Frame frame, File extension, File module) {
            super(Resources.getString("Editor.edit_extension"), frame, Editor.class.getName(), new LaunchRequest(LaunchRequest.Mode.EDIT_EXT, module, extension));
            this.setEnabled(!EditExtensionLaunchAction.isInUse(module) && !EditExtensionLaunchAction.isInUse(extension));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EditExtensionLaunchAction.isInUse(this.lr.module) || EditExtensionLaunchAction.isInUse(this.lr.extension)) {
                return;
            }
            EditExtensionLaunchAction.incrementUsed(this.lr.module);
            EditExtensionLaunchAction.markEditing(this.lr.module);
            super.actionPerformed(e);
            this.setEnabled(false);
        }

        @Override
        protected void addFileFilters(FileChooser fc) {
            fc.addChoosableFileFilter(new ModuleExtensionFileFilter());
        }

        @Override
        protected AbstractLaunchAction.LaunchTask getLaunchTask() {
            return new AbstractLaunchAction.LaunchTask(){

                @Override
                protected void done() {
                    super.done();
                    AbstractLaunchAction.decrementUsed(this.lr.module);
                    AbstractLaunchAction.unmarkEditing(this.lr.extension);
                    this.setEnabled(true);
                }
            };
        }
    }

    private class NewExtensionLaunchAction
    extends AbstractLaunchAction {
        private static final long serialVersionUID = 1L;

        public NewExtensionLaunchAction(Frame frame) {
            super(Resources.getString("ModuleManager.new_extension"), frame, Editor.class.getName(), new LaunchRequest(LaunchRequest.Mode.NEW_EXT));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.lr.module = ModuleManagerWindow.this.getSelectedModule();
            if (NewExtensionLaunchAction.isEditing(this.lr.module)) {
                return;
            }
            NewExtensionLaunchAction.incrementUsed(this.lr.module);
            super.actionPerformed(e);
        }

        @Override
        protected AbstractLaunchAction.LaunchTask getLaunchTask() {
            return new AbstractLaunchAction.LaunchTask(){

                @Override
                protected void done() {
                    super.done();
                    AbstractLaunchAction.decrementUsed(this.lr.module);
                }
            };
        }
    }
}

