/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.configure.PropertyExpression;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.script.AbstractInterpreter;
import VASSAL.script.expression.ExpressionException;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.WarningDialog;
import bsh.BeanShellExpressionValidator;
import bsh.EvalError;
import bsh.NameSpace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionInterpreter
extends AbstractInterpreter
implements RecursionLimiter.Loopable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ExpressionInterpreter.class);
    protected static final String INIT_SCRIPT = "/VASSAL/script/init_expression.bsh";
    protected static final String THIS = "_interp";
    protected static final String SOURCE = "_source";
    protected static final String MAGIC1 = "_xyzzy";
    protected static final String MAGIC2 = "_plugh";
    protected static final String MAGIC3 = "_plover";
    protected static NameSpace topLevelNameSpace;
    protected NameSpace expressionNameSpace;
    protected String expression;
    protected List<String> variables;
    protected List<String> stringVariables;
    protected PropertySource source;

    @Override
    public String getComponentTypeName() {
        return Resources.getString("Editor.ExpressionInterpreter.component_type");
    }

    @Override
    public String getComponentName() {
        return Resources.getString("Editor.ExpressionInterpreter.component_type");
    }

    protected static String strip(String expr) {
        String s = expr.trim();
        if (s.startsWith("{") && s.endsWith("}")) {
            return s.substring(1, s.length() - 1);
        }
        return expr;
    }

    public ExpressionInterpreter(String expr) throws ExpressionException {
        this.expression = expr == null ? "" : ExpressionInterpreter.strip(expr);
        this.setClassLoader(this.getClass().getClassLoader());
        if (topLevelNameSpace == null) {
            this.initialiseStatic();
        }
        this.expressionNameSpace = new NameSpace(topLevelNameSpace, "expression");
        BeanShellExpressionValidator validator = new BeanShellExpressionValidator(this.expression);
        this.variables = validator.getVariables();
        this.stringVariables = validator.getStringVariables();
        this.setNameSpace(this.expressionNameSpace);
        if (this.expression.length() > 0) {
            try {
                StringBuilder argList = new StringBuilder();
                for (String variable : this.stringVariables) {
                    if (argList.length() > 0) {
                        argList.append(',');
                    }
                    argList.append("String ").append(variable);
                }
                this.eval("String _plugh(" + argList.toString() + ") { _plover=" + this.expression + "; return _plover.toString();}");
            }
            catch (EvalError e) {
                throw new ExpressionException(this.getExpression());
            }
        }
        this.setVar(THIS, this);
    }

    protected void initialiseStatic() {
        topLevelNameSpace = new NameSpace(null, this.getClassManager(), "topLevel");
        this.setNameSpace(topLevelNameSpace);
        this.getNameSpace().importClass("VASSAL.build.module.properties.PropertySource");
        this.getNameSpace().importClass("VASSAL.script.ExpressionInterpreter");
        URL ini = this.getClass().getResource(INIT_SCRIPT);
        logger.info("Attempting to load /VASSAL/script/init_expression.bsh URI generated=" + ini);
        try (InputStream is = ini.openStream();
             InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader in = new BufferedReader(isr);){
            try {
                this.eval(in);
            }
            catch (EvalError e) {
                logger.error("Error trying to read init script: " + ini);
                WarningDialog.show(e, "", new Object[0]);
            }
        }
        catch (IOException e) {
            logger.error("Error trying to read init script: " + ini);
            WarningDialog.show(e, "", new Object[0]);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public String evaluate(PropertySource ps) throws ExpressionException {
        return this.evaluate(ps, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String evaluate(PropertySource ps, boolean localized) throws ExpressionException {
        String result;
        if (this.getExpression().length() == 0) {
            return "";
        }
        try {
            RecursionLimiter.startExecution(this);
            this.source = ps == null ? GameModule.getGameModule() : ps;
            this.setNameSpace(this.expressionNameSpace);
            for (String string : this.variables) {
                String value;
                String name = string;
                if (name.length() > 2 && name.startsWith("$") && name.endsWith("$")) {
                    name = name.substring(1, name.length() - 1);
                }
                Object prop = localized ? this.source.getLocalizedProperty(name) : this.source.getProperty(name);
                String string2 = value = prop == null ? "" : prop.toString();
                if (value == null) {
                    this.setVar(string, "");
                    continue;
                }
                if ("true".equals(value)) {
                    this.setVar(string, true);
                    continue;
                }
                if ("false".equals(value)) {
                    this.setVar(string, false);
                    continue;
                }
                if (!StringUtils.containsOnly((CharSequence)value, (String)"+-.0123456789")) {
                    this.setVar(string, value);
                    continue;
                }
                try {
                    this.setVar(string, Integer.parseInt(value));
                }
                catch (NumberFormatException ex1) {
                    try {
                        this.setVar(string, Float.parseFloat(value));
                    }
                    catch (NumberFormatException ex2) {
                        this.setVar(string, value);
                    }
                }
            }
            StringBuilder argList = new StringBuilder();
            for (String var : this.stringVariables) {
                if (argList.length() > 0) {
                    argList.append(',');
                }
                Object value = localized ? this.source.getLocalizedProperty(var) : this.source.getProperty(var);
                argList.append('\"').append(value == null ? "" : value.toString()).append('\"');
            }
            this.setVar(THIS, this);
            this.setVar(SOURCE, this.source);
            try {
                this.eval("_xyzzy=_plugh(" + argList.toString() + ")");
                result = this.get(MAGIC1).toString();
            }
            catch (EvalError evalError) {
                String s = evalError.getRawMessage();
                String search = "_plugh();'' : ";
                int pos = s.indexOf("_plugh();'' : ");
                throw new ExpressionException(this.getExpression(), s.substring(pos + "_plugh();'' : ".length()));
            }
        }
        catch (RecursionLimitException e) {
            result = "";
            ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.possible_infinite_expression_loop"), this.getExpression(), e));
        }
        finally {
            RecursionLimiter.endExecution();
            this.source = null;
        }
        return result;
    }

    public String evaluate() throws ExpressionException {
        return this.getExpression().length() == 0 ? "" : this.evaluate(GameModule.getGameModule());
    }

    public Object wrap(String value) {
        if (value == null) {
            return "";
        }
        if ("true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value)) {
            return Boolean.FALSE;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return value;
        }
    }

    public Object getProperty(String name) {
        Object value = this.source.getProperty(name);
        return value == null ? "" : this.wrap(value.toString());
    }

    public Object getLocalizedProperty(String name) {
        Object value = this.source.getLocalizedProperty(name);
        return value == null ? "" : this.wrap(value.toString());
    }

    public Object getZoneProperty(String propertyName, String zoneName) {
        Zone zone;
        Map map;
        if (this.source instanceof GamePiece && (map = ((GamePiece)this.source).getMap()) != null && (zone = map.findZone(zoneName)) != null) {
            return this.wrap((String)zone.getProperty(propertyName));
        }
        return this.wrap("");
    }

    public Object getZoneProperty(String propertyName, String zoneName, String mapName) {
        Zone zone;
        Map map = this.findVassalMap(mapName);
        if (map != null && (zone = map.findZone(zoneName)) != null) {
            return this.wrap((String)zone.getProperty(propertyName));
        }
        return this.wrap("");
    }

    public Object getMapProperty(String propertyName, String mapName) {
        Map map = this.findVassalMap(mapName);
        return map == null ? this.wrap("") : this.wrap((String)map.getProperty(propertyName));
    }

    public Object sumStack(String property, PropertySource ps) {
        int result = 0;
        if (ps instanceof GamePiece) {
            Stack s = ((GamePiece)ps).getParent();
            if (s == null) {
                try {
                    result += Integer.parseInt(ps.getProperty(property).toString());
                }
                catch (Exception exception) {}
            } else {
                for (GamePiece gamePiece : s.asList()) {
                    try {
                        result += Integer.parseInt(gamePiece.getProperty(property).toString());
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return result;
    }

    public Object sumLocation(String property, PropertySource ps) {
        GamePiece p;
        Map m;
        int result = 0;
        if (ps instanceof GamePiece && (m = (p = (GamePiece)ps).getMap()) != null) {
            GamePiece[] pieces;
            String here = m.locationName(p.getPosition());
            for (GamePiece piece : pieces = m.getPieces()) {
                if (!here.equals(m.locationName(piece.getPosition()))) continue;
                if (piece instanceof Stack) {
                    Stack s = (Stack)piece;
                    for (GamePiece gamePiece : s.asList()) {
                        try {
                            result += Integer.parseInt(gamePiece.getProperty(property).toString());
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    continue;
                }
                try {
                    result += Integer.parseInt(piece.getProperty(property).toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public Object random(Object src, Object minString, Object maxString) {
        int min = this.parseInt(src, "Random", minString, 1);
        int max = this.parseInt(src, "Random", maxString, 1);
        if (max < min) {
            max = min;
        }
        if (min == max) {
            return min;
        }
        int range = max - min + 1;
        return GameModule.getGameModule().getRNG().nextInt(range) + min;
    }

    public Object isRandom(Object src, Object percentString) {
        int r;
        int percent = this.parseInt(src, "IsRandom", percentString, 50);
        if (percent < 0) {
            percent = 0;
        }
        if (percent > 100) {
            percent = 100;
        }
        return (r = GameModule.getGameModule().getRNG().nextInt(100) + 1) <= percent;
    }

    private int parseInt(Object src, String function, Object value, int dflt) {
        int result = dflt;
        try {
            result = Integer.parseInt(value.toString());
        }
        catch (Exception e) {
            String message = "Illegal number in call to Beanshell function " + function + ". " + (String)(src instanceof Decorator ? "Piece= [" + ((Decorator)src).getProperty("BasicName") + "]. " : "");
            String data = "Data=[" + value.toString() + "].";
            ErrorDialog.dataWarning(new BadDataReport(message, data, e));
        }
        return result;
    }

    public Object sum(Object src, Object propertyName, Object propertyMatch) {
        return this.sum(src, propertyName, propertyMatch, null);
    }

    public Object sum(Object src, Object propertyName, Object propertyMatch, Object mapName) {
        int result = 0;
        if (!(src instanceof GamePiece)) {
            return 0;
        }
        if (!(propertyName instanceof String)) {
            return 0;
        }
        if (propertyMatch != null && !(propertyMatch instanceof String)) {
            return 0;
        }
        if (mapName != null && !(mapName instanceof String)) {
            return 0;
        }
        GamePiece sourcePiece = (GamePiece)src;
        String matchString = this.replaceDollarVariables((String)propertyMatch, sourcePiece);
        PieceFilter filter = matchString == null ? null : new PropertyExpression(this.unescape(matchString)).getFilter(sourcePiece);
        for (Map map : this.getMapList(mapName, sourcePiece)) {
            for (GamePiece piece : map.getAllPieces()) {
                if (piece instanceof Stack) {
                    for (GamePiece p : ((Stack)piece).asList()) {
                        result += this.getIntPropertyValue(p, filter, (String)propertyName);
                    }
                    continue;
                }
                result += this.getIntPropertyValue(piece, filter, (String)propertyName);
            }
        }
        return result;
    }

    private int getIntPropertyValue(GamePiece piece, PieceFilter filter, String propertyName) {
        if (filter == null || filter.accept(piece)) {
            try {
                return Integer.parseInt((String)piece.getProperty(propertyName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public Object count(Object src, Object propertyMatch) {
        return this.count(src, propertyMatch, null);
    }

    public Object count(Object src, Object propertyMatch, Object mapName) {
        if (!(src instanceof GamePiece)) {
            return 0;
        }
        if (propertyMatch != null && !(propertyMatch instanceof String)) {
            return 0;
        }
        if (mapName != null && !(mapName instanceof String)) {
            return 0;
        }
        GamePiece sourcePiece = (GamePiece)src;
        String matchString = this.replaceDollarVariables((String)propertyMatch, sourcePiece);
        PieceFilter filter = matchString == null ? null : new PropertyExpression(this.unescape(matchString)).getFilter(sourcePiece);
        int result = 0;
        for (Map map : this.getMapList(mapName, sourcePiece)) {
            for (GamePiece piece : map.getAllPieces()) {
                if (piece instanceof Stack) {
                    for (GamePiece p : ((Stack)piece).asList()) {
                        if (filter != null && !filter.accept(p)) continue;
                        ++result;
                    }
                    continue;
                }
                if (filter != null && !filter.accept(piece)) continue;
                ++result;
            }
        }
        return result;
    }

    private String unescape(String expr) {
        return expr.replace("\\\"", "\"");
    }

    private List<Map> getMapList(Object mapName, GamePiece sourcePiece) {
        List<Map> maps;
        if (mapName == null) {
            maps = Map.getMapList();
        } else {
            maps = new ArrayList<Map>();
            if (sourcePiece != null && sourcePiece.getMap().getMapName().equals(mapName)) {
                maps.add(sourcePiece.getMap());
            } else {
                for (Map map : Map.getMapList()) {
                    if (!map.getMapName().equals(mapName)) continue;
                    maps.add(map);
                    break;
                }
            }
        }
        return maps;
    }

    private Map findVassalMap(String mapName) {
        for (Map map : Map.getMapList()) {
            if (!map.getMapName().equals(mapName)) continue;
            return map;
        }
        return null;
    }

    private String replaceDollarVariables(String expression, GamePiece src) {
        if (expression == null || !expression.contains("$")) {
            return expression;
        }
        StringBuilder buffer = new StringBuilder();
        int state = 0;
        StringBuilder propertyName = new StringBuilder();
        block4: for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '$') {
                        state = 1;
                        propertyName.setLength(0);
                        continue block4;
                    }
                    buffer.append(c);
                    continue block4;
                }
                case 1: {
                    if (c == '$') {
                        String propertyValue;
                        String propName = propertyName.toString();
                        Object prop = src == null ? null : src.getLocalizedProperty(propName);
                        String string = propertyValue = prop == null ? null : prop.toString();
                        if (propertyValue == null) {
                            buffer.append('$');
                            buffer.append((CharSequence)propertyName);
                            propertyName.setLength(0);
                            state = 1;
                            continue block4;
                        }
                        buffer.append(propertyValue);
                        state = 0;
                        continue block4;
                    }
                    propertyName.append(c);
                }
            }
        }
        if (state == 1) {
            buffer.append('$');
            buffer.append((CharSequence)propertyName);
        }
        return buffer.toString();
    }
}

