/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script.expression;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.counters.PieceFilter;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.BeanShellExpression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.script.expression.FormattedStringExpression;
import VASSAL.script.expression.IntExpression;
import VASSAL.script.expression.NullExpression;
import VASSAL.script.expression.PropertyMatchExpression;
import VASSAL.script.expression.SinglePropertyExpression;
import VASSAL.script.expression.StringExpression;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.concurrent.ConcurrentSoftHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public class Expression {
    protected static final Map<Pair<Object, Class<? extends Expression>>, Expression> CACHE = new ConcurrentSoftHashMap<Pair<Object, Class<? extends Expression>>, Expression>();
    private final String expr;

    protected Expression(String s) {
        this.expr = s;
    }

    public String getExpression() {
        return this.expr;
    }

    public void setExpression(String s) {
        throw new UnsupportedOperationException();
    }

    protected void reset() {
    }

    public String evaluate(PropertySource ps, Map<String, String> properties, boolean localized) throws ExpressionException {
        return this.expr;
    }

    public String evaluate() throws ExpressionException {
        return this.evaluate(null, null, false);
    }

    public String evaluate(PropertySource ps) throws ExpressionException {
        return this.evaluate(ps, null, false);
    }

    public String evaluate(PropertySource ps, boolean localized) throws ExpressionException {
        return this.evaluate(ps, null, localized);
    }

    public String evaluate(boolean localized) throws ExpressionException {
        return this.evaluate(null, null, localized);
    }

    protected void handleError(ExpressionException e) {
        ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.expression_error"), "Expression=" + this.getExpression() + ", Error=" + e.getError(), e));
    }

    public String tryEvaluate(PropertySource ps) {
        return this.tryEvaluate(ps, null, false);
    }

    public String tryEvaluate() {
        return this.tryEvaluate(null, null, false);
    }

    public String tryEvaluate(PropertySource ps, boolean localized) {
        return this.tryEvaluate(ps, null, localized);
    }

    public String tryEvaluate(boolean localized) {
        return this.tryEvaluate(null, null, localized);
    }

    public String tryEvaluate(PropertySource ps, Map<String, String> properties, boolean localized) {
        try {
            return this.evaluate(ps, properties, localized);
        }
        catch (ExpressionException e) {
            this.handleError(e);
            return null;
        }
    }

    public PieceFilter getFilter(PropertySource ps) {
        return piece -> true;
    }

    public PieceFilter getFilter() {
        return this.getFilter(GameModule.getGameModule());
    }

    public String toBeanShellString() {
        return this.expr;
    }

    public static Expression createExpression(String s) {
        if (s == null || s.isBlank()) {
            return NullExpression.instance();
        }
        String t = s.trim();
        if (t.startsWith("{") && t.endsWith("}")) {
            return BeanShellExpression.createExpression(s);
        }
        try {
            return IntExpression.instance(Integer.parseInt(t));
        }
        catch (NumberFormatException numberFormatException) {
            if (t.indexOf(36) >= 0) {
                return FormattedStringExpression.instance(t);
            }
            return StringExpression.instance(s);
        }
    }

    public int hashCode() {
        return this.expr == null ? 0 : this.expr.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Expression other = (Expression)obj;
        return Objects.equals(this.expr, other.expr);
    }

    public static Expression createPropertyExpression(String s) {
        if (s == null || s.isBlank()) {
            return NullExpression.instance();
        }
        String t = s.trim();
        if (t.startsWith("{") && t.endsWith("}")) {
            return BeanShellExpression.instance(t.substring(1, t.length() - 1));
        }
        return PropertyMatchExpression.instance(t);
    }

    public static Expression createSimplePropertyExpression(String s) {
        if (s == null || s.isBlank()) {
            return NullExpression.instance();
        }
        String t = s.trim();
        if (t.startsWith("{") && t.endsWith("}")) {
            return BeanShellExpression.instance(t.substring(1, t.length() - 1));
        }
        return SinglePropertyExpression.instance(t);
    }

    public static void resetCachedExpressions() {
        CACHE.values().forEach(Expression::reset);
    }
}

