/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.counters.EditablePiece;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.concurrent.ConcurrentSoftHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public class FormattedString
implements RecursionLimiter.Loopable {
    private static final Map<Pair<String, PropertySource>, FSData> CACHE = new ConcurrentSoftHashMap<Pair<String, PropertySource>, FSData>();
    private FSData fsdata;
    protected Map<String, String> props;

    private static FSData dataOf(String fs, PropertySource dp) {
        return CACHE.computeIfAbsent((Pair<String, PropertySource>)Pair.of((Object)fs, (Object)dp), p -> new FSData((String)p.getLeft(), (PropertySource)p.getRight()));
    }

    public FormattedString() {
        this("");
    }

    public FormattedString(String s) {
        this(s, GameModule.getGameModule());
    }

    public FormattedString(PropertySource defaultProperties) {
        this("", defaultProperties);
    }

    public FormattedString(String formatString, PropertySource defaultProperties) {
        this.fsdata = FormattedString.dataOf(formatString, defaultProperties);
    }

    public void setFormat(String fs) {
        this.fsdata = FormattedString.dataOf(fs, this.fsdata.defaultProperties);
    }

    public String getFormat() {
        return this.fsdata.formatString;
    }

    public void setProperty(String name, String value) {
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        this.props.put(name.intern(), value != null ? value.intern() : null);
    }

    public void clearProperties() {
        if (this.props != null) {
            this.props.clear();
        }
    }

    public void setDefaultProperties(PropertySource defaultProperties) {
        this.fsdata = FormattedString.dataOf(this.fsdata.formatString, defaultProperties);
    }

    public PropertySource getDefaultProperties() {
        return this.fsdata.defaultProperties;
    }

    public String getText() {
        return this.getText(this.fsdata.defaultProperties, false);
    }

    public String getLocalizedText() {
        return this.getText(this.fsdata.defaultProperties, true);
    }

    public String getText(PropertySource ps) {
        return this.getText(ps, false);
    }

    public String getText(PropertySource ps, String def) {
        String s = this.getText(ps, false);
        if (s == null || s.length() == 0) {
            s = def;
        }
        return s;
    }

    public String getLocalizedText(PropertySource ps) {
        return this.getText(ps, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getText(PropertySource ps, boolean localized) {
        PropertySource source = ps == null ? this.fsdata.defaultProperties : ps;
        try {
            RecursionLimiter.startExecution(this);
            try {
                String string = this.fsdata.format.evaluate(source, this.props, localized);
                return string;
            }
            catch (ExpressionException e) {
                String string;
                try {
                    String msg = Resources.getString("Error.expression_error");
                    String exp = this.fsdata.format.getExpression();
                    BadDataReport bdr = source instanceof EditablePiece ? new BadDataReport((EditablePiece)source, msg, exp, (Throwable)e) : (source instanceof AbstractConfigurable ? new BadDataReport((AbstractConfigurable)((Object)source), msg, exp, (Throwable)e) : new BadDataReport(msg, exp, e));
                    ErrorDialog.dataWarning(bdr);
                    string = "";
                }
                catch (RecursionLimitException e2) {
                    ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.possible_infinite_string_loop"), this.fsdata.format.getExpression(), e2));
                    String string2 = "";
                    return string2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                RecursionLimiter.endExecution();
                return string;
            }
        }
        finally {
            RecursionLimiter.endExecution();
        }
    }

    public int getTextAsInt(PropertySource ps, String description, EditablePiece source) {
        int result = 0;
        String value = this.getText(ps, "0");
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            ErrorDialog.dataWarning(new BadDataReport(source, Resources.getString("Error.non_number_error"), FormattedString.debugInfo(this, value, description), (Throwable)e));
        }
        return result;
    }

    public int getTextAsInt(PropertySource ps, String description, AbstractConfigurable source) {
        int result = 0;
        String value = this.getText(ps, "0");
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            ErrorDialog.dataWarning(new BadDataReport(source, Resources.getString("Error.non_number_error"), FormattedString.debugInfo(this, value, description), (Throwable)e));
        }
        return result;
    }

    public static String debugInfo(FormattedString fs, String value, String description) {
        return description + (String)(value.equals(fs.getFormat()) ? "" : "[" + fs.getFormat() + "]") + "=" + value;
    }

    public String debugInfo(String value, String description) {
        return FormattedString.debugInfo(this, value, description);
    }

    public int hashCode() {
        return this.fsdata.formatString == null ? 0 : this.fsdata.formatString.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FormattedString other = (FormattedString)obj;
        return Objects.equals(this.fsdata.formatString, other.fsdata.formatString);
    }

    @Override
    public String getComponentTypeName() {
        return Resources.getString("Editor.FormattedString.component_type");
    }

    @Override
    public String getComponentName() {
        return Resources.getString("Editor.FormattedString.component_type");
    }

    private static class FSData {
        public final String formatString;
        public final Expression format;
        public final PropertySource defaultProperties;

        public FSData(String fs, PropertySource dp) {
            this.formatString = fs;
            this.format = Expression.createExpression(fs);
            this.defaultProperties = dp;
        }
    }
}

