/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Random;

public class HTTPPostBuilder {
    private final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
    private final BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)this.bytes, StandardCharsets.UTF_8));
    private final String boundary = "---------------------------" + HTTPPostBuilder.randomString() + HTTPPostBuilder.randomString() + HTTPPostBuilder.randomString();
    private static final String endl = "\r\n";
    private static final Random rng = new Random();

    private static String randomString() {
        return Long.toString(rng.nextLong(), 36);
    }

    public void setParameter(String name, String value) throws IOException {
        this.bw.append("--").append(this.boundary).append(endl).append("Content-Disposition: form-data; name=\"").append(name).append('\"').append(endl).append(endl).append(value).append(endl);
    }

    public void setParameter(String name, File file) throws IOException {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            this.setParameter(name, file.getPath(), in);
        }
    }

    public void setParameter(String name, String filename, InputStream in) throws IOException {
        this.writeCommonFileHeaders(name, filename);
        String type = HttpURLConnection.guessContentTypeFromName(filename);
        this.bw.append(type == null ? "application/octet-stream" : type).append(endl).append(endl);
        this.bw.flush();
        in.transferTo(this.bytes);
        this.bw.append(endl);
    }

    public void setParameter(String name, String filename, String contents) throws IOException {
        this.writeCommonFileHeaders(name, filename);
        this.bw.append("text/plain; charset=\"UTF-8\"").append(endl).append(endl).append(contents).append(endl);
    }

    private void writeCommonFileHeaders(String name, String filename) throws IOException {
        this.bw.append("--").append(this.boundary).append(endl).append("Content-Disposition: form-data; name=\"").append(name).append("\"; filename=\"").append(filename).append(endl).append("Content-Type: ");
    }

    private void writeEnd() throws IOException {
        this.bw.append("--").append(this.boundary).append("--").append(endl);
        this.bw.close();
    }

    public InputStream post(String url) throws IOException {
        return this.post(new URL(url));
    }

    public InputStream post(URL url) throws IOException {
        this.writeEnd();
        HttpURLConnection http = (HttpURLConnection)url.openConnection();
        http.setRequestMethod("POST");
        http.setDoInput(true);
        http.setDoOutput(true);
        http.setUseCaches(false);
        http.setAllowUserInteraction(false);
        http.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        http.setRequestProperty("Content-Length", String.valueOf(this.bytes.size()));
        try (OutputStream out = http.getOutputStream();){
            this.bytes.writeTo(out);
        }
        return http.getInputStream();
    }
}

