/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.DataArchive;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.NoSuchFileException;

public class JarArchive
extends DataArchive {
    protected String prefix;

    public JarArchive() {
        this((String)null);
    }

    public JarArchive(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public URL getURL(String fileName) throws IOException {
        URL url = this.getClass().getResource(this.getAbsolutePath(fileName));
        if (url != null) {
            return url;
        }
        for (DataArchive ext : this.extensions) {
            try {
                return ext.getURL(fileName);
            }
            catch (FileNotFoundException | NoSuchFileException iOException) {
            }
        }
        throw new FileNotFoundException("'" + fileName + "' not found in " + this.getName());
    }

    @Override
    public InputStream getInputStream(String fileName) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(this.getAbsolutePath(fileName));
        if (in != null) {
            return in;
        }
        for (DataArchive ext : this.extensions) {
            try {
                return ext.getInputStream(fileName);
            }
            catch (FileNotFoundException | NoSuchFileException iOException) {
            }
        }
        throw new FileNotFoundException(String.format("'%s' not found in %s", fileName, this.getName()));
    }

    protected String getAbsolutePath(String file) {
        return (String)(this.prefix != null ? "/" + this.prefix : "") + "/" + file;
    }

    @Override
    public String getName() {
        return this.prefix != null ? this.prefix : super.getName();
    }

    @Override
    @Deprecated(since="2020-08-06", forRemoval=true)
    public InputStream getFileStream(String fileName) throws IOException {
        return this.getInputStream(fileName);
    }
}

