/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.IteratorUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="2020-08-05", forRemoval=true)
public class ZipUpdater
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ZipUpdater.class);
    public static final String CHECKSUM_RESOURCE = "checksums";
    public static final String TARGET_ARCHIVE = "target";
    public static final String UPDATED_ARCHIVE_NAME = "finalName";
    public static final String ENTRIES_DIR = "entries/";
    private File oldFile;
    private ZipFile oldZipFile;
    private Properties checkSums;
    private String fileName;
    private Exception error;

    public ZipUpdater(File input) throws IOException {
        this.oldFile = input;
        if (!this.oldFile.exists()) {
            throw new IOException("Could not find file " + input.getPath());
        }
    }

    private long getCrc(ZipFile file, ZipEntry entry) throws IOException {
        long crc = -1L;
        if (entry != null && (crc = entry.getCrc()) < 0L) {
            CRC32 checksum = new CRC32();
            try (InputStream in = file.getInputStream(entry);){
                int count;
                byte[] buffer = new byte[1024];
                while ((count = in.read(buffer)) >= 0) {
                    checksum.update(buffer, 0, count);
                }
                crc = checksum.getValue();
            }
        }
        return crc;
    }

    private long copyEntry(ZipOutputStream output, ZipEntry newEntry) throws IOException {
        try (InputStream in = this.oldZipFile.getInputStream(new ZipEntry(newEntry.getName()));){
            long l = this.writeEntry(in, output, newEntry);
            return l;
        }
    }

    private long replaceEntry(ZipOutputStream output, ZipEntry newEntry) throws IOException {
        String r = "/entries/" + newEntry.getName();
        try (InputStream newContents = this.getClass().getResourceAsStream(r);){
            long l;
            if (newContents == null) {
                throw new IOException("This updater was created with an original that differs from the file you're trying to update.\nLocal entry does not match original:  " + newEntry.getName());
            }
            try (BufferedInputStream in = new BufferedInputStream(newContents);){
                l = this.writeEntry(in, output, newEntry);
            }
            return l;
        }
    }

    private long writeEntry(InputStream zis, ZipOutputStream output, ZipEntry newEntry) throws IOException {
        byte[] contents = zis.readAllBytes();
        CRC32 checksum = new CRC32();
        checksum.update(contents);
        if (newEntry.getMethod() == 0) {
            newEntry.setSize(contents.length);
            newEntry.setCrc(checksum.getValue());
        }
        output.putNextEntry(newEntry);
        output.write(contents, 0, contents.length);
        return checksum.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File destination) throws IOException {
        this.checkSums = new Properties();
        try (InputStream rin = ZipUpdater.class.getResourceAsStream("/checksums");){
            if (rin == null) {
                throw new IOException("Resource not found: checksums");
            }
            try (BufferedInputStream in = new BufferedInputStream(rin);){
                this.checkSums.load(in);
            }
        }
        File tempFile = File.createTempFile("VSL", ".zip");
        try (ZipFile ozf = new ZipFile(this.oldFile.getPath());){
            this.oldZipFile = ozf;
            ZipOutputStream output = new ZipOutputStream(Files.newOutputStream(tempFile.toPath(), new OpenOption[0]));
            try {
                for (String entryName : this.checkSums.stringPropertyNames()) {
                    long targetSum;
                    try {
                        targetSum = Long.parseLong(this.checkSums.getProperty(entryName, "<none>"));
                    }
                    catch (NumberFormatException invalid) {
                        throw new IOException("Invalid checksum " + this.checkSums.getProperty(entryName, "<none>") + " for entry " + entryName);
                    }
                    ZipEntry entry = this.oldZipFile.getEntry(entryName);
                    ZipEntry newEntry = new ZipEntry(entryName);
                    newEntry.setMethod(entry != null ? entry.getMethod() : 8);
                    if (!(targetSum == this.getCrc(this.oldZipFile, entry) ? targetSum != this.copyEntry(output, newEntry) : targetSum != this.replaceEntry(output, newEntry))) continue;
                    throw new IOException("Checksum mismatch for entry " + entry.getName());
                }
            }
            finally {
                try {
                    output.close();
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
        if (destination.getName().equals(this.oldFile.getName())) {
            String backup;
            String updatedName = destination.getName();
            int index = updatedName.lastIndexOf(46);
            String string = backup = index < 0 || index == updatedName.length() - 1 ? updatedName + "Backup" : updatedName.substring(0, index) + "Backup" + updatedName.substring(index);
            if (!this.oldFile.renameTo(new File(backup))) {
                throw new IOException("Unable to create backup file " + backup + ".\nUpdated file is in " + tempFile.getPath());
            }
        }
        if (!tempFile.renameTo(destination)) {
            throw new IOException("Unable to write to file " + destination.getPath() + ".\nUpdated file is in " + tempFile.getPath());
        }
    }

    public void createUpdater(File newFile) throws IOException {
        String inputArchiveName = this.oldFile.getName();
        int index = inputArchiveName.indexOf(46);
        String jarName = index >= 0 ? "update" + inputArchiveName.substring(0, index) + ".jar" : "update" + inputArchiveName;
        this.createUpdater(newFile, new File(jarName));
    }

    public void createUpdater(File newFile, File updaterFile) throws IOException {
        if (!updaterFile.getName().endsWith(".jar")) {
            String newName = updaterFile.getName().replace('.', '_') + ".jar";
            updaterFile = new File(updaterFile.getParentFile(), newName);
        }
        this.checkSums = new Properties();
        try (ZipFile ozf = new ZipFile(this.oldFile);){
            this.oldZipFile = ozf;
            String inputArchiveName = this.oldFile.getName();
            try (ZipFile goal = new ZipFile(newFile);
                 OutputStream fout = Files.newOutputStream(updaterFile.toPath(), new OpenOption[0]);
                 BufferedOutputStream bout = new BufferedOutputStream(fout);
                 JarOutputStream out = new JarOutputStream(bout);){
                for (ZipEntry zipEntry : IteratorUtils.iterate(goal.entries().asIterator())) {
                    long inputCrc;
                    long goalCrc = this.getCrc(goal, zipEntry);
                    if (goalCrc != (inputCrc = this.getCrc(this.oldZipFile, this.oldZipFile.getEntry(zipEntry.getName())))) {
                        ZipEntry outputEntry = new ZipEntry(ENTRIES_DIR + zipEntry.getName());
                        outputEntry.setMethod(zipEntry.getMethod());
                        try (InputStream inner = goal.getInputStream(zipEntry);
                             BufferedInputStream gis = new BufferedInputStream(inner);){
                            this.writeEntry(gis, out, outputEntry);
                        }
                    }
                    this.checkSums.put(zipEntry.getName(), Long.toString(goalCrc));
                }
                ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
                manifestEntry.setMethod(8);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Manifest-Version: 1.0\nMain-Class: VASSAL.tools.ZipUpdater\n");
                this.writeEntry(new ByteArrayInputStream(stringBuilder.toString().getBytes(StandardCharsets.UTF_8)), out, manifestEntry);
                ZipEntry nameEntry = new ZipEntry(TARGET_ARCHIVE);
                nameEntry.setMethod(8);
                this.writeEntry(new ByteArrayInputStream(inputArchiveName.getBytes(StandardCharsets.UTF_8)), out, nameEntry);
                ZipEntry updatedEntry = new ZipEntry(UPDATED_ARCHIVE_NAME);
                updatedEntry.setMethod(8);
                this.writeEntry(new ByteArrayInputStream(newFile.getName().getBytes(StandardCharsets.UTF_8)), out, updatedEntry);
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                this.checkSums.store(byteOut, null);
                ZipEntry sumEntry = new ZipEntry(CHECKSUM_RESOURCE);
                sumEntry.setMethod(8);
                this.writeEntry(new ByteArrayInputStream(byteOut.toByteArray()), out, sumEntry);
                String className = this.getClass().getName().replace('.', '/') + ".class";
                ZipEntry classEntry = new ZipEntry(className);
                classEntry.setMethod(8);
                try (InputStream is = this.getClass().getResourceAsStream("/" + className);){
                    if (is == null) {
                        throw new IOException("Resource not found: " + className);
                    }
                    try (BufferedInputStream in = new BufferedInputStream(is);){
                        this.writeEntry(in, out, classEntry);
                    }
                }
            }
        }
    }

    private ZipUpdater(String fileName, Exception error) {
        this.fileName = fileName;
        this.error = error;
    }

    @Override
    public void run() {
        JOptionPane.showMessageDialog(null, "Unable to update " + this.fileName + ".\n" + this.error.getMessage(), "Update failed", 0);
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block21: {
            String oldArchiveName = "<unknown>";
            try {
                if (args.length > 1) {
                    oldArchiveName = args[0];
                    String goal = args[1];
                    ZipUpdater updater = new ZipUpdater(new File(oldArchiveName));
                    updater.createUpdater(new File(goal));
                    break block21;
                }
                BufferedReader r = null;
                try {
                    r = new BufferedReader(new InputStreamReader(ZipUpdater.class.getResourceAsStream("/target")));
                    oldArchiveName = r.readLine();
                    r.close();
                }
                finally {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                try {
                    r = new BufferedReader(new InputStreamReader(ZipUpdater.class.getResourceAsStream("/finalName"), StandardCharsets.UTF_8));
                    String newArchiveName = r.readLine();
                    ZipUpdater updater = new ZipUpdater(new File(oldArchiveName));
                    updater.write(new File(newArchiveName));
                    r.close();
                }
                finally {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    SwingUtilities.invokeAndWait(new ZipUpdater(oldArchiveName, e));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }
}

