/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class FileUtils {
    private static final RoundingMode ROUNDING_MODE = RoundingMode.HALF_UP;

    public static String byteCountToDisplaySize(BigInteger fileSize) {
        String val;
        String unit = FileSize.BYTE.unit;
        BigDecimal fileSizeInUnit = BigDecimal.ZERO;
        for (FileSize fs : FileSize.values()) {
            BigDecimal size_bd = new BigDecimal(fileSize);
            fileSizeInUnit = size_bd.divide(new BigDecimal(fs.byteCount), 5, ROUNDING_MODE);
            if (fileSizeInUnit.compareTo(BigDecimal.ONE) < 0) continue;
            unit = fs.unit;
            break;
        }
        if ((val = fileSizeInUnit.divide(BigDecimal.valueOf(100.0), RoundingMode.DOWN).compareTo(BigDecimal.ONE) >= 0 ? fileSizeInUnit.setScale(0, ROUNDING_MODE).toString() : (fileSizeInUnit.divide(BigDecimal.valueOf(10.0), RoundingMode.DOWN).compareTo(BigDecimal.ONE) >= 0 ? fileSizeInUnit.setScale(1, ROUNDING_MODE).toString() : fileSizeInUnit.setScale(2, ROUNDING_MODE).toString())).endsWith(".00")) {
            val = val.substring(0, val.length() - 3);
        } else if (val.endsWith(".0")) {
            val = val.substring(0, val.length() - 2);
        }
        return String.format("%s %s", val, unit);
    }

    public static String byteCountToDisplaySize(long fileSize) {
        return FileUtils.byteCountToDisplaySize(BigInteger.valueOf(fileSize));
    }

    static enum FileSize {
        EXABYTE("EB", org.apache.commons.io.FileUtils.ONE_EB_BI),
        PETABYTE("PB", org.apache.commons.io.FileUtils.ONE_PB_BI),
        TERABYTE("TB", org.apache.commons.io.FileUtils.ONE_TB_BI),
        GIGABYTE("GB", org.apache.commons.io.FileUtils.ONE_GB_BI),
        MEGABYTE("MB", org.apache.commons.io.FileUtils.ONE_MB_BI),
        KILOBYTE("KB", org.apache.commons.io.FileUtils.ONE_KB_BI),
        BYTE("bytes", BigInteger.ONE);

        private final String unit;
        private final BigInteger byteCount;

        private FileSize(String unit, BigInteger byteCount) {
            this.unit = unit;
            this.byteCount = byteCount;
        }
    }
}

