/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipWriter
implements Closeable {
    private final Path full;
    private final Path part;
    private final ZipOutputStream zout;

    public ZipWriter(File f) throws IOException {
        this(Objects.requireNonNull(f).toPath());
    }

    public ZipWriter(Path p) throws IOException {
        this.full = Objects.requireNonNull(p);
        if (!Files.exists(this.full, new LinkOption[0])) {
            Files.createFile(this.full, new FileAttribute[0]);
        }
        this.part = this.full.resolveSibling(this.full.getFileName() + ".part");
        this.zout = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(this.part, new OpenOption[0])));
    }

    public void write(File src, String dst) throws IOException {
        this.write(src.toPath(), dst);
    }

    public void write(Path src, String dst) throws IOException {
        ZipEntry e = ZipWriter.makeEntry(dst);
        e.setTime(Files.getLastModifiedTime(src, new LinkOption[0]).toMillis());
        this.zout.putNextEntry(e);
        try (InputStream in = Files.newInputStream(src, new OpenOption[0]);){
            in.transferTo(this.zout);
        }
    }

    public void write(InputStream src, String dst) throws IOException {
        this.zout.putNextEntry(ZipWriter.makeEntry(dst));
        src.transferTo(this.zout);
    }

    public void write(byte[] src, String dst) throws IOException {
        this.zout.putNextEntry(ZipWriter.makeEntry(dst));
        this.zout.write(src, 0, src.length);
    }

    public OutputStream write(String dst) throws IOException {
        this.zout.putNextEntry(ZipWriter.makeEntry(dst));
        return new FilterOutputStream(this.zout){

            @Override
            public void write(int b) throws IOException {
                this.out.write(b);
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.out.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.zout.close();
        Files.move(this.part, this.full, StandardCopyOption.REPLACE_EXISTING);
    }

    private static ZipEntry makeEntry(String path) {
        ZipEntry e = new ZipEntry(path);
        e.setMethod(8);
        return e;
    }
}

