/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.swing;

import VASSAL.Info;
import VASSAL.tools.DataArchive;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataArchiveHTMLEditorKit
extends HTMLEditorKit {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DataArchiveHTMLEditorKit.class);
    private final DataArchive arch;

    public DataArchiveHTMLEditorKit(DataArchive arch) {
        this.arch = arch;
    }

    @Override
    public ViewFactory getViewFactory() {
        return new DataArchiveHTMLFactory();
    }

    private class DataArchiveHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        private DataArchiveHTMLFactory() {
        }

        @Override
        public View create(Element e) {
            String file;
            AttributeSet attrs = e.getAttributes();
            HTML.Tag kind = (HTML.Tag)attrs.getAttribute(StyleConstants.NameAttribute);
            if (kind == HTML.Tag.IMG && !(file = (String)attrs.getAttribute(HTML.Attribute.SRC)).isBlank() && !file.contains("/")) {
                return new DataArchiveImageView(e);
            }
            return super.create(e);
        }
    }

    private class DataArchiveImageView
    extends ImageView {
        public DataArchiveImageView(Element e) {
            super(e);
        }

        @Override
        public URL getImageURL() {
            String src = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
            URL url = null;
            Path out = Info.getTempDir().toPath().resolve(src);
            try {
                if (!Files.exists(out, new LinkOption[0])) {
                    try (InputStream in = DataArchiveHTMLEditorKit.this.arch.getInputStream("images/" + src);){
                        Files.copy(in, out, new CopyOption[0]);
                    }
                    out.toFile().deleteOnExit();
                }
                url = out.toUri().toURL();
            }
            catch (IOException e) {
                logger.error("Failed to load {}", (Object)src, (Object)e);
            }
            return url;
        }
    }
}

