/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Vector;
import org.litesoft.p2pchat.IllegalArgument;

public class PeerReader
extends Thread {
    private Vector<String> zLines = new Vector();
    private BufferedReader zReader;
    private boolean isOpen = true;

    public PeerReader(InputStream pIs) {
        IllegalArgument.ifNull("Is", pIs);
        this.zReader = new BufferedReader(new InputStreamReader(pIs, Charset.forName("UTF-8")));
        this.setName("Peer Reader Thread");
        this.start();
    }

    public synchronized void close() {
        this.isOpen = false;
        this.notifyAll();
    }

    public synchronized boolean isOpen() {
        return this.isOpen;
    }

    private synchronized void add(String pMessage) {
        if (this.isOpen) {
            this.zLines.addElement(pMessage);
        }
        this.notifyAll();
    }

    public synchronized String readLine() {
        while (this.isOpen && this.zLines.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        String message = null;
        if (this.isOpen && this.zLines.size() > 0) {
            message = this.zLines.elementAt(0);
            this.zLines.removeElementAt(0);
        }
        return message;
    }

    @Override
    public void run() {
        try {
            String line;
            while (null != (line = this.zReader.readLine())) {
                this.add(line);
                if (!line.equals("BYE")) continue;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isOpen = false;
        try {
            this.zReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

