/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractToolbarItem;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.TranslatableStringEnum;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.BooleanAndPieceFilter;
import VASSAL.counters.Decorator;
import VASSAL.counters.Embellishment;
import VASSAL.counters.GlobalCommand;
import VASSAL.counters.GlobalCommandTarget;
import VASSAL.counters.PieceFilter;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.ToolBarComponent;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.ArrayUtils;

public class MassKeyCommand
extends AbstractToolbarItem
implements RecursionLimiter.Loopable {
    public static final String DEPRECATED_NAME = "text";
    public static final String BUTTON_TEXT = "buttonText";
    public static final String HOTKEY = "buttonHotkey";
    public static final String KEY_COMMAND = "hotkey";
    public static final String AFFECTED_PIECE_NAMES = "names";
    public static final String PROPERTIES_FILTER = "filter";
    public static final String REPORT_SINGLE = "reportSingle";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String CONDITION = "condition";
    public static final String DECK_COUNT = "deckCount";
    private static final String IF_ACTIVE = "If layer is active";
    private static final String IF_INACTIVE = "If layer is inactive";
    private static final String ALWAYS = "Always";
    public static final String CHECK_PROPERTY = "property";
    public static final String CHECK_VALUE = "propValue";
    public static final String SINGLE_MAP = "singleMap";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String NAME = "name";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String ICON = "icon";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String TOOLTIP = "tooltip";
    @Deprecated(since="2020-10-21", forRemoval=true)
    protected LaunchButton launch;
    protected NamedKeyStroke stroke = NamedKeyStroke.NULL_KEYSTROKE;
    protected String[] names = new String[0];
    protected String condition;
    protected String checkProperty;
    protected String checkValue;
    protected PropertyExpression propertiesFilter = new PropertyExpression();
    protected PropertySource propertySource;
    protected PieceFilter filter;
    protected Map map;
    protected GlobalCommand globalCommand = new GlobalCommand(this);
    protected FormattedString reportFormat = new FormattedString();
    protected boolean singleMap = true;
    public static final String TARGET = "target";
    protected GlobalCommandTarget target = new GlobalCommandTarget(this.getGKCtype());

    public GlobalCommandTarget.GKCtype getGKCtype() {
        return GlobalCommandTarget.GKCtype.MAP;
    }

    public MassKeyCommand() {
        this.setButtonTextKey(BUTTON_TEXT);
        this.setHotKeyKey(HOTKEY);
        this.setLaunchButton(this.makeLaunchButton(Resources.getString("Editor.GlobalKeyCommand.button_name"), Resources.getString("Editor.GlobalKeyCommand.button_name"), "", e -> this.apply()));
        this.launch = this.getLaunchButton();
    }

    @Override
    public void addTo(Buildable parent) {
        if (parent instanceof Map) {
            this.map = (Map)parent;
        }
        if (parent instanceof ToolBarComponent) {
            ((ToolBarComponent)((Object)parent)).getToolBar().add(this.getLaunchButton());
        }
        if (parent instanceof PropertySource) {
            this.propertySource = (PropertySource)((Object)parent);
        }
        this.setAttributeTranslatable(NAME, false);
        this.globalCommand.setPropertySource(this.propertySource);
    }

    public void apply() {
        this.buildFilter();
        if (this.singleMap) {
            GameModule.getGameModule().sendAndLog(this.globalCommand.apply(this.map, this.getFilter(), this.target));
        } else {
            List<Map> l = Map.getMapList();
            GameModule.getGameModule().sendAndLog(this.globalCommand.apply(l.toArray(new Map[0]), this.getFilter(), this.target));
        }
    }

    public void setPropertySource(PropertySource source) {
        this.propertySource = source;
        this.globalCommand.setPropertySource(source);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeDescriptions() {
        if (this.condition == null) {
            return (String[])ArrayUtils.addAll((Object[])super.getAttributeDescriptions(), (Object[])new String[]{Resources.getString("Editor.GlobalKeyCommand.global_key_command"), Resources.getString("Editor.MassKey.counters"), Resources.getString("Editor.GlobalKeyCommand.pre_select"), Resources.getString("Editor.MassKey.match"), Resources.getString("Editor.GlobalKeyCommand.deck_policy"), Resources.getString("Editor.MassKey.suppress"), Resources.getString("Editor.report_format")});
        }
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeDescriptions(), (Object[])new String[]{Resources.getString("Editor.MassKey.key"), Resources.getString("Editor.MassKey.counters"), Resources.getString("Editor.GlobalKeyCommand.pre_select"), Resources.getString("Editor.MassKey.match"), Resources.getString("Editor.MassKey.deck_content"), Resources.getString("Editor.MassKey.suppress"), Resources.getString("Editor.report_format"), Resources.getString("Editor.MassKey.apply")});
    }

    @Override
    public String[] getAttributeNames() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeNames(), (Object[])new String[]{KEY_COMMAND, SINGLE_MAP, TARGET, PROPERTIES_FILTER, DECK_COUNT, REPORT_SINGLE, REPORT_FORMAT, CONDITION, CHECK_VALUE, CHECK_PROPERTY, AFFECTED_PIECE_NAMES});
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        if (this.condition == null) {
            return (Class[])ArrayUtils.addAll((Object[])super.getAttributeTypes(), (Object[])new Class[]{NamedKeyStroke.class, Boolean.class, GlobalCommandTarget.class, PropertyExpression.class, DeckPolicyConfig.class, Boolean.class, ReportFormatConfig.class});
        }
        return (Class[])ArrayUtils.addAll((Object[])super.getAttributeTypes(), (Object[])new Class[]{NamedKeyStroke.class, Boolean.class, GlobalCommandTarget.class, String.class, DeckPolicyConfig.class, Boolean.class, ReportFormatConfig.class, Prompt.class});
    }

    @Override
    public String getAttributeValueString(String key) {
        if (KEY_COMMAND.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.stroke);
        }
        if (AFFECTED_PIECE_NAMES.equals(key)) {
            return this.names == null || this.names.length == 0 ? null : StringArrayConfigurer.arrayToString(this.names);
        }
        if (CHECK_PROPERTY.equals(key)) {
            return this.propertiesFilter != null ? null : this.checkProperty;
        }
        if (CHECK_VALUE.equals(key)) {
            return this.propertiesFilter != null ? null : this.checkValue;
        }
        if (PROPERTIES_FILTER.equals(key)) {
            return this.propertiesFilter.getExpression();
        }
        if (CONDITION.equals(key)) {
            return ALWAYS.equals(this.condition) ? null : this.condition;
        }
        if (REPORT_SINGLE.equals(key)) {
            return String.valueOf(this.globalCommand.isReportSingle());
        }
        if (DECK_COUNT.equals(key)) {
            return String.valueOf(this.globalCommand.getSelectFromDeck());
        }
        if (REPORT_FORMAT.equals(key)) {
            return this.reportFormat.getFormat();
        }
        if (SINGLE_MAP.equals(key)) {
            return String.valueOf(this.singleMap);
        }
        if (TARGET.equals(key)) {
            return this.target.encode();
        }
        return super.getAttributeValueString(key);
    }

    public GlobalCommandTarget getTarget() {
        return this.target;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.GlobalkeyCommand.global_key_command");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.html", "GlobalKeyCommand");
    }

    @Override
    public void removeFrom(Buildable parent) {
        if (parent instanceof ToolBarComponent) {
            ((ToolBarComponent)((Object)parent)).getToolBar().remove(this.getLaunchButton());
        }
    }

    public PieceFilter getFilter() {
        this.buildFilter();
        return this.filter;
    }

    private void buildFilter() {
        if (this.checkValue != null) {
            this.propertiesFilter.setExpression(this.checkProperty + "=" + this.checkValue);
        }
        if (this.propertiesFilter != null) {
            this.filter = this.propertiesFilter.getFilter(this.propertySource);
        }
        if (this.filter != null && this.condition != null) {
            this.filter = new BooleanAndPieceFilter(this.filter, piece -> {
                boolean valid = false;
                if (ALWAYS.equals(this.condition)) {
                    valid = true;
                } else if (IF_ACTIVE.equals(this.condition)) {
                    valid = Embellishment.getLayerWithMatchingActivateCommand(piece, this.stroke, true) != null;
                } else if (IF_INACTIVE.equals(this.condition)) {
                    valid = Embellishment.getLayerWithMatchingActivateCommand(piece, this.stroke, false) != null;
                }
                return valid;
            });
        }
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String key) {
        return () -> true;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (DEPRECATED_NAME.equals(key)) {
            this.setAttribute(NAME, value);
            this.setAttribute(BUTTON_TEXT, value);
        } else if (NAME.equals(key)) {
            this.setConfigureName((String)value);
            if (this.getLaunchButton().getAttributeValueString(TOOLTIP) == null) {
                this.getLaunchButton().setAttribute(TOOLTIP, value);
            }
        } else if (KEY_COMMAND.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.stroke = (NamedKeyStroke)value;
            this.globalCommand.setKeyStroke(this.stroke);
        } else if (AFFECTED_PIECE_NAMES.equals(key)) {
            if (value instanceof String) {
                value = StringArrayConfigurer.stringToArray((String)value);
            }
            this.names = value;
            if (this.names.length == 0) {
                this.names = null;
            } else {
                this.filter = piece -> {
                    for (String s : this.names) {
                        if (!Decorator.getInnermost(piece).getName().equals(s)) continue;
                        return true;
                    }
                    return false;
                };
            }
        } else if (CHECK_PROPERTY.equals(key)) {
            this.checkProperty = (String)value;
        } else if (CHECK_VALUE.equals(key)) {
            this.checkValue = (String)value;
        } else if (PROPERTIES_FILTER.equals(key)) {
            this.propertiesFilter.setExpression((String)value);
        } else if (CONDITION.equals(key)) {
            this.condition = (String)value;
        } else if (REPORT_SINGLE.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.globalCommand.setReportSingle((Boolean)value);
        } else if (DECK_COUNT.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.globalCommand.setSelectFromDeck((Integer)value);
        } else if (REPORT_FORMAT.equals(key)) {
            this.reportFormat.setFormat((String)value);
            this.globalCommand.setReportFormat((String)value);
        } else if (SINGLE_MAP.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.singleMap = (Boolean)value;
        } else if (TARGET.equals(key)) {
            if (value instanceof String) {
                value = new GlobalCommandTarget((String)value);
            }
            this.target = (GlobalCommandTarget)value;
            this.target.setGKCtype(this.getGKCtype());
            if (this.getGKCtype() == GlobalCommandTarget.GKCtype.DECK) {
                this.target.setFastMatchLocation(false);
                this.target.setFastMatchProperty(false);
            }
        } else {
            super.setAttribute(key, value);
        }
    }

    @Override
    public String getComponentName() {
        return this.getConfigureName();
    }

    @Override
    public String getComponentTypeName() {
        return MassKeyCommand.getConfigureTypeName();
    }

    @Override
    public List<String> getPropertyList() {
        return this.target.getPropertyList();
    }

    @Override
    public List<String> getExpressionList() {
        List<String> expList = this.target.getExpressionList();
        expList.add(this.propertiesFilter.getExpression());
        return expList;
    }

    @Override
    public List<String> getFormattedStringList() {
        return List.of(this.reportFormat.getFormat());
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(NamedHotKeyConfigurer.decode(this.getAttributeValueString(HOTKEY)), NamedHotKeyConfigurer.decode(this.getAttributeValueString(KEY_COMMAND)));
    }

    public static class DeckPolicyConfig
    extends Configurer
    implements ConfigurerFactory {
        protected static final String FIXED = "Fixed number of pieces";
        protected static final String NONE = "No pieces";
        protected static final String ALL = "All pieces";
        protected IntConfigurer intConfig;
        protected TranslatingStringEnumConfigurer typeConfig = new TranslatingStringEnumConfigurer(new String[]{"All pieces", "No pieces", "Fixed number of pieces"}, new String[]{"Editor.GlobalKeyCommand.all_pieces", "Editor.GlobalKeyCommand.no_pieces", "Editor.GlobalKeyCommand.fixed_number_of_pieces"});
        protected JLabel prompt;
        protected Box controls;
        protected JPanel controls2;

        public DeckPolicyConfig() {
            this(false);
        }

        public DeckPolicyConfig(boolean showPrompt) {
            super(null, "");
            this.intConfig = new IntConfigurer(null, "");
            if (showPrompt) {
                this.controls2 = new JPanel((LayoutManager)new MigLayout("ins 0", "[]rel[]rel[]"));
                this.prompt = new JLabel(Resources.getString("Editor.GlobalKeyCommand.deck_policy"));
                this.controls2.add(this.prompt);
            } else {
                this.controls2 = new JPanel((LayoutManager)new MigLayout("ins 0", "[]rel[]"));
            }
            this.controls2.add(this.typeConfig.getControls());
            this.controls2.add(this.intConfig.getControls());
            PropertyChangeListener l = evt -> {
                this.intConfig.getControls().setVisible(FIXED.equals(this.typeConfig.getValueString()));
                SwingUtils.repack(this.intConfig.getControls());
            };
            PropertyChangeListener l2 = evt -> this.setValue(this.getIntValue());
            this.typeConfig.addPropertyChangeListener(l);
            this.typeConfig.addPropertyChangeListener(l2);
            this.intConfig.addPropertyChangeListener(l2);
        }

        @Override
        public Component getControls() {
            return this.controls2;
        }

        @Override
        public String getValueString() {
            return String.valueOf(this.getIntValue());
        }

        public int getIntValue() {
            String type = this.typeConfig.getValueString();
            if (ALL.equals(type)) {
                return -1;
            }
            if (NONE.equals(type)) {
                return 0;
            }
            return this.intConfig.getIntValue(1);
        }

        @Override
        public void setValue(Object o) {
            if (this.typeConfig != null) {
                this.typeConfig.setFrozen(true);
                this.intConfig.setFrozen(true);
                if (o instanceof Integer) {
                    Integer i = (Integer)o;
                    switch (i) {
                        case 0: {
                            this.typeConfig.setValue(NONE);
                            this.intConfig.setValue(1);
                            break;
                        }
                        case -1: {
                            this.typeConfig.setValue(ALL);
                            this.intConfig.setValue(1);
                            break;
                        }
                        default: {
                            this.typeConfig.setValue(FIXED);
                            this.intConfig.setValue(i);
                        }
                    }
                    this.intConfig.getControls().setVisible(FIXED.equals(this.typeConfig.getValueString()));
                }
            }
            super.setValue(o);
            if (this.typeConfig != null) {
                this.typeConfig.setFrozen(false);
                this.intConfig.setFrozen(false);
            }
        }

        @Override
        public void setValue(String s) {
            if (s != null) {
                this.setValue(Integer.valueOf(s));
            }
        }

        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            this.setName(name);
            this.key = key;
            return this;
        }
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new PlayerIdFormattedStringConfigurer(key, name, new String[0]);
        }
    }

    public static class Prompt
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{MassKeyCommand.ALWAYS, MassKeyCommand.IF_ACTIVE, MassKeyCommand.IF_INACTIVE};
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            return new String[]{"Editor.GlobalKeyCommand.if_layer_is_active", "Editor.GlobalKeyCommand.if_layer_is_inactive", "Editor.GlobalKeyCommand.always"};
        }
    }

    @Deprecated(since="2020-10-01", forRemoval=true)
    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, "/images/keyCommand.gif");
        }
    }
}

