/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.board.GeometricGrid;
import VASSAL.build.module.map.boardPicker.board.GridEditor;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridContainer;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridNumbering;
import VASSAL.build.module.map.boardPicker.board.mapgrid.HexGridNumbering;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;

public class HexGrid
extends AbstractConfigurable
implements GeometricGrid,
GridEditor.EditableGrid {
    protected Point origin = new Point(0, 32);
    protected double dx;
    protected double dy;
    protected int snapScale = 0;
    protected GridContainer container;
    protected GridNumbering numbering;
    protected boolean visible = false;
    protected boolean dotsVisible = false;
    protected boolean edgesLegal = false;
    protected boolean cornersLegal = false;
    protected Color color = Color.black;
    protected boolean sideways = false;
    protected boolean snapTo = true;
    protected Map<Integer, Area> shapeCache = new HashMap<Integer, Area>();
    protected HexGridEditor gridEditor;
    public static final String X0 = "x0";
    public static final String Y0 = "y0";
    public static final String DY = "dy";
    public static final String DX = "dx";
    public static final String VISIBLE = "visible";
    public static final String DOTS_VISIBLE = "dotsVisible";
    public static final String CORNERS = "cornersLegal";
    public static final String EDGES = "edgesLegal";
    public static final String SIDEWAYS = "sideways";
    public static final String COLOR = "color";
    public static final String SNAP_SCALE = "snapscale";
    public static final String SNAP_TO = "snapTo";
    protected static final double sqrt3_2 = Math.sqrt(3.0) / 2.0;
    private static final double DEFAULT_HEIGHT = 64.0;
    private static final double DEFAULT_WIDTH = sqrt3_2 * 64.0;
    protected boolean alternate;

    @Override
    public String[] getAttributeNames() {
        return new String[]{SIDEWAYS, X0, Y0, DY, DX, SNAP_TO, EDGES, CORNERS, VISIBLE, DOTS_VISIBLE, COLOR};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.HexGrid.sideways"), Resources.getString("Editor.x_offset"), Resources.getString("Editor.y_offset"), Resources.getString("Editor.HexGrid.hex_height"), Resources.getString("Editor.HexGrid.hex_width"), Resources.getString("Editor.Grid.snap"), Resources.getString("Editor.Grid.edges"), Resources.getString("Editor.HexGrid.vertices"), Resources.getString("Editor.Grid.show_grid"), Resources.getString("Editor.Grid.center_dots"), Resources.getString("Editor.color_label")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{Boolean.class, Integer.class, Integer.class, Double.class, Double.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Color.class};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (COLOR.equals(name)) {
            return () -> this.visible;
        }
        if (EDGES.equals(name) || CORNERS.equals(name)) {
            return () -> this.snapTo;
        }
        return super.getAttributeVisibility(name);
    }

    @Override
    public Configurer getConfigurer() {
        boolean buttonExists = this.config != null;
        AutoConfigurer c = (AutoConfigurer)super.getConfigurer();
        Configurer dxConfig = c.getConfigurer(DX);
        c.getConfigurer(DY).addPropertyChangeListener(evt -> {
            if (evt.getNewValue() != null) {
                double hgt = (Double)evt.getNewValue();
                dxConfig.setValue(Double.toString(sqrt3_2 * hgt));
            }
        });
        if (!buttonExists) {
            JButton b = new JButton(Resources.getString("Editor.Grid.edit_grid"));
            b.addActionListener(e -> this.editGrid());
            ((Container)c.getControls()).add(b);
        }
        return this.config;
    }

    public HexGrid(double height, double width, boolean alt) {
        this.dy = height;
        this.dx = width;
        this.alternate = alt;
    }

    public HexGrid(double size, boolean alt) {
        this(size, sqrt3_2 * size, alt);
    }

    public HexGrid() {
        this(64.0, DEFAULT_WIDTH, false);
    }

    @Override
    public boolean isVisible() {
        return this.visible || this.numbering != null && this.numbering.isVisible();
    }

    public boolean isEdgesLegal() {
        return this.edgesLegal;
    }

    public boolean isCornersLegal() {
        return this.cornersLegal;
    }

    @Override
    public void setVisible(boolean legal) {
        this.visible = legal;
    }

    public void setEdgesLegal(boolean legal) {
        this.edgesLegal = legal;
    }

    @Override
    public boolean isSideways() {
        return this.sideways;
    }

    @Override
    public void setSideways(boolean b) {
        this.sideways = b;
    }

    public void setCornersLegal(boolean legal) {
        this.cornersLegal = legal;
    }

    public void setHexSize(double size) {
        this.dy = size;
        this.dx = sqrt3_2 * size;
        this.shapeCache.clear();
    }

    public double getHexSize() {
        return this.dy;
    }

    public double getHexWidth() {
        return this.dx;
    }

    public void setHexWidth(double w) {
        this.dx = w;
    }

    @Override
    public double getDx() {
        return this.getHexWidth();
    }

    @Override
    public void setDx(double d) {
        this.setHexWidth(d);
    }

    @Override
    public double getDy() {
        return this.getHexSize();
    }

    @Override
    public void setDy(double d) {
        this.dy = d;
    }

    @Override
    public GridContainer getContainer() {
        return this.container;
    }

    @Override
    public void addTo(Buildable b) {
        this.container = (GridContainer)((Object)b);
        this.container.setGrid(this);
    }

    @Override
    public void removeFrom(Buildable b) {
        ((GridContainer)((Object)b)).removeGrid(this);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.HexGrid.component_type");
    }

    @Override
    public String getGridName() {
        return HexGrid.getConfigureTypeName();
    }

    @Override
    public String getConfigureName() {
        return null;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("HexGrid.html");
    }

    @Override
    public String getAttributeValueString(String key) {
        if (X0.equals(key)) {
            return String.valueOf(this.origin.x);
        }
        if (Y0.equals(key)) {
            return String.valueOf(this.origin.y);
        }
        if (DY.equals(key)) {
            return String.valueOf(this.dy);
        }
        if (DX.equals(key)) {
            return String.valueOf(this.dx);
        }
        if (SNAP_TO.equals(key)) {
            return String.valueOf(this.snapTo);
        }
        if (CORNERS.equals(key)) {
            return String.valueOf(this.cornersLegal);
        }
        if (EDGES.equals(key)) {
            return String.valueOf(this.edgesLegal);
        }
        if (SIDEWAYS.equals(key)) {
            return String.valueOf(this.sideways);
        }
        if (VISIBLE.equals(key)) {
            return String.valueOf(this.visible);
        }
        if (DOTS_VISIBLE.equals(key)) {
            return String.valueOf(this.dotsVisible);
        }
        if (COLOR.equals(key)) {
            return ColorConfigurer.colorToString(this.color);
        }
        return null;
    }

    @Override
    public void setAttribute(String key, Object val) {
        if (X0.equals(key)) {
            if (val instanceof String) {
                val = Integer.valueOf((String)val);
            }
            this.origin.x = (Integer)val;
        } else if (Y0.equals(key)) {
            if (val instanceof String) {
                val = Integer.valueOf((String)val);
            }
            this.origin.y = (Integer)val;
        } else if (DY.equals(key)) {
            if (val instanceof String) {
                val = Double.valueOf((String)val);
            }
            this.dy = (Double)val;
            if (Double.compare(this.dx, DEFAULT_WIDTH) == 0) {
                this.dx = sqrt3_2 * this.dy;
            }
        } else if (DX.equals(key)) {
            if (val instanceof String) {
                val = Double.valueOf((String)val);
            }
            this.dx = (Double)val;
        } else if (SNAP_TO.equals(key)) {
            if (val instanceof String) {
                val = Boolean.valueOf((String)val);
            }
            this.snapTo = (Boolean)val;
        } else if (CORNERS.equals(key)) {
            if (val instanceof String) {
                val = Boolean.valueOf((String)val);
            }
            this.cornersLegal = (Boolean)val;
        } else if (EDGES.equals(key)) {
            if (val instanceof String) {
                val = Boolean.valueOf((String)val);
            }
            this.edgesLegal = (Boolean)val;
        } else if (SIDEWAYS.equals(key)) {
            if (val instanceof String) {
                val = Boolean.valueOf((String)val);
            }
            this.sideways = (Boolean)val;
        } else if (VISIBLE.equals(key)) {
            if (val instanceof String) {
                val = Boolean.valueOf((String)val);
            }
            this.visible = (Boolean)val;
        } else if (DOTS_VISIBLE.equals(key)) {
            if (val instanceof String) {
                val = Boolean.valueOf((String)val);
            }
            this.dotsVisible = (Boolean)val;
        } else if (COLOR.equals(key)) {
            if (val instanceof String) {
                val = ColorConfigurer.stringToColor((String)val);
            }
            this.color = (Color)val;
        } else if (SNAP_SCALE.equals(key)) {
            if (val instanceof String) {
                val = Integer.valueOf((String)val);
            }
            this.snapScale = (Integer)val;
        }
        this.shapeCache.clear();
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{HexGridNumbering.class};
    }

    @Override
    public String locationName(Point p) {
        return this.numbering == null ? null : this.numbering.locationName(p);
    }

    @Override
    public String localizedLocationName(Point p) {
        return this.numbering == null ? null : this.numbering.localizedLocationName(p);
    }

    @Override
    public Point getLocation(String location) throws MapGrid.BadCoords {
        if (this.numbering == null) {
            throw new MapGrid.BadCoords();
        }
        return this.numbering.getLocation(location);
    }

    @Override
    public Point snapTo(Point p) {
        if (!this.snapTo) {
            return p;
        }
        Point center = this.snapToHex(p);
        if (this.edgesLegal && this.cornersLegal) {
            Point edge = this.snapToHexSide(p);
            Point vertex = this.snapToHexVertex(p);
            if ((p.x - edge.x) * (p.x - edge.x) + (p.y - edge.y) * (p.y - edge.y) < (p.x - vertex.x) * (p.x - vertex.x) + (p.y - vertex.y) * (p.y - vertex.y)) {
                return this.checkCenter(center, edge);
            }
            return this.checkCenter(center, vertex);
        }
        if (this.edgesLegal) {
            return this.checkCenter(center, this.snapToHexSide(p));
        }
        if (this.cornersLegal) {
            return this.checkCenter(center, this.snapToHexVertex(p));
        }
        return this.snapToHex(p);
    }

    protected Point checkCenter(Point center, Point target) {
        if ((center.x - target.x) * (center.x - target.x) + (center.y - target.y) * (center.y - target.y) <= 2) {
            return center;
        }
        return target;
    }

    @Override
    public boolean isLocationRestricted(Point p) {
        return this.snapTo;
    }

    public Point snapToHex(Point p) {
        p = new Point(p);
        this.rotateIfSideways(p);
        p.setLocation(this.hexX(p.x, p.y), this.hexY(p.x, p.y));
        this.rotateIfSideways(p);
        return p;
    }

    public Point snapToHexSide(Point p) {
        p = new Point(p);
        this.rotateIfSideways(p);
        int x = this.sideX(p.x, p.y);
        int y = this.sideY(p.x, p.y);
        if (this.snapScale > 0) {
            int hexX = this.hexX(p.x, p.y);
            int hexY = this.hexY(p.x, p.y);
            if (Math.abs(p.x - hexX) + Math.abs(p.y - hexY) <= Math.abs(p.x - x) + Math.abs(p.y - y)) {
                x = hexX;
                y = hexY;
            }
        }
        p.setLocation(x, y);
        this.rotateIfSideways(p);
        return p;
    }

    public Point snapToHexVertex(Point p) {
        p = new Point(p);
        this.rotateIfSideways(p);
        int x = this.vertexX(p.x, p.y);
        int y = this.vertexY(p.x, p.y);
        if (this.snapScale > 0) {
            int hexX = this.hexX(p.x, p.y);
            int hexY = this.hexY(p.x, p.y);
            if (Math.abs(p.x - hexX) + Math.abs(p.y - hexY) <= Math.abs(p.x - x) + Math.abs(p.y - y)) {
                x = hexX;
                y = hexY;
            }
        }
        p.setLocation(x, y);
        this.rotateIfSideways(p);
        return p;
    }

    public void rotate(Point p) {
        int swap = p.x;
        p.x = p.y;
        p.y = swap;
    }

    public void rotateIfSideways(Point p) {
        if (this.sideways) {
            this.rotate(p);
        }
    }

    @Override
    public Area getGridShape(Point center, int range) {
        Area shape = this.shapeCache.get(range);
        if (shape == null) {
            Point origin = new Point(0, 0);
            shape = this.getSingleHexShape(origin.x, origin.y, false);
            for (int i = -range; i <= range; ++i) {
                int x = origin.x + (int)((double)i * this.dx);
                int length = range * 2 + 1 - Math.abs(i);
                int startY = length % 2 == 1 ? origin.y - (int)(this.dy * (double)(length - 1) / 2.0) : origin.y - (int)(this.dy * (0.5 + (double)((length - 2) / 2)));
                int y = startY;
                for (int j = 0; j < length; ++j) {
                    Point p = new Point(x, y);
                    this.rotateIfSideways(p);
                    shape.add(this.getSingleHexShape(p.x, p.y, false));
                    y = (int)((double)y + this.dy);
                }
            }
            this.rotateIfSideways(origin);
            shape.transform(AffineTransform.getTranslateInstance(0 - origin.x, 0 - origin.y));
            this.shapeCache.put(range, shape);
        }
        shape = new Area(AffineTransform.getTranslateInstance(center.x, center.y).createTransformedShape(shape));
        return shape;
    }

    protected Area getSingleHexShape(int centerX, int centerY, boolean reversed) {
        Polygon poly = new Polygon();
        float x = this.sideways ? centerY : centerX;
        float y = this.sideways ? centerX : centerY;
        float deltaX = (float)this.dx;
        float deltaY = (float)this.dy;
        float r = 2.0f * deltaX / 3.0f;
        Point p1 = new Point();
        Point p2 = new Point();
        Point p3 = new Point();
        Point p4 = new Point();
        Point p5 = new Point();
        Point p6 = new Point();
        float x1 = x - r;
        float y1 = y;
        p1.setLocation(Math.round(x1), Math.round(y1));
        float x2 = x - 0.5f * r;
        float y2 = reversed ? y + 0.5f * deltaY : y - 0.5f * deltaY;
        p2.setLocation(Math.round(x2), Math.round(y2));
        float x3 = x + 0.5f * r;
        float y3 = y2;
        p3.setLocation(Math.round(x3) + 1, Math.round(y3));
        float x4 = x + r;
        float y4 = y;
        p4.setLocation(Math.round(x4) + 1, Math.round(y4));
        float x5 = x3;
        float y5 = reversed ? y - 0.5f * deltaY : y + 0.5f * deltaY;
        p5.setLocation(Math.round(x5) + 1, Math.round(y5) + 1);
        float x6 = x2;
        float y6 = y5;
        p6.setLocation(Math.round(x6), Math.round(y6) + 1);
        if (this.sideways) {
            this.rotate(p1);
            this.rotate(p2);
            this.rotate(p3);
            this.rotate(p4);
            this.rotate(p5);
            this.rotate(p6);
        }
        poly.addPoint(p1.x, p1.y);
        poly.addPoint(p2.x, p2.y);
        poly.addPoint(p3.x, p3.y);
        poly.addPoint(p4.x, p4.y);
        poly.addPoint(p5.x, p5.y);
        poly.addPoint(p6.x, p6.y);
        poly.addPoint(p1.x, p1.y);
        return new Area(poly);
    }

    @Override
    public int range(Point p1, Point p2) {
        double theta;
        p1 = new Point(p1);
        this.rotateIfSideways(p1);
        p2 = new Point(p2);
        this.rotateIfSideways(p2);
        int x = p2.x - p1.x;
        int y = p2.y - p1.y;
        for (theta = Math.atan2(-x, -y) + Math.PI; theta > 1.0471975511965976; theta -= 1.0471975511965976) {
        }
        theta = 0.5235987755982988 - theta;
        double r = Math.sqrt(x * x + y * y);
        return (int)((r *= Math.cos(theta)) / (this.dy * sqrt3_2) + 0.5);
    }

    protected int hexX(int x, int y) {
        int loc = (int)(this.dx * (double)((int)Math.floor(((double)(x - this.origin.x) + this.dx / 2.0) / this.dx)) + (double)this.origin.x);
        if (this.snapScale > 0) {
            int delta = x - loc;
            delta = (int)Math.round((double)delta / (0.5 * this.dx / (double)this.snapScale));
            delta = Math.max(delta, 1 - this.snapScale);
            delta = Math.min(delta, this.snapScale - 1);
            delta = (int)Math.round((double)delta * 0.5 * this.dx / (double)this.snapScale);
            loc += delta;
        }
        return loc;
    }

    protected int hexY(int x, int y) {
        int nx = (int)Math.floor(((double)(x - this.origin.x) + this.dx / 2.0) / this.dx);
        int loc = nx % 2 == 0 ? (int)(this.dy * (double)((int)Math.floor(((double)(y - this.origin.y) + this.dy / 2.0) / this.dy)) + (double)this.origin.y) : (int)(this.dy * (double)((int)Math.floor((double)(y - this.origin.y) / this.dy)) + (double)((int)(this.dy / 2.0)) + (double)this.origin.y);
        if (this.snapScale > 0) {
            int delta = y - loc;
            delta = (int)Math.round((double)delta / (0.5 * this.dy / (double)this.snapScale));
            delta = Math.max(delta, 1 - this.snapScale);
            delta = Math.min(delta, this.snapScale - 1);
            delta = (int)Math.round((double)delta * 0.5 * this.dy / (double)this.snapScale);
            loc += delta;
        }
        return loc;
    }

    protected int sideX(int x, int y) {
        return (int)(this.dx / 2.0 * (double)((int)Math.floor(((double)(x - this.origin.x) + this.dx / 4.0) * 2.0 / this.dx)) + (double)this.origin.x);
    }

    protected int sideY(int x, int y) {
        int nx = (int)Math.floor(((double)(x - this.origin.x) + this.dx / 4.0) * 2.0 / this.dx);
        if (nx % 2 == 0) {
            return (int)(this.dy / 2.0 * (double)((int)Math.floor(((double)(y - this.origin.y) + this.dy / 4.0) * 2.0 / this.dy)) + (double)this.origin.y);
        }
        return (int)(this.dy / 2.0 * (double)((int)Math.floor((double)((y - this.origin.y) * 2) / this.dy)) + (double)((int)(this.dy / 4.0)) + (double)this.origin.y);
    }

    protected int vertexX(int x, int y) {
        int ny = (int)Math.floor(((double)(y - this.origin.y) + this.dy / 4.0) * 2.0 / this.dy);
        if (ny % 2 == 0) {
            return (int)(2.0 * this.dx / 3.0 * (double)((int)(Math.floor((double)(x - this.origin.x) + this.dx / 3.0) * 3.0 / (2.0 * this.dx))) + (double)this.origin.x);
        }
        return (int)(2.0 * this.dx / 3.0 * (double)((int)(Math.floor((double)(x - this.origin.x) + this.dx / 3.0 + this.dx / 3.0) * 3.0 / (2.0 * this.dx))) - (double)((int)(this.dx / 3.0)) + (double)this.origin.x);
    }

    protected int vertexY(int x, int y) {
        return (int)(this.dy / 2.0 * (double)((int)Math.floor(((double)(y - this.origin.y) + this.dy / 4.0) * 2.0 / this.dy)) + (double)this.origin.y);
    }

    @Override
    public void draw(Graphics g, Rectangle bounds, Rectangle visibleRect, double zoom, boolean reversed) {
        if (this.visible) {
            this.forceDraw(g, bounds, visibleRect, zoom, reversed);
        }
        if (this.numbering != null) {
            this.numbering.draw(g, bounds, visibleRect, zoom, reversed);
        }
    }

    public void forceDraw(Graphics g, Rectangle bounds, Rectangle visibleRect, double zoom, boolean reversed) {
        if (!bounds.intersects(visibleRect) || this.color == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.color);
        float deltaX = (float)(this.dx * zoom);
        float deltaY = (float)(this.dy * zoom);
        float r = 2.0f * deltaX / 3.0f;
        Rectangle region = bounds.intersection(visibleRect);
        Shape oldClip = g2d.getClip();
        if (oldClip != null) {
            Area clipArea = new Area(oldClip);
            clipArea.intersect(new Area(region));
            g2d.setClip(clipArea);
        }
        if (this.sideways) {
            bounds = new Rectangle(bounds.y, bounds.x, bounds.height, bounds.width);
            region = new Rectangle(region.y, region.x, region.height, region.width);
        }
        float xmin = reversed ? (float)bounds.x + (float)zoom * (float)this.origin.x + (float)bounds.width - 2.0f * deltaX * (float)Math.ceil(((double)bounds.x + zoom * (double)this.origin.x + (double)bounds.width - (double)region.x) / (double)(2.0f * deltaX)) : (float)bounds.x + (float)zoom * (float)this.origin.x + 2.0f * deltaX * (float)Math.floor(((double)(region.x - bounds.x) - zoom * (double)this.origin.x) / (double)(2.0f * deltaX));
        float xmax = (float)(region.x + region.width) + 2.0f * deltaX;
        float ymin = reversed ? (float)bounds.y + (float)zoom * (float)this.origin.y + (float)bounds.height - deltaY * (float)Math.ceil(((double)bounds.y + zoom * (double)this.origin.y + (double)bounds.height - (double)region.y) / (double)deltaY) : (float)bounds.y + (float)zoom * (float)this.origin.y + deltaY * (float)Math.floor(((double)(region.y - bounds.y) - zoom * (double)this.origin.y) / (double)deltaY);
        float ymax = (float)(region.y + region.height) + deltaY;
        Point center = new Point();
        Point p1 = new Point();
        Point p2 = new Point();
        Point p3 = new Point();
        Point p4 = new Point();
        float x = xmin;
        while (x < xmax) {
            float y = ymin;
            while (y < ymax) {
                float x1 = x - r;
                float y1 = y;
                p1.setLocation(Math.round(x1), Math.round(y1));
                float x2 = x - 0.5f * r;
                float y2 = reversed ? y + 0.5f * deltaY : y - 0.5f * deltaY;
                p2.setLocation(Math.round(x2), Math.round(y2));
                float x3 = x + 0.5f * r;
                float y3 = y2;
                p3.setLocation(Math.round(x3), Math.round(y3));
                float x4 = x + r;
                float y4 = y;
                p4.setLocation(Math.round(x4), Math.round(y4));
                if (this.sideways) {
                    this.rotate(p1);
                    this.rotate(p2);
                    this.rotate(p3);
                    this.rotate(p4);
                }
                g2d.drawLine(p1.x, p1.y, p2.x, p2.y);
                g2d.drawLine(p2.x, p2.y, p3.x, p3.y);
                g2d.drawLine(p3.x, p3.y, p4.x, p4.y);
                if (this.dotsVisible) {
                    center.setLocation(Math.round(x), Math.round(y));
                    this.rotateIfSideways(center);
                    g2d.fillRect(center.x, center.y, 2, 2);
                    center.setLocation(Math.round(x + deltaX), Math.round(y + deltaY / 2.0f));
                    this.rotateIfSideways(center);
                    g2d.fillRect(center.x, center.y, 2, 2);
                }
                p1.setLocation(Math.round(x1 += deltaX), Math.round(y1 += 0.5f * deltaY));
                p2.setLocation(Math.round(x2 += deltaX), Math.round(y2 += 0.5f * deltaY));
                p3.setLocation(Math.round(x3 += deltaX), Math.round(y3 += 0.5f * deltaY));
                p4.setLocation(Math.round(x4 += deltaX), Math.round(y4 += 0.5f * deltaY));
                if (this.sideways) {
                    this.rotate(p1);
                    this.rotate(p2);
                    this.rotate(p3);
                    this.rotate(p4);
                }
                g2d.drawLine(p1.x, p1.y, p2.x, p2.y);
                g2d.drawLine(p2.x, p2.y, p3.x, p3.y);
                g2d.drawLine(p3.x, p3.y, p4.x, p4.y);
                if (x == xmin) {
                    p1.setLocation(Math.round(x - r), Math.round(y));
                    p2.setLocation(Math.round(x - r / 2.0f), Math.round(y + deltaY / 2.0f));
                    if (this.sideways) {
                        this.rotate(p1);
                        this.rotate(p2);
                    }
                    g2d.drawLine(p1.x, p1.y, p2.x, p2.y);
                }
                y = (float)((double)y + zoom * this.dy);
            }
            x = (float)((double)x + zoom * 2.0 * this.dx);
        }
        g2d.setClip(oldClip);
    }

    public void setGridNumbering(GridNumbering numbering) {
        this.numbering = numbering;
    }

    @Override
    public GridNumbering getGridNumbering() {
        return this.numbering;
    }

    @Override
    public Point getOrigin() {
        return new Point(this.origin);
    }

    @Override
    public void setOrigin(Point p) {
        this.origin.x = p.x;
        this.origin.y = p.y;
    }

    public void editGrid() {
        this.gridEditor = new HexGridEditor(this);
        this.gridEditor.setVisible(true);
        double origDx = this.dx;
        AutoConfigurer cfg = (AutoConfigurer)this.getConfigurer();
        cfg.getConfigurer(DY).setValue(String.valueOf(this.dy));
        this.dx = origDx;
        cfg.getConfigurer(DX).setValue(String.valueOf(this.dx));
        cfg.getConfigurer(X0).setValue(String.valueOf(this.origin.x));
        cfg.getConfigurer(Y0).setValue(String.valueOf(this.origin.y));
        cfg.getConfigurer(SIDEWAYS).setValue(String.valueOf(this.sideways));
    }

    public int getSnapScale() {
        return this.snapScale;
    }

    public void setSnapScale(int snapScale) {
        this.snapScale = snapScale;
    }

    public static class HexGridEditor
    extends GridEditor {
        private static final long serialVersionUID = 1L;

        public HexGridEditor(GridEditor.EditableGrid grid) {
            super(grid);
        }

        @Override
        public void calculate() {
            if (this.isPerpendicular(this.hp1, this.hp2)) {
                this.calculate_step2(this.hp1, this.hp2, this.hp3);
            } else if (this.isPerpendicular(this.hp1, this.hp3)) {
                this.calculate_step2(this.hp1, this.hp3, this.hp2);
            } else if (this.isPerpendicular(this.hp2, this.hp3)) {
                this.calculate_step2(this.hp2, this.hp3, this.hp1);
            } else {
                this.reportShapeError();
            }
        }

        protected void calculate_step2(Point p1, Point p2, Point p3) {
            if (!this.isPerpendicular(p1, p3) && !this.isPerpendicular(p2, p3)) {
                if (this.isHorizontal(p1, p2)) {
                    if (p3.x < p1.x && p3.x < p2.x || p3.x > p1.x && p3.x > p2.x) {
                        this.check(false, p1, p2, p3);
                    } else {
                        this.checkEnd(true, p1, p2, p3);
                    }
                } else if (p3.y < p1.y && p3.y < p2.y || p3.y > p1.y && p3.y > p2.y) {
                    this.check(true, this.reverse(p1), this.reverse(p2), this.reverse(p3));
                } else {
                    this.checkEnd(false, this.reverse(p1), this.reverse(p2), this.reverse(p3));
                }
            } else {
                this.reportShapeError();
            }
        }

        protected Point reverse(Point p) {
            return new Point(p.y, p.x);
        }

        protected void check(boolean sideways, Point p1, Point p2, Point p3) {
            int r = Math.abs(p1.x - p2.x);
            int width = r * 3 / 2;
            if (width < 1) {
                this.reportShapeError();
                return;
            }
            int height = Math.abs(p3.y - p2.y) * 2;
            int Xoff = Math.min(p1.x, p2.x) % width + r / 2;
            int col = Math.min(p1.x, p2.x) / width;
            int Yoff = Math.min(p1.y, p2.y) % height - (col % 2 == 1 ? 0 : height / 2);
            if (Yoff < 0) {
                Yoff += height;
            }
            this.setMetrics(width, height, Xoff, Yoff, sideways);
        }

        protected void checkEnd(boolean sideways, Point p1, Point p2, Point p3) {
            if (Math.abs((p1.x + p2.x) / 2 - p3.x) > 5) {
                this.reportShapeError();
                return;
            }
            int r = Math.abs(p3.y - p1.y) * 2;
            int width = r * 3 / 2;
            int height = Math.abs(p3.x - p2.x) * 2;
            int xOrigin = p1.y - (p3.y < p1.y ? 0 : r);
            int Xoff = xOrigin % width + r / 2;
            int col = xOrigin / width;
            int Yoff = Math.min(p1.x, p2.x) % height - (col % 2 == 1 ? 0 : height / 2);
            this.setMetrics(width, height, Xoff, Yoff, sideways);
        }

        protected void setMetrics(int width, int height, int xoff, int yoff, boolean b) {
            this.grid.setDx(width);
            this.grid.setDy(height);
            this.grid.setOrigin(new Point(xoff, yoff));
            this.grid.setSideways(b);
        }
    }
}

