/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.LockableRoom;
import VASSAL.chat.Player;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.node.NodePlayer;
import VASSAL.configure.StringArrayConfigurer;
import java.util.List;
import java.util.Properties;

public class NodeRoom
extends SimpleRoom
implements LockableRoom {
    public static final String OWNER = "owner";
    public static final String MEMBERS = "members";
    public static final String STATUS = "status";
    public static final String LOCKED = "locked";
    private String owner;
    private String[] members;
    private boolean locked;

    public NodeRoom() {
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public NodeRoom(String name) {
        super(name);
    }

    public NodeRoom(String name, Player[] players) {
        super(name, players);
    }

    public void setInfo(Properties p) {
        this.owner = p.getProperty(OWNER, this.owner);
        this.members = StringArrayConfigurer.stringToArray(p.getProperty(MEMBERS, StringArrayConfigurer.arrayToString(this.members)));
        this.locked = "true".equals(p.getProperty(LOCKED));
    }

    public Properties getInfo() {
        Properties p = new Properties();
        if (this.owner != null) {
            p.setProperty(OWNER, this.owner);
        }
        if (this.locked) {
            p.setProperty(LOCKED, "true");
        }
        if (this.members != null) {
            p.setProperty(MEMBERS, StringArrayConfigurer.arrayToString(this.members));
        }
        return p;
    }

    public void setMembersToCurrentPlayers() {
        List<Player> l = this.getPlayerList();
        NodePlayer[] p = l.toArray(new NodePlayer[0]);
        this.members = new String[p.length];
        for (int i = 0; i < p.length; ++i) {
            this.members[i] = p[i].getId();
        }
    }

    public String[] getMembers() {
        return this.members;
    }

    public boolean isMember(NodePlayer p) {
        boolean isMember = false;
        if (this.members != null) {
            for (int i = 0; !isMember && i < this.members.length; ++i) {
                isMember = p.getId().equals(this.members[i]);
            }
        }
        return isMember;
    }

    public boolean isOwner(NodePlayer p) {
        return p != null && this.owner != null && this.owner.equals(p.getId());
    }

    @Override
    public boolean isOwner(String jid) {
        return jid.equals(this.owner);
    }

    public String getOwner() {
        return this.owner;
    }

    @Override
    public Player getOwningPlayer() {
        return this.getPlayer(this.owner);
    }

    public void lock() {
        this.locked = true;
    }

    public void toggleLock() {
        this.locked = !this.locked;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }
}

