/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.GameModule;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.DoubleConfigurer;
import VASSAL.configure.FileConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.ImageConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.PropertyExpressionConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.configure.TranslatableStringEnum;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ReflectionUtils;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class AutoConfigurer
extends Configurer
implements PropertyChangeListener {
    protected JPanel p;
    protected AutoConfigurable target;
    protected List<Configurer> configurers = new ArrayList<Configurer>();
    protected Map<String, VisibilityCondition> conditions;
    protected Map<String, JComponent> labels = new HashMap<String, JComponent>();

    public AutoConfigurer(AutoConfigurable c) {
        super(null, c.getConfigureName());
        this.target = c;
        this.setValue(this.target);
        this.target.addPropertyChangeListener(evt -> {
            if ("name".equals(evt.getPropertyName())) {
                this.setName((String)evt.getNewValue());
            }
        });
        this.p = new JPanel();
        this.p.setLayout((LayoutManager)new MigLayout("ins panel,gapy 4, hidemode 3", "[align right]rel[fill,grow]"));
        String[] name = c.getAttributeNames();
        String[] prompt = c.getAttributeDescriptions();
        Class<?>[] type = c.getAttributeTypes();
        int n = Math.min(name.length, Math.min(prompt.length, type.length));
        for (int i = 0; i < n; ++i) {
            if (type[i] == null) continue;
            Configurer config = AutoConfigurer.createConfigurer(type[i], name[i], "", this.target);
            if (config != null) {
                config.addPropertyChangeListener(this);
                config.setValue(this.target.getAttributeValueString(name[i]));
                JLabel label = new JLabel(prompt[i]);
                label.setLabelFor(config.getControls());
                this.labels.put(name[i], label);
                this.p.add(label);
                this.p.add(config.getControls(), "wrap,grow");
                this.configurers.add(config);
            }
            this.setVisibility(name[i], c.getAttributeVisibility(name[i]));
        }
    }

    public static Configurer createConfigurer(Class<?> type, String key, String prompt, AutoConfigurable target) {
        Configurer config = null;
        if (String.class.isAssignableFrom(type)) {
            config = new StringConfigurer(key, prompt);
        } else if (Integer.class.isAssignableFrom(type)) {
            config = new IntConfigurer(key, prompt);
        } else if (Double.class.isAssignableFrom(type)) {
            config = new DoubleConfigurer(key, prompt);
        } else if (Boolean.class.isAssignableFrom(type)) {
            config = new BooleanConfigurer(key, prompt);
        } else if (Image.class.isAssignableFrom(type)) {
            config = new ImageConfigurer(key, prompt, GameModule.getGameModule().getArchiveWriter());
        } else if (Color.class.isAssignableFrom(type)) {
            config = new ColorConfigurer(key, prompt);
        } else if (KeyStroke.class.isAssignableFrom(type)) {
            config = new HotKeyConfigurer(key, prompt);
        } else if (NamedKeyStroke.class.isAssignableFrom(type)) {
            config = new NamedHotKeyConfigurer(key, prompt);
        } else if (File.class.isAssignableFrom(type)) {
            config = new FileConfigurer(key, prompt, GameModule.getGameModule().getArchiveWriter());
        } else if (String[].class.isAssignableFrom(type)) {
            config = new StringArrayConfigurer(key, prompt);
        } else if (Icon.class.isAssignableFrom(type)) {
            config = new IconConfigurer(key, prompt, null);
        } else if (PropertyExpression.class.isAssignableFrom(type)) {
            config = new PropertyExpressionConfigurer(key, prompt);
        } else if (TranslatableStringEnum.class.isAssignableFrom(type)) {
            TranslatableStringEnum se = null;
            try {
                se = (TranslatableStringEnum)type.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                ReflectionUtils.handleNewInstanceFailure(t, type);
                config = new StringConfigurer(key, prompt);
            }
            if (se != null) {
                String[] validValues = se.getValidValues(target);
                String[] i18nKeys = se.getI18nKeys(target);
                config = new TranslatingStringEnumConfigurer(key, prompt, validValues, i18nKeys, se.isDisplayNames());
            }
        } else if (StringEnum.class.isAssignableFrom(type)) {
            StringEnum se = null;
            try {
                se = (StringEnum)type.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                ReflectionUtils.handleNewInstanceFailure(t, type);
                config = new StringConfigurer(key, prompt);
            }
            if (se != null) {
                String[] validValues = se.getValidValues(target);
                config = new StringEnumConfigurer(key, prompt, validValues);
            }
        } else if (ConfigurerFactory.class.isAssignableFrom(type)) {
            ConfigurerFactory cf = null;
            try {
                cf = (ConfigurerFactory)type.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                ReflectionUtils.handleNewInstanceFailure(t, type);
            }
            if (cf != null) {
                config = cf.getConfigurer(target, key, prompt);
            }
        } else {
            throw new IllegalArgumentException("Invalid class " + type.getName());
        }
        return config;
    }

    public void reset() {
        String[] s;
        for (String item : s = this.target.getAttributeNames()) {
            Configurer config = this.getConfigurer(item);
            if (config == null) continue;
            config.setValue(this.target.getAttributeValueString(item));
        }
    }

    @Override
    public String getValueString() {
        return this.target.getConfigureName();
    }

    @Override
    public void setValue(String s) {
        throw new UnsupportedOperationException("Can't set Configurable from String");
    }

    @Override
    public Component getControls() {
        return this.p;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.target.setAttribute(evt.getPropertyName(), evt.getNewValue());
        this.checkVisibility();
    }

    public void setVisibility(String attribute, VisibilityCondition c) {
        if (c != null) {
            if (this.conditions == null) {
                this.conditions = new HashMap<String, VisibilityCondition>();
            }
            this.conditions.put(attribute, c);
            this.checkVisibility();
        }
    }

    protected void checkVisibility() {
        boolean visChanged = false;
        if (this.conditions != null) {
            for (Configurer c : this.configurers) {
                VisibilityCondition cond = this.conditions.get(c.getKey());
                if (cond == null || c.getControls().isVisible() == cond.shouldBeVisible()) continue;
                visChanged = true;
                c.getControls().setVisible(cond.shouldBeVisible());
                JComponent label = this.labels.get(c.getKey());
                if (label == null) continue;
                label.setVisible(cond.shouldBeVisible());
            }
            if (visChanged && this.p.getTopLevelAncestor() instanceof Window) {
                SwingUtils.repack((Window)this.p.getTopLevelAncestor());
            }
        }
    }

    public Configurer getConfigurer(String attribute) {
        for (Configurer c : this.configurers) {
            if (!attribute.equals(c.getKey())) continue;
            return c;
        }
        return null;
    }

    public JComponent getLabel(String key) {
        return this.labels.get(key);
    }
}

