/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.configure.ValidationReport;
import VASSAL.i18n.Resources;
import VASSAL.tools.ScrollPane;
import java.awt.Component;
import java.awt.Frame;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class ValidationReportDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final CallBack callback;

    public ValidationReportDialog(ValidationReport report, CallBack cb) {
        super((Frame)GameModule.getGameModule().getPlayerWindow(), false);
        this.setTitle(Resources.getString("Editor.ValidationReportDialog.problems"));
        this.callback = cb;
        Box reportBox = Box.createVerticalBox();
        this.add(reportBox);
        JPanel buttonPanel = new JPanel();
        this.add((Component)buttonPanel, "South");
        List<String> warnings = report.getWarnings();
        switch (warnings.size()) {
            case 0: {
                reportBox.add(new JLabel(Resources.getString("Editor.ValidationReportDialog.no_problems")));
                buttonPanel.add(this.createOkButton());
                break;
            }
            case 1: {
                reportBox.add(new JLabel(Resources.getString("Editor.ValidationReportDialog.a_problem")));
                reportBox.add(new JLabel(warnings.get(0) + "."));
                buttonPanel.add(this.createOkButton());
                buttonPanel.add(this.createCancelButton());
                break;
            }
            default: {
                reportBox.add(new JLabel(Resources.getString("Editor.ValidationReportDialog.following_problems")));
                reportBox.add(new JLabel(Resources.getString("Editor.ValidationReportDialog.danger_will_robinson")));
                JList<String> list = new JList<String>(warnings.toArray(new String[0]));
                list.setVisibleRowCount(Math.min(list.getVisibleRowCount(), warnings.size()));
                reportBox.add(new ScrollPane(list));
                buttonPanel.add(this.createOkButton());
                buttonPanel.add(this.createCancelButton());
            }
        }
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private JButton createCancelButton() {
        JButton cancel = new JButton(Resources.getString("General.cancel"));
        cancel.addActionListener(e -> {
            this.callback.cancel();
            this.dispose();
        });
        return cancel;
    }

    private JButton createOkButton() {
        JButton ok = new JButton(Resources.getString("Editor.ValidationReportDialog.ignore"));
        ok.addActionListener(e -> {
            this.callback.ok();
            this.dispose();
        });
        return ok;
    }

    public static interface CallBack {
        public void ok();

        public void cancel();
    }
}

