/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.KeyStroke;

public class Marker
extends Decorator
implements EditablePiece {
    public static final String ID = "mark;";
    protected String[] keys;
    protected String[] values;

    public Marker() {
        this(ID, null);
    }

    public Marker(String type, GamePiece p) {
        this.mySetType(type);
        this.setInner(p);
    }

    public String[] getKeys() {
        return this.keys;
    }

    @Override
    public void mySetType(String s) {
        s = s.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ',');
        ArrayList<String> l = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        this.keys = l.toArray(new String[0]);
        this.values = new String[this.keys.length];
        Arrays.fill(this.values, "");
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public Object getProperty(Object key) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(key)) continue;
            return this.values[i];
        }
        return super.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(key)) continue;
            return this.values[i];
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public void setProperty(Object key, Object value) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(key)) continue;
            this.values[i] = (String)value;
            return;
        }
        super.setProperty(key, value);
    }

    @Override
    public String myGetState() {
        SequenceEncoder se = new SequenceEncoder(',');
        for (String value : this.values) {
            se.append(value);
        }
        return se.getValue();
    }

    @Override
    public void mySetState(String state) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(state, ',');
        int i = 0;
        while (st.hasMoreTokens() && i < this.values.length) {
            this.values[i++] = st.nextToken();
        }
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(',');
        for (String key : this.keys) {
            se.append(key);
        }
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return KeyCommand.NONE;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    @Override
    public String getDescription() {
        Object result = Resources.getString("Editor.Marker.trait_description");
        if (this.keys != null && this.keys.length > 0 && this.keys[0].length() > 0) {
            result = (String)result + " - " + this.keys[0];
            if (this.values.length > 0 && this.values[0].length() > 0) {
                result = (String)result + " = " + this.values[0];
            }
            if (this.keys.length > 1) {
                result = (String)result + " " + Resources.getString("Editor.Marker.more_keys", this.keys.length - 1);
            }
        }
        return result;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("PropertyMarker.html");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        Collections.addAll(l, this.keys);
        return l;
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof Marker)) {
            return false;
        }
        Marker c = (Marker)o;
        if (!Arrays.equals(this.keys, c.keys)) {
            return false;
        }
        return Arrays.equals(this.values, c.values);
    }

    @Override
    public List<String> getExpressionList() {
        return Arrays.asList(this.values);
    }

    @Override
    public List<String> getPropertyList() {
        return Arrays.asList(this.values);
    }

    private static class Ed
    implements PieceEditor {
        private final StringConfigurer propName;
        private final StringConfigurer propValue;
        private final TraitConfigPanel panel = new TraitConfigPanel();

        private Ed(Marker m) {
            SequenceEncoder seKeys = new SequenceEncoder(',');
            for (int i = 0; i < m.keys.length; ++i) {
                seKeys.append(m.keys[i]);
            }
            SequenceEncoder seValues = new SequenceEncoder(',');
            for (int i = 0; i < m.values.length; ++i) {
                seValues.append(m.values[i]);
            }
            this.propName = new StringConfigurer(m.keys.length == 0 ? "" : seKeys.getValue());
            this.panel.add("Editor.Marker.property_name", (Configurer)this.propName);
            this.propValue = new StringConfigurer(m.values.length == 0 ? "" : seValues.getValue());
            this.panel.add("Editor.Marker.property_value", (Configurer)this.propValue);
        }

        @Override
        public Component getControls() {
            return this.panel;
        }

        @Override
        public String getState() {
            return this.propValue.getValueString();
        }

        @Override
        public String getType() {
            return Marker.ID + this.propName.getValueString();
        }
    }
}

