/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class MovementMarkable
extends Decorator
implements TranslatablePiece {
    public static final String ID = "markmoved;";
    private int xOffset = 0;
    private int yOffset = 0;
    private String command;
    private NamedKeyStroke key;
    private final IconConfigurer movedIcon = new IconConfigurer("/images/moved.gif");
    private boolean hasMoved = false;
    private String description;

    public MovementMarkable() {
        this("markmoved;moved.gif;0;0", null);
    }

    public MovementMarkable(String type, GamePiece p) {
        this.mySetType(type);
        this.setInner(p);
    }

    public boolean isMoved() {
        return this.hasMoved;
    }

    public void setMoved(boolean b) {
        this.hasMoved = b;
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.movedIcon.setValue(st.nextToken());
        this.xOffset = st.nextInt(0);
        this.yOffset = st.nextInt(0);
        this.command = st.nextToken(Resources.getString("Editor.MovementMarkable.default_command"));
        this.key = st.nextNamedKeyStroke('M');
        this.description = st.nextToken("");
    }

    @Override
    public void mySetState(String newState) {
        this.hasMoved = "true".equals(newState);
    }

    @Override
    public String myGetState() {
        return String.valueOf(this.hasMoved);
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.movedIcon.getValueString()).append(this.xOffset).append(this.yOffset).append(this.command).append(this.key).append(this.description);
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        KeyCommand[] keyCommandArray;
        if (this.command.isEmpty() || this.key == null || this.key.isNull()) {
            keyCommandArray = KeyCommand.NONE;
        } else {
            KeyCommand[] keyCommandArray2 = new KeyCommand[1];
            keyCommandArray = keyCommandArray2;
            keyCommandArray2[0] = new KeyCommand(this.command, this.key, Decorator.getOutermost(this), (TranslatablePiece)this);
        }
        return keyCommandArray;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        if (stroke == null) {
            return null;
        }
        if (this.key.equals(stroke)) {
            ChangeTracker c = new ChangeTracker(this);
            Decorator.getOutermost(this).setProperty("Moved", !this.hasMoved);
            return c.getChangeCommand();
        }
        return null;
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public Rectangle boundingBox() {
        Rectangle r = this.piece.boundingBox();
        r.add(this.piece.boundingBox());
        Dimension d = this.getImageSize();
        r.add(new Rectangle(this.xOffset, this.yOffset, d.width, d.height));
        return r;
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
        if (this.hasMoved && this.movedIcon.getIconValue() != null) {
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform transform = g2d.getTransform();
            g2d.scale(zoom, zoom);
            this.movedIcon.getIconValue().paintIcon(obs, g, (int)Math.round((double)x / zoom) + this.xOffset, (int)Math.round((double)y / zoom) + this.yOffset);
            g2d.setTransform(transform);
        }
    }

    private Dimension getImageSize() {
        Icon icon = this.movedIcon.getIconValue();
        return icon != null ? new Dimension(icon.getIconWidth(), icon.getIconHeight()) : new Dimension();
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.MovementMarkable.trait_description", this.description);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("MarkMoved.html");
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if ("Moved".equals(key)) {
            return this.isMoved() ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public Object getProperty(Object key) {
        if ("Moved".equals(key)) {
            return this.isMoved() ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.getProperty(key);
    }

    @Override
    public void setProperty(Object key, Object val) {
        if ("Moved".equals(key)) {
            this.setMoved(Boolean.TRUE.equals(val));
            this.piece.setProperty(key, val);
        } else {
            super.setProperty(key, val);
        }
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.command, Resources.getString("Editor.MovementMarkable.mark_moved_command"));
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof MovementMarkable)) {
            return false;
        }
        MovementMarkable c = (MovementMarkable)o;
        if (!Objects.equals(this.movedIcon.getValueString(), c.movedIcon.getValueString())) {
            return false;
        }
        if (!Objects.equals(this.xOffset, c.xOffset)) {
            return false;
        }
        if (!Objects.equals(this.yOffset, c.yOffset)) {
            return false;
        }
        if (!Objects.equals(this.command, c.command)) {
            return false;
        }
        if (!Objects.equals(this.key, c.key)) {
            return false;
        }
        return Objects.equals(this.hasMoved, c.hasMoved);
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("Moved");
        return l;
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Collections.singletonList(this.key);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.command);
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        String iconName = this.movedIcon.getValueString();
        if (iconName != null) {
            s.add(iconName);
        }
    }

    private static class Ed
    implements PieceEditor {
        private final IconConfigurer iconConfig;
        private final IntConfigurer xOff;
        private final IntConfigurer yOff;
        private final StringConfigurer command;
        private final NamedHotKeyConfigurer key;
        private final TraitConfigPanel box = new TraitConfigPanel();
        private final StringConfigurer descInput;

        private Ed(MovementMarkable p) {
            this.descInput = new StringConfigurer(p.description);
            this.descInput.setHintKey("Editor.description_hint");
            this.box.add("Editor.description_label", (Configurer)this.descInput);
            this.command = new StringConfigurer(p.command);
            this.command.setHintKey("Editor.menu_command_hint");
            this.box.add("Editor.menu_command", (Configurer)this.command);
            this.key = new NamedHotKeyConfigurer(p.key);
            this.box.add("Editor.keyboard_command", (Configurer)this.key);
            this.iconConfig = p.movedIcon;
            this.box.add("Editor.MovementMarkable.marker_image", (Configurer)this.iconConfig);
            this.xOff = new IntConfigurer(p.xOffset);
            this.box.add("Editor.MovementMarkable.horizontal_offset", (Configurer)this.xOff);
            this.yOff = new IntConfigurer(p.yOffset);
            this.box.add("Editor.MovementMarkable.vertical_offset", (Configurer)this.yOff);
        }

        @Override
        public Component getControls() {
            boolean enabled = false;
            for (Map m : Map.getMapList()) {
                String value = m.getAttributeValueString("markMoved");
                enabled = enabled || "Always".equals(value) || "Use Preferences Setting".equals(value);
            }
            if (!enabled) {
                Runnable runnable = () -> JOptionPane.showMessageDialog(this.box, Resources.getString("Editor.MovementMarkable.enable_text"), Resources.getString("Editor.MovementMarkable.option_not_enabled"), 2);
                SwingUtilities.invokeLater(runnable);
            }
            return this.box;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.iconConfig.getValueString()).append(this.xOff.getValueString()).append(this.yOff.getValueString()).append(this.command.getValueString()).append(this.key.getValueString()).append(this.descInput.getValueString());
            return MovementMarkable.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "false";
        }
    }
}

