/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.preferences;

import VASSAL.Info;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.GlobalPrefs;
import VASSAL.preferences.PrefsEditor;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.ReadErrorDialog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.NoSuchFileException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;

public class Prefs
implements Closeable {
    public static final String MODULES_DIR_KEY = "modulesDir";
    public static final String DISABLE_D3D = "disableD3d";
    public static final String MAIN_WINDOW_REMEMBER = "mainWindowRemember";
    public static final String MAIN_WINDOW_HEIGHT = "mainWindowHeight";
    public static final String MAIN_WINDOW_WIDTH = "mainWindowWidth";
    public static final String TRANSLATABLE_SUPPORT = "translatableSupport";
    private static Prefs globalPrefs;
    private final Map<String, Configurer> options = new HashMap<String, Configurer>();
    private final Properties storedValues = new Properties();
    private final PrefsEditor editor;
    private final File file;

    public Prefs(PrefsEditor editor, String name) {
        this(editor, new File(Info.getPrefsDir(), Prefs.sanitize(name)));
    }

    protected Prefs(PrefsEditor editor, File file) {
        this.editor = editor;
        this.file = file;
        this.read();
        for (String key : this.storedValues.stringPropertyNames()) {
            String value = this.storedValues.getProperty(key);
            Configurer c = this.options.get(key);
            if (c == null) continue;
            c.setValue(value);
        }
        editor.addPrefs(this);
    }

    public PrefsEditor getEditor() {
        return this.editor;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isDisableAutoWrite() {
        return false;
    }

    public void setDisableAutoWrite(boolean b) {
    }

    public void addOption(Configurer o) {
        this.addOption(Resources.getString("Prefs.general_tab"), o);
    }

    public void addOption(String category, Configurer o) {
        this.addOption(category, o, null);
    }

    public synchronized void addOption(String category, Configurer o, String prompt) {
        if (o != null && this.options.get(o.getKey()) == null) {
            this.options.put(o.getKey(), o);
            String val = this.storedValues.getProperty(o.getKey());
            if (val != null) {
                o.setValue(val);
                prompt = null;
            }
            if (category != null && o.getControls() != null) {
                this.editor.addOption(category, o, prompt);
            }
        }
    }

    public synchronized void setValue(String option, Object value) {
        this.options.get(option).setValue(value);
    }

    public synchronized Configurer getOption(String s) {
        return this.options.get(s);
    }

    public synchronized Object getValue(String key) {
        Configurer c = this.options.get(key);
        return c == null ? null : c.getValue();
    }

    public synchronized String getStoredValue(String key) {
        return this.storedValues.getProperty(key);
    }

    protected synchronized void read() {
        try (RandomAccessFile raf2 = new RandomAccessFile(this.file, "rw");){
            FileChannel ch = raf2.getChannel();
            try (FileLock lock = ch.lock();){
                BufferedInputStream in = new BufferedInputStream(Channels.newInputStream(ch));
                this.storedValues.clear();
                this.storedValues.load(in);
            }
        }
        catch (NoSuchFileException raf2) {
        }
        catch (IOException e) {
            ReadErrorDialog.errorNoI18N(e, this.file);
        }
    }

    public synchronized void save() throws IOException {
        this.storedValues.clear();
        if (!Info.getPrefsDir().exists()) {
            FileUtils.forceMkdir((File)Info.getPrefsDir());
        }
        try (RandomAccessFile raf = new RandomAccessFile(this.file, "rw");){
            FileChannel ch = raf.getChannel();
            try (FileLock lock = ch.lock();){
                BufferedInputStream in = new BufferedInputStream(Channels.newInputStream(ch));
                this.storedValues.load(in);
                for (Configurer c : this.options.values()) {
                    String val = c.getValueString();
                    if (val == null) continue;
                    this.storedValues.put(c.getKey(), val);
                }
                ch.truncate(0L);
                ch.position(0L);
                BufferedOutputStream out = new BufferedOutputStream(Channels.newOutputStream(ch));
                this.storedValues.store(out, null);
                ((OutputStream)out).flush();
            }
        }
    }

    @Deprecated(since="2021-02-15", forRemoval=true)
    public void write() throws IOException {
        ProblemDialog.showDeprecated("2021-02-15");
        this.save();
    }

    @Override
    public void close() throws IOException {
        this.save();
    }

    public static synchronized Prefs getGlobalPrefs() {
        if (globalPrefs == null) {
            PrefsEditor ed = new PrefsEditor();
            globalPrefs = new GlobalPrefs(ed, new File(Info.getPrefsDir(), "V_Global"));
        }
        return globalPrefs;
    }

    public static void initSharedGlobalPrefs() {
        Prefs.getGlobalPrefs();
        DirectoryConfigurer c = new DirectoryConfigurer(MODULES_DIR_KEY, null);
        c.setValue(new File(System.getProperty("user.home")));
        globalPrefs.addOption(null, c);
        BooleanConfigurer windowRemember = new BooleanConfigurer(MAIN_WINDOW_REMEMBER, Resources.getString("Prefs.main_window"), Boolean.TRUE);
        globalPrefs.addOption(Resources.getString("Prefs.general_tab"), windowRemember);
        IntConfigurer windowWidth = new IntConfigurer(MAIN_WINDOW_WIDTH, null, (Integer)-1);
        globalPrefs.addOption(null, windowWidth);
        IntConfigurer windowHeight = new IntConfigurer(MAIN_WINDOW_HEIGHT, null, (Integer)-1);
        globalPrefs.addOption(null, windowHeight);
        if (SystemUtils.IS_OS_WINDOWS) {
            BooleanConfigurer d3dConf = new BooleanConfigurer(DISABLE_D3D, Resources.getString("Prefs.disable_d3d"), Boolean.FALSE);
            globalPrefs.addOption(Resources.getString("Prefs.compatibility_tab"), d3dConf);
        }
        BooleanConfigurer wizardConf = new BooleanConfigurer("welcomeWizard", Resources.getString("WizardSupport.ShowWizard"), Boolean.TRUE);
        globalPrefs.addOption(wizardConf);
        BooleanConfigurer translatableSupport = new BooleanConfigurer(TRANSLATABLE_SUPPORT, "Translatable Support", Boolean.FALSE);
        globalPrefs.addOption(null, translatableSupport);
    }

    public static String sanitize(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            int cp = str.codePointAt(i);
            if (48 <= cp && cp <= 57 || 65 <= cp && cp <= 90 || 97 <= cp && cp <= 122) {
                sb.append((char)cp);
                continue;
            }
            sb.append('_').append(Integer.toHexString(cp).toUpperCase()).append('_');
        }
        return sb.toString();
    }
}

