/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.Info;
import VASSAL.i18n.Resources;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.BugUtils;
import VASSAL.tools.swing.DetailsButton;
import VASSAL.tools.swing.FlowLabel;
import VASSAL.tools.version.VersionUtils;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BugDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(BugDialog.class);
    private final Throwable thrown;
    private final String errorLog;
    private JPanel contents;
    private CardLayout deck;
    private JPanel buttons;
    private CardLayout button_deck;
    private JTextArea descriptionArea;
    private JTextField emailField;
    private JScrollPane descriptionScroll;
    private CheckRequest checkRequest = null;
    private SendRequest sendRequest = null;

    public BugDialog(Frame owner, Throwable thrown) {
        super(owner, true);
        this.thrown = thrown;
        this.errorLog = BugUtils.getErrorLog();
        JXHeader header = new JXHeader(Resources.getString("BugDialog.heading"), Resources.getString("BugDialog.message"), (Icon)new ImageIcon(BugDialog.class.getResource("/icons/48x48/bug.png")));
        this.setTitle(Resources.getString("BugDialog.title"));
        this.setLocationRelativeTo(owner);
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (BugDialog.this.checkRequest != null) {
                    BugDialog.this.checkRequest.cancel(true);
                }
                if (BugDialog.this.sendRequest != null) {
                    BugDialog.this.sendRequest.cancel(true);
                }
            }
        });
        this.add((Component)header, "North");
        this.add(this.buildContentsPanel(), "Center");
        this.add(this.buildButtonPanel(), "South");
        this.showVersionCheckPanel();
        this.pack();
    }

    private Component buildContentsPanel() {
        this.deck = new CardLayout();
        this.contents = new JPanel(this.deck);
        this.contents.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 12));
        this.contents.add(this.buildVersionCheckPanel(), "versionCheckPanel");
        this.contents.add(this.buildCurrentVersionPanel(), "currentVersionPanel");
        this.contents.add(this.buildSendingBugReportPanel(), "sendingBugReportPanel");
        this.contents.add(this.buildOldVersionPanel(), "oldVersionPanel");
        this.contents.add(this.buildConnectionFailedPanel(), "connectionFailedPanel");
        this.contents.add(this.buildEmergencySavePanel(), "emergencySavePanel");
        return this.contents;
    }

    private Component buildButtonPanel() {
        this.button_deck = new CardLayout();
        this.buttons = new JPanel(this.button_deck);
        this.buttons.add(this.buildVersionCheckButtons(), "versionCheckButtons");
        this.buttons.add(this.buildCurrentVersionButtons(), "currentVersionButtons");
        this.buttons.add(this.buildSendingBugReportButtons(), "sendingBugReportButtons");
        this.buttons.add(this.buildOldVersionButtons(), "oldVersionButtons");
        this.buttons.add(this.buildConnectionFailedButtons(), "connectionFailedButtons");
        this.buttons.add(this.buildEmergencySaveButtons(), "emergencySaveButtons");
        return this.buttons;
    }

    private Component buildVersionCheckPanel() {
        JXBusyLabel spinner = new JXBusyLabel(new Dimension(40, 40));
        spinner.setBusy(true);
        FlowLabel label = new FlowLabel(Resources.getString("BugDialog.collecting_details"));
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "", "[]push[]push"));
        panel.add((Component)label, "cell 0 0, growx, pushx");
        panel.add((Component)spinner, "cell 0 1, align center");
        return panel;
    }

    private Component buildVersionCheckButtons() {
        JButton cancelButton = new JButton(new AbstractAction(Resources.getString("General.cancel")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BugDialog.this.dispose();
            }
        });
        JPanel panel = new JPanel((LayoutManager)new MigLayout("align right"));
        panel.add((Component)cancelButton, "tag cancel");
        return panel;
    }

    private Component buildCurrentVersionPanel() {
        FlowLabel label = new FlowLabel(Resources.getString("BugDialog.current_version_instructions"));
        this.descriptionArea = new JTextArea(10, 1);
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setWrapStyleWord(true);
        this.descriptionScroll = new JScrollPane(this.descriptionArea);
        JLabel descriptionLabel = new JLabel(Resources.getString("BugDialog.bug_description"));
        descriptionLabel.setFont(descriptionLabel.getFont().deriveFont(1));
        descriptionLabel.setLabelFor(this.descriptionScroll);
        this.emailField = new JTextField(26);
        JLabel emailLabel = new JLabel(Resources.getString("BugDialog.user_email_address"));
        emailLabel.setLabelFor(this.emailField);
        JScrollPane detailsScroll = this.buildDetailsScroll();
        DetailsButton detailsButton = new DetailsButton(Resources.getString("Dialogs.show_details"), Resources.getString("Dialogs.hide_details"), detailsScroll);
        detailsButton.setBuddy(label);
        JPanel panel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "", "[]unrel[]rel[]unrel[]unrel[]rel[]"));
        panel.add((Component)label, "cell 0 0, growx, pushx");
        panel.add((Component)descriptionLabel, "cell 0 1");
        panel.add((Component)this.descriptionScroll, "cell 0 2, grow, push");
        panel.add((Component)emailLabel, "cell 0 3");
        panel.add((Component)this.emailField, "cell 0 3, growx, pushx");
        panel.add((Component)detailsButton, "cell 0 4");
        panel.add((Component)detailsScroll, "cell 0 5, grow, push");
        return panel;
    }

    private Component buildCurrentVersionButtons() {
        JButton sendButton = new JButton(new AbstractAction(Resources.getString("BugDialog.send_button")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BugDialog.this.showSendingBugReportPanel();
            }
        });
        JButton dontSendButton = new JButton(new AbstractAction(Resources.getString("BugDialog.dont_send_button")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BugDialog.this.showEmergencySavePanel();
            }
        });
        JPanel panel = new JPanel((LayoutManager)new MigLayout("align right"));
        panel.add((Component)sendButton, "tag ok");
        panel.add((Component)dontSendButton, "tag cancel");
        return panel;
    }

    private JScrollPane buildDetailsScroll() {
        JTextArea detailsArea = new JTextArea(this.errorLog, 10, 20);
        detailsArea.setEditable(false);
        detailsArea.setTabSize(2);
        return new JScrollPane(detailsArea);
    }

    private Component buildOldVersionPanel() {
        FlowLabel label = new FlowLabel(Resources.getString("BugDialog.old_version_instructions"));
        label.addHyperlinkListener(BrowserSupport.getListener());
        JScrollPane detailsScroll = this.buildDetailsScroll();
        DetailsButton detailsButton = new DetailsButton(Resources.getString("Dialogs.show_details"), Resources.getString("Dialogs.hide_details"), detailsScroll);
        detailsButton.setBuddy(label);
        JPanel panel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "", "[]unrel[]rel[]"));
        panel.add((Component)label, "cell 0 0, growx, pushx");
        panel.add((Component)detailsButton, "cell 0 1");
        panel.add((Component)detailsScroll, "cell 0 2, grow, push");
        return panel;
    }

    private Component buildOldVersionButtons() {
        JButton okButton = new JButton(new AbstractAction(Resources.getString("General.ok")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BugDialog.this.showEmergencySavePanel();
            }
        });
        JPanel panel = new JPanel((LayoutManager)new MigLayout("align right"));
        panel.add((Component)okButton, "tag ok");
        return panel;
    }

    private Component buildConnectionFailedPanel() {
        String errorLogPath = Info.getErrorLogPath().getAbsolutePath();
        FlowLabel label = new FlowLabel(Resources.getString("BugDialog.connection_failed_instructions", errorLogPath));
        label.addHyperlinkListener(BrowserSupport.getListener());
        JScrollPane detailsScroll = this.buildDetailsScroll();
        DetailsButton detailsButton = new DetailsButton(Resources.getString("Dialogs.show_details"), Resources.getString("Dialogs.hide_details"), detailsScroll);
        detailsButton.setBuddy(label);
        JPanel panel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "", "[]unrel[]rel[]"));
        panel.add((Component)label, "cell 0 0, growx, pushx");
        panel.add((Component)detailsButton, "cell 0 1");
        panel.add((Component)detailsScroll, "cell 0 2, grow, push");
        return panel;
    }

    private Component buildConnectionFailedButtons() {
        JButton okButton = new JButton(new AbstractAction(Resources.getString("General.ok")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BugDialog.this.showEmergencySavePanel();
            }
        });
        JPanel panel = new JPanel((LayoutManager)new MigLayout("align right"));
        panel.add((Component)okButton, "tag ok");
        return panel;
    }

    private Component buildEmergencySavePanel() {
        FlowLabel label = new FlowLabel(Resources.getString("BugDialog.how_to_proceed"));
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "", "[]push"));
        panel.add((Component)label, "cell 0 0, growx, pushx");
        return panel;
    }

    private Component buildEmergencySaveButtons() {
        JButton okButton = new JButton(new AbstractAction(Resources.getString("General.ok")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BugDialog.this.dispose();
            }
        });
        JPanel panel = new JPanel((LayoutManager)new MigLayout("align right"));
        panel.add((Component)okButton, "tag ok");
        return panel;
    }

    private void showVersionCheckPanel() {
        this.deck.show(this.contents, "versionCheckPanel");
        this.button_deck.show(this.buttons, "versionCheckButtons");
    }

    private void showCurrentVersionPanel() {
        this.deck.show(this.contents, "currentVersionPanel");
        this.button_deck.show(this.buttons, "currentVersionButtons");
    }

    private void showSendingBugReportPanel() {
        this.deck.show(this.contents, "sendingBugReportPanel");
        this.button_deck.show(this.buttons, "sendingBugReportButtons");
        this.sendRequest = new SendRequest();
        this.sendRequest.execute();
    }

    private void showOldVersionPanel() {
        this.deck.show(this.contents, "oldVersionPanel");
        this.button_deck.show(this.buttons, "oldVersionButtons");
    }

    private void showConnectionFailedPanel() {
        this.deck.show(this.contents, "connectionFailedPanel");
        this.button_deck.show(this.buttons, "connectionFailedButtons");
    }

    private void showEmergencySavePanel() {
        this.deck.show(this.contents, "emergencySavePanel");
        this.button_deck.show(this.buttons, "emergencySaveButtons");
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && !this.isVisible()) {
            this.checkRequest = new CheckRequest();
            this.checkRequest.execute();
        }
        super.setVisible(visible);
    }

    private Component buildSendingBugReportPanel() {
        JXBusyLabel spinner = new JXBusyLabel(new Dimension(40, 40));
        spinner.setBusy(true);
        FlowLabel label = new FlowLabel(Resources.getString("BugDialog.sending_bug_report"));
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "", "[]push[]push"));
        panel.add((Component)label, "cell 0 0, growx, pushx");
        panel.add((Component)spinner, "cell 0 1, align center");
        return panel;
    }

    private Component buildSendingBugReportButtons() {
        JButton cancelButton = new JButton(new AbstractAction(Resources.getString("General.cancel")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BugDialog.this.dispose();
            }
        });
        JPanel panel = new JPanel((LayoutManager)new MigLayout("align right"));
        panel.add((Component)cancelButton, "tag cancel");
        return panel;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            BugDialog bd = new BugDialog(null, null);
            bd.setVisible(true);
        });
    }

    private class CheckRequest
    extends SwingWorker<Boolean, Void> {
        private Timer timer = null;

        private CheckRequest() {
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            CountDownLatch latch = new CountDownLatch(1);
            this.timer = new Timer(2000, e -> latch.countDown());
            this.timer.start();
            Boolean cur = VersionUtils.isCurrent(Info.getVersion());
            latch.await();
            return cur;
        }

        @Override
        protected void done() {
            try {
                if (((Boolean)this.get(10L, TimeUnit.SECONDS)).booleanValue()) {
                    BugDialog.this.showCurrentVersionPanel();
                } else {
                    BugDialog.this.showOldVersionPanel();
                }
            }
            catch (CancellationException e) {
                this.timer.stop();
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                this.timer.stop();
                logger.error("", (Throwable)e);
                BugDialog.this.showConnectionFailedPanel();
            }
        }
    }

    private class SendRequest
    extends SwingWorker<Void, Void> {
        private Timer timer = null;

        private SendRequest() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            CountDownLatch latch = new CountDownLatch(1);
            this.timer = new Timer(2000, e -> latch.countDown());
            this.timer.start();
            BugUtils.sendBugReport(BugDialog.this.emailField.getText(), BugDialog.this.descriptionArea.getText(), BugDialog.this.errorLog, BugDialog.this.thrown);
            latch.await();
            return null;
        }

        @Override
        protected void done() {
            try {
                this.get(10L, TimeUnit.SECONDS);
                BugDialog.this.showEmergencySavePanel();
            }
            catch (CancellationException e) {
                this.timer.stop();
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                this.timer.stop();
                logger.error("", (Throwable)e);
                BugDialog.this.showConnectionFailedPanel();
            }
        }
    }
}

