/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.GameModule;
import VASSAL.build.GpIdChecker;
import VASSAL.build.GpIdSupport;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.PrototypesContainer;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.widget.PieceSlot;
import VASSAL.command.ChangePiece;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.NullCommand;
import VASSAL.command.RemovePiece;
import VASSAL.counters.Deck;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Immobilized;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GameRefresher
implements CommandEncoder,
GameComponent {
    private static final Logger logger = LoggerFactory.getLogger(GameRefresher.class);
    private static final char DELIMITER = '\t';
    public static final String COMMAND_PREFIX = "DECKREPOS\t";
    private String id;
    private Point newPosition;
    private Action refreshAction;
    private final GpIdSupport gpIdSupport;
    private GpIdChecker gpIdChecker;
    private RefreshDialog dialog;
    private int updatedCount;
    private int notFoundCount;
    private int noStackCount;
    private int noMapCount;
    private final GameModule theModule;
    private final Set<String> options = new HashSet<String>();

    public GameRefresher(GpIdSupport gpIdSupport) {
        this.gpIdSupport = gpIdSupport;
        this.theModule = GameModule.getGameModule();
    }

    @Override
    public String encode(Command c) {
        if (c instanceof DeckRepositionCommand) {
            DeckRepositionCommand drc = (DeckRepositionCommand)c;
            SequenceEncoder se = new SequenceEncoder('\t');
            se.append(drc.id).append(drc.newPosition.x).append(drc.newPosition.y).append(drc.oldPosition.x).append(drc.oldPosition.y);
            return COMMAND_PREFIX + se.getValue();
        }
        return null;
    }

    @Override
    public Command decode(String s) {
        if (s.startsWith(COMMAND_PREFIX)) {
            SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, '\t');
            sd.nextToken();
            String id = sd.next();
            int x = sd.nextInt(0);
            int y = sd.nextInt(0);
            Point newPosition = new Point(x, y);
            int xold = sd.nextInt(0);
            int yold = sd.nextInt(0);
            Point oldPosition = new Point(xold, yold);
            return new DeckRepositionCommand(id, newPosition, oldPosition);
        }
        return null;
    }

    public void addTo(AbstractConfigurable parent) {
        this.refreshAction = new AbstractAction(Resources.getString("GameRefresher.refresh_counters")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                new GameRefresher(GameRefresher.this.gpIdSupport).start();
            }
        };
        GameModule.getGameModule().getGameState().addGameComponent(this);
        GameModule.getGameModule().addCommandEncoder(this);
        this.refreshAction.setEnabled(false);
    }

    public Action getRefreshAction() {
        return this.refreshAction;
    }

    public boolean isTestMode() {
        return this.options.contains("TestMode");
    }

    public boolean isDeleteNoMap() {
        return this.options.contains("DeleteNoMap");
    }

    public void start() {
        this.dialog = new RefreshDialog(this);
        this.dialog.setVisible(true);
        this.dialog = null;
    }

    public void log(String message) {
        GameModule.getGameModule().warn(message);
        logger.info(message);
    }

    public List<GamePiece> getCurrentGameRefresherPieces() {
        ArrayList<GamePiece> pieces = new ArrayList<GamePiece>();
        int totalCount = 0;
        int notOwnedCount = 0;
        int notVisibleCount = 0;
        for (GamePiece piece : this.theModule.getGameState().getAllPieces()) {
            Iterator<GamePiece> i;
            if (piece instanceof Deck) {
                i = ((Stack)piece).getPiecesInVisibleOrderIterator();
                while (i.hasNext()) {
                    ++totalCount;
                    pieces.add(0, i.next());
                }
                continue;
            }
            if (piece instanceof Stack) {
                i = ((Stack)piece).getPiecesInVisibleOrderIterator();
                while (i.hasNext()) {
                    GamePiece p = i.next();
                    if (!Boolean.TRUE.equals(p.getProperty("Invisible")) && !Boolean.TRUE.equals(p.getProperty("Obscured"))) {
                        ++totalCount;
                        pieces.add(0, p);
                        continue;
                    }
                    if (Boolean.TRUE.equals(piece.getProperty("Invisible"))) {
                        ++notVisibleCount;
                        continue;
                    }
                    ++notOwnedCount;
                }
                continue;
            }
            if (piece.getParent() != null) continue;
            if (!Boolean.TRUE.equals(piece.getProperty("Invisible")) && !Boolean.TRUE.equals(piece.getProperty("Obscured"))) {
                ++totalCount;
                pieces.add(0, piece);
                continue;
            }
            if (Boolean.TRUE.equals(piece.getProperty("Invisible"))) {
                ++notVisibleCount;
                continue;
            }
            ++notOwnedCount;
        }
        this.log(Resources.getString("GameRefresher.get_all_pieces"));
        this.log(Resources.getString("GameRefresher.counters_total", totalCount));
        this.log(Resources.getString("GameRefresher.counters_kept", totalCount - notOwnedCount - notVisibleCount));
        this.log(Resources.getString("GameRefresher.counters_not_owned", notOwnedCount));
        this.log(Resources.getString("GameRefresher.counters_not_visible", notVisibleCount));
        this.log("-");
        return pieces;
    }

    public void execute(Set<String> options, Command command) throws IllegalBuildException {
        if (command == null) {
            command = new NullCommand();
        }
        if (!options.isEmpty()) {
            this.options.addAll(options);
        }
        this.notFoundCount = 0;
        this.updatedCount = 0;
        this.noMapCount = 0;
        this.noStackCount = 0;
        if (Objects.isNull(this.gpIdChecker)) {
            this.gpIdChecker = new GpIdChecker(options);
            for (PieceSlot slot : this.theModule.getAllDescendantComponentsOf(PieceSlot.class)) {
                this.gpIdChecker.add(slot);
            }
            for (PrototypesContainer pc : this.theModule.getComponentsOf(PrototypesContainer.class)) {
                pc.getDefinitions().forEach(this.gpIdChecker::add);
            }
            if (this.gpIdChecker.hasErrors()) {
                this.gpIdChecker = null;
                this.log(Resources.getString("GameRefresher.gpid_error_message"));
                return;
            }
        }
        List<GamePiece> pieces = this.getCurrentGameRefresherPieces();
        for (GamePiece piece : pieces) {
            this.processGamePiece(piece, command);
        }
        this.log(Resources.getString("GameRefresher.run_refresh_counters_v3", this.theModule.getGameVersion()));
        this.log(Resources.getString("GameRefresher.counters_refreshed", this.updatedCount));
        this.log(Resources.getString("GameRefresher.counters_not_found", this.notFoundCount));
        this.log(Resources.getString("GameRefresher.counters_no_map", this.noMapCount));
        this.log("----------");
        this.log(Resources.getString("GameRefresher.counters_no_stack", this.noStackCount));
        this.log("----------");
    }

    private void processGamePiece(GamePiece piece, Command command) {
        GamePiece newPiece;
        Immobilized i;
        Map map = piece.getMap();
        if (map == null) {
            ++this.noMapCount;
            this.log(Resources.getString("GameRefresher.refresh_error_nomap1", piece.getName(), piece.getId()));
            if (this.isDeleteNoMap()) {
                this.log(Resources.getString("GameRefresher.refresh_error_nomap2", piece.getName(), piece.getId()));
                RemovePiece remove = new RemovePiece(Decorator.getOutermost(piece));
                remove.execute();
                command.append(remove);
            }
            return;
        }
        Stack oldStack = piece.getParent();
        if (oldStack == null && (i = (Immobilized)Decorator.getDecorator(piece, Immobilized.class)) == null) {
            ++this.noStackCount;
            this.log(Resources.getString("GameRefresher.refresh_error_nostack", piece.getName(), piece.getId()));
        }
        if ((newPiece = this.gpIdChecker.createUpdatedPiece(piece)) == null) {
            ++this.notFoundCount;
            this.log(Resources.getString("GameRefresher.refresh_error_nomatch_pieceslot", piece.getName(), piece.getId()));
            return;
        }
        ++this.updatedCount;
        if (this.isTestMode()) {
            RemovePiece remove = new RemovePiece(Decorator.getOutermost(newPiece));
            remove.execute();
            command.append(remove);
        } else {
            int newPos;
            Stack newStack;
            Point piecePosition = piece.getPosition();
            Point hiddenPosition = new Point(-100, -100);
            Point tempPosition = piecePosition;
            int oldStackIndex = oldStack == null ? 0 : oldStack.indexOf(piece);
            Stack stack = piece.getParent();
            Deck deck = null;
            String id = "";
            boolean isDeck = stack instanceof Deck;
            if (isDeck) {
                deck = (Deck)stack;
                id = deck.getId();
                tempPosition = this.getDeckFreePosition(deck);
                DeckRepositionCommand deckRepositionCommand = new DeckRepositionCommand(id, tempPosition, piecePosition);
                deckRepositionCommand.execute();
                command.append(deckRepositionCommand);
            }
            RemovePiece remove = new RemovePiece(Decorator.getOutermost(piece));
            remove.execute();
            command.append(remove);
            Command place = map.placeOrMerge(newPiece, hiddenPosition);
            command.append(place);
            place = map.placeOrMerge(newPiece, tempPosition);
            command.append(place);
            if (isDeck) {
                DeckRepositionCommand deckRepositionCommand = new DeckRepositionCommand(id, piecePosition, tempPosition);
                deckRepositionCommand.execute();
                command.append(deckRepositionCommand);
            }
            if ((newStack = newPiece.getParent()) != null && newStack == oldStack && (newPos = newStack.indexOf(newPiece)) >= 0 && oldStackIndex >= 0 && newPos != oldStackIndex) {
                String oldState = newStack.getState();
                newStack.insert(newPiece, oldStackIndex);
                command.append(new ChangePiece(newStack.getId(), oldState, newStack.getState()));
            }
        }
    }

    private Point getDeckFreePosition(Deck deck) {
        Boolean correctTempPositionNotFound;
        Point tempPosition = new Point(-1, -1);
        GamePiece[] pieces = deck.getMap().getAllPieces();
        block0: do {
            correctTempPositionNotFound = false;
            for (GamePiece piece : pieces) {
                Point piecePosition = piece.getPosition();
                if (!piecePosition.equals(tempPosition)) continue;
                --tempPosition.x;
                correctTempPositionNotFound = true;
                continue block0;
            }
        } while (correctTempPositionNotFound.booleanValue());
        return tempPosition;
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    @Override
    public void setup(boolean gameStarting) {
        this.refreshAction.setEnabled(gameStarting);
    }

    private class DeckRepositionCommand
    extends Command {
        private final String id;
        private final Point newPosition;
        private final Point oldPosition;

        public DeckRepositionCommand(String id, Point newPosition, Point oldPosition) {
            this.id = id;
            this.newPosition = newPosition;
            this.oldPosition = oldPosition;
        }

        @Override
        protected void executeCommand() {
            Stack deck = null;
            for (GamePiece piece : GameModule.getGameModule().getGameState().getAllPieces()) {
                String deckId;
                if (!(piece instanceof Deck) || !(deckId = ((Deck)piece).getId()).equals(this.id)) continue;
                deck = (Deck)piece;
                break;
            }
            if (deck == null) {
                return;
            }
            deck.setPosition(this.newPosition);
        }

        @Override
        protected Command myUndoCommand() {
            return new DeckRepositionCommand(this.id, this.oldPosition, this.newPosition);
        }
    }

    static class RefreshDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private final GameRefresher refresher;
        private JTextArea results;
        private JCheckBox nameCheck;
        private JCheckBox testModeOn;
        private JCheckBox labelerNameCheck;
        private JCheckBox layerNameCheck;
        private JCheckBox deletePieceNoMap;
        private final Set<String> options = new HashSet<String>();

        RefreshDialog(GameRefresher refresher) {
            super(GameModule.getGameModule().getPlayerWindow());
            this.refresher = refresher;
            this.setTitle(Resources.getString("GameRefresher.refresh_counters"));
            this.setModal(true);
            this.initComponents();
        }

        protected void initComponents() {
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    this.exit();
                }
            });
            this.setLayout((LayoutManager)new MigLayout("wrap 1", "[fill]"));
            JPanel panel = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 1,gapy 4", "[fill]"));
            panel.setBorder(BorderFactory.createEtchedBorder());
            JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "push[]rel[]rel[]push"));
            JButton runButton = new JButton(Resources.getString("General.run"));
            runButton.addActionListener(e -> this.run());
            JButton exitButton = new JButton(Resources.getString("General.cancel"));
            exitButton.addActionListener(e -> this.exit());
            JButton helpButton = new JButton(Resources.getString("General.help"));
            helpButton.addActionListener(e -> this.help());
            buttonPanel.add((Component)runButton, "tag ok,sg 1");
            buttonPanel.add((Component)exitButton, "tag cancel,sg 1");
            buttonPanel.add((Component)helpButton, "tag help,sg 1");
            this.nameCheck = new JCheckBox(Resources.getString("GameRefresher.use_basic_name"));
            panel.add(this.nameCheck);
            this.labelerNameCheck = new JCheckBox(Resources.getString("GameRefresher.use_labeler_descr"));
            panel.add(this.labelerNameCheck);
            this.layerNameCheck = new JCheckBox(Resources.getString("GameRefresher.use_layer_descr"));
            panel.add(this.layerNameCheck);
            this.testModeOn = new JCheckBox(Resources.getString("GameRefresher.test_mode"));
            panel.add(this.testModeOn);
            this.deletePieceNoMap = new JCheckBox(Resources.getString("GameRefresher.delete_piece_no_map"));
            this.deletePieceNoMap.setSelected(true);
            panel.add(this.deletePieceNoMap);
            panel.add((Component)buttonPanel, "grow");
            this.add((Component)panel, "grow");
            SwingUtils.repack(this);
        }

        protected void setOptions() {
            this.options.clear();
            if (this.nameCheck.isSelected()) {
                this.options.add("UseName");
            }
            if (this.labelerNameCheck.isSelected()) {
                this.options.add("UseLabelerName");
            }
            if (this.layerNameCheck.isSelected()) {
                this.options.add("UseLayerName");
            }
            if (this.testModeOn.isSelected()) {
                this.options.add("TestMode");
            }
            if (this.deletePieceNoMap.isSelected()) {
                this.options.add("DeleteNoMap");
            }
        }

        protected void exit() {
            this.setVisible(false);
        }

        protected void run() {
            GameModule g = GameModule.getGameModule();
            NullCommand command = new NullCommand();
            String player = GlobalOptions.getInstance().getPlayerId();
            this.setOptions();
            if (this.refresher.isTestMode()) {
                this.refresher.log(Resources.getString("GameRefresher.refresh_counters_test_mode"));
            } else {
                Chatter.DisplayText msg = new Chatter.DisplayText(g.getChatter(), Resources.getString("GameRefresher.run_refresh_counters_v2", player, g.getGameVersion()));
                msg.execute();
                command.append(msg);
            }
            this.refresher.execute(this.options, command);
            g.sendAndLog(command);
            this.exit();
        }

        protected void help() {
            File dir = Documentation.getDocumentationBaseDir();
            dir = new File(dir, "ReferenceManual");
            File theFile = new File(dir, "HelpMenu.html");
            HelpFile h = null;
            try {
                h = new HelpFile(null, theFile, "#HelpFile");
            }
            catch (MalformedURLException e) {
                ErrorDialog.bug(e);
            }
            BrowserSupport.openURL(h.getContents().toString());
        }

        public void addMessage(String mess) {
            this.results.setText(this.results.getText() + "\n" + mess);
        }
    }
}

