/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.GameModule;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.ObscurableOptions;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.PieceMover;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.SingleChildInstance;
import VASSAL.configure.StringEnum;
import VASSAL.i18n.Resources;
import VASSAL.preferences.BasicPreference;
import VASSAL.preferences.BooleanPreference;
import VASSAL.preferences.DoublePreference;
import VASSAL.preferences.EnumPreference;
import VASSAL.preferences.IntegerPreference;
import VASSAL.preferences.Prefs;
import VASSAL.preferences.StringPreference;
import VASSAL.preferences.TextPreference;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Container;
import java.awt.dnd.DragSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JLabel;
import org.apache.commons.lang3.SystemUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class GlobalOptions
extends AbstractConfigurable {
    public static final String NON_OWNER_UNMASKABLE = "nonOwnerUnmaskable";
    public static final String PROMPT_STRING = "promptString";
    public static final String MARK_MOVED = "markMoved";
    public static final String AUTO_REPORT = "autoReport";
    public static final String CHATTER_HTML_SUPPORT = "chatterHTMLSupport";
    public static final String TRANSLATABLE_SUPPORT = "translatableSupport";
    public static final String ALWAYS = "Always";
    public static final String NEVER = "Never";
    public static final String PROMPT = "Use Preferences Setting";
    public static final String CENTER_ON_MOVE = "centerOnMove";
    public static final String CENTER_ON_MOVE_SENSITIVITY = "centerOnMoveSensitivity";
    public static final String SINGLE_WINDOW = "singleWindow";
    public static final String MAXIMUM_HEAP = "maximumHeap";
    public static final String DRAG_THRESHOLD = "dragThreshold";
    public static final String BUG_10295 = "bug10295";
    public static final String CLASSIC_MFD = "classicMfd";
    public static final String MAC_LEGACY = "macLegacy";
    public static final String OLD_CONTINUATION = "oldContinuation";
    public static final String SEND_TO_LOCATION_MOVEMENT_TRAILS = "stlMovementTrails";
    public static final String SOUND_GLOBAL_MUTE = "soundGlobalMute";
    public static final String SOUND_WAKEUP_MUTE = "soundWakeupMute";
    public static final String PLAYER_NAME = "PlayerName";
    public static final String PLAYER_NAME_ALT = "playerName";
    public static final String PLAYER_SIDE = "PlayerSide";
    public static final String PLAYER_SIDE_ALT = "playerSide";
    public static final String PLAYER_ID = "PlayerId";
    public static final String PLAYER_ID_ALT = "playerId";
    public static final String PLAYER_ID_FORMAT = "playerIdFormat";
    public static final boolean FORCE_MAC_LEGACY = true;
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String INITIAL_HEAP = "initialHeap";
    private String nonOwnerUnmaskable = "Never";
    private String autoReport = "Always";
    private String markMoved = "Never";
    private String chatterHTMLSupport = "Never";
    private String promptString = Resources.getString("GlobalOptions.opponents_can_unmask_my_pieces");
    private final FormattedString playerIdFormat = new FormattedString("$PlayerName$");
    private int dragThreshold = 10;
    private boolean macLegacy;
    private boolean soundGlobalMute = false;
    private boolean soundWakeupMute = false;
    private boolean useSingleWindow;
    private boolean useClassicMoveFixedDistance = false;
    private boolean warnOldContinuation = true;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private static final Map<String, Configurer> OPTION_CONFIGURERS = new LinkedHashMap<String, Configurer>();
    private static final Properties OPTION_INITIAL_VALUES = new Properties();
    private static GlobalOptions instance = new GlobalOptions();

    private static void setInstance(GlobalOptions go) {
        instance = go;
    }

    public static GlobalOptions getInstance() {
        return instance;
    }

    @Override
    public void addTo(Buildable parent) {
        GlobalOptions.setInstance(this);
        GameModule gm = GameModule.getGameModule();
        Prefs prefs = gm.getPrefs();
        this.validator = new SingleChildInstance(gm, this.getClass());
        BooleanConfigurer combConf = new BooleanConfigurer(SINGLE_WINDOW, Resources.getString("GlobalOptions.use_combined"), Boolean.TRUE);
        prefs.addOption(combConf);
        this.useSingleWindow = !Boolean.FALSE.equals(combConf.getValue());
        IntConfigurer maxHeapConf = new IntConfigurer(MAXIMUM_HEAP, Resources.getString("GlobalOptions.maximum_heap"), (Integer)512);
        prefs.addOption(maxHeapConf);
        IntConfigurer dragThresholdConf = new IntConfigurer(DRAG_THRESHOLD, Resources.getString("GlobalOptions.mouse_drag_threshold"), (Integer)10);
        dragThresholdConf.addPropertyChangeListener(e -> {
            this.dragThreshold = dragThresholdConf.getIntValue(10);
            System.setProperty("awt.dnd.drag.threshold", Integer.toString(this.dragThreshold));
        });
        prefs.addOption(dragThresholdConf);
        BooleanConfigurer config = new BooleanConfigurer(CENTER_ON_MOVE, Resources.getString("GlobalOptions.center_on_move"), Boolean.TRUE);
        prefs.addOption(config);
        IntConfigurer pctRecenterOn = new IntConfigurer(CENTER_ON_MOVE_SENSITIVITY, Resources.getString("GlobalOptions.center_on_move_sensitivity"), (Integer)10);
        prefs.addOption(pctRecenterOn);
        if (SystemUtils.IS_OS_WINDOWS) {
            boolean dragHandlerNoImageNecessary;
            BooleanConfigurer bug10295Conf = new BooleanConfigurer(BUG_10295, Resources.getString("GlobalOptions.bug10295"), Boolean.FALSE);
            boolean bl = dragHandlerNoImageNecessary = Boolean.TRUE.equals(bug10295Conf.getValue()) && !(PieceMover.AbstractDragHandler.getTheDragHandler() instanceof PieceMover.DragHandlerNoImage);
            if (dragHandlerNoImageNecessary) {
                PieceMover.AbstractDragHandler.setTheDragHandler(new PieceMover.DragHandlerNoImage());
            }
            bug10295Conf.addPropertyChangeListener(e -> PieceMover.AbstractDragHandler.setTheDragHandler(Boolean.TRUE.equals(e.getNewValue()) || !DragSource.isDragImageSupported() ? new PieceMover.DragHandlerNoImage() : new PieceMover.DragHandler()));
            prefs.addOption(Resources.getString("Prefs.compatibility_tab"), bug10295Conf);
        }
        BooleanConfigurer classicMfd = new BooleanConfigurer(CLASSIC_MFD, Resources.getString("GlobalOptions.classic_mfd"), Boolean.FALSE);
        classicMfd.addPropertyChangeListener(evt -> this.setUseClassicMoveFixedDistance(classicMfd.getValueBoolean()));
        prefs.addOption(Resources.getString("Prefs.compatibility_tab"), classicMfd);
        BooleanConfigurer macLegacyConf = new BooleanConfigurer(MAC_LEGACY, Resources.getString("GlobalOptions.mac_legacy"), Boolean.FALSE);
        macLegacyConf.addPropertyChangeListener(evt -> this.setPrefMacLegacy(macLegacyConf.getValueBoolean()));
        BooleanConfigurer oldContinuationConf = new BooleanConfigurer(OLD_CONTINUATION, Resources.getString("GlobalOptions.old_continuation"), Boolean.TRUE);
        oldContinuationConf.addPropertyChangeListener(evt -> this.setWarnOldContinuation(oldContinuationConf.getValueBoolean()));
        prefs.addOption(Resources.getString("Prefs.compatibility_tab"), oldContinuationConf);
        BooleanConfigurer sendToLocationMovementTrails = new BooleanConfigurer(SEND_TO_LOCATION_MOVEMENT_TRAILS, Resources.getString("GlobalOptions.send_to_location_movement_trails"), Boolean.TRUE);
        prefs.addOption(Resources.getString("Prefs.compatibility_tab"), sendToLocationMovementTrails);
        BooleanConfigurer soundWakeupMuteConf = new BooleanConfigurer(SOUND_WAKEUP_MUTE, Resources.getString("GlobalOptions.sound_wakeup_mute"), Boolean.FALSE);
        soundWakeupMuteConf.addPropertyChangeListener(evt -> this.setSoundWakeupMute(soundWakeupMuteConf.getValueBoolean()));
        prefs.addOption(Resources.getString("Prefs.sounds_tab"), soundWakeupMuteConf);
        BooleanConfigurer soundGlobalMuteConf = new BooleanConfigurer(SOUND_GLOBAL_MUTE, Resources.getString("GlobalOptions.sound_global_mute"), Boolean.FALSE);
        soundGlobalMuteConf.addPropertyChangeListener(evt -> this.setSoundGlobalMute(soundGlobalMuteConf.getValueBoolean()));
        prefs.addOption(Resources.getString("Prefs.sounds_tab"), soundGlobalMuteConf);
    }

    public boolean isUseSingleWindow() {
        return this.useSingleWindow;
    }

    public boolean isUseClassicMoveFixedDistance() {
        return this.useClassicMoveFixedDistance;
    }

    public void setUseClassicMoveFixedDistance(boolean b) {
        this.useClassicMoveFixedDistance = b;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public boolean isAveragedScaling() {
        ProblemDialog.showDeprecated("2020-08-06");
        return true;
    }

    public void setPrefMacLegacy(boolean b) {
        this.macLegacy = b;
        SwingUtils.setMacLegacy(b);
        GameModule.getGameModule().refreshKeyStrokeListeners();
    }

    public boolean getPrefMacLegacy() {
        return this.macLegacy;
    }

    public void setWarnOldContinuation(boolean b) {
        this.warnOldContinuation = b;
    }

    public boolean isWarnOldContinuation() {
        return this.warnOldContinuation;
    }

    public void setSoundGlobalMute(Boolean b) {
        this.soundGlobalMute = b;
    }

    public Boolean isSoundGlobalMute() {
        return this.soundGlobalMute;
    }

    public void setSoundWakeupMute(Boolean b) {
        this.soundWakeupMute = b;
    }

    public Boolean isSoundWakeupMute() {
        return this.soundWakeupMute;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.GlobalOption.component_type");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{StringPreference.class, TextPreference.class, EnumPreference.class, IntegerPreference.class, DoublePreference.class, BooleanPreference.class};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.GlobalOption.nonowner_unmask"), null, Resources.getString("Editor.GlobalOption.autoreport_moves"), Resources.getString("Editor.GlobalOption.playerid_format"), Resources.getString("Editor.GlobalOption.chatter_html_support")};
    }

    @Override
    public String[] getAttributeNames() {
        ArrayList<String> attributes = new ArrayList<String>(Arrays.asList(NON_OWNER_UNMASKABLE, PROMPT_STRING, AUTO_REPORT, PLAYER_ID_FORMAT, CHATTER_HTML_SUPPORT));
        attributes.addAll(this.properties.keySet());
        return attributes.toArray(new String[0]);
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{Prompt.class, null, Prompt.class, PlayerIdFormatConfig.class, PromptOnOff.class};
    }

    public void addOption(Configurer option) {
        OPTION_CONFIGURERS.put(option.getKey(), option);
        Object initValue = OPTION_INITIAL_VALUES.get(option.getKey());
        if (initValue instanceof String) {
            option.setValue((String)initValue);
        }
        if (this.config != null) {
            ((Container)this.config.getControls()).add(option.getControls());
        }
    }

    @Override
    public void build(Element e) {
        if (e == null) {
            return;
        }
        NamedNodeMap nnm = e.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Attr att = (Attr)nnm.item(i);
            this.setAttribute(att.getName(), att.getValue());
        }
        for (Node n = e.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            Element element = (Element)n;
            if ("option".equals(element.getTagName())) {
                String optionName = element.getAttribute("name");
                String value = Builder.getText(element);
                OPTION_INITIAL_VALUES.put(optionName, value);
                Configurer config = OPTION_CONFIGURERS.get(optionName);
                if (config == null) continue;
                config.setValue(value);
                continue;
            }
            try {
                Buildable b = Builder.create(element);
                b.addTo(this);
                this.add(b);
                continue;
            }
            catch (IllegalBuildException ex) {
                ErrorDialog.bug(ex);
            }
        }
    }

    @Override
    public Element getBuildElement(Document doc) {
        Element e = super.getBuildElement(doc);
        for (Configurer c : OPTION_CONFIGURERS.values()) {
            Element option = doc.createElement("option");
            option.setAttribute("name", c.getKey());
            option.appendChild(doc.createTextNode(c.getValueString()));
            e.appendChild(option);
        }
        return e;
    }

    @Override
    public Configurer getConfigurer() {
        if (this.config == null) {
            Configurer defaultConfig = super.getConfigurer();
            for (Configurer c : OPTION_CONFIGURERS.values()) {
                Container container = (Container)defaultConfig.getControls();
                String name = c.getName();
                JLabel label = new JLabel(name);
                c.setName("");
                label.setLabelFor(c.getControls());
                container.add(label);
                container.add(c.getControls(), "wrap");
                c.setName(name);
            }
        }
        return this.config;
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NON_OWNER_UNMASKABLE.equals(key)) {
            return this.nonOwnerUnmaskable;
        }
        if (PROMPT_STRING.equals(key)) {
            return this.promptString;
        }
        if (CHATTER_HTML_SUPPORT.equals(key)) {
            if (PROMPT.equals(this.chatterHTMLSupport)) {
                return NEVER;
            }
            return this.chatterHTMLSupport;
        }
        if (AUTO_REPORT.equals(key)) {
            return this.autoReport;
        }
        if (MARK_MOVED.equals(key)) {
            return this.markMoved;
        }
        if (PLAYER_ID_FORMAT.equals(key)) {
            return this.playerIdFormat.getFormat();
        }
        if (DRAG_THRESHOLD.equals(key)) {
            return Integer.toString(this.dragThreshold);
        }
        if (!OPTION_CONFIGURERS.containsKey(key)) {
            Object val = this.properties.get(key);
            return val != null ? val.toString() : null;
        }
        return null;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GlobalOptions.html");
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (NON_OWNER_UNMASKABLE.equals(key)) {
            this.nonOwnerUnmaskable = (String)value;
            if (ALWAYS.equals(this.nonOwnerUnmaskable)) {
                ObscurableOptions.getInstance().allowAll();
            } else if (NEVER.equals(this.nonOwnerUnmaskable)) {
                ObscurableOptions.getInstance().allowNone();
            } else if (PROMPT.equals(this.nonOwnerUnmaskable)) {
                ObscurableOptions.getInstance().allowSome(this.promptString);
                GameModule.getGameModule().getGameState().addGameComponent(ObscurableOptions.getInstance());
                GameModule.getGameModule().addCommandEncoder(ObscurableOptions.getInstance());
            }
        } else if (PROMPT_STRING.equals(key)) {
            this.promptString = (String)value;
        } else if (CHATTER_HTML_SUPPORT.equals(key)) {
            this.chatterHTMLSupport = (String)value;
        } else if (AUTO_REPORT.equals(key)) {
            this.autoReport = (String)value;
            if (PROMPT.equals(this.autoReport)) {
                BooleanConfigurer config = new BooleanConfigurer(AUTO_REPORT, Resources.getString("GlobalOptions.auto_report"));
                GameModule.getGameModule().getPrefs().addOption(config);
            }
        } else if (MARK_MOVED.equals(key)) {
            this.markMoved = (String)value;
            if (PROMPT.equals(this.markMoved)) {
                BooleanConfigurer config = new BooleanConfigurer(MARK_MOVED, Resources.getString("GlobalOptions.mark_moved"));
                GameModule.getGameModule().getPrefs().addOption(config);
            }
        } else if (PLAYER_ID_FORMAT.equals(key)) {
            this.playerIdFormat.setFormat((String)value);
        } else if (OPTION_CONFIGURERS.containsKey(key)) {
            OPTION_CONFIGURERS.get(key).setValue(value);
        } else {
            this.properties.put(key, value);
        }
    }

    public boolean autoReportEnabled() {
        return this.isEnabled(this.autoReport, AUTO_REPORT);
    }

    public boolean centerOnOpponentsMove() {
        return Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue(CENTER_ON_MOVE));
    }

    public double centerOnOpponentsMoveSensitivity() {
        int sensitivity = (Integer)GameModule.getGameModule().getPrefs().getValue(CENTER_ON_MOVE_SENSITIVITY);
        if (sensitivity > 100) {
            sensitivity = 100;
        } else if (sensitivity < 0) {
            sensitivity = 0;
        }
        return sensitivity;
    }

    public String chatterHTMLSetting() {
        return this.chatterHTMLSupport;
    }

    public boolean chatterHTMLSupport() {
        return this.isEnabled(this.chatterHTMLSupport, CHATTER_HTML_SUPPORT);
    }

    public boolean isMarkMoveEnabled() {
        return this.isEnabled(this.markMoved, MARK_MOVED);
    }

    public int getDragThreshold() {
        return this.dragThreshold;
    }

    public String getPlayerId() {
        this.playerIdFormat.setProperty(PLAYER_NAME, (String)GameModule.getGameModule().getPrefs().getValue("RealName"));
        this.playerIdFormat.setProperty(PLAYER_SIDE, PlayerRoster.getMyLocalizedSide());
        return this.playerIdFormat.getText();
    }

    private boolean isEnabled(String attValue, String prefsPrompt) {
        if (ALWAYS.equals(attValue)) {
            return true;
        }
        if (NEVER.equals(attValue) || CHATTER_HTML_SUPPORT.equals(prefsPrompt)) {
            return false;
        }
        return Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue(prefsPrompt));
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        for (Buildable b : this.getBuildables()) {
            if (!(b instanceof BasicPreference)) continue;
            l.add(((BasicPreference)b).getVariableName());
        }
        return l;
    }

    @Override
    public List<String> getFormattedStringList() {
        return List.of(this.playerIdFormat.getFormat());
    }

    @Override
    public void addImageNamesRecursively(Collection<String> s) {
        for (Configurer c : OPTION_CONFIGURERS.values()) {
            if (!(c instanceof IconConfigurer)) continue;
            s.add(c.getValueString());
        }
    }

    public static class Prompt
    extends StringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{GlobalOptions.ALWAYS, GlobalOptions.NEVER, GlobalOptions.PROMPT};
        }
    }

    public static class PlayerIdFormatConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new FormattedStringConfigurer(key, name, new String[]{GlobalOptions.PLAYER_NAME, GlobalOptions.PLAYER_SIDE});
        }
    }

    public static class PromptOnOff
    extends StringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{GlobalOptions.ALWAYS, GlobalOptions.NEVER};
        }
    }
}

