/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractToolbarItem;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.Drawable;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.command.Command;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.TranslatableStringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.UniqueIdManager;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.Op;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class MapShader
extends AbstractToolbarItem
implements GameComponent,
Drawable,
UniqueIdManager.Identifyable {
    public static final String NAME = "name";
    public static final String HOT_KEY = "hotkey";
    public static final String BUTTON_TEXT = "buttonText";
    public static final String ICON = "icon";
    public static final String TOOLTIP = "tooltip";
    public static final String ALWAYS_ON = "alwaysOn";
    public static final String STARTS_ON = "startsOn";
    public static final String BOARDS = "boards";
    public static final String BOARD_LIST = "boardList";
    public static final String ALL_BOARDS = "Yes";
    public static final String EXC_BOARDS = "No, exclude Boards in list";
    public static final String INC_BOARDS = "No, only shade Boards in List";
    protected static final UniqueIdManager idMgr = new UniqueIdManager("MapShader");
    @Deprecated(since="2021-04-03", forRemoval=true)
    protected LaunchButton launch;
    protected boolean alwaysOn = false;
    protected boolean startsOn = false;
    protected String boardSelection = "Yes";
    protected String[] boardList = new String[0];
    protected boolean shadingVisible;
    protected boolean scaleImage;
    protected Map map;
    protected String id;
    protected Area boardClip = null;
    public static final String TYPE = "type";
    public static final String DRAW_OVER = "drawOver";
    public static final String PATTERN = "pattern";
    public static final String COLOR = "color";
    public static final String IMAGE = "image";
    public static final String SCALE_IMAGE = "scaleImage";
    public static final String OPACITY = "opacity";
    public static final String BORDER = "border";
    public static final String BORDER_COLOR = "borderColor";
    public static final String BORDER_WIDTH = "borderWidth";
    public static final String BORDER_OPACITY = "borderOpacity";
    public static final String BG_TYPE = "Background";
    public static final String FG_TYPE = "Foreground";
    public static final String TYPE_25_PERCENT = "25%";
    public static final String TYPE_50_PERCENT = "50%";
    public static final String TYPE_75_PERCENT = "75%";
    public static final String TYPE_SOLID = "100% (Solid)";
    public static final String TYPE_IMAGE = "Custom Image";
    protected String imageName;
    protected Color color = Color.BLACK;
    protected String type = "Foreground";
    protected boolean drawOver = false;
    protected String pattern = "25%";
    protected int opacity = 100;
    protected boolean border = false;
    protected Color borderColor = Color.BLACK;
    protected int borderWidth = 1;
    protected int borderOpacity = 100;
    protected Area shape;
    protected Rectangle patternRect = new Rectangle();
    protected ImageOp srcOp;
    protected TexturePaint texture = null;
    protected java.util.Map<Double, TexturePaint> textures = new HashMap<Double, TexturePaint>();
    protected AlphaComposite composite = null;
    protected AlphaComposite borderComposite = null;
    protected BasicStroke stroke = null;

    public MapShader() {
        this.setButtonTextKey(BUTTON_TEXT);
        this.setLaunchButton(this.makeLaunchButton("", Resources.getString("Editor.MapShader.shade"), "", e -> this.toggleShading()));
        this.launch = this.getLaunchButton();
        this.getLaunchButton().setEnabled(false);
        this.setLaunchButtonVisibility();
        this.setConfigureName(Resources.getString("Editor.MapShader.configure_name"));
        this.reset();
    }

    @Override
    public void draw(Graphics g, Map map) {
        if (!this.shadingVisible) {
            return;
        }
        Area area = this.getShadeShape(map);
        if (area.isEmpty()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
        double zoom = map.getZoom() * os_scale;
        if (zoom != 1.0) {
            area = new Area(AffineTransform.getScaleInstance(zoom, zoom).createTransformedShape(area));
        }
        Composite oldComposite = g2d.getComposite();
        Color oldColor = g2d.getColor();
        Paint oldPaint = g2d.getPaint();
        g2d.setComposite(this.getComposite());
        g2d.setColor(this.getColor());
        g2d.setPaint(this.getTexture(zoom));
        g2d.fill(area);
        if (this.border) {
            Stroke oldStroke = g2d.getStroke();
            g2d.setComposite(this.getBorderComposite());
            g2d.setStroke(this.getStroke(zoom));
            g2d.setColor(this.getBorderColor());
            g2d.draw(area);
            g2d.setStroke(oldStroke);
        }
        g2d.setComposite(oldComposite);
        g2d.setColor(oldColor);
        g2d.setPaint(oldPaint);
    }

    protected AlphaComposite getComposite() {
        if (this.composite == null) {
            this.buildComposite();
        }
        return this.composite;
    }

    protected void buildComposite() {
        this.composite = AlphaComposite.getInstance(3, (float)this.opacity / 100.0f);
    }

    protected AlphaComposite getBorderComposite() {
        if (this.borderComposite == null) {
            this.borderComposite = this.buildBorderComposite();
        }
        return this.borderComposite;
    }

    protected AlphaComposite buildBorderComposite() {
        return AlphaComposite.getInstance(3, (float)this.borderOpacity / 100.0f);
    }

    protected Area getShadeShape(Map map) {
        Area myShape = this.type.equals(FG_TYPE) ? new Area() : new Area(this.getBoardClip());
        Arrays.stream(map.getPieces()).forEach(p -> this.checkPiece(myShape, (GamePiece)p));
        return myShape;
    }

    protected void checkPiece(Area area, GamePiece piece) {
        if (piece instanceof Stack) {
            Stack s = (Stack)piece;
            s.asList().forEach(gamePiece -> this.checkPiece(area, (GamePiece)gamePiece));
        } else {
            Area shape;
            ShadedPiece shaded = (ShadedPiece)((Object)Decorator.getDecorator(piece, ShadedPiece.class));
            if (shaded != null && (shape = shaded.getArea(this)) != null) {
                if (this.type.equals(FG_TYPE)) {
                    area.add(shape);
                } else {
                    area.subtract(shape);
                }
            }
        }
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    protected BufferedImage getShadePattern() {
        ProblemDialog.showDeprecated("2020-08-06");
        return this.getShadePattern(1.0);
    }

    protected BufferedImage getShadePattern(double zoom) {
        if (this.srcOp == null) {
            this.buildShadePattern();
        }
        BufferedImage src = (zoom == 1.0 ? this.srcOp : Op.scale(this.srcOp, zoom)).getImage();
        return ImageUtils.toType(src, ImageUtils.getCompatibleTranslucentImageType());
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    protected Rectangle getPatternRect() {
        ProblemDialog.showDeprecated("2020-08-06");
        return this.patternRect;
    }

    protected Rectangle getPatternRect(double zoom) {
        return zoom == 1.0 ? this.patternRect : new Rectangle((int)Math.round(zoom * (double)this.patternRect.width), (int)Math.round(zoom * (double)this.patternRect.height));
    }

    protected void buildShadePattern() {
        this.srcOp = this.pattern.equals(TYPE_IMAGE) && this.imageName != null ? Op.load(this.imageName) : new PatternOp(this.color, this.pattern);
        this.patternRect = new Rectangle(this.srcOp.getSize());
    }

    protected BasicStroke getStroke(double zoom) {
        if (this.stroke == null) {
            this.buildStroke(zoom);
        }
        return this.stroke;
    }

    protected void buildStroke(double zoom) {
        this.stroke = new BasicStroke((float)Math.min((double)this.borderWidth * zoom, 1.0), 1, 1);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    protected TexturePaint getTexture() {
        ProblemDialog.showDeprecated("2020-08-06");
        return this.getTexture(1.0);
    }

    protected TexturePaint getTexture(double zoom) {
        boolean usingScaledImage;
        boolean bl = usingScaledImage = this.scaleImage && this.imageName != null && this.pattern.equals(TYPE_IMAGE);
        if (!usingScaledImage) {
            zoom = 1.0;
        }
        this.texture = this.textures.computeIfAbsent(zoom, this::makeTexture);
        return this.texture;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    protected void buildTexture() {
        ProblemDialog.showDeprecated("2020-08-06");
        this.buildTexture(1.0);
    }

    protected void buildTexture(double zoom) {
        this.texture = this.makeTexture(zoom);
    }

    protected TexturePaint makeTexture(double zoom) {
        BufferedImage pat = this.getShadePattern(zoom);
        return pat != null ? new TexturePaint(pat, this.getPatternRect(zoom)) : null;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public boolean drawAboveCounters() {
        return this.drawOver;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, ALWAYS_ON, STARTS_ON, BUTTON_TEXT, TOOLTIP, ICON, HOT_KEY, BOARDS, BOARD_LIST, TYPE, DRAW_OVER, PATTERN, COLOR, IMAGE, SCALE_IMAGE, OPACITY, BORDER, BORDER_COLOR, BORDER_WIDTH, BORDER_OPACITY};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Boolean.class, Boolean.class, String.class, String.class, IconConfig.class, NamedKeyStroke.class, BoardPrompt.class, String[].class, TypePrompt.class, Boolean.class, PatternPrompt.class, Color.class, Image.class, Boolean.class, Integer.class, Boolean.class, Color.class, Integer.class, Integer.class};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.MapShader.shading_on"), Resources.getString("Editor.MapShader.shading_start"), Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.hotkey_label"), Resources.getString("Editor.MapShader.shade_boards"), Resources.getString("Editor.MapShader.board_list"), Resources.getString("Editor.MapShader.type"), Resources.getString("Editor.MapShader.shade_top"), Resources.getString("Editor.MapShader.pattern"), Resources.getString("Editor.color_label"), Resources.getString("Editor.image_label"), Resources.getString("Editor.MapShader.scale"), Resources.getString("Editor.MapShader.opacity"), Resources.getString("Editor.MapShader.border"), Resources.getString("Editor.border_color"), Resources.getString("Editor.MapShader.border_width"), Resources.getString("Editor.MapShader.border_opacity")};
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public void reset() {
        this.shadingVisible = this.isAlwaysOn() || this.isStartsOn();
    }

    protected void toggleShading() {
        this.setShadingVisibility(!this.shadingVisible);
    }

    public void setShadingVisibility(boolean b) {
        this.shadingVisible = b;
        this.map.repaint();
    }

    protected boolean isAlwaysOn() {
        return this.alwaysOn;
    }

    protected boolean isStartsOn() {
        return this.startsOn;
    }

    protected Map getMap() {
        return this.map;
    }

    public Area getBoardClip() {
        this.buildBoardClip();
        return this.boardClip;
    }

    protected void buildBoardClip() {
        if (this.boardClip == null) {
            this.boardClip = new Area();
            for (Board b : this.map.getBoards()) {
                String boardName = b.getName();
                boolean doShade = false;
                switch (this.boardSelection) {
                    case "Yes": {
                        doShade = true;
                        break;
                    }
                    case "No, exclude Boards in list": {
                        int i;
                        doShade = true;
                        for (i = 0; i < this.boardList.length && doShade; ++i) {
                            doShade = !this.boardList[i].equals(boardName);
                        }
                        break;
                    }
                    case "No, only shade Boards in List": {
                        int i;
                        for (i = 0; i < this.boardList.length && !doShade; ++i) {
                            doShade = this.boardList[i].equals(boardName);
                        }
                        break;
                    }
                }
                if (!doShade) continue;
                this.boardClip.add(new Area(b.bounds()));
            }
        }
    }

    public void setLaunchButtonVisibility() {
        this.getLaunchButton().setVisible(!this.isAlwaysOn());
    }

    @Override
    public void setup(boolean gameStarting) {
        this.getLaunchButton().setEnabled(gameStarting);
        if (!gameStarting) {
            this.boardClip = null;
        }
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    protected void buildPatternAndTexture() {
        this.textures.clear();
        this.buildShadePattern();
        this.buildTexture(1.0);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)value);
            if (super.getAttributeValueString(TOOLTIP) == null) {
                super.setAttribute(TOOLTIP, value);
            }
        } else if (ALWAYS_ON.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.alwaysOn = (Boolean)value;
            this.setLaunchButtonVisibility();
            this.reset();
        } else if (STARTS_ON.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.startsOn = (Boolean)value;
            this.setLaunchButtonVisibility();
            this.reset();
        } else if (BOARDS.equals(key)) {
            this.boardSelection = (String)value;
        } else if (BOARD_LIST.equals(key)) {
            if (value instanceof String) {
                value = StringArrayConfigurer.stringToArray((String)value);
            }
            this.boardList = value;
        } else if (TYPE.equals(key)) {
            this.type = (String)value;
        } else if (DRAW_OVER.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.drawOver = (Boolean)value;
        } else if (PATTERN.equals(key)) {
            this.pattern = (String)value;
            this.buildPatternAndTexture();
        } else if (COLOR.equals(key)) {
            if (value instanceof String) {
                value = ColorConfigurer.stringToColor((String)value);
            }
            if (value != null) {
                this.color = (Color)value;
                this.buildPatternAndTexture();
            }
        } else if (IMAGE.equals(key)) {
            if (value instanceof File) {
                value = ((File)value).getName();
            }
            this.imageName = (String)value;
            this.buildPatternAndTexture();
        } else if (SCALE_IMAGE.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.scaleImage = (Boolean)value;
        } else if (BORDER.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.border = (Boolean)value;
        } else if (BORDER_COLOR.equals(key)) {
            if (value instanceof String) {
                value = ColorConfigurer.stringToColor((String)value);
            }
            this.borderColor = (Color)value;
        } else if (BORDER_WIDTH.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.borderWidth = (Integer)value;
            if (this.borderWidth < 0) {
                this.borderWidth = 0;
            }
            this.stroke = null;
        } else if (OPACITY.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.opacity = (Integer)value;
            if (this.opacity < 0 || this.opacity > 100) {
                this.opacity = 100;
            }
            this.buildComposite();
        } else if (BORDER_OPACITY.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.borderOpacity = (Integer)value;
            if (this.borderOpacity < 0 || this.borderOpacity > 100) {
                this.borderOpacity = 100;
            }
            this.buildBorderComposite();
        } else {
            super.setAttribute(key, value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (ALWAYS_ON.equals(key)) {
            return String.valueOf(this.isAlwaysOn());
        }
        if (STARTS_ON.equals(key)) {
            return String.valueOf(this.isStartsOn());
        }
        if (BOARDS.equals(key)) {
            return this.boardSelection;
        }
        if (BOARD_LIST.equals(key)) {
            return StringArrayConfigurer.arrayToString(this.boardList);
        }
        if (TYPE.equals(key)) {
            return this.type;
        }
        if (DRAW_OVER.equals(key)) {
            return String.valueOf(this.drawOver);
        }
        if (PATTERN.equals(key)) {
            return this.pattern;
        }
        if (COLOR.equals(key)) {
            return ColorConfigurer.colorToString(this.color);
        }
        if (IMAGE.equals(key)) {
            return this.imageName;
        }
        if (SCALE_IMAGE.equals(key)) {
            return String.valueOf(this.scaleImage);
        }
        if (BORDER.equals(key)) {
            return String.valueOf(this.border);
        }
        if (BORDER_COLOR.equals(key)) {
            return ColorConfigurer.colorToString(this.borderColor);
        }
        if (BORDER_WIDTH.equals(key)) {
            return Integer.toString(this.borderWidth);
        }
        if (OPACITY.equals(key)) {
            return Integer.toString(this.opacity);
        }
        if (BORDER_OPACITY.equals(key)) {
            return Integer.toString(this.borderOpacity);
        }
        return super.getAttributeValueString(key);
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (List.of(ICON, HOT_KEY, BUTTON_TEXT, STARTS_ON, TOOLTIP).contains(name)) {
            return () -> !this.isAlwaysOn();
        }
        if (BOARD_LIST.equals(name)) {
            return () -> !this.boardSelection.equals(ALL_BOARDS);
        }
        if (COLOR.equals(name)) {
            return () -> !this.pattern.equals(TYPE_IMAGE);
        }
        if (IMAGE.equals(name)) {
            return () -> this.pattern.equals(TYPE_IMAGE);
        }
        if (SCALE_IMAGE.equals(name)) {
            return () -> this.pattern.equals(TYPE_IMAGE);
        }
        if (List.of(BORDER_COLOR, BORDER_WIDTH, BORDER_OPACITY).contains(name)) {
            return () -> this.border;
        }
        return super.getAttributeVisibility(name);
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        if (this.imageName != null) {
            s.add(this.imageName);
        }
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.MapShader.component_type");
    }

    @Override
    public void removeFrom(Buildable parent) {
        GameModule.getGameModule().getToolBar().remove(this.getLaunchButton());
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        this.map.removeDrawComponent(this);
        idMgr.remove(this);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.html", "MapShading");
    }

    @Override
    public void addTo(Buildable parent) {
        LaunchButton lb = this.getLaunchButton();
        GameModule.getGameModule().getToolBar().add(lb);
        lb.setAlignmentY(0.0f);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        this.map = (Map)parent;
        this.map.addDrawComponent(this);
        idMgr.add(this);
        this.validator = idMgr;
        this.setAttributeTranslatable(NAME, false);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public List<String> getPropertyList() {
        return Arrays.asList(this.boardList);
    }

    @FunctionalInterface
    public static interface ShadedPiece {
        public Area getArea(MapShader var1);
    }

    private static class PatternOp
    extends AbstractTileOpImpl {
        private final Color color;
        private final String pattern;
        private final int hash;

        public PatternOp(Color color, String pattern) {
            if (color == null || pattern == null) {
                throw new IllegalArgumentException();
            }
            this.color = color;
            this.pattern = pattern;
            this.hash = new HashCodeBuilder().append((Object)color).append((Object)pattern).toHashCode();
        }

        @Override
        public BufferedImage eval() throws Exception {
            BufferedImage im = ImageUtils.createCompatibleTranslucentImage(2, 2);
            Graphics2D g = im.createGraphics();
            g.setColor(this.color);
            if (MapShader.TYPE_25_PERCENT.equals(this.pattern)) {
                g.drawLine(0, 0, 0, 0);
            } else if (MapShader.TYPE_50_PERCENT.equals(this.pattern)) {
                g.drawLine(0, 0, 0, 0);
                g.drawLine(1, 1, 1, 1);
            } else if (MapShader.TYPE_75_PERCENT.equals(this.pattern)) {
                g.drawLine(0, 0, 1, 0);
                g.drawLine(1, 1, 1, 1);
            } else {
                g.drawLine(0, 0, 1, 0);
                g.drawLine(0, 1, 1, 1);
            }
            g.dispose();
            return im;
        }

        @Override
        protected void fixSize() {
        }

        @Override
        public Dimension getSize() {
            return new Dimension(2, 2);
        }

        @Override
        public int getWidth() {
            return 2;
        }

        @Override
        public int getHeight() {
            return 2;
        }

        @Override
        public List<VASSAL.tools.opcache.Op<?>> getSources() {
            return Collections.emptyList();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PatternOp)) {
                return false;
            }
            return this.color.equals(((PatternOp)o).color) && this.pattern.equals(((PatternOp)o).pattern);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    @Deprecated(since="2020-10-01", forRemoval=true)
    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, ((MapShader)c).getLaunchButton().getAttributeValueString(MapShader.ICON));
        }
    }

    public static class BoardPrompt
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{MapShader.ALL_BOARDS, MapShader.EXC_BOARDS, MapShader.INC_BOARDS};
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            return new String[]{"Editor.MapShader.all_boards", "Editor.MapShader.exc_boards", "Editor.MapShader.inc_boards"};
        }
    }

    public static class TypePrompt
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{MapShader.FG_TYPE, MapShader.BG_TYPE};
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            return new String[]{"Editor.MapShader.foreground", "Editor.MapShader.background"};
        }
    }

    public static class PatternPrompt
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{MapShader.TYPE_25_PERCENT, MapShader.TYPE_50_PERCENT, MapShader.TYPE_75_PERCENT, MapShader.TYPE_SOLID, MapShader.TYPE_IMAGE};
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            return new String[]{"Editor.MapShader.p25", "Editor.MapShader.p50", "Editor.MapShader.p75", "Editor.MapShader.solid", "Editor.MapShader.image"};
        }
    }
}

