/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.metadata;

import VASSAL.build.GameModule;
import VASSAL.build.module.metadata.AbstractMetaData;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ModuleMetaData
extends AbstractMetaData {
    private static final Logger logger = LoggerFactory.getLogger(ModuleMetaData.class);
    public static final String ZIP_ENTRY_NAME = "moduledata";
    public static final String DATA_VERSION = "1";
    protected AbstractMetaData.Attribute nameAttr;

    public ModuleMetaData(ZipFile zip) {
        this.read(zip);
    }

    public ModuleMetaData(GameModule module) {
        this.nameAttr = new AbstractMetaData.Attribute(module, "name");
        this.setDescription(new AbstractMetaData.Attribute(module, "description"));
        this.setVersion(module.getGameVersion());
    }

    public ModuleMetaData(String name, String version) {
        this.nameAttr = new AbstractMetaData.Attribute("name", name);
        this.setVersion(version);
    }

    public String getName() {
        return this.nameAttr == null ? "" : this.nameAttr.getValue();
    }

    public String getLocalizedName() {
        return this.nameAttr == null ? "" : this.nameAttr.getLocalizedValue();
    }

    @Override
    public String getZipEntryName() {
        return ZIP_ENTRY_NAME;
    }

    @Override
    public String getMetaDataVersion() {
        return DATA_VERSION;
    }

    @Override
    protected void addElements(Document doc, Element root) {
        this.nameAttr.generateXML(doc, root, "name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ZipFile zip) {
        this.version = "";
        try (ZipFile zipFile = zip;){
            DefaultHandler handler;
            ZipEntry data = zip.getEntry(ZIP_ENTRY_NAME);
            if (data == null) {
                data = zip.getEntry("buildFile");
                if (data == null) {
                    return;
                }
                handler = new ModuleBuildFileXMLHandler();
            } else {
                handler = new MetadataXMLHandler();
            }
            try (InputStream zin = zip.getInputStream(data);
                 BufferedInputStream in = new BufferedInputStream(zin);){
                XMLReader xMLReader = parser;
                synchronized (xMLReader) {
                    parser.setContentHandler(handler);
                    parser.setDTDHandler(handler);
                    parser.setEntityResolver(handler);
                    parser.setErrorHandler(handler);
                    parser.parse(new InputSource(in));
                }
            }
        }
        catch (AbstractMetaData.SAXEndException sAXEndException) {
        }
        catch (IOException | SAXException e) {
            logger.error("", (Throwable)e);
        }
    }

    private class ModuleBuildFileXMLHandler
    extends AbstractMetaData.BuildFileXMLHandler {
        private ModuleBuildFileXMLHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws AbstractMetaData.SAXEndException {
            super.startElement(uri, localName, qName, attrs);
            if ("VASSAL.launch.BasicModule".equals(qName) || "VASSAL.build.GameModule".equals(qName)) {
                ModuleMetaData.this.nameAttr = new AbstractMetaData.Attribute("name", this.getAttr(attrs, "name"));
                ModuleMetaData.this.setVersion(this.getAttr(attrs, "version"));
                ModuleMetaData.this.setVassalVersion(this.getAttr(attrs, "vassalVersion"));
                ModuleMetaData.this.setDescription(this.getAttr(attrs, "description"));
                throw new AbstractMetaData.SAXEndException();
            }
        }
    }

    private class MetadataXMLHandler
    extends AbstractMetaData.XMLHandler {
        private MetadataXMLHandler() {
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if ("name".equals(qName)) {
                if (ModuleMetaData.this.nameAttr == null) {
                    ModuleMetaData.this.nameAttr = new AbstractMetaData.Attribute("name", this.accumulator.toString().trim());
                } else {
                    ModuleMetaData.this.nameAttr.addTranslation(this.language, this.accumulator.toString().trim());
                }
            } else {
                super.endElement(uri, localName, qName);
            }
        }
    }
}

