/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.SimpleStatus;
import java.awt.Component;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class RoomTreeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private Icon away;
    private Icon looking;

    public RoomTreeRenderer() {
        URL image = this.getClass().getResource("/images/playerAway.gif");
        if (image != null) {
            this.away = new ImageIcon(image);
        }
        if ((image = this.getClass().getResource("/images/playerLooking.gif")) != null) {
            this.looking = new ImageIcon(image);
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.putClientProperty("html.disable", Boolean.TRUE);
        Object item = ((DefaultMutableTreeNode)value).getUserObject();
        if (item instanceof Player) {
            if (((SimpleStatus)((Player)item).getStatus()).isAway()) {
                this.setIcon(this.away);
            } else if (((SimpleStatus)((SimplePlayer)item).getStatus()).isLooking()) {
                this.setIcon(this.looking);
            } else {
                this.setIcon(null);
            }
        } else if (item instanceof SimpleRoom) {
            List<Player> players = ((Room)item).getPlayerList();
            this.setText(this.getText() + " (" + players.size() + ")");
        }
        return this;
    }
}

