/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.DynamicKeyCommandListConfigurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.DynamicProperty;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;

public class SetGlobalProperty
extends DynamicProperty {
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String ID = "setprop;";
    public static final String CURRENT_ZONE = "Current Zone/Current Map/Module";
    public static final String NAMED_ZONE = "Named Zone";
    public static final String NAMED_MAP = "Named Map";
    protected String description;
    protected String propertyLevel;
    protected String searchName;
    protected Decorator dec;

    public SetGlobalProperty() {
        this(ID, null);
    }

    public SetGlobalProperty(String type, GamePiece p) {
        super(type, p);
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.SetGlobalProperty.trait_description", this.key, this.description);
    }

    @Override
    public void mySetType(String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ';');
        sd.nextToken();
        this.key = sd.nextToken("name");
        this.decodeConstraints(sd.nextToken(""));
        this.keyCommandListConfig.setValue(sd.nextToken(""));
        this.keyCommands = this.keyCommandListConfig.getListValue().toArray(new DynamicProperty.DynamicKeyCommand[0]);
        this.menuCommands = (KeyCommand[])Arrays.stream(this.keyCommands).filter(kc -> !StringUtils.isEmpty((CharSequence)kc.getName())).toArray(KeyCommand[]::new);
        this.description = sd.nextToken("");
        this.propertyLevel = sd.nextToken(CURRENT_ZONE);
        this.searchName = sd.nextToken("");
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.key);
        se.append(this.encodeConstraints());
        se.append(this.keyCommandListConfig.getValueString());
        se.append(this.description);
        se.append(this.propertyLevel);
        se.append(this.searchName);
        return ID + se.getValue();
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public void mySetState(String state) {
    }

    @Override
    public Object getProperty(Object key) {
        if ("KeyCommands".equals(key)) {
            return this.getKeyCommands();
        }
        if ("Inner".equals(key)) {
            return this.piece;
        }
        if ("Outer".equals(key)) {
            return this.dec;
        }
        if ("visibleState".equals(key)) {
            return this.myGetState() + this.piece.getProperty(key);
        }
        return this.piece.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if ("KeyCommands".equals(key)) {
            return this.getProperty(key);
        }
        if ("Inner".equals(key)) {
            return this.getProperty(key);
        }
        if ("Outer".equals(key)) {
            return this.getProperty(key);
        }
        if ("visibleState".equals(key)) {
            return this.getProperty(key);
        }
        return this.piece.getLocalizedProperty(key);
    }

    @Override
    public void setProperty(Object key, Object val) {
        if ("Inner".equals(key)) {
            this.setInner((GamePiece)val);
        } else if ("Outer".equals(key)) {
            this.dec = (Decorator)val;
        } else {
            this.piece.setProperty(key, val);
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("SetGlobalProperty.html");
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        Command comm = new NullCommand();
        for (DynamicProperty.DynamicKeyCommand keyCommand : this.keyCommands) {
            MutableProperty prop;
            if (!keyCommand.matches(stroke)) continue;
            String propertyName = new FormattedString(this.key).getText(Decorator.getOutermost(this));
            ArrayList<MutablePropertiesContainer> propertyContainers = new ArrayList<MutablePropertiesContainer>();
            propertyContainers.add(0, GameModule.getGameModule());
            Map map = this.getMap();
            if (NAMED_MAP.equals(this.propertyLevel)) {
                String mapName = new FormattedString(this.searchName).getText(Decorator.getOutermost(this));
                map = Map.getMapById(mapName);
            }
            if (map != null) {
                propertyContainers.add(0, map);
            }
            Zone z = null;
            if (CURRENT_ZONE.equals(this.propertyLevel) && this.getMap() != null) {
                z = this.getMap().findZone(this.getPosition());
            } else if (NAMED_ZONE.equals(this.propertyLevel) && this.getMap() != null) {
                String zoneName = new FormattedString(this.searchName).getText(Decorator.getOutermost(this));
                z = this.getMap().findZone(zoneName);
            }
            if (z != null) {
                propertyContainers.add(0, z);
            }
            if ((prop = MutableProperty.Util.findMutableProperty(propertyName, propertyContainers)) == null) {
                String message = "Unable to locate Global Property in " + this.propertyLevel + ".";
                String data = "Property Expression=[" + this.key + "], Property Name=" + propertyName + "].";
                ErrorDialog.dataWarning(new BadDataReport(this, message, data));
                continue;
            }
            String oldValue = prop.getPropertyValue();
            String newValue = keyCommand.propChanger.getNewValue(oldValue);
            this.format.setFormat(newValue);
            newValue = this.format.getText(Decorator.getOutermost(this));
            comm = prop.setPropertyValue(newValue);
        }
        return comm;
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof SetGlobalProperty)) {
            return false;
        }
        SetGlobalProperty c = (SetGlobalProperty)o;
        if (!Objects.equals(this.key, c.key)) {
            return false;
        }
        if (!Objects.equals(this.encodeConstraints(), c.encodeConstraints())) {
            return false;
        }
        if (!Objects.equals(this.keyCommandListConfig.getValueString(), c.keyCommandListConfig.getValueString())) {
            return false;
        }
        if (!Objects.equals(this.description, c.description)) {
            return false;
        }
        if (!Objects.equals(this.propertyLevel, c.propertyLevel)) {
            return false;
        }
        return Objects.equals(this.searchName, c.searchName);
    }

    protected static class Ed
    implements PieceEditor {
        protected StringConfigurer descConfig;
        protected FormattedExpressionConfigurer nameConfig;
        protected BooleanConfigurer numericConfig;
        protected JLabel minLabel;
        protected IntConfigurer minConfig;
        protected JLabel maxLabel;
        protected IntConfigurer maxConfig;
        protected JLabel wrapLabel;
        protected BooleanConfigurer wrapConfig;
        protected DynamicKeyCommandListConfigurer keyCommandListConfig;
        protected TranslatingStringEnumConfigurer levelConfig;
        protected FormattedExpressionConfigurer searchNameConfig;
        protected String mapText = Resources.getString("Editor.SetGlobalProperty.name_of_map");
        private final String mapHint = Resources.getString("Editor.GlobalKeyCommand.map_name_hint");
        protected String zoneText = Resources.getString("Editor.SetGlobalProperty.name_of_zone");
        private final String zoneHint = Resources.getString("Editor.GlobalKeyCommand.zone_name_hint");
        protected JLabel searchLabel;
        protected TraitConfigPanel controls;

        public Ed(SetGlobalProperty m) {
            this.keyCommandListConfig = new DynamicKeyCommandListConfigurer(null, Resources.getString("Editor.DynamicProperty.commands"), m);
            this.keyCommandListConfig.setValue(new ArrayList<DynamicProperty.DynamicKeyCommand>(Arrays.asList(m.keyCommands)));
            this.controls = new TraitConfigPanel();
            this.descConfig = new StringConfigurer(m.description);
            this.descConfig.setHintKey("Editor.description_hint");
            this.controls.add("Editor.description_label", (Configurer)this.descConfig);
            this.nameConfig = new FormattedExpressionConfigurer(m.getKey(), m);
            this.nameConfig.setHintKey("Editor.SetGlobalProperty.global_property_name_hint");
            this.controls.add("Editor.SetGlobalProperty.global_property_name", (Configurer)this.nameConfig);
            String[] levelKeys = new String[]{"Editor.SetGlobalProperty.current", "Editor.SetGlobalProperty.named_zone", "Editor.SetGlobalProperty.named_map"};
            this.levelConfig = new TranslatingStringEnumConfigurer(new String[]{SetGlobalProperty.CURRENT_ZONE, SetGlobalProperty.NAMED_ZONE, SetGlobalProperty.NAMED_MAP}, levelKeys, m.propertyLevel);
            this.levelConfig.addPropertyChangeListener(e -> this.updateVisibility());
            this.controls.add("Editor.SetGlobalProperty.locate_property", (Configurer)this.levelConfig);
            this.searchNameConfig = new FormattedExpressionConfigurer(m.searchName, m);
            this.searchLabel = new JLabel(this.mapText);
            this.controls.add(this.searchLabel, (Configurer)this.searchNameConfig);
            this.numericConfig = new BooleanConfigurer(m.isNumeric());
            this.controls.add("Editor.DynamicProperty.is_numeric", (Configurer)this.numericConfig);
            this.minLabel = new JLabel(Resources.getString("Editor.GlobalProperty.minimum_value"));
            this.minConfig = new IntConfigurer(m.getMinimumValue());
            this.controls.add(this.minLabel, (Configurer)this.minConfig);
            this.maxLabel = new JLabel(Resources.getString("Editor.GlobalProperty.maximum_value"));
            this.maxConfig = new IntConfigurer(m.getMaximumValue());
            this.controls.add(this.maxLabel, (Configurer)this.maxConfig);
            this.wrapLabel = new JLabel(Resources.getString("Editor.DynamicProperty.wrap"));
            this.wrapConfig = new BooleanConfigurer(m.isWrap());
            this.controls.add(this.wrapLabel, (Configurer)this.wrapConfig);
            this.controls.add("Editor.DynamicProperty.key_commands", (Configurer)this.keyCommandListConfig);
            this.numericConfig.addPropertyChangeListener(evt -> {
                boolean isNumeric = this.numericConfig.booleanValue();
                this.minConfig.getControls().setVisible(isNumeric);
                this.minLabel.setVisible(isNumeric);
                this.maxConfig.getControls().setVisible(isNumeric);
                this.maxLabel.setVisible(isNumeric);
                this.wrapConfig.getControls().setVisible(isNumeric);
                this.wrapLabel.setVisible(isNumeric);
                this.keyCommandListConfig.repack();
            });
            this.numericConfig.fireUpdate();
            this.updateVisibility();
        }

        protected void updateVisibility() {
            switch (this.levelConfig.getValueString()) {
                case "Named Map": {
                    this.searchLabel.setText(this.mapText);
                    this.searchNameConfig.updateHint(this.mapHint);
                    break;
                }
                case "Named Zone": {
                    this.searchLabel.setText(this.zoneText);
                    this.searchNameConfig.updateHint(this.zoneHint);
                }
            }
            this.searchLabel.setVisible(!this.levelConfig.getValueString().equals(SetGlobalProperty.CURRENT_ZONE));
            this.searchNameConfig.getControls().setVisible(!this.levelConfig.getValueString().equals(SetGlobalProperty.CURRENT_ZONE));
            Decorator.repack(this.controls);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        protected String encodeConstraints() {
            return new SequenceEncoder(',').append(this.numericConfig.getValueString()).append(this.minConfig.getValueString()).append(this.maxConfig.getValueString()).append(this.wrapConfig.getValueString()).getValue();
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.nameConfig.getValueString());
            se.append(this.encodeConstraints());
            se.append(this.keyCommandListConfig.getValueString());
            se.append(this.descConfig.getValueString());
            se.append(this.levelConfig.getValueString());
            se.append(this.searchNameConfig.getValueString());
            return SetGlobalProperty.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

