/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import java.util.IllegalFormatException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleHelper {
    private static final Logger logger = LoggerFactory.getLogger(BundleHelper.class);
    private final ResourceBundle bundle;

    public BundleHelper(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public String getString(String id) {
        try {
            return this.bundle.getString(id);
        }
        catch (ClassCastException | MissingResourceException e) {
            logger.warn("No Translation: " + id);
            return id;
        }
    }

    public String getString(String id, Object ... args) {
        try {
            return String.format(this.getString(id), args);
        }
        catch (IllegalFormatException e) {
            logger.error("Illegal Message Format: " + id);
            return id;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }
}

