/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerPanel;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LocaleConfigurer
extends Configurer {
    protected static final String ANY_COUNTRY = "[Any Country]";
    protected JPanel panel;
    protected static final Map<String, String> languages = new HashMap<String, String>();
    protected static String[] languageList;
    protected static final Map<String, String> countries;
    protected static String[] countryList;
    protected JComboBox<String> langBox;
    protected JComboBox<String> countryBox;

    public LocaleConfigurer(String key, String name) {
        this(key, name, "");
    }

    public LocaleConfigurer(String key, String name, Locale locale) {
        super(key, name);
        this.setValue(locale);
    }

    public LocaleConfigurer(String key, String name, String val) {
        super(key, name, val);
        this.setValue(val);
    }

    @Override
    public String getValueString() {
        return (String)this.value;
    }

    public Locale getValueLocale() {
        return LocaleConfigurer.stringToLocale((String)this.value);
    }

    public void setValue(Locale l) {
        this.setValue(LocaleConfigurer.localeToString(l));
    }

    @Override
    public void setValue(String s) {
        this.getControls();
        if (!this.noUpdate && this.langBox != null && this.countryBox != null) {
            SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ',');
            this.setLanguage(sd.nextToken(Locale.getDefault().getLanguage()));
            this.setCountry(sd.nextToken(""));
        }
        this.setValue((Object)s);
    }

    protected void setLanguage(String l) {
        String lang = new Locale(l, "").getDisplayLanguage(Locale.getDefault());
        this.langBox.setSelectedItem(lang);
    }

    protected void setCountry(String c) {
        String country = c.length() == 0 ? ANY_COUNTRY : new Locale(Locale.getDefault().getLanguage(), c).getDisplayCountry(Locale.getDefault());
        this.countryBox.setSelectedItem(country);
    }

    @Override
    public Component getControls() {
        if (this.panel == null) {
            this.panel = new ConfigurerPanel(this.getName(), "[]rel[][]rel[]", "[]rel[]rel[][]rel[]");
            this.langBox = new JComboBox<String>(this.getLanguageList());
            this.langBox.setSelectedItem(Locale.getDefault().getDisplayLanguage());
            this.langBox.addActionListener(e -> this.updateValue());
            this.panel.add(new JLabel(Resources.getString("Editor.LocaleConfigurer.language")));
            this.panel.add(this.langBox);
            this.countryBox = new JComboBox<String>(this.getCountryList());
            this.countryBox.setSelectedItem(ANY_COUNTRY);
            this.countryBox.addActionListener(e -> this.updateValue());
            this.panel.add(new JLabel(Resources.getString("Editor.LocaleConfigurer.country")));
            this.panel.add(this.countryBox);
        }
        return this.panel;
    }

    protected void updateValue() {
        String language = languages.get(this.langBox.getSelectedItem());
        String country = countries.get(this.countryBox.getSelectedItem());
        this.setValue(language + "," + country);
    }

    protected String[] getLanguageList() {
        if (languageList == null) {
            String[] langs = Locale.getISOLanguages();
            ArrayList<Object> sortedLangs = new ArrayList<Object>();
            for (String s : langs) {
                String lang = new Locale(s).getDisplayLanguage(Locale.getDefault());
                languages.put(lang, s);
                sortedLangs.add(lang);
            }
            sortedLangs.sort(Collator.getInstance(Locale.getDefault()));
            languageList = sortedLangs.toArray(new String[0]);
        }
        return languageList;
    }

    protected String[] getCountryList() {
        if (countryList == null) {
            String[] c = Locale.getISOCountries();
            ArrayList<Object> sortedCountries = new ArrayList<Object>();
            for (String s : c) {
                String country = new Locale("en", s).getDisplayCountry(Locale.getDefault());
                countries.put(country, s);
                sortedCountries.add(country);
            }
            sortedCountries.sort(Collator.getInstance(Locale.getDefault()));
            countries.put(ANY_COUNTRY, "");
            sortedCountries.add(0, ANY_COUNTRY);
            countryList = sortedCountries.toArray(new String[0]);
        }
        return countryList;
    }

    public static Locale stringToLocale(String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ',');
        return new Locale(sd.nextToken(""), sd.nextToken(""));
    }

    public static String localeToString(Locale l) {
        return l.getLanguage() + "," + l.getCountry();
    }

    static {
        countries = new HashMap<String, String>();
    }
}

